/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.rpc.ElsTaxLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Scope(value="prototype")
@Service(value="purchaseRequestItemExcelHandler")
public class PurchaseRequestItemExcelHandler
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestItemExcelHandler.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    private List<TemplateConfigItemDTO> templateConfigItemDTOList;

    public TemplateHeadDTO getTemplate(String headId) {
        PurchaseRequestHead dbHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)headId)));
        String account = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
        String templateVersion = String.valueOf(dbHead.getTemplateVersion());
        TemplateHeadDTO config = this.templateHeadService.getConfig(account, dbHead.getTemplateNumber(), templateVersion);
        this.templateConfigItemDTOList = JSON.parseArray((String)JSON.toJSONString((Object)config.getTemplateConfigItemList()), TemplateConfigItemDTO.class);
        return config;
    }

    public List<Object> getExportData(String headId) {
        List<PurchaseRequestItem> itemList = this.purchaseRequestItemService.selectByMainId(headId);
        return new ArrayList<PurchaseRequestItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = this.templateConfigItemDTOList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        Map<String, Integer> taxMap = this.elsTaxService.getAllTax(TenantContext.getTenant());
        for (Map<String, Object> data : dataList) {
            Field[] fields;
            String materialNumber;
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode)) {
                Assert.isTrue((boolean)taxMap.containsKey(taxCode), (String)I18nUtil.translate((String)"", (String)("\u7a0e\u7801\uff1a" + taxCode + "\u4e0d\u5b58\u5728")));
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!StringUtils.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHeadDTO materialHead = this.purchaseMaterialHeadService.getMaterialHeadByNumber(materialNumber);
            Assert.notNull((Object)materialHead, (String)I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801\uff1a" + materialNumber + "\u4e0d\u5b58\u5728")));
            for (Field field : fields = ConvertUtils.getAllFields((Object)materialHead)) {
                if (!data.containsKey(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get(materialHead));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return dataList;
    }
}

