/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseHeadEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.SaleEbiddingConfirmVO;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ebidding/saleEbiddingHead"})
@Api(tags={"\u9500\u552e\u7ade\u4ef7\u5934"})
public class SaleEbiddingHeadController
extends BaseController<SaleEbiddingHead, SaleEbiddingHeadService> {
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisService saleEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingConfirmService saleEbiddingConfirmService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleEbiddingHead saleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((SaleEbiddingHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        SaleEbiddingHeadVO headVO = new SaleEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        PurchaseEbiddingSupplier supplier = (PurchaseEbiddingSupplier)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)headVO.getSupplierListId())));
        if (supplier != null) {
            headVO.setReplyStatus(supplier.getReplyStatus());
        }
        List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(id);
        headVO.setSaleEbiddingItemList(itemList);
        List<SaleEbiddingConfirmVO> confirmList = this.saleEbiddingConfirmService.selectByMainId(id);
        headVO.setSaleEbiddingConfirmList(confirmList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        List attachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(attachmentList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u5e94\u6807")
    @ApiOperation(value="\u5e94\u6807", notes="\u5e94\u6807")
    @PostMapping(value={"/acceptResponse"})
    public Result<?> acceptResponse(@RequestBody SaleEbiddingHeadVO webVO) {
        String headId = webVO.getId();
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.WAIT_REPLY.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u65e0\u9700\u5e94\u6807"));
        Assert.isTrue((boolean)dbSaleHead.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5e94\u6807"));
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(headId).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List<SaleAttachmentDTO> saleAttachmentList = webVO.getSaleAttachmentList();
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> StrUtil.isNotBlank((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (SaleAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        if ("1".equals(dbSaleHead.getSupplierTaxRate())) {
            List<SaleEbiddingItem> itemList;
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
                itemList = webVO.getSaleEbiddingItemList();
                Iterator<BaseHeadEntity> iterator = itemList.iterator();
                while (iterator.hasNext()) {
                    SaleEbiddingItem item2;
                    item2.setTaxRate(StrUtil.isBlank((CharSequence)(item2 = (SaleEbiddingItem)iterator.next()).getTaxRate()) ? webVO.getTaxRate() : item2.getTaxRate());
                    item2.setTaxCode(StrUtil.isBlank((CharSequence)item2.getTaxCode()) ? webVO.getTaxCode() : item2.getTaxCode());
                    Assert.hasText((String)item2.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item2.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            } else {
                Assert.hasText((String)webVO.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)webVO.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                itemList = this.saleEbiddingItemService.selectByMainId(headId);
                itemList.forEach(item -> {
                    item.setTaxCode(webVO.getTaxCode());
                    item.setTaxRate(webVO.getTaxRate());
                });
                webVO.setSaleEbiddingItemList(itemList);
            }
        }
        List<SaleEbiddingConfirmVO> saleEbiddingConfirmList = webVO.getSaleEbiddingConfirmList();
        for (SaleEbiddingConfirmVO confirm : saleEbiddingConfirmList) {
            if (!"1".equals(confirm.getMust())) continue;
            Assert.hasText((String)confirm.getContent(), (String)I18nUtil.translate((String)"", (String)"\u786e\u8ba4\u9879\u5fc5\u586b"));
        }
        ((SaleEbiddingHeadService)this.service).acceptResponse(webVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @GetMapping(value={"/rejectResponse"})
    public Result<?> rejectResponse(@RequestParam(name="id") String id) {
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EbiddingStatusEnum.WAIT_REPLY.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u4e0d\u53ef\u62d2\u7edd"));
        ((SaleEbiddingHeadService)this.service).refuseResponse(dbSaleHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quotePrice"})
    public Result<?> quotePrice(@RequestBody SaleEbiddingHeadVO headVO) {
        ((SaleEbiddingHeadService)this.service).quotePrice(headVO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u5934\u884c\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u5934\u884c\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyDetail"})
    public Result<?> queryBidLobbyDetail(@RequestParam(name="id") String id) {
        SaleEbiddingHeadVO saleHeadVO = new SaleEbiddingHeadVO();
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)saleHeadVO));
        List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(id);
        saleHeadVO.setSaleEbiddingItemList(itemList);
        saleHeadVO.setServiceTime(new Date());
        return Result.ok((Object)((Object)saleHeadVO));
    }

    @ApiOperation(value="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2", notes="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyQuote"})
    public Result<?> queryBidLobbyQuote(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        List<Object> saleItemList;
        String supplierShow;
        SaleEbiddingHeadVO saleHeadVO = new SaleEbiddingHeadVO();
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)saleHeadVO));
        List<PurchaseEbiddingItem> allList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        String string = supplierShow = dbHead.getSupplierShow() == null ? "" : dbHead.getSupplierShow();
        if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) || supplierShow.contains(EbiddingShowEnum.NAME.getValue())) {
            saleItemList = SysUtil.copyProperties(allList, SaleEbiddingItem.class);
            for (SaleEbiddingItem saleEbiddingItem : saleItemList) {
                String relationId = saleEbiddingItem.getRelationId();
                saleEbiddingItem.setRelationId(saleEbiddingItem.getId());
                saleEbiddingItem.setId(relationId);
                String toElsAccount = saleEbiddingItem.getToElsAccount();
                saleEbiddingItem.setToElsAccount(saleEbiddingItem.getElsAccount());
                saleEbiddingItem.setElsAccount(toElsAccount);
                if (!supplierShow.contains(EbiddingShowEnum.NAME.getValue())) {
                    saleEbiddingItem.setSupplierName(null);
                }
                if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) || this.getTenantId().equals(saleEbiddingItem.getElsAccount())) continue;
                saleEbiddingItem.setPrice(null);
                saleEbiddingItem.setNetPrice(null);
                saleEbiddingItem.setTaxAmount(null);
                saleEbiddingItem.setNetAmount(null);
                saleEbiddingItem.setTotalAmount(null);
                saleEbiddingItem.setNetTotalAmount(null);
            }
        } else {
            saleItemList = this.saleEbiddingItemService.selectByMainId(id).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        }
        if (supplierShow.contains(EbiddingShowEnum.RANK.getValue())) {
            for (SaleEbiddingItem saleEbiddingItem : saleItemList) {
                this.rank(allList, saleEbiddingItem, dbHead.getEbiddingWay(), dbHead.getEbiddingType());
            }
        }
        saleItemList.sort(Comparator.comparing(SaleEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
        saleHeadVO.setSaleEbiddingItemList(saleItemList);
        saleHeadVO.setServiceTime(new Date());
        return Result.ok((Object)((Object)saleHeadVO));
    }

    private void rank(List<PurchaseEbiddingItem> allList, SaleEbiddingItem saleItem, String ebiddingWay, String ebiddingType) {
        List sortList = EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay) ? (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? allList.stream().filter(item -> item.getNetPrice() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getNetPrice).reversed().thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()) : allList.stream().filter(item -> item.getNetPrice() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getNetPrice).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList())) : (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? allList.stream().filter(item -> item.getNetTotalAmount() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getNetTotalAmount).reversed().thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()) : allList.stream().filter(item -> item.getNetTotalAmount() != null && item.getQuoteTime() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getNetTotalAmount).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()));
        for (int i = 0; i < sortList.size(); ++i) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
                if (!saleItem.getId().equals(((PurchaseEbiddingItem)((Object)sortList.get(i))).getRelationId())) continue;
                int rank = i + 1;
                saleItem.setQuoteRank(rank);
                break;
            }
            if (!saleItem.getElsAccount().equals(((PurchaseEbiddingItem)((Object)sortList.get(i))).getToElsAccount())) continue;
            int rank = i + 1;
            saleItem.setQuoteRank(rank);
            break;
        }
    }

    @AutoLog(value="\u9500\u552e\u7ade\u4ef7\u5934-\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650")
    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650", notes="\u7ade\u4ef7\u5927\u5385\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650")
    @PostMapping(value={"/setUpper"})
    public Result<?> setUpper(@RequestBody SaleEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getChangeRangeUpper(), (String)I18nUtil.translate((String)"", (String)"\u5e45\u5ea6\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()) || EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(dbHead.getEbiddingStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u6216\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\u53ef\u4ee5\u8bbe\u7f6e\u5e45\u5ea6\u4e0a\u9650");
        Assert.isTrue((headVO.getChangeRangeUpper().compareTo(dbHead.getChangeRange()) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5e45\u5ea6\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e\u5e45\u5ea6\u4e0b\u7ebf"));
        dbHead.setChangeRangeUpper(headVO.getChangeRangeUpper());
        ((SaleEbiddingHeadService)this.service).updateById((Object)dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7", busModule="\u9500\u552e\u7ade\u4ef7\u5934")
    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7", notes="\u65e5\u5f0f/\u8377\u5f0f-\u63a5\u53d7\u62a5\u4ef7")
    @GetMapping(value={"/quoteAccept"})
    public Result<?> quoteAccept(@RequestParam(value="itemHisId") String itemHisId) {
        SaleEbiddingItemHis dbItemHis = (SaleEbiddingItemHis)((Object)this.saleEbiddingItemHisService.getById((Serializable)((Object)itemHisId)));
        SaleEbiddingItem dbItem = (SaleEbiddingItem)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)dbItemHis.getItemId())));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u63a5\u53d7"));
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)dbItemHis.getHeadId())));
        SaleEbiddingItem quoteItem = new SaleEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
        quoteItem.setId(dbItem.getId());
        quoteItem.setRelationId(dbItem.getRelationId());
        ((SaleEbiddingHeadService)this.service).quoteAccept(dbHead, dbItemHis, quoteItem);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7", busModule="\u9500\u552e\u7ade\u4ef7\u5934")
    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7", notes="\u65e5\u5f0f/\u8377\u5f0f-\u62d2\u7edd\u62a5\u4ef7")
    @GetMapping(value={"/quoteReject"})
    public Result<?> quoteReject(@RequestParam(value="itemHisId") String itemHisId) {
        SaleEbiddingItemHis dbItemHis = (SaleEbiddingItemHis)((Object)this.saleEbiddingItemHisService.getById((Serializable)((Object)itemHisId)));
        SaleEbiddingItem dbItem = (SaleEbiddingItem)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)dbItemHis.getItemId())));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u62d2\u7edd"));
        SaleEbiddingHead dbHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadService)this.service).getById((Serializable)((Object)dbItemHis.getHeadId())));
        SaleEbiddingItem quoteItem = new SaleEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)dbItemHis), (Object)((Object)quoteItem));
        quoteItem.setId(dbItem.getId());
        quoteItem.setRelationId(dbItem.getRelationId());
        ((SaleEbiddingHeadService)this.service).quoteReject(dbHead, dbItemHis, quoteItem);
        return this.commonSuccessResult(3);
    }
}

