/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.websocket;

import cn.hutool.core.lang.UUID;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/online/{purchaseHeadId}/{elsAccount}")
public class OnlineWebSocket {
    private static final Logger log = LoggerFactory.getLogger(OnlineWebSocket.class);
    private Session session;
    private String purchaseHeadId;
    private String elsAccount;
    private String id;
    private static Map<String, List<OnlineWebSocket>> clientMap = new ConcurrentHashMap<String, List<OnlineWebSocket>>();
    private RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
    private final String redisKeyPrefix = "online:cache:users:";
    private final long expire = 172800L;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="purchaseHeadId") String purchaseHeadId, @PathParam(value="elsAccount") String elsAccount) {
        try {
            this.session = session;
            this.purchaseHeadId = purchaseHeadId;
            this.elsAccount = elsAccount;
            this.id = UUID.randomUUID().toString();
            List<OnlineWebSocket> clients = clientMap.get(purchaseHeadId);
            if (clients == null) {
                clients = new ArrayList<OnlineWebSocket>();
            }
            clients.add(this);
            clientMap.put(purchaseHeadId, clients);
            String redisKey = "online:cache:users:" + purchaseHeadId;
            ArrayList<String> elsAccountList = (ArrayList<String>)this.redis.get(redisKey);
            if (elsAccountList == null) {
                elsAccountList = new ArrayList<String>();
                elsAccountList.add(elsAccount);
            } else {
                elsAccountList.add(elsAccount);
            }
            this.redis.set(redisKey, elsAccountList, 172800L);
            this.redis.publish("hall-online-topic", (Object)purchaseHeadId);
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnClose
    public void onClose() {
        try {
            String redisKey;
            List elsAccountList;
            List<OnlineWebSocket> clients = clientMap.get(this.purchaseHeadId);
            if (clients != null) {
                List result = clients.stream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.purchaseHeadId, result);
            }
            if ((elsAccountList = (List)this.redis.get(redisKey = "online:cache:users:" + this.purchaseHeadId)) != null) {
                elsAccountList.remove(this.elsAccount);
                this.redis.set(redisKey, (Object)elsAccountList, 172800L);
            } else {
                this.redis.del(new String[]{redisKey});
            }
            this.redis.publish("hall-online-topic", (Object)this.purchaseHeadId);
            log.info("\u3010OnlineWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        this.session.getAsyncRemote().sendText(message);
    }

    public void sendOnlineUsersMessage(String purchaseHeadId) {
        List<OnlineWebSocket> clients = clientMap.get(purchaseHeadId);
        if (clients != null && !clients.isEmpty()) {
            String redisKey = "online:cache:users:" + purchaseHeadId;
            List elsAccountList = (List)this.redis.get(redisKey);
            String onlineUsers = elsAccountList == null ? "" : String.join((CharSequence)",", elsAccountList);
            for (OnlineWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                try {
                    socket.session.getAsyncRemote().sendText(onlineUsers);
                }
                catch (Exception e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }
}

