/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.vo.SupplierInvesttreeInfoVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingSupplierMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierCompanyHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierHumanHoldingDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingSupplierServiceImpl
extends ServiceImpl<PurchaseEbiddingSupplierMapper, PurchaseEbiddingSupplier>
implements PurchaseEbiddingSupplierService {
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;

    @Override
    public List<PurchaseEbiddingSupplier> selectByMainId(String mainId) {
        return ((PurchaseEbiddingSupplierMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void addBatch(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        if (CollectionUtil.isNotEmpty(supplierList)) {
            int supplierItemNumber = 1;
            for (PurchaseEbiddingSupplier supplier : supplierList) {
                supplier.setId(IdWorker.getIdStr());
                supplier.setHeadId(head.getId());
                supplier.setEbiddingNumber(head.getEbiddingNumber());
                supplier.setItemNumber(String.valueOf(supplierItemNumber++));
                SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            }
            this.saveBatch(supplierList, 2000);
        }
    }

    @Override
    public void publish(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        int supplierItemNumber = 1;
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            supplier.setId(IdWorker.getIdStr());
            supplier.setEbiddingNumber(head.getEbiddingNumber());
            supplier.setHeadId(head.getId());
            String replyStatus = "1".equals(head.getNeedEcho()) ? EbiddingReplyStatusEnum.WAIT_REPLY.getValue() : EbiddingReplyStatusEnum.NOT_NEED.getValue();
            supplier.setReplyStatus(replyStatus);
            supplier.setCurrentRound(head.getCurrentRound());
            supplier.setItemNumber(String.valueOf(supplierItemNumber++));
        }
        this.saveBatch(supplierList, 2000);
    }

    @Override
    public void updateBidResultBatch(List<PurchaseEbiddingSupplier> supplierList) {
        ((PurchaseEbiddingSupplierMapper)this.baseMapper).updateBidResultBatch(supplierList);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingSupplierMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<SupplierRelationFindResultVO> probe(Map<String, PurchaseEbiddingSupplier> supplierMap) {
        List<EnterpriseRiskDTO> riskList = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(supplierMap.keySet());
        if (riskList.isEmpty()) {
            return new ArrayList<SupplierRelationFindResultVO>();
        }
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        Map riskMap = riskList.stream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
        HashMap<String, Map<String, String>> supplierInvestTreeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : riskMap.entrySet()) {
            String elsAccount = entry.getKey();
            EnterpriseRiskDTO risk = (EnterpriseRiskDTO)riskMap.get(elsAccount);
            HashMap investTreeMap = new HashMap();
            risk.getSupplierInvesttreeList().forEach(dto -> {
                investTreeMap.put(dto.getCreditCode(), dto.getSupplierName());
                this.getAllSupplierCreditCode(investTreeMap, dto.getChildren());
            });
            supplierInvestTreeMap.put(elsAccount, investTreeMap);
            Map<String, String> humanHoldingMap = risk.getSupplierHumanHoldingList().stream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
            supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
            Map<String, String> companyHoldingMap = risk.getSupplierCompanyHoldingList().stream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
            supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
        }
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierInvestTreeMap, RiskTypeEnum.INVESTTREE.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(supplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        return relationFindResultList;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRisk(Map<String, PurchaseEbiddingSupplier> supplierMap, Map<String, Map<String, String>> riskMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : riskMap.entrySet()) {
            String elsAccount = entry.getKey();
            hadCheckedList.add(elsAccount);
            for (Map.Entry<String, Map<String, String>> nextEntry : riskMap.entrySet()) {
                String nextElsAccount = nextEntry.getKey();
                if (hadCheckedList.contains(nextElsAccount)) continue;
                Map<String, String> nextInvestTreeMap = nextEntry.getValue();
                for (String compareKey : nextInvestTreeMap.keySet()) {
                    if (!entry.getValue().containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(supplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(supplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setType(type);
                    findResultVO.setResult(nextInvestTreeMap.get(compareKey));
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    private void getAllSupplierCreditCode(Map<String, String> supplierMap, String children) {
        if (StringUtils.isBlank((CharSequence)children) || "[]".equals(children)) {
            return;
        }
        List investTreeInfoList = JSON.parseArray((String)children, SupplierInvesttreeInfoVO.class);
        investTreeInfoList.forEach(info -> {
            if (StringUtils.isNotBlank((CharSequence)info.getCreditCode())) {
                supplierMap.put(info.getCreditCode(), info.getName());
            }
            this.getAllSupplierCreditCode(supplierMap, info.getChildren());
        });
    }
}

