/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingItemServiceImpl
extends ServiceImpl<PurchaseEbiddingItemMapper, PurchaseEbiddingItem>
implements PurchaseEbiddingItemService {
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Override
    public List<PurchaseEbiddingItem> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void addBatch(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            for (PurchaseEbiddingItem item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingItemStatusEnum.NEW.getValue());
                item.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                item.setSendStatus("0");
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.saveBatch(itemList, 2000);
        }
    }

    @Override
    public List<PurchaseEbiddingItem> publish(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, Map<String, PurchaseMaterialRelationDTO> relationMap) {
        ArrayList<PurchaseEbiddingItem> insertList = new ArrayList<PurchaseEbiddingItem>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            int itemNumber = 1;
            for (PurchaseEbiddingItem item : itemList) {
                PurchaseEbiddingItem insertItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insertItem));
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItem.setId(IdWorker.getIdStr());
                insertItem.setRelationId(IdWorker.getIdStr());
                insertItem.setHeadId(head.getId());
                insertItem.setEbiddingNumber(head.getEbiddingNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setItemStatus(EbiddingItemStatusEnum.PUBLISHED.getValue());
                insertItem.setCurrentRound(head.getCurrentRound());
                if (StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                insertList.add(insertItem);
            }
        }
        this.saveBatch(insertList, 2000);
        return insertList;
    }

    @Override
    public void updateBidByHeadId(List<PurchaseEbiddingItem> purchaseItemList) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).updateBidByHeadId(purchaseItemList);
    }

    @Override
    public PurchaseEbiddingItem selectOneByMainIdAndItemNumber(String headId, String itemNumber) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, itemNumber);
    }

    @Override
    public void replenishMaterialNumber(PurchaseEbiddingItem webItem) {
        List<PurchaseEbiddingItem> itemList = this.selectByMainId(webItem.getHeadId()).stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        itemList.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        this.updateBatchById(itemList);
        SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
        saleEbiddingItemService.replenishMaterialNumber(itemList);
        PurchaseEbiddingItem item2 = itemList.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item2.getSourceType()) && StringUtils.isNotBlank((CharSequence)item2.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item2.getSourceItemId(), item2.getMaterialNumber(), item2.getMaterialDesc(), item2.getMaterialGroup(), item2.getMaterialSpec());
        }
    }
}

