/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.entity.SaleClarificationInfo;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.mapper.PurchaseClarificationInfoMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleClarificationInfoService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseClarificationInfoServiceImpl
extends BaseServiceImpl<PurchaseClarificationInfoMapper, PurchaseClarificationInfo>
implements PurchaseClarificationInfoService {
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private SaleClarificationInfoService saleClarificationInfoService;
    @Autowired
    private PurchaseClarificationInfoMapper purchaseClarificationInfoMapper;
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void savePurchaseClarificationInfo(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        purchaseClarificationInfo.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)purchaseClarificationInfo.getSendStatus())) {
            purchaseClarificationInfo.setSendStatus("0");
        }
        purchaseClarificationInfo.setClarificationNumber(this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)purchaseClarificationInfo));
        ((PurchaseClarificationInfoMapper)this.baseMapper).insert((Object)purchaseClarificationInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updatePurchaseClarificationInfo(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        int count = ((PurchaseClarificationInfoMapper)this.baseMapper).updateById((Object)purchaseClarificationInfo);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delPurchaseClarificationInfo(String id) {
        ((PurchaseClarificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchPurchaseClarificationInfo(List<String> idList) {
        ((PurchaseClarificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void publish(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments) {
        PurchaseBiddingHead biddingHead;
        purchaseClarificationInfo.setSendStatus("1");
        if (StringUtils.isBlank((CharSequence)purchaseClarificationInfo.getId())) {
            this.savePurchaseClarificationInfo(purchaseClarificationInfo, attachments);
        } else {
            this.updatePurchaseClarificationInfo(purchaseClarificationInfo, attachments);
        }
        HashMap<String, String> suppliers = null;
        if (purchaseClarificationInfo.getBusinessType().equals(BusinessBillTypeEnum.EBIDDING.getValue())) {
            PurchaseEbiddingHead ebiddingHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)purchaseClarificationInfo.getBusinessId())));
            if (ebiddingHead != null) {
                suppliers = new HashMap<String, String>();
                List<PurchaseEbiddingSupplier> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(ebiddingHead.getId());
                for (PurchaseEbiddingSupplier purchaseEbiddingSupplier : dbSupplierList) {
                    suppliers.put(purchaseEbiddingSupplier.getToElsAccount(), purchaseEbiddingSupplier.getSupplierName());
                }
                this.sendToSupplier(purchaseClarificationInfo, attachments, suppliers);
            }
        } else if (purchaseClarificationInfo.getBusinessType().equals(BusinessBillTypeEnum.ENQUIRY.getValue())) {
            PurchaseEnquiryHead enquiryHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)purchaseClarificationInfo.getBusinessId())));
            if (enquiryHead != null) {
                suppliers = new HashMap();
                List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(enquiryHead.getId());
                for (EnquirySupplierList enquirySupplierList : supplierList) {
                    suppliers.put(enquirySupplierList.getToElsAccount(), enquirySupplierList.getSupplierName());
                }
                this.sendToSupplier(purchaseClarificationInfo, attachments, suppliers);
            }
        } else if (purchaseClarificationInfo.getBusinessType().equals(BusinessBillTypeEnum.CALL_BIDS.getValue()) && (biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)purchaseClarificationInfo.getBusinessId())))) != null) {
            suppliers = new HashMap();
            List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(biddingHead.getId());
            for (BiddingSupplier biddingSupplier : biddingSupplierList) {
                suppliers.put(biddingSupplier.getToElsAccount(), biddingSupplier.getSupplierName());
            }
            this.sendToSupplier(purchaseClarificationInfo, attachments, suppliers);
        }
    }

    public void sendToSupplier(PurchaseClarificationInfo purchaseClarificationInfo, List<PurchaseAttachmentDTO> attachments, Map<String, String> suppliers) {
        if (suppliers != null && suppliers.size() > 0) {
            Set<String> toElsAccounts = suppliers.keySet();
            ArrayList<String> recevieAccount = new ArrayList<String>();
            for (String string : toElsAccounts) {
                this.saveSaleClarification(purchaseClarificationInfo, string, attachments);
                recevieAccount.add(string);
            }
            String url = "id=" + purchaseClarificationInfo.getRelationId();
            super.sendMsg(TenantContext.getTenant(), recevieAccount, (Object)purchaseClarificationInfo, url, "clarification", "publish");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addClarificationInfoForSupplier(String businessType, String businessNumber, String toElsAccount, String supplierName) {
        List<PurchaseClarificationInfo> clarificationInfos = this.purchaseClarificationInfoMapper.getByKey(TenantContext.getTenant(), businessType, businessNumber);
        if (clarificationInfos != null && clarificationInfos.size() > 0) {
            for (PurchaseClarificationInfo purchaseClarificationInfo : clarificationInfos) {
                List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseClarificationInfo.getId());
                this.saveSaleClarification(purchaseClarificationInfo, toElsAccount, attachments);
            }
        }
        this.purchaseMentoringHeadService.addMentoringInfoForSupplier(businessType, businessNumber, toElsAccount, supplierName);
    }

    public void saveSaleClarification(PurchaseClarificationInfo purchaseClarificationInfo, String toElsAccount, List<PurchaseAttachmentDTO> attachments) {
        SaleClarificationInfo saleClarificationInfo = new SaleClarificationInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseClarificationInfo), (Object)((Object)saleClarificationInfo));
        saleClarificationInfo.setId(null);
        saleClarificationInfo.setRelationId(purchaseClarificationInfo.getId());
        saleClarificationInfo.setElsAccount(toElsAccount);
        saleClarificationInfo.setToElsAccount(purchaseClarificationInfo.getElsAccount());
        saleClarificationInfo.setViewStatus("0");
        saleClarificationInfo.setReceiveTime(new Date());
        this.saleClarificationInfoService.saveSaleClarificationInfo(saleClarificationInfo);
        if (attachments != null && attachments.size() > 0) {
            ArrayList<SaleAttachmentDTO> saleAttachmentArrayList = new ArrayList<SaleAttachmentDTO>();
            ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                if (StringUtils.isBlank((CharSequence)purchaseAttachment.getHeadId()) || StringUtils.isNotBlank((CharSequence)purchaseAttachment.getHeadId()) && "undefined".equals(purchaseAttachment.getHeadId())) {
                    purchaseAttachment.setHeadId(purchaseClarificationInfo.getId());
                    purchaseAttachments.add(purchaseAttachment);
                }
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(null);
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(toElsAccount);
                saleAttachment.setHeadId(saleClarificationInfo.getId());
                saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                saleAttachmentArrayList.add(saleAttachment);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentArrayList);
        }
    }
}

