/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryScopeEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.job.utils.EnquiryJobUtil;
import com.els.modules.enquiry.mapper.PurchaseEnquiryHeadMapper;
import com.els.modules.enquiry.rocketMq.util.EnquiryMqUtil;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PublicEnquiryService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.service.impl.PublicEnquiryServiceImpl;
import com.els.modules.enquiry.vo.PurchaseAwardOpinionVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.inquiry.service.PublishToB2BService;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseEnquiryHeadServiceImpl
extends BaseServiceImpl<PurchaseEnquiryHeadMapper, PurchaseEnquiryHead>
implements PurchaseEnquiryHeadService,
PurchaseExecuteReviewService {
    @Resource
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PublishToB2BService publishToB2BService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Autowired
    private PurchaseQualificationReviewService purchaseQualificationReviewService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEnquiryHeadVO headVO) {
        SysUtil.setNullCreate((BaseEntity)headVO);
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, false);
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmEnquiryNumber", (Object)head);
        head.setEnquiryNumber(enquiryNumber);
        super.setHeadDefaultValue((BaseEntity)head);
        ((PurchaseEnquiryHeadMapper)this.baseMapper).insert((Object)head);
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        this.insertData(head, itemList, headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue());
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEnquiryHeadVO headVO) {
        SysUtil.setNullCreate((BaseEntity)headVO);
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, false);
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        int count = ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.deleteSubTable(head.getId());
        this.insertData(head, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
    }

    private void deleteSubTable(String headId) {
        this.purchaseEnquiryItemService.deleteByMainId(headId);
        this.enquirySupplierListService.deleteByMainId(headId);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    public static void setHeadParamAndCheck(PurchaseEnquiryHeadVO headVO, boolean isPublish) {
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setEnquiryStatus(isPublish ? EnquiryStatusEnum.QUOTING.getValue() : EnquiryStatusEnum.NEW.getValue());
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus("1".equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setOpenBidStatus("0");
        if (isPublish) {
            List<PurchaseAttachmentDemandDTO> demandList;
            Date currentDate = new Date();
            headVO.setPublishTime(currentDate);
            LoginUser user = SysUtil.getLoginUser();
            headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
            headVO.setEnquiryDate(headVO.getEnquiryDate() == null ? currentDate : headVO.getEnquiryDate());
            headVO.setAllowDelay(StrUtil.isBlank((CharSequence)headVO.getAllowDelay()) ? "1" : headVO.getAllowDelay());
            headVO.setEnquiryScope(StrUtil.isBlank((CharSequence)headVO.getEnquiryScope()) ? EnquiryScopeEnum.INVITE.getValue() : headVO.getEnquiryScope());
            Assert.notNull((Object)headVO.getQuoteEndTime(), (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getQuoteEndTime().after(currentDate), (String)I18nUtil.translate((String)"i18n_alert_suyRKIlTfUAPKI_7f71245d", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            if (headVO.getQuoteConfirmTime() != null) {
                Assert.isTrue((boolean)headVO.getQuoteConfirmTime().after(currentDate), (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                Assert.isTrue((boolean)headVO.getQuoteConfirmTime().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4"));
            }
            if (EnquiryScopeEnum.PUBLIC.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIxOLV_a953b64e", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().after(currentDate), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTfUAPKI_8dd43873", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUsuyRKI_c93a6f5b", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4"));
                if (headVO.getQuoteConfirmTime() != null) {
                    Assert.isTrue((boolean)headVO.getApplyEndTime().before(headVO.getQuoteConfirmTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4"));
                }
            }
            if ("1".equals(headVO.getOpenBidBefore())) {
                Assert.hasText((String)headVO.getOpenBidPassword(), (String)I18nUtil.translate((String)"", (String)"\u5f00\u6807\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
            ArrayList checkEmptyLadderPriceRows = new ArrayList();
            headVO.getPurchaseEnquiryItemList().forEach(item -> {
                PurchaseEnquiryHeadServiceImpl.headToItem(headVO, item);
                Assert.notNull((Object)item.getQuotePriceWay(), (String)I18nUtil.translate((String)"i18n_alert_suCKxOLV_4d9cccf8", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
                if ("1".equals(headVO.getMustMaterialNumber())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (!"1".equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay()) && StrUtil.isBlank((CharSequence)item.getLadderPriceJson())) {
                    checkEmptyLadderPriceRows.add(item.getItemNumber());
                }
                item.setQuoteFlag(headVO.getQuoteConfirmTime() == null ? "1" : "0");
                BigDecimal purchaseCycle = StrUtil.isBlank((CharSequence)item.getPurchaseCycle()) ? null : new BigDecimal(item.getPurchaseCycle());
                Assert.isTrue((purchaseCycle == null || purchaseCycle.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_nRsAlTLiW_d97980b4", (String)"\u91c7\u8d2d\u5468\u671f\u5fc5\u987b\u4e3a\u6b63\u6570"));
                Assert.notNull((Object)item.getRequireQuantity(), (String)I18nUtil.translate((String)"", (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            });
            Assert.isTrue((boolean)CollectionUtil.isEmpty(checkEmptyLadderPriceRows), (String)I18nUtil.translate((String)"", (String)("\u7b2c" + String.join((CharSequence)",", checkEmptyLadderPriceRows) + "\u884c\u62a5\u4ef7\u65b9\u5f0f\u4e3a\"\u9636\u68af\u62a5\u4ef7\"\uff0c\u8bf7\u8bbe\u7f6e\"\u9636\u68af\u62a5\u4ef7JSON\"")));
            if (EnquiryScopeEnum.INVITE.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notEmpty(headVO.getEnquirySupplierListList(), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
                if (headVO.getParticipateQuantity() != null) {
                    Assert.isTrue((headVO.getEnquirySupplierListList().size() >= headVO.getParticipateQuantity() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_diRdXWRlTfUEUsUWR_fa3da170", (String)"\u6240\u9009\u4f9b\u5e94\u5546\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53c2\u4e0e\u6570\u91cf"));
                }
            } else {
                Assert.hasText((String)headVO.getEnquiryScope(), (String)I18nUtil.translate((String)"", (String)"\u8be2\u4ef7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (CollectionUtil.isNotEmpty(demandList = headVO.getPurchaseAttachmentDemandList())) {
                List distinctList = demandList.stream().map(demand -> demand.getFileType() + "_" + demand.getStageType()).distinct().collect(Collectors.toList());
                Assert.isTrue((demandList.size() == distinctList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u540c\u4e00\u9636\u6bb5\u5b58\u5728\u91cd\u590d\u9644\u4ef6\u9700\u6c42"));
                for (PurchaseAttachmentDemandDTO purchaseAttachmentDemandDTO : demandList) {
                    Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getFileType()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getStageType()), (String)I18nUtil.translate((String)"", (String)"\u9636\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
        }
    }

    private static void headToItem(PurchaseEnquiryHead head, PurchaseEnquiryItem item) {
        item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
        item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
        item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
    }

    @Override
    public void insertData(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList, List<PurchaseAttachmentDemandDTO> demandList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            LoginUser sysUser = SysUtil.getLoginUser();
            for (PurchaseEnquiryItem item : itemList) {
                item.setId(null);
                item.setHeadId(head.getId());
                item.setEnquiryNumber(head.getEnquiryNumber());
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setToElsAccount("");
                item.setPurchaseName(sysUser.getEnterpriseName());
                item.setItemStatus(EnquiryStatusEnum.NEW.getValue());
                item.setAuditStatus("1".equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setNullCreate((BaseEntity)item);
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEnquiryItemService.saveBatch(itemList, 2000);
        }
        if (CollectionUtil.isNotEmpty(supplierList)) {
            for (EnquirySupplierList supplier : supplierList) {
                supplier.setId(null);
                supplier.setHeadId(head.getId());
                SysUtil.setNullCreate((BaseEntity)supplier);
                SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            }
            this.enquirySupplierListService.saveBatch(supplierList, 2000);
        }
        for (PurchaseAttachmentDemandDTO purchaseAttachmentDemandDTO : demandList) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getFileType()), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getStageType()), (String)I18nUtil.translate((String)"", (String)"\u9636\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(demandList, head.getId(), "enquiry");
    }

    @Override
    public void goBackDemand(List<PurchaseEnquiryItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List<String> idList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).map(PurchaseEnquiryItem::getSourceItemId).distinct().collect(Collectors.toList());
            this.purchaseRequestItemService.updateStatusById(idList, status);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjVIzEjtFqQG_65b871ca", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u53ef\u5220\u9664"));
        String auditStatus = dbHead.getAuditStatus();
        boolean delete = !AuditStatusEnum.AUDIT_DOING.getValue().equals(auditStatus) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus);
        Assert.isTrue((boolean)delete, (String)I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEnquiryItem> purchaseEnquiryItems = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        this.goBackDemand(purchaseEnquiryItems, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.purchaseEnquiryItemService.deleteByMainId(id);
        this.enquirySupplierListService.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
        ((PurchaseEnquiryHeadMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        idList.forEach(this::delMain);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, true);
        if (StrUtil.isNotBlank((CharSequence)headVO.getOpenBidPassword())) {
            headVO.setOpenBidPassword(AesEncryptUtil.encrypt((String)headVO.getOpenBidPassword()));
        }
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        List<EnquirySupplierList> supplierList = headVO.getEnquirySupplierListList();
        List<PurchaseAttachmentDemandDTO> demandList = headVO.getPurchaseAttachmentDemandList();
        boolean supplierEmpty = CollectionUtils.isEmpty(supplierList);
        head.setEnquiryStatus(supplierEmpty ? head.getEnquiryStatus() : EnquiryStatusEnum.PUBLISHING.getValue());
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmEnquiryNumber", (Object)head);
            head.setEnquiryNumber(enquiryNumber);
            ((PurchaseEnquiryHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)head);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.deleteSubTable(head.getId());
        }
        this.insertInitTable(head.getId(), itemList);
        if (supplierEmpty) {
            this.insertData(head, itemList, supplierList, demandList);
        } else {
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            headVO.setPurchaseEnquiryItemList(itemList);
            headVO.setEnquirySupplierListList(supplierList);
            headVO.setPurchaseAttachmentDemandList(demandList);
            LoginUser user = SysUtil.getLoginUser();
            JSONObject msg = new JSONObject();
            msg.put("user", (Object)user);
            msg.put("content", (Object)headVO);
            msg.put("tenant", (Object)TenantContext.getTenant());
            EnquiryMqUtil.sendPublishMsg(msg.toJSONString());
        }
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(head.getEnquiryScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                PublicEnquiryService publicEnquiryService = (PublicEnquiryService)SpringContextUtils.getBean(PublicEnquiryServiceImpl.class);
                publicEnquiryService.publishNotice(head);
                if (publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                    this.publishToB2BService.publishToB2B(head, itemList);
                }
            }
        }
        EnquiryJobUtil.updateOrCreateJob(head, head.getQuoteEndTime());
    }

    private void insertInitTable(String headId, List<PurchaseEnquiryItem> itemList) {
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)TenantContext.getTenant());
        object.put("relationId", (Object)headId);
        object.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(object.toJSONString());
    }

    @Override
    public AttachmentSendDTO publishEnquiry(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList, List<PurchaseAttachmentDemandDTO> demandList, String enterpriseName, String loginSubAccount) {
        List<String> toElsAccountList = supplierList.stream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEnquiryItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseEnquiryItem> insertItemList = new ArrayList<PurchaseEnquiryItem>();
        LoginUser user = SysUtil.getLoginUser();
        for (EnquirySupplierList supplier : supplierList) {
            supplier.setId(IdWorker.getIdStr());
            supplier.setHeadId(head.getId());
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            int itemNumber = 1;
            for (PurchaseEnquiryItem item2 : itemList) {
                PurchaseEnquiryItem insertItem = new PurchaseEnquiryItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)insertItem));
                insertItem.setId(null);
                insertItem.setRelationId(IdWorker.getIdStr());
                insertItem.setHeadId(head.getId());
                insertItem.setSupplierId(supplier.getId());
                insertItem.setEnquiryNumber(head.getEnquiryNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setItemStatus(EnquiryStatusEnum.QUOTING.getValue());
                insertItem.setAuditStatus("1".equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                insertItem.setPurchaseName(user.getEnterpriseName());
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                insertItem.setNeedCoordination(supplier.getNeedCoordination());
                if (EnquiryQuoteWayEnum.NORMAL.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setLadderPriceJson(null);
                    insertItem.setCostFormJson(null);
                } else if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setCostFormJson(null);
                } else {
                    insertItem.setLadderPriceJson(null);
                }
                insertItem.setSendStatus("0");
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item2.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                insertItem.setQuoteEndTime(head.getQuoteEndTime());
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItemList.add(insertItem);
            }
        }
        this.purchaseEnquiryItemService.saveBatch(insertItemList, 2000);
        this.enquirySupplierListService.saveBatch(supplierList, 2000);
        Map<String, SaleEnquiryHead> supplierMap = this.saleEnquiryHeadService.add(head, insertItemList, supplierList, enterpriseName, loginSubAccount);
        HashMap<String, String> idMap = new HashMap<String, String>();
        supplierMap.forEach((key, value) -> idMap.put((String)key, value.getId()));
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, head.getId(), "enquiry", idMap);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(head.getId());
        HashMap toSend = new HashMap();
        idMap.forEach((key, value) -> toSend.put(value, key));
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        head.setPurchaseCompanyName(user.getEnterpriseName());
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)head, receiveParamMap, "enquiry", "publish");
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEnquiryHead dbHead, List<EnquirySupplierList> chooseSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.enquirySupplierListService.selectByMainId(headId).stream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<EnquirySupplierList> supplierList = chooseSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        LoginUser user = SysUtil.getLoginUser();
        this.publishEnquiry(dbHead, itemList, supplierList, demandList, user.getEnterpriseName(), user.getSubAccount());
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (EnquirySupplierList supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateQuoteEntTime(PurchaseEnquiryHead dbHead, Date quoteEndTime) {
        PurchaseEnquiryHead updateHead = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)updateHead));
        updateHead.setQuoteEndTime(quoteEndTime);
        updateHead.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
        this.updateById((Object)updateHead);
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        itemList.forEach(item -> {
            item.setQuoteEndTime(quoteEndTime);
            if (EnquiryStatusEnum.NO_QUOTE.getValue().equals(item.getItemStatus())) {
                item.setItemStatus(EnquiryStatusEnum.QUOTING.getValue());
            }
        });
        this.purchaseEnquiryItemService.updateBatchById(itemList);
        this.saleEnquiryHeadService.updateQuoteEntTime(dbHead.getId(), quoteEndTime, itemList);
        EnquiryJobUtil.updateOrCreateJob(dbHead, quoteEndTime);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void openBid(PurchaseEnquiryHead dbHead, boolean isJob) {
        String purchaseHeadId = dbHead.getId();
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(purchaseHeadId);
        List quotingList = itemList.stream().filter(item -> EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (!isJob) {
            Assert.isTrue((quotingList.size() != itemList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6ca1\u6709\u4efb\u4f55\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u63d0\u524d\u5f00\u6807"));
        }
        String enquiryStatus = quotingList.size() == itemList.size() ? EnquiryStatusEnum.NO_QUOTE.getValue() : EnquiryStatusEnum.BARGAIN.getValue();
        dbHead.setEnquiryStatus(enquiryStatus);
        dbHead.setOpenBidStatus("1");
        this.updateById((Object)dbHead);
        for (PurchaseEnquiryItem item2 : itemList) {
            String itemStatus = EnquiryStatusEnum.QUOTING.getValue().equals(item2.getItemStatus()) ? EnquiryStatusEnum.NO_QUOTE.getValue() : item2.getItemStatus();
            item2.setItemStatus(itemStatus);
        }
        this.purchaseEnquiryItemService.updateBatchById(itemList, 2000);
        this.saleEnquiryHeadService.openBid(dbHead.getId(), itemList);
        EnquiryJobUtil.deleteJob(dbHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void oneAward(PurchaseEnquiryHead dbHead, String optType) {
        Map<String, List<PurchaseEnquiryItem>> itemMap;
        ArrayList<PurchaseEnquiryItem> pricedList = new ArrayList<PurchaseEnquiryItem>();
        List<PurchaseEnquiryItem> dbItemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        List distinctList = dbItemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        int i = 1;
        for (Object item2 : distinctList) {
            List<String> list = Arrays.asList(EnquiryStatusEnum.QUOTED.getValue(), EnquiryStatusEnum.BARGAIN.getValue());
            Assert.isTrue((boolean)list.contains(((PurchaseEnquiryItem)((Object)item2)).getItemStatus()), (String)I18nUtil.translate((String)"", (String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c" + i++ + "\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c")));
        }
        if ("minPrice".equals(optType)) {
            itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getItemNumber));
            for (Map.Entry entry : itemMap.entrySet()) {
                List itemList = (List)entry.getValue();
                List needSortList = itemList.stream().filter(item -> item.getPrice() != null).collect(Collectors.toList());
                List<PurchaseEnquiryItem> sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItem::getPrice).thenComparing(PurchaseEnquiryItem::getQuoteTime)).collect(Collectors.toList());
                this.setItemStatus(dbHead, sortList, itemList, false);
                pricedList.addAll(itemList);
            }
        } else if ("minNetPrice".equals(optType)) {
            itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getItemNumber));
            for (Map.Entry entry : itemMap.entrySet()) {
                List itemList = (List)entry.getValue();
                List needSortList = itemList.stream().filter(item -> item.getNetPrice() != null).collect(Collectors.toList());
                List<PurchaseEnquiryItem> sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItem::getNetPrice).thenComparing(PurchaseEnquiryItem::getQuoteTime)).collect(Collectors.toList());
                this.setItemStatus(dbHead, sortList, itemList, false);
                pricedList.addAll(itemList);
            }
        } else if ("minPackagePrice".equals(optType)) {
            Map<String, PurchaseEnquiryItem> packageMap = dbItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getToElsAccount, item -> {
                BigDecimal taxAmount = item.getTaxAmount();
                Assert.notNull((Object)taxAmount, (String)"\u5b58\u5728\u672a\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807");
                Assert.isTrue((boolean)"0".equals(item.getQuotePrice()), (String)"\u5b58\u5728\u4e0d\u80fd\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807");
                return item;
            }, (oldVal, newVal) -> {
                BigDecimal newTaxAmount = newVal.getTaxAmount();
                Assert.notNull((Object)newTaxAmount, (String)"\u5b58\u5728\u672a\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807");
                Assert.isTrue((boolean)"0".equals(newVal.getQuotePrice()), (String)"\u5b58\u5728\u4e0d\u80fd\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807");
                BigDecimal oldTaxAmount = oldVal.getTaxAmount();
                oldVal.setTaxAmount(oldTaxAmount.add(newTaxAmount));
                return oldVal;
            }));
            ArrayList needSortList = new ArrayList();
            packageMap.forEach((key, value) -> needSortList.add(value));
            List<PurchaseEnquiryItem> list = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItem::getTaxAmount).thenComparing(PurchaseEnquiryItem::getQuoteTime)).collect(Collectors.toList());
            this.setItemStatus(dbHead, list, dbItemList, true);
            pricedList.addAll(dbItemList);
        }
        List<String> acceptAccountList = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        this.checkReview(dbHead, acceptAccountList);
        this.purchaseEnquiryItemService.updateBatchById(pricedList);
    }

    private void setItemStatus(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> sortList, List<PurchaseEnquiryItem> itemList, boolean isPackage) {
        if (CollectionUtil.isNotEmpty(sortList)) {
            PurchaseEnquiryItem min = sortList.get(0);
            for (PurchaseEnquiryItem item2 : itemList) {
                if (isPackage && min.getToElsAccount().equals(item2.getToElsAccount()) || !isPackage && min.getId().equals(item2.getId())) {
                    BigDecimal quota = QuotaWayEnum.QUANTITY.getValue().equals(dbHead.getQuotaWay()) ? item2.getRequireQuantity() : BigDecimal.valueOf(100L);
                    item2.setQuota(quota);
                    item2.setItemStatus(EnquiryStatusEnum.ACCEPT.getValue());
                    continue;
                }
                item2.setQuota(item2.getQuota() == null ? null : BigDecimal.ZERO);
                item2.setItemStatus(EnquiryStatusEnum.REJECT.getValue());
            }
        } else {
            itemList.forEach(item -> {
                item.setItemStatus(EnquiryStatusEnum.REJECT.getValue());
                item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void accept(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue(("1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u53ef\u63a5\u53d7\uff0c\u8bf7\u63d0\u524d\u5f00\u6807\u6216\u7b49\u5f85\u62a5\u4ef7\u7ed3\u675f");
        List<PurchaseEnquiryItem> acceptList = headVO.getPurchaseEnquiryItemList();
        ArrayList<String> acceptAccountList = new ArrayList<String>();
        acceptList.forEach(item -> {
            acceptAccountList.add(item.getToElsAccount());
            List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTED.getValue(), EnquiryStatusEnum.RE_QUOTE.getValue(), EnquiryStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(item.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5df2\u62a5\u4ef7\u3001\u91cd\u62a5\u4ef7\u6216\u5df2\u6094\u6807\u7684\u884c\u6570\u636e\u53ef\u63a5\u53d7"));
            if (EnquiryStatusEnum.REGRET.getValue().equals(item.getItemStatus())) {
                Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u884c\u6570\u636e\u53ef\u63a5\u53d7"));
            }
            if (QuotaWayEnum.QUANTITY.getValue().equals(headVO.getQuotaWay())) {
                Assert.isTrue((item.getQuota() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u586b\u5199\u62c6\u5206\u767e\u5206\u6bd4"));
            } else {
                Assert.isTrue((item.getQuota() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u586b\u5199\u62c6\u5206\u6570\u91cf\u6570\u503c"));
            }
            item.setItemStatus(EnquiryStatusEnum.ACCEPT.getValue());
        });
        this.checkReview(dbHead, acceptAccountList);
        this.purchaseEnquiryItemService.updateBatchById(acceptList);
    }

    private void checkReview(PurchaseEnquiryHead dbHead, List<String> acceptAccountList) {
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(dbHead.getEnquiryScope()) && QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            List<PurchaseQualificationReview> reviewList = this.purchaseQualificationReviewService.selectByMainId(dbHead.getId());
            Map<String, String> reviewMap = reviewList.stream().collect(Collectors.toMap(PurchaseQualificationReview::getToElsAccount, PurchaseQualificationReview::getReviewStatus, (newVal, oldVal) -> newVal));
            for (String acceptAccount : acceptAccountList) {
                String reviewStatus = reviewMap.get(acceptAccount);
                if (reviewStatus == null) continue;
                if (ReviewStatusEnum.NEW.getValue().equals(reviewStatus)) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"${0}\u8d44\u8d28\u672a\u5ba1\u67e5\uff0c\u4e0d\u53ef\u63a5\u53d7\u62a5\u4ef7", (String[])new String[]{acceptAccount}));
                }
                if (!ReviewStatusEnum.REJECT.getValue().equals(reviewStatus)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"${0}\u8d44\u8d28\u5ba1\u67e5\u672a\u901a\u8fc7\uff0c\u4e0d\u53ef\u63a5\u53d7\u62a5\u4ef7", (String[])new String[]{acceptAccount}));
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reject(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue(("1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u53ef\u62d2\u7edd\uff0c\u8bf7\u63d0\u524d\u5f00\u6807\u6216\u7b49\u5f85\u62a5\u4ef7\u7ed3\u675f");
        List<PurchaseEnquiryItem> rejectList = headVO.getPurchaseEnquiryItemList();
        for (PurchaseEnquiryItem item : rejectList) {
            List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTED.getValue(), EnquiryStatusEnum.RE_QUOTE.getValue(), EnquiryStatusEnum.CAN_NOT_QUOTE.getValue(), EnquiryStatusEnum.NO_QUOTE.getValue(), EnquiryStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(item.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5df2\u62a5\u4ef7\u3001\u91cd\u62a5\u4ef7\u3001\u4e0d\u80fd\u62a5\u4ef7\u3001\u672a\u62a5\u4ef7\u6216\u5df2\u6094\u6807\u7684\u884c\u6570\u636e\u53ef\u62d2\u7edd"));
            if (EnquiryStatusEnum.REGRET.getValue().equals(item.getItemStatus())) {
                Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u884c\u6570\u636e\u53ef\u62d2\u7edd"));
            }
            BigDecimal quota = item.getQuota() == null ? null : BigDecimal.ZERO;
            item.setQuota(quota);
            item.setItemStatus(EnquiryStatusEnum.REJECT.getValue());
        }
        this.purchaseEnquiryItemService.updateBatchById(rejectList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void revoke(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        List<String> status = Arrays.asList(EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u62a5\u4ef7\u4e2d\u3001\u8bae\u4ef7\u4e2d\u3001\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u64a4\u9500"));
        List<PurchaseEnquiryItem> revokeList = headVO.getPurchaseEnquiryItemList();
        List saleItemIdList = revokeList.stream().map(PurchaseEnquiryItem::getRelationId).collect(Collectors.toList());
        List itemList = this.saleEnquiryItemService.listByIds(saleItemIdList);
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(SaleEnquiryItem::getRelationId, SaleEnquiryItem::getItemStatus));
        revokeList.forEach(item -> {
            String itemStatus = item.getItemStatus();
            boolean flag = EnquiryStatusEnum.ACCEPT.getValue().equals(itemStatus) || EnquiryStatusEnum.REJECT.getValue().equals(itemStatus);
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u53ea\u53ef\u64a4\u9500\u63a5\u53d7\u6216\u62d2\u7edd\u7684\u884c\u4fe1\u606f"));
            itemStatus = (String)itemStatusMap.get(item.getId());
            item.setItemStatus(itemStatus);
        });
        this.purchaseEnquiryItemService.updateBatchById(revokeList);
    }

    @Override
    @SrmTransaction
    public void submitPriced(PurchaseAwardOpinionVO awardOpinionVO) {
        this.purchaseAwardOpinionService.save((Object)awardOpinionVO);
        String headId = awardOpinionVO.getHeadId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headId)));
        List<String> statusList = Arrays.asList(EnquiryStatusEnum.BARGAIN.getValue(), EnquiryStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)statusList.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u53ef\u64cd\u4f5c\u8bae\u4ef7\u4e2d\u6216\u5df2\u6094\u6807\u7684\u5355\u636e"));
        List<PurchaseEnquiryItem> dbItemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        List<PurchaseEnquiryItem> itemList = awardOpinionVO.getPurchaseEnquiryItemList();
        if (CollectionUtil.isEmpty(itemList)) {
            itemList = dbItemList;
        } else {
            List itemNumberList = itemList.stream().map(PurchaseEnquiryItem::getItemNumber).collect(Collectors.toList());
            itemList = dbItemList.stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
        }
        List alreadyPricedList = itemList.stream().filter(item -> "1".equals(item.getPricedFlag()) || AuditStatusEnum.AUDIT_DOING.getValue().equals(item.getAuditStatus())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(alreadyPricedList), (String)I18nUtil.translate((String)"", (String)"\u5b58\u5728\u5df2\u5b9a\u4ef7\u6216\u5df2\u63d0\u4ea4\u5b9a\u4ef7\u7684\u884c\u4fe1\u606f\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        List<PurchaseEnquiryItem> pricedList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        Assert.isTrue((itemList.size() == pricedList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u5168\u90e8\u64cd\u4f5c\u6210\u529f\u540e\u624d\u53ef\u63d0\u4ea4\u5b9a\u4ef7"));
        if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
            itemList.forEach(item -> Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801")));
        }
        Map<String, List<PurchaseEnquiryItem>> acceptMap = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.groupingBy(PurchaseEnquiryItem::getItemNumber));
        ArrayList errorList = new ArrayList();
        acceptMap.forEach((key, value) -> {
            BigDecimal needSum;
            BigDecimal sum = value.stream().filter(item -> item.getQuota() != null).map(PurchaseEnquiryItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseEnquiryItem item2 = (PurchaseEnquiryItem)((Object)((Object)value.get(0)));
            BigDecimal bigDecimal = needSum = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : item2.getRequireQuantity();
            if (sum.compareTo(needSum) != 0) {
                errorList.add(item2.getMaterialName());
            }
        });
        if (CollectionUtil.isNotEmpty(errorList)) {
            String materialName = String.join((CharSequence)"\uff0c", errorList);
            boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
            String message = isScale ? I18nUtil.translate((String)"", (String)"${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100", (String[])new String[]{materialName}) : I18nUtil.translate((String)"", (String)"${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf", (String[])new String[]{materialName});
            throw new ELSBootException(message);
        }
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, pricedList);
            this.goBackDemand(pricedList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEnquiryItem> acceptList = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecord(dbHead, acceptList);
            }
        } else {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            String businessId = dbHead.getId();
            if (dbItemList.size() != itemList.size()) {
                businessId = businessId + "_" + itemList.stream().map(PurchaseEnquiryItem::getItemNumber).collect(Collectors.joining(","));
            }
            dto.setBusinessId(businessId);
            dto.setBusinessType("resultEnquiry");
            dto.setAuditSubject(I18nUtil.translate((String)"i18n_title_RFQResultapprovalDocNo", (String)"\u8be2\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a") + dbHead.getEnquiryNumber());
            PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEnquiryItemList(itemList);
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        }
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> pricedList) {
        pricedList.forEach(item -> item.setPricedFlag("1"));
        this.purchaseEnquiryItemService.updateBatchById(pricedList);
        List<PurchaseEnquiryItem> allList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        long pricedCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).count();
        dbHead.setEnquiryStatus(pricedCount == (long)allList.size() ? EnquiryStatusEnum.PRICED.getValue() : dbHead.getEnquiryStatus());
        BigDecimal enquiryAmount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && item.getTaxAmount() != null).map(PurchaseEnquiryItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        dbHead.setEnquiryAmount(enquiryAmount);
        dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(enquiryAmount));
        if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
            dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 2, 4).multiply(BigDecimal.valueOf(100L)));
        }
        ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEnquiryHeadService.priced(dbHead, pricedList);
        List<Object> toElsAccount = new ArrayList();
        if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice())) {
            toElsAccount = pricedList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        } else if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
            toElsAccount = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        }
        List<SaleEnquiryHead> saleEnquiryHeads = this.saleEnquiryHeadService.selectByMainId(dbHead.getId());
        Map<String, SaleEnquiryHead> supplierMap = saleEnquiryHeads.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        super.sendMsg(TenantContext.getTenant(), toElsAccount, (Object)dbHead, receiveParamMap, "enquiry", "confirm");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reQuote(PurchaseEnquiryHeadVO headVO) {
        List<PurchaseEnquiryItem> reQuoteList;
        if ("user".equals(headVO.getReQuoteWay())) {
            reQuoteList = headVO.getPurchaseEnquiryItemList();
        } else if ("material".equals(headVO.getReQuoteWay())) {
            List<PurchaseEnquiryItem> webItemList = headVO.getPurchaseEnquiryItemList();
            Assert.notEmpty(webItemList, (String)I18nUtil.translate((String)"i18n_alert_SLVHxOLV_1771ce0e", (String)"\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            List itemNumberList = webItemList.stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId()).stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
        } else if ("supplier".equals(headVO.getReQuoteWay())) {
            List<EnquirySupplierList> supplierList = headVO.getEnquirySupplierListList();
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
            List toElsAccountList = supplierList.stream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId()).stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        } else {
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId());
        }
        Assert.notEmpty(reQuoteList, (String)I18nUtil.translate((String)"i18n_alert_ssujWFcxOLV_e3533a99", (String)"\u91cd\u62a5\u4ef7\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId());
        List distinctList = itemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        int i = 1;
        for (PurchaseEnquiryItem purchaseEnquiryItem : distinctList) {
            List<String> statusList = Arrays.asList(EnquiryStatusEnum.QUOTED.getValue(), EnquiryStatusEnum.CAN_NOT_QUOTE.getValue(), EnquiryStatusEnum.NO_QUOTE.getValue(), EnquiryStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(purchaseEnquiryItem.getItemStatus()), (String)I18nUtil.translate((String)"", (String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c" + i++ + "\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b21\u64cd\u4f5c")));
            if (!EnquiryStatusEnum.REGRET.getValue().equals(purchaseEnquiryItem.getItemStatus())) continue;
            Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(purchaseEnquiryItem.getRegretFlag()), (String)I18nUtil.translate((String)"", (String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c" + i++ + "\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b21\u64cd\u4f5c")));
        }
        reQuoteList.forEach(item -> {
            item.setItemStatus(EnquiryStatusEnum.RE_QUOTE.getValue());
            item.setQuoteEndTime(headVO.getQuoteEndTime());
        });
        this.purchaseEnquiryItemService.updateBatchById(reQuoteList);
        Map<String, SaleEnquiryHead> supplierMap = this.saleEnquiryHeadService.reQuote(headVO, reQuoteList);
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headVO.getId())));
        List toElsAccount = reQuoteList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        dbHead.setQuoteEndTime(headVO.getQuoteEndTime());
        dbHead.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
        super.sendMsg(TenantContext.getTenant(), toElsAccount, (Object)dbHead, receiveParamMap, "enquiry", "reply");
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleEnquiryHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("busAccount", (Object)value.getBusAccount());
                object.put("supplierTaxRate", (Object)value.getSupplierTaxRate());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(PurchaseEnquiryHead dbHead) {
        dbHead.setEnquiryStatus(EnquiryStatusEnum.CANCEL.getValue());
        int count = ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)dbHead.getId())).set(PurchaseEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        this.saleEnquiryHeadService.cancel(dbHead.getId());
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        EnquiryJobUtil.deleteJob(dbHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String regret(PurchaseEnquiryHeadVO headVO) {
        List<PurchaseEnquiryItem> webList;
        String headId = headVO.getId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EnquiryStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5df2\u5b9a\u4ef7\u7684\u5355\u636e\u53ef\u6094\u6807"));
        if ("whole".equals(headVO.getRegretWay())) {
            webList = this.purchaseEnquiryItemService.selectByMainId(headId);
        } else {
            webList = headVO.getPurchaseEnquiryItemList();
            Assert.notEmpty(webList, (String)I18nUtil.translate((String)"i18n_alert_MBcVHxOLV_798887b7", (String)"\u6094\u6807\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String regretFlag = headVO.getRegretFlag();
        if (RegretFlagEnum.RE_SOURCE.getValue().equals(regretFlag)) {
            this.goBackDemand(webList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        } else if (RegretFlagEnum.RE_PRICED.getValue().equals(regretFlag)) {
            this.goBackDemand(webList, PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue());
        }
        String returnMsg = "\u64cd\u4f5c\u6210\u529f";
        for (PurchaseEnquiryItem purchaseEnquiryItem : webList) {
            if (!"1".equals(purchaseEnquiryItem.getSendStatus())) continue;
            returnMsg = "\u4ef7\u683c\u8bb0\u5f55\u4f5c\u5e9f\u6210\u529f";
        }
        this.regret(dbHead, webList, regretFlag);
        return returnMsg;
    }

    private void regret(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> webList, String regretFlag) {
        webList.forEach(item -> {
            item.setItemStatus(EnquiryStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            item.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            item.setPricedFlag("0");
            item.setSendStatus("0");
        });
        this.purchaseEnquiryItemService.updateBatchById(webList);
        List<PurchaseEnquiryItem> allList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        long regretCount = allList.stream().filter(item -> EnquiryStatusEnum.REGRET.getValue().equals(item.getItemStatus())).count();
        if ((long)allList.size() == regretCount) {
            dbHead.setEnquiryStatus(EnquiryStatusEnum.REGRET.getValue());
        }
        ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEnquiryHeadService.regret(dbHead, webList);
        String sourceNumber = dbHead.getEnquiryNumber();
        List<String> itemNumberList = webList.stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.ENQUIRY.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList)) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEnquiryItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setCompany(dbHead.getCompany());
                records.setPurchaseUnit(item.getQuantityUnit());
                records.setSourceType(PriceSourceTypeEnum.ENQUIRY.getValue());
                records.setSourceNumber(dbHead.getEnquiryNumber());
                records.setSourceItemNumber(item.getItemNumber());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setCurrencyCode(item.getCurrency());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEnquiryItem> updateList = new ArrayList<PurchaseEnquiryItem>();
            for (PurchaseEnquiryItem item : acceptList) {
                PurchaseEnquiryItem update = new PurchaseEnquiryItem();
                update.setId(item.getId());
                update.setSendStatus("1");
                updateList.add(update);
            }
            this.purchaseEnquiryItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEnquiryHead updateHead = new PurchaseEnquiryHead();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)dbHead.getQuoteEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        LoginUser user = SysUtil.getLoginUser();
        this.executeReview(dbHead, review, user.getEnterpriseName(), user.getSubAccount());
    }

    @Override
    public void executeReview(PurchaseEnquiryHead dbHead, PurchaseQualificationReview review, String enterpriseName, String loginSubAccount) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId());
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        ArrayList supplierList = Lists.newArrayList();
        EnquirySupplierList supplier = new EnquirySupplierList();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EnquiryStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getItemStatus).distinct().collect(Collectors.toList());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        AttachmentSendDTO sendVO = this.publishEnquiry(dbHead, initItemList, supplierList, demandList, enterpriseName, loginSubAccount);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.invokeBaseRpcService.updateSaleFile(sendVO);
    }
}

