/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.websocket;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/online/{purchaseHeadId}/{elsAccount}")
public class OnlineWebSocket {
    private static final Logger log = LoggerFactory.getLogger(OnlineWebSocket.class);
    private Session session;
    private String purchaseHeadId;
    private String elsAccount;
    private String id;
    private static Map<String, List<OnlineWebSocket>> clientMap = new ConcurrentHashMap<String, List<OnlineWebSocket>>();
    private RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
    private final String redisKeyPrefix = "online:cache:users:";
    private final long expire = 172800L;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="purchaseHeadId") String purchaseHeadId, @PathParam(value="elsAccount") String elsAccount) {
        try {
            this.session = session;
            this.purchaseHeadId = purchaseHeadId;
            this.elsAccount = elsAccount;
            this.id = UUID.randomUUID().toString();
            List<Object> clients = clientMap.get(purchaseHeadId) == null ? new ArrayList() : clientMap.get(purchaseHeadId);
            clients.add(this);
            clientMap.put(purchaseHeadId, clients);
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnClose
    public void onClose() {
        try {
            List<OnlineWebSocket> clients = clientMap.get(this.purchaseHeadId);
            if (clients != null) {
                List result = clients.stream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.purchaseHeadId, result);
            }
            log.info("\u3010OnlineWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        log.info("Online Hart:" + DateUtil.formatDateTime((Date)new Date()));
        String redisKey = "online:cache:users:" + this.purchaseHeadId;
        ConcurrentHashMap<String, Date> hartMap = (ConcurrentHashMap<String, Date>)this.redis.get(redisKey);
        if (hartMap == null) {
            hartMap = new ConcurrentHashMap<String, Date>();
            hartMap.put(this.elsAccount, new Date());
        } else {
            DateTime onlineDate = DateUtil.offsetSecond((Date)new Date(), (int)-10);
            ArrayList removeList = new ArrayList();
            for (Map.Entry entry : hartMap.entrySet()) {
                Date value = (Date)entry.getValue();
                if (value.compareTo((Date)onlineDate) >= 0) continue;
                removeList.add(entry.getKey());
            }
            if (CollectionUtil.isNotEmpty(removeList)) {
                for (String removeAccount : removeList) {
                    hartMap.remove(removeAccount);
                }
            }
            hartMap.put(this.elsAccount, new Date());
        }
        this.redis.set(redisKey, hartMap, 172800L);
        this.redis.publish("hall-online-topic", (Object)this.purchaseHeadId);
    }

    public void sendOnlineUsersMessage(String purchaseHeadId) {
        List<OnlineWebSocket> clients = clientMap.get(purchaseHeadId);
        if (clients != null && !clients.isEmpty()) {
            String redisKey = "online:cache:users:" + purchaseHeadId;
            Map hartMap = (Map)this.redis.get(redisKey);
            String onlineUsers = hartMap == null ? "" : String.join((CharSequence)",", hartMap.keySet());
            for (OnlineWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                socket.session.getAsyncRemote().sendText(onlineUsers);
            }
        }
    }

    public void sendQuoteMessage(String purchaseHeadId) {
        List<OnlineWebSocket> clients = clientMap.get(purchaseHeadId);
        if (clients != null && !clients.isEmpty()) {
            for (OnlineWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                socket.session.getAsyncRemote().sendText(purchaseHeadId);
            }
        }
    }
}

