/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSAgainException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingScopeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStartWayEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.service.PublicEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.PurchaseAwardOpinionVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingConfirmVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEbiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseEbiddingHeadMapper, PurchaseEbiddingHead>
implements PurchaseEbiddingHeadService,
PurchaseExecuteReviewService {
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Autowired
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private PublicEbiddingService publicEbiddingService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    private static final String START_PRICE_FLAG = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(1);
        ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EbiddingStatusEnum.NEW.getValue().equals(head.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.deleteSubTable(id);
    }

    private void deleteSubTable(String headId) {
        this.purchaseEbiddingItemService.deleteByMainId(headId);
        this.purchaseEbiddingSupplierService.deleteByMainId(headId);
        this.purchaseEbiddingConfirmService.deleteByMainId(headId);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    private void insertData(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        this.purchaseEbiddingItemService.addBatch(head, itemList);
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
    }

    @Override
    public void goBackDemand(List<PurchaseEbiddingItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List<String> idList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).map(PurchaseEbiddingItem::getSourceItemId).distinct().collect(Collectors.toList());
            this.purchaseRequestItemService.updateStatusById(idList, status);
        }
    }

    private void checkAndSetParam(PurchaseEbiddingHeadVO headVO) {
        Date beginTime = headVO.getBeginTime();
        Assert.notNull((Object)beginTime, (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)beginTime.after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        BigDecimal keepMinute = headVO.getKeepMinute();
        Assert.notNull((Object)headVO.getChangeRange(), (String)I18nUtil.translate((String)"", (String)"\u4ef7\u683c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRangeUnit(), (String)I18nUtil.translate((String)"", (String)"\u5e45\u5ea6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Integer participateQuantity = headVO.getParticipateQuantity();
        Assert.notNull((Object)participateQuantity, (String)I18nUtil.translate((String)"", (String)"\u53c2\u4e0e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        headVO.setInviteQuantity(supplierList.size());
        String ebiddingScope = StrUtil.isNotBlank((CharSequence)headVO.getEbiddingScope()) ? headVO.getEbiddingScope() : EbiddingScopeEnum.INVITE.getValue();
        headVO.setEbiddingScope(ebiddingScope);
        if (EbiddingScopeEnum.INVITE.getValue().equals(ebiddingScope)) {
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((participateQuantity.compareTo(headVO.getInviteQuantity()) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u53c2\u4e0e\u6570\u91cf"));
        }
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (START_PRICE_FLAG.equals(headVO.getSetStartPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getStartTotalAmount(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getTargetTotalAmount(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u7a0e\u7387\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f"));
        } else if (checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.hasText((String)headVO.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.hasText((String)headVO.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            Assert.notNull((Object)headVO.getEchoEndTime(), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().before(beginTime), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4"));
        }
        if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String delayRule = headVO.getDelayRule();
        if (EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(delayRule)) {
            Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
            Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayCount(), (String)I18nUtil.translate((String)"", (String)"\u53ef\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(ebiddingScope)) {
            Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"", (String)"\u516c\u5f00\u7ade\u4ef7\uff0c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Date time = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? headVO.getEchoEndTime() : headVO.getBeginTime();
            String message = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? "\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5e94\u6807\u622a\u6b62\u65f6\u95f4" : "\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4";
            Assert.isTrue((boolean)time.after(headVO.getApplyEndTime()), (String)I18nUtil.translate((String)"", (String)message));
        }
        List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseEbiddingItem item : itemList) {
            PurchaseEbiddingHeadServiceImpl.headToItem(headVO, item);
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice())) {
                    Assert.notNull((Object)item.getTargetPrice(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (START_PRICE_FLAG.equals(headVO.getSetStartPrice())) {
                    Assert.notNull((Object)item.getStartPrice(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (!START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
            if (!START_PRICE_FLAG.equals(headVO.getMustMaterialNumber())) continue;
            Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List needEchoList = headVO.getPurchaseAttachmentDemandList().stream().filter(demand -> START_PRICE_FLAG.equals(demand.getRequired())).filter(demand -> StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needEchoList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"", (String)(StageTypeEnum.QUOTE.getDesc() + "\u9644\u4ef6\u5fc5\u4f20\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f")));
        }
        headVO.setEbiddingStatus(START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        DateTime endTime = DateUtil.offsetSecond((Date)beginTime, (int)SysUtil.minuteToSecond((BigDecimal)keepMinute, (int)1));
        headVO.setEndTime((Date)endTime);
        headVO.setStartTime(beginTime);
        headVO.setCurrentRound(headVO.getCurrentRound() == null ? 1 : headVO.getCurrentRound());
        LoginUser user = SysUtil.getLoginUser();
        headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        headVO.setPublishTime(new Date());
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private static void headToItem(PurchaseEbiddingHead head, PurchaseEbiddingItem item) {
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (checkWayList.contains(head.getEbiddingWay())) {
            item.setTaxRate(head.getTaxRate());
            item.setTaxCode(head.getTaxCode());
            item.setCurrency(head.getCurrency());
        } else {
            item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
        }
        item.setEffectiveDate(item.getEffectiveDate() == null ? head.getEffectiveDate() : item.getEffectiveDate());
        item.setExpiryDate(item.getExpiryDate() == null ? head.getExpiryDate() : item.getExpiryDate());
    }

    private boolean publishAudit(PurchaseEbiddingHeadVO headVO) {
        if (START_PRICE_FLAG.equals(headVO.getPublishAudit()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(headVO.getAuditStatus())) {
            List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
            List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
            List<PurchaseAttachmentDemandDTO> demandList = headVO.getPurchaseAttachmentDemandList();
            List<PurchaseEbiddingConfirmVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
            if (StrUtil.isBlank((CharSequence)headVO.getId())) {
                this.saveMain(headVO, itemList, supplierList, demandList, confirmList);
            } else {
                this.updateMain(headVO, itemList, supplierList, demandList, confirmList);
            }
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(headVO.getId());
            dto.setBusinessType("publishEbidding");
            dto.setAuditSubject("\u7ade\u4ef7\u53d1\u5e03\u524d\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + headVO.getEbiddingNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
            return true;
        }
        return false;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEbiddingHeadVO headVO) {
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            EbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            this.publicEbiddingService.publishNotice(head);
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, String> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", value);
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    private void insertInitTable(String headId, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingConfirmVO> confirmList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("relationId", (Object)headId);
        itemObject.put("businessType", (Object)"item");
        itemObject.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(itemObject.toJSONString());
        JSONObject confirmObject = new JSONObject();
        confirmObject.put("relationId", (Object)headId);
        confirmObject.put("businessType", (Object)"confirm");
        confirmObject.put("businessInfoJson", (Object)JSON.toJSONString(confirmList));
        InitTableMqUtil.sendInitMsg(confirmObject.toJSONString());
    }

    private AttachmentSendDTO publishEbidding(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> demandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEbiddingItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        this.purchaseEbiddingSupplierService.publish(head, supplierList);
        List<PurchaseEbiddingItem> insertItemList = this.purchaseEbiddingItemService.publish(head, itemList, supplierList, relationMap);
        List<PurchaseEbiddingConfirm> insertConfirmList = this.purchaseEbiddingConfirmService.publish(head, confirmList, supplierList);
        Map<String, String> idMap = this.saleEbiddingHeadService.publish(head, insertItemList, supplierList, insertConfirmList);
        AttachmentSendDTO sendDTO = this.sendAttachment(head, idMap, demandList);
        super.sendMsg(head.getElsAccount(), toElsAccountList, (Object)head, this.getReceiveParamMap(idMap), "ebidding", "publish");
        return sendDTO;
    }

    private AttachmentSendDTO sendAttachment(PurchaseEbiddingHead purchaseHead, Map<String, String> idMap, List<PurchaseAttachmentDemandDTO> demandList) {
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(purchaseHead.getId());
        sendVO.setElsAccount(purchaseHead.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        for (String elsAccount : idMap.keySet()) {
            toSend.put(idMap.get(elsAccount), elsAccount);
        }
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, purchaseHead.getId(), "ebidding", idMap);
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingSupplier> webSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.purchaseEbiddingSupplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingSupplier> supplierList = webSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List itemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        this.publishEbidding(dbHead, itemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (PurchaseEbiddingSupplier supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startBidding(String id) {
        List<String> itemIdList;
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            } else {
                String itemNumber = StrUtil.isNotBlank((CharSequence)dbHead.getCurrentItemNumber()) ? dbHead.getCurrentItemNumber() : START_PRICE_FLAG;
                List<PurchaseEbiddingItem> updateList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                dbHead.setCurrentItemNumber(itemNumber);
                dbHead.setCurrentMaterialDesc(((PurchaseEbiddingItem)((Object)updateList.get(0))).getMaterialDesc());
                dbHead.setCurrentDelayCount(0);
                updateList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = updateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(updateList);
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
            itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.startEbidding(dbHead, itemIdList);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            EbiddingJobUtil.createEndJob(dbHead, dbHead.getEndTime());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endBidding(String id, List<String> itemNumberList) {
        ArrayList<String> itemIdList = new ArrayList<String>();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                List<PurchaseEbiddingItem> currentItemList = itemList.stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(currentItemList)) {
                    currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    itemIdList.addAll(idList);
                    this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                    List biddingEndList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                    dbHead.setEbiddingStatus(itemList.size() == biddingEndList.size() ? EbiddingStatusEnum.BIDDING_END.getValue() : EbiddingStatusEnum.BIDDING.getValue());
                }
            } else {
                String currentItemNumber = dbHead.getCurrentItemNumber();
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                PurchaseEbiddingItem nextItem = this.purchaseEbiddingItemService.selectOneByMainIdAndItemNumber(id, nextItemNumber);
                if (nextItem != null) {
                    dbHead.setCurrentItemNumber(nextItemNumber);
                    dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                    dbHead.setCurrentDelayCount(0);
                    if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime((Date)DateUtil.offsetSecond((Date)dbHead.getEndTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                        EbiddingJobUtil.createStartJob(dbHead, dbHead.getBeginTime());
                    } else {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
                    }
                } else {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setBeginTime(dbHead.getBeginTime());
                    dbHead.setEndTime(dbHead.getEndTime());
                    dbHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                }
                List<PurchaseEbiddingItem> currentItemList = itemList.stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(currentItemList)) {
                    currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                    List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    itemIdList.addAll(idList);
                }
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            itemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.updateBatchById(itemList);
            List idList = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            itemIdList.addAll(idList);
        }
        if (EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus())) {
            long count = itemList.stream().filter(item -> item.getQuoteCount() != null && item.getQuoteCount() > 0).map(PurchaseEbiddingItem::getToElsAccount).distinct().count();
            dbHead.setEbiddingStatus(count < (long)dbHead.getParticipateQuantity().intValue() ? EbiddingStatusEnum.BID_FAILED.getValue() : EbiddingStatusEnum.BIDDING_END.getValue());
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.endEbidding(dbHead, itemIdList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualStartBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(dbHead.getBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\uff01"));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u548c\u5f85\u5e94\u6807\u7684\u5355\u636e\u53ef\u5f00\u542f"));
        PurchaseEbiddingHead update = new PurchaseEbiddingHead();
        update.setId(headVO.getId());
        update.setStartTime(currentTime);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            DateTime endTime = DateUtil.offsetSecond((Date)currentTime, (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1));
            update.setEndTime((Date)endTime);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)update);
        this.startBidding(headVO.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualEndBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u7ed3\u675f\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff01"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)currentTime.after(dbHead.getEndTime()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u7ed3\u675f\u7ade\u4ef7\uff01"));
        }
        ArrayList<String> itemNumberList = new ArrayList<String>();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
            Assert.notEmpty(headVO.getPurchaseEbiddingItemList(), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u675f\u7ade\u4ef7\u7684\u7269\u6599"));
            headVO.getPurchaseEbiddingItemList().forEach(item -> itemNumberList.add(item.getItemNumber()));
        }
        this.endBidding(dbHead.getId(), itemNumberList);
    }

    private Map<String, BigDecimal> getStartPriceMap(PurchaseEbiddingHeadVO headVO, List<PurchaseEbiddingItem> dbItemList) {
        HashMap<String, BigDecimal> startPriceMap = new HashMap<String, BigDecimal>(16);
        String startPriceFlag = headVO.getStartPriceFlag();
        if (START_PRICE_FLAG.equals(startPriceFlag)) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Map<String, List<PurchaseEbiddingItem>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List itemList = itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null).collect(Collectors.toList());
                    if (itemList.isEmpty()) continue;
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxPrice = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                        startPriceMap.put(itemNumber, maxPrice);
                        continue;
                    }
                    BigDecimal minPrice = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                    startPriceMap.put(itemNumber, minPrice);
                }
            } else {
                List itemList = dbItemList.stream().filter(item -> item.getTaxAmount() != null).collect(Collectors.toList());
                if (!itemList.isEmpty()) {
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxTotalAmount = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), maxTotalAmount);
                    } else {
                        BigDecimal minTotalAmount = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), minTotalAmount);
                    }
                }
            }
        }
        return startPriceMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createNewRound(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u521b\u5efa\u65b0\u8f6e\u6b21"));
        String startPriceFlag = headVO.getStartPriceFlag();
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        Map<String, BigDecimal> startPriceMap = this.getStartPriceMap(headVO, dbItemList);
        for (PurchaseEbiddingItem item : initItemList) {
            if (!START_PRICE_FLAG.equals(startPriceFlag)) continue;
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                item.setStartPrice(startPriceMap.get(item.getItemNumber()));
                continue;
            }
            headVO.setStartTotalAmount(startPriceMap.get(headId));
            break;
        }
        headVO.setPurchaseEbiddingItemList(initItemList);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        headVO.setPurchaseEbiddingConfirmList(confirmList);
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        supplierList.forEach(supplier -> supplier.setReplyTime(null));
        headVO.setPurchaseEbiddingSupplierList(supplierList);
        headVO.setCurrentRound(headVO.getCurrentRound() + 1);
        headVO.setCurrentDelayCount(0);
        headVO.setReplyQuantity(0);
        headVO.setId(null);
        this.publish(headVO);
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(headId);
        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.NEW_ROUND.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)purchaseHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPrice(PurchaseEbiddingHead dbHead, PurchaseAwardOpinionVO opinionVO, List<PurchaseEbiddingItem> dbItemList) {
        ArrayList<PurchaseEbiddingItem> itemList = new ArrayList<PurchaseEbiddingItem>();
        List<PurchaseEbiddingSupplierVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierVO purchaseEbiddingSupplierVO : supplierVOList) {
            itemList.addAll(purchaseEbiddingSupplierVO.getPurchaseEbiddingItemList());
        }
        this.checkConfirm(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        ArrayList<PurchaseEbiddingSupplier> supplierList = new ArrayList<PurchaseEbiddingSupplier>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item2 : itemList) {
                item2.setQuota((BigDecimal)(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : (item2.getQuota() == null ? null : BigDecimal.ZERO)));
                item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue());
            }
            this.purchaseEbiddingItemService.updateBatchById(itemList);
            Map<String, String> map = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            map.forEach((key, value) -> {
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItem item2 : itemList) {
                String itemStatus = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item2.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, itemList, supplierList);
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItem> list = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecord(dbHead, list);
            }
        } else {
            AuditInputParamDTO auditInputParamDTO = new AuditInputParamDTO();
            auditInputParamDTO.setBusinessId(dbHead.getId());
            auditInputParamDTO.setBusinessType("resultEbidding");
            auditInputParamDTO.setAuditSubject("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber());
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemList(dbItemList);
            auditInputParamDTO.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(auditInputParamDTO);
        }
    }

    private void checkConfirm(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getItemNumber, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        for (String itemNumber : itemMap.keySet()) {
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                List sortList;
                List needSortList;
                List<PurchaseEbiddingItem> list = itemMap.get(itemNumber);
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    needSortList = list.stream().filter(item -> item.getPrice() != null).collect(Collectors.toList());
                    sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEbiddingItem::getPrice).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList());
                } else {
                    needSortList = list.stream().filter(item -> item.getTotalAmount() != null).collect(Collectors.toList());
                    sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList());
                }
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItem min = (PurchaseEbiddingItem)((Object)sortList.get(0));
                    for (PurchaseEbiddingItem item2 : list) {
                        if (!item2.getId().equals(min.getId())) continue;
                        item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : min.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus)) continue;
            throw new ELSAgainException(I18nUtil.translate((String)"", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
        }
        List<PurchaseEbiddingItem> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
            });
            Map<String, List<PurchaseEbiddingItem>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItem> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList) {
        List limit;
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_SUCCESS.getValue());
        BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItem)((Object)limit.get(0))).getTotalAmount());
        dbHead.setEbiddingAmount(ebiddingAmount);
        if (dbHead.getProjectBudget() != null) {
            dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
            if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 4, 4).multiply(BigDecimal.valueOf(100L)));
            }
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.priced(dbHead, itemList, supplierList);
        if (!PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) {
            List<PurchaseEbiddingSupplier> msgSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                msgSupplierList = msgSupplierList.parallelStream().filter(supplier -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).collect(Collectors.toList());
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                msgSupplierList = msgSupplierList.parallelStream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).collect(Collectors.toList());
            }
            List toElsAccountList = msgSupplierList.parallelStream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
            List<SaleEbiddingHead> saleEbiddingHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            for (SaleEbiddingHead saleEbiddingHead : saleEbiddingHeadList) {
                JSONObject urlParam = new JSONObject();
                urlParam.put("id", (Object)saleEbiddingHead.getId());
                urlParam.put("templateNumber", (Object)saleEbiddingHead.getTemplateNumber());
                urlParam.put("templateVersion", (Object)saleEbiddingHead.getTemplateVersion());
                urlParam.put("busAccount", (Object)saleEbiddingHead.getBusAccount());
                receiveParamMap.put(saleEbiddingHead.getElsAccount(), urlParam);
            }
            super.sendMsg(dbHead.getElsAccount(), toElsAccountList, (Object)dbHead, receiveParamMap, "ebidding", "confirm");
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.INVALID.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        this.saleEbiddingHeadService.remove((Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId()));
        EbiddingJobUtil.deleteAllJob(dbHead);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        this.checkQuotePrice(dbHead, dbItem, quoteItem);
        this.computeQuotePrice(dbHead, dbItem, quoteItem);
        List saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> dbItem.getToElsAccount().equals(head.getElsAccount())).collect(Collectors.toList());
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)saleHeadList.get(0));
        this.purchaseEbiddingItemHisService.save(quoteItem, dbSaleHead);
        RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void checkQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        BigDecimal startPric;
        PurchaseEbiddingItemHis dbHisItem;
        List dbHisList = this.purchaseEbiddingItemHisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHis::getQuoteTime));
        PurchaseEbiddingItemHis purchaseEbiddingItemHis = dbHisItem = dbHisList.isEmpty() ? new PurchaseEbiddingItemHis() : (PurchaseEbiddingItemHis)((Object)dbHisList.get(0));
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            startPric = dbItem.getStartPrice();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetPrice() : dbHisItem.getPrice();
        } else {
            startPric = dbHead.getStartTotalAmount();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetTotalAmount() : dbHisItem.getTotalAmount();
        }
        if (startPric != null) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPric.compareTo(webPrice) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            } else {
                Assert.isTrue((startPric.compareTo(webPrice) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
        }
        if (dbPrice != null) {
            BigDecimal changeRange;
            BigDecimal bigDecimal = changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? dbPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 6, 4)) : dbHead.getChangeRange();
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
        }
    }

    private void computeQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal taxRate;
        BigDecimal bigDecimal = taxRate = StrUtil.isNotBlank((CharSequence)dbItem.getTaxRate()) ? new BigDecimal(dbItem.getTaxRate()) : BigDecimal.ZERO;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            BigDecimal bigDecimal2 = requireQuantity = dbItem.getRequireQuantity() == null ? BigDecimal.ONE : dbItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal totalAmount = quoteItem.getTotalAmount();
            BigDecimal netTotalAmount = totalAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            quoteItem.setNetTotalAmount(netTotalAmount);
        } else {
            BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
            BigDecimal totalAmount = netTotalAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
            quoteItem.setTotalAmount(totalAmount);
        }
        quoteItem.setQuoteTime(new Date());
        quoteItem.setQuoteCount(dbItem.getQuoteCount() == null ? 1 : dbItem.getQuoteCount() + 1);
        quoteItem.setQuoteIp(IPUtils.getIpAddr());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(head.getEbiddingWay()) && !START_PRICE_FLAG.equals(head.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(head.getPurchaseGroup());
                records.setPurchaseOrg(head.getPurchaseOrg());
                records.setCompany(head.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(head.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItem> updateList = new ArrayList<PurchaseEbiddingItem>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseEbiddingItem update = new PurchaseEbiddingItem();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        String regretFlag = headVO.getRegretFlag();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u5df2\u6388\u6807\u7684\u5355\u636e\u624d\u53ef\u6094\u6807"));
        dbHead.setEbiddingStatus(EbiddingStatusEnum.REGRET.getValue());
        dbHead.setResultAuditStatus(START_PRICE_FLAG.equals(dbHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        itemList.forEach(item -> {
            item.setItemStatus(EbiddingItemStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            item.setSendStatus("0");
            item.setAuditStatus(dbHead.getResultAuditStatus());
        });
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        if (RegretFlagEnum.RE_SOURCE.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        } else if (RegretFlagEnum.RE_PRICED.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        }
        this.saleEbiddingHeadService.regret(dbHead, itemList);
        String sourceNumber = dbHead.getEbiddingNumber();
        List<String> itemNumberList = itemList.stream().map(PurchaseEbiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.EBIDDING.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    public void failed(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue());
        this.updateById((Object)dbHead);
        this.saleEbiddingHeadService.failed(dbHead);
        EbiddingJobUtil.deleteAllJob(dbHead);
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEbiddingHead dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        ArrayList supplierList = Lists.newArrayList();
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getItemStatus).distinct().collect(Collectors.toList());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        AttachmentSendDTO sendVO = this.publishEbidding(dbHead, initItemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.invokeBaseRpcService.updateSaleFile(sendVO);
    }
}

