/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingHeadMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.SaleEbiddingHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEbiddingHeadServiceImpl
extends ServiceImpl<SaleEbiddingHeadMapper, SaleEbiddingHead>
implements SaleEbiddingHeadService {
    @Resource
    private SaleEbiddingItemMapper saleEbiddingItemMapper;
    @Resource
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private PurchaseEbiddingHeadMapper purchaseEbiddingHeadMapper;
    @Resource
    private PurchaseEbiddingItemMapper purchaseEbiddingItemMapper;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisService saleEbiddingItemHisService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public Map<String, String> add(PurchaseEbiddingHead purchaseHead, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList) {
        ArrayList<SaleEbiddingHead> saleHeadList = new ArrayList<SaleEbiddingHead>();
        LoginUser user = SysUtil.getLoginUser();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead saleHead = new SaleEbiddingHead();
            BeanUtils.copyProperties((Object)((Object)purchaseHead), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)purchaseHead);
            saleHead.setId(null);
            saleHead.setRelationId(purchaseHead.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getEnterpriseName());
            saleHead.setSupplierListId(supplier.getId());
            BigDecimal targetTotalAmount = "1".equals(purchaseHead.getSendTargetPrice()) ? purchaseHead.getTargetTotalAmount() : null;
            saleHead.setTargetTotalAmount(targetTotalAmount);
            String ebiddingStatus = "1".equals(purchaseHead.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue();
            saleHead.setEbiddingStatus(ebiddingStatus);
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, String> idMap = saleHeadList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, BaseEntity::getId));
        ArrayList<SaleEbiddingItem> saleItemList = new ArrayList<SaleEbiddingItem>();
        for (PurchaseEbiddingItem buyItem : itemList) {
            SaleEbiddingItem saleItem = new SaleEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)buyItem), (Object)((Object)saleItem));
            saleItem.setId(buyItem.getRelationId());
            saleItem.setElsAccount(buyItem.getToElsAccount());
            saleItem.setRelationId(buyItem.getId());
            saleItem.setHeadId(idMap.get(buyItem.getToElsAccount()));
            saleItem.setToElsAccount(buyItem.getElsAccount());
            saleItem.setPurchaseName(user.getEnterpriseName());
            BigDecimal targetPrice = "1".equals(purchaseHead.getSendTargetPrice()) ? buyItem.getTargetPrice() : null;
            saleItem.setTargetPrice(targetPrice);
            saleItem.setExpiryDate(buyItem.getExpiryDate());
            saleItem.setEffectiveDate(buyItem.getEffectiveDate());
            saleItemList.add(saleItem);
        }
        this.saleEbiddingItemService.saveBatch(saleItemList);
        return idMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void responseBid(SaleEbiddingHeadVO saleHeadVO) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setId(saleHeadVO.getId());
        saleHead.setEbiddingStatus(saleHeadVO.getEbiddingStatus());
        saleHead.setTaxCode(saleHeadVO.getTaxCode());
        saleHead.setTaxRate(saleHeadVO.getTaxRate());
        int count = ((SaleEbiddingHeadMapper)this.baseMapper).updateById((Object)saleHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setId(saleHeadVO.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(saleHeadVO.getReplyStatus());
        boolean b = this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        if (!b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        if (EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(saleHeadVO.getReplyStatus())) {
            PurchaseEbiddingHead dbPurchaseHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)saleHeadVO.getRelationId())));
            Integer replyQuantity = dbPurchaseHead.getReplyQuantity() == null ? 1 : dbPurchaseHead.getReplyQuantity() + 1;
            dbPurchaseHead.setReplyQuantity(replyQuantity);
            count = this.purchaseEbiddingHeadMapper.updateById((Object)dbPurchaseHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.updateItemAndFile(saleHeadVO);
        }
    }

    private void updateItemAndFile(SaleEbiddingHeadVO saleHeadVO) {
        List<SaleEbiddingItem> itemList = saleHeadVO.getSaleEbiddingItemList();
        if (CollectionUtil.isNotEmpty(itemList) && "1".equals(saleHeadVO.getSupplierTaxRate())) {
            ArrayList<SaleEbiddingItem> updateSaleList = new ArrayList<SaleEbiddingItem>();
            ArrayList updatePurchaseList = new ArrayList();
            for (SaleEbiddingItem item : itemList) {
                SaleEbiddingItem updateSaleItem = new SaleEbiddingItem();
                updateSaleItem.setId(item.getId());
                updateSaleItem.setTaxCode(item.getTaxCode());
                updateSaleItem.setTaxRate(item.getTaxRate());
                updateSaleList.add(updateSaleItem);
                PurchaseEbiddingItem updatePurchaseItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)updateSaleItem), (Object)((Object)updatePurchaseItem));
                updatePurchaseItem.setId(item.getRelationId());
            }
            this.saleEbiddingItemService.updateBatchById(updateSaleList);
            this.purchaseEbiddingItemService.updateBatchById(updatePurchaseList);
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(saleHeadVO.getId());
        sendVO.setElsAccount(saleHeadVO.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(saleHeadVO.getRelationId(), saleHeadVO.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
    }

    private BigDecimal getPrice(String ebiddingType, String ebiddingWay, String quoteType, List<PurchaseEbiddingItem> purchaseItemList) {
        BigDecimal resultPrice = null;
        if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                    resultPrice = price;
                }
            } else {
                for (PurchaseEbiddingItem item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                    resultPrice = price;
                }
            }
        } else if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                resultPrice = price;
            }
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                resultPrice = price;
            }
        }
        return resultPrice;
    }

    private void checkQuote(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime, PurchaseEbiddingSupplier supplier, Map<String, List<PurchaseEbiddingItem>> purchaseMap) {
        BigDecimal dbPrice;
        boolean flag;
        BigDecimal webPrice;
        SaleEbiddingItem currentItem;
        SaleEbiddingItem quoteItem;
        String supplierShow;
        Assert.isTrue((boolean)dbSaleHead.getEndTime().after(currentTime), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u72b6\u6001\u624d\u53ef\u62a5\u4ef7"));
        if ("1".equals(dbSaleHead.getNeedEcho())) {
            Assert.isTrue((boolean)EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus()), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u540e\u624d\u53ef\u62a5\u4ef7"));
        }
        for (SaleEbiddingItem quoteItem2 : quoteList) {
            if (quoteItem2.getExpiryDate() == null || quoteItem2.getEffectiveDate() == null || !quoteItem2.getEffectiveDate().after(quoteItem2.getExpiryDate())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
        }
        String ebiddingType = dbSaleHead.getEbiddingType();
        String string = supplierShow = dbSaleHead.getSupplierShow() == null ? "" : dbSaleHead.getSupplierShow();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            Assert.isTrue((boolean)quoteItem.getItemNumber().equals(dbSaleHead.getCurrentItemNumber()), (String)I18nUtil.translate((String)"", (String)"\u8be5\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                flag = currentItem.getStartPrice() == null || currentItem.getStartPrice().compareTo(webPrice) <= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            } else {
                flag = currentItem.getStartPrice() == null || currentItem.getStartPrice().compareTo(webPrice) >= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.SINGLE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get(quoteItem.getItemNumber())) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getPrice() : currentItem.getNetPrice());
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get("1");
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getTotalAmount() : quoteItem.getNetTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                flag = dbSaleHead.getStartTotalAmount() == null || dbSaleHead.getStartTotalAmount().compareTo(webPrice) <= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            } else {
                flag = dbSaleHead.getStartTotalAmount() == null || dbSaleHead.getStartTotalAmount().compareTo(webPrice) >= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.PACKAGE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1")) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount());
        } else {
            SaleEbiddingItem currentItem2 = dbItemMap.get("1");
            BigDecimal quotePrice = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem3 : quoteList) {
                BigDecimal itemPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem3.getPrice() : quoteItem3.getNetPrice();
                Assert.notNull((Object)itemPrice, (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                BigDecimal requireQuantity = quoteItem3.getRequireQuantity() == null ? BigDecimal.ONE : quoteItem3.getRequireQuantity();
                quotePrice = quotePrice.add(itemPrice.multiply(requireQuantity));
            }
            webPrice = quotePrice;
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                flag = dbSaleHead.getStartTotalAmount() == null || dbSaleHead.getStartTotalAmount().compareTo(webPrice) <= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            } else {
                flag = dbSaleHead.getStartTotalAmount() == null || dbSaleHead.getStartTotalAmount().compareTo(webPrice) >= 0;
                Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                dbPrice = this.getPrice(ebiddingType, EbiddingWayEnum.BATCH.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1"));
            } else {
                BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem2.getTotalAmount() : currentItem2.getNetTotalAmount();
            }
        }
        if (dbPrice != null) {
            BigDecimal changeRange = dbSaleHead.getChangeRange();
            String rangeUnit = dbSaleHead.getRangeUnit();
            if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                changeRange = dbPrice.multiply(changeRange.divide(BigDecimal.valueOf(100L))).setScale(6, 4);
            }
            flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            BigDecimal changeRangeUpper = dbSaleHead.getChangeRangeUpper();
            if (changeRangeUpper != null) {
                if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                    changeRangeUpper = dbPrice.multiply(changeRangeUpper.divide(BigDecimal.valueOf(100L))).setScale(6, 4);
                }
                boolean upperFlag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRangeUpper).compareTo(dbPrice) < 0 : webPrice.add(changeRangeUpper).compareTo(dbPrice) > 0;
                Assert.isTrue((boolean)upperFlag, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u62a5\u4ef7\u8d85\u8fc7\u5e45\u5ea6\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            }
        }
    }

    private void autoDelay(SaleEbiddingHead dbSaleHead) {
        int delayMinute = dbSaleHead.getDelayMinute() == null ? 1 : dbSaleHead.getDelayMinute();
        DateTime endTime = DateUtil.offsetMinute((Date)dbSaleHead.getEndTime(), (int)delayMinute);
        SaleEbiddingHead updateSaleHead = new SaleEbiddingHead();
        updateSaleHead.setEndTime((Date)endTime);
        int currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
        updateSaleHead.setCurrentDelayCount(currentDelayCount + 1);
        ((SaleEbiddingHeadMapper)this.baseMapper).update((Object)updateSaleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbSaleHead.getRelationId()));
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(dbSaleHead.getRelationId());
        purchaseHead.setEndTime((Date)endTime);
        purchaseHead.setCurrentDelayCount(updateSaleHead.getCurrentDelayCount());
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
        EbiddingJobUtil.updateEndJob(dbSaleHead, (Date)endTime);
    }

    private void checkDelay(SaleEbiddingHead dbSaleHead, Date currentTime) {
        String delayRule = dbSaleHead.getDelayRule();
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(delayRule)) {
            int beforeEndMinute = dbSaleHead.getBeforeEndMinute() == null ? 1 : dbSaleHead.getBeforeEndMinute();
            Date endTime = dbSaleHead.getEndTime();
            DateTime checkDate = DateUtil.offsetMinute((Date)currentTime, (int)beforeEndMinute);
            if (checkDate.compareTo(endTime) > 0) {
                if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                    int currentDelayCount;
                    int delayCount = dbSaleHead.getDelayCount() == null ? 1 : dbSaleHead.getDelayCount();
                    int n = currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
                    if (delayCount > currentDelayCount) {
                        this.autoDelay(dbSaleHead);
                    }
                } else {
                    this.autoDelay(dbSaleHead);
                }
            }
        }
    }

    private void compute(SaleEbiddingHead dbSaleHead, List<SaleEbiddingItem> quoteList, Map<String, SaleEbiddingItem> dbItemMap, Date currentTime) {
        Object taxRate;
        SaleEbiddingItem currentItem;
        SaleEbiddingItem quoteItem;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            taxRate = StrUtil.isNotBlank((CharSequence)currentItem.getTaxRate()) ? new BigDecimal(currentItem.getTaxRate()) : BigDecimal.ZERO;
            BigDecimal bigDecimal = requireQuantity = currentItem.getRequireQuantity() == null ? BigDecimal.ONE : currentItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = price.divide(BigDecimal.ONE.add(((BigDecimal)taxRate).divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(((BigDecimal)taxRate).divide(BigDecimal.valueOf(100L)))).setScale(6, 4);
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            Object object = taxRate = StrUtil.isNotBlank((CharSequence)currentItem.getTaxRate()) ? new BigDecimal(currentItem.getTaxRate()) : BigDecimal.ZERO;
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal totalAmount = quoteItem.getTotalAmount();
                BigDecimal netTotalAmount = totalAmount.divide(BigDecimal.ONE.add(((BigDecimal)taxRate).divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetTotalAmount(netTotalAmount);
            } else {
                BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
                BigDecimal totalAmount = netTotalAmount.multiply(BigDecimal.ONE.add(((BigDecimal)taxRate).divide(BigDecimal.valueOf(100L)))).setScale(6, 4);
                quoteItem.setTotalAmount(totalAmount);
            }
        } else {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal netTotalAmount = BigDecimal.ZERO;
            for (SaleEbiddingItem quoteItem2 : quoteList) {
                BigDecimal requireQuantity;
                SaleEbiddingItem currentItem2 = dbItemMap.get(quoteItem2.getItemNumber());
                BigDecimal taxRate2 = StrUtil.isNotBlank((CharSequence)currentItem2.getTaxRate()) ? new BigDecimal(currentItem2.getTaxRate()) : BigDecimal.ZERO;
                BigDecimal bigDecimal = requireQuantity = currentItem2.getRequireQuantity() == null ? BigDecimal.ONE : currentItem2.getRequireQuantity();
                if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                    BigDecimal price = quoteItem2.getPrice();
                    BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate2.divide(BigDecimal.valueOf(100L))), 6, 4);
                    quoteItem2.setNetPrice(netPrice);
                    quoteItem2.setTaxAmount(price.multiply(requireQuantity));
                    totalAmount = totalAmount.add(quoteItem2.getTaxAmount());
                    quoteItem2.setNetAmount(netPrice.multiply(requireQuantity));
                    netTotalAmount = netTotalAmount.add(quoteItem2.getNetAmount());
                    continue;
                }
                BigDecimal netPrice = quoteItem2.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(taxRate2.divide(BigDecimal.valueOf(100L)))).setScale(6, 4);
                quoteItem2.setPrice(price);
                quoteItem2.setTaxAmount(price.multiply(requireQuantity));
                totalAmount = totalAmount.add(quoteItem2.getTaxAmount());
                quoteItem2.setNetAmount(netPrice.multiply(requireQuantity));
                netTotalAmount = netTotalAmount.add(quoteItem2.getNetAmount());
            }
            for (SaleEbiddingItem quoteItem2 : quoteList) {
                quoteItem2.setTotalAmount(totalAmount);
                quoteItem2.setNetTotalAmount(netTotalAmount);
            }
        }
        for (SaleEbiddingItem quoteItem3 : quoteList) {
            SaleEbiddingItem currentItem3 = dbItemMap.get(quoteItem3.getItemNumber());
            quoteItem3.setHeadId(dbSaleHead.getId());
            quoteItem3.setQuoteTime(currentTime);
            quoteItem3.setQuoteCount(currentItem3.getQuoteCount() == null ? 1 : currentItem3.getQuoteCount() + 1);
            quoteItem3.setQuoteIp(IPUtils.getIpAddr());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quotePrice(SaleEbiddingHeadVO saleHeadVO) {
        Date currentTime = new Date();
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)((SaleEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleHeadVO.getId())));
        List<SaleEbiddingItem> quoteList = saleHeadVO.getSaleEbiddingItemList();
        Map<String, SaleEbiddingItem> dbItemMap = this.saleEbiddingItemMapper.selectByMainId(saleHeadVO.getId()).stream().collect(Collectors.toMap(SaleEbiddingItem::getItemNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        PurchaseEbiddingSupplier supplier = (PurchaseEbiddingSupplier)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)dbSaleHead.getSupplierListId())));
        Map<String, List<PurchaseEbiddingItem>> purchaseMap = this.purchaseEbiddingItemMapper.selectByMainId(dbSaleHead.getRelationId()).stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        this.checkQuote(dbSaleHead, quoteList, dbItemMap, currentTime, supplier, purchaseMap);
        this.checkDelay(dbSaleHead, currentTime);
        this.compute(dbSaleHead, quoteList, dbItemMap, currentTime);
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            int count = this.saleEbiddingItemMapper.updateById((Object)quoteItem);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItem quoteItem = quoteList.get(0);
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItem purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        } else {
            ArrayList<PurchaseEbiddingItem> purchaseList = new ArrayList<PurchaseEbiddingItem>();
            for (SaleEbiddingItem quoteItem : quoteList) {
                purchaseList.add(this.getPurchaseItemByQuote(dbSaleHead, quoteItem));
            }
            this.saleEbiddingItemService.updateBatchById(quoteList);
            this.purchaseEbiddingItemService.updateBatchById(purchaseList);
        }
        this.saleEbiddingItemHisService.save(dbSaleHead, quoteList, supplier);
        this.redisUtil.publish("quote-price-topic", (Object)dbSaleHead.getEbiddingNumber());
    }

    private PurchaseEbiddingItem getPurchaseItemByQuote(SaleEbiddingHead dbSaleHead, SaleEbiddingItem quoteItem) {
        PurchaseEbiddingItem purchaseItem = new PurchaseEbiddingItem();
        BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchaseItem));
        purchaseItem.setId(quoteItem.getRelationId());
        purchaseItem.setHeadId(dbSaleHead.getRelationId());
        purchaseItem.setRelationId(quoteItem.getId());
        purchaseItem.setToElsAccount(dbSaleHead.getElsAccount());
        purchaseItem.setElsAccount(dbSaleHead.getToElsAccount());
        return purchaseItem;
    }

    @Override
    public void confirmBid(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList) {
        SaleEbiddingItem saleItem;
        ArrayList<SaleEbiddingItem> saleItemList = new ArrayList<SaleEbiddingItem>();
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
        } else {
            for (PurchaseEbiddingItem item : purchaseItemList) {
                saleItem = new SaleEbiddingItem();
                saleItem.setRelationId(item.getId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
        }
        this.saleEbiddingItemMapper.updateBidResultBatchRelationId(saleItemList);
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(BaseEntity::getElsAccount, (Object)supplier.getToElsAccount())).set(SaleEbiddingHead::getEbiddingStatus, (Object)supplier.getBiddingStatus()));
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList) {
        this.updateStatus(dbHead, itemList);
    }

    @Override
    public void regret(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList) {
        this.updateStatus(dbHead, itemList);
    }

    @Override
    public List<SaleEbiddingHead> getByRelationId(String relationId) {
        return ((SaleEbiddingHeadMapper)this.baseMapper).selectByMainId(relationId);
    }

    private void updateStatus(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).set(SaleEbiddingHead::getEbiddingStatus, (Object)dbHead.getEbiddingStatus()));
        ArrayList<SaleEbiddingItem> updateList = new ArrayList<SaleEbiddingItem>();
        for (PurchaseEbiddingItem item : itemList) {
            SaleEbiddingItem saleItem = new SaleEbiddingItem();
            saleItem.setId(item.getRelationId());
            saleItem.setItemStatus(item.getItemStatus());
            updateList.add(saleItem);
        }
        this.saleEbiddingItemService.updateBatchById(updateList);
    }
}

