/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="saleEnquiryItemExcelServiceImpl")
public class SaleEnquiryItemExcelServiceImpl
implements ExcelItemByConfigRpcService {
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<SaleEnquiryItem> itemList = this.saleEnquiryItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<SaleEnquiryItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        List quotePriceList = null;
        if (dataList.get(dataList.size() - 1).get("otherSheetList") != null) {
            quotePriceList = (List)dataList.get(dataList.size() - 1).get("otherSheetList");
            dataList.remove(dataList.size() - 1);
        }
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)this.headId)));
        List<String> excludeColumn = Arrays.asList("price", "netPrice", "taxCode", "taxRate");
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setHeadId(this.headId);
        List editColumn = this.getTemplate(dto).getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleEdit())).filter(item -> !excludeColumn.contains(item.getFieldName())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        if ("1".equals(dbHead.getSupplierTaxRate())) {
            editColumn.add("taxCode");
        }
        if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType())) {
            editColumn.add("netPrice");
        } else {
            editColumn.add("price");
        }
        Map taxMap = this.invokeBaseRpcService.getAllTax(dbHead.getToElsAccount());
        for (Map<String, Object> data : dataList) {
            String taxCode;
            String quotePriceWay = (String)data.get("quotePriceWay");
            String itemNumber = (String)data.get("itemNumber");
            Integer taxRate = Integer.parseInt(data.get("taxRate") + "");
            Integer requireQuantity = data.get("requireQuantity") != null ? Integer.parseInt(data.get("requireQuantity").toString()) : 1;
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (!editColumn.contains(entry.getKey())) {
                    data.put(entry.getKey(), null);
                    continue;
                }
                data.put(entry.getKey(), entry.getValue());
            }
            if (!EnquiryQuoteWayEnum.NORMAL.getValue().equals(quotePriceWay)) {
                data.put("price", null);
                data.put("netPrice", null);
            }
            if (StringUtils.isNotBlank((CharSequence)(taxCode = (String)data.get("taxCode")))) {
                Assert.isTrue((boolean)taxMap.containsKey(taxCode), (String)I18nUtil.translate((String)"", (String)("\u7a0e\u7801\uff1a" + taxCode + "\u4e0d\u5b58\u5728")));
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!EnquiryQuoteWayEnum.LADDER.getValue().equals(quotePriceWay) || quotePriceList == null) continue;
            List newQuotePriceList = quotePriceList.stream().filter(info -> itemNumber.equals(info.get("itemNumber"))).collect(Collectors.toList());
            newQuotePriceList.stream().forEach(info -> {
                if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("netPrice") != null) {
                    Float netPrice = Float.valueOf(Float.valueOf(info.get("netPrice") + "").floatValue() * (1.0f + (float)taxRate.intValue() / 100.0f));
                    info.put("price", String.format("%.6f", netPrice));
                } else if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType()) && info.get("price") != null) {
                    Float netPrice = Float.valueOf(Float.valueOf(info.get("price") + "").floatValue() / (1.0f + (float)taxRate.intValue() / 100.0f));
                    info.put("netPrice", String.format("%.6f", netPrice));
                }
            });
            data.put("ladderPriceJson", JSONArray.toJSONString(newQuotePriceList));
            data.put("price", ((Map)newQuotePriceList.get(0)).get("price"));
            data.put("netPrice", ((Map)newQuotePriceList.get(0)).get("netPrice"));
            Float netAmount = Float.valueOf(Float.valueOf(((Map)newQuotePriceList.get(0)).get("netPrice") + "").floatValue() * (float)requireQuantity.intValue());
            Float taxAmount = Float.valueOf(Float.valueOf(((Map)newQuotePriceList.get(0)).get("price") + "").floatValue() * (float)requireQuantity.intValue());
            data.put("netAmount", String.format("%.6f", netAmount));
            data.put("taxAmount", String.format("%.6f", taxAmount));
        }
        for (Map<String, Object> map : dataList) {
            if (map.get("expiryDate") != null) {
                map.put("expiryDate", map.get("expiryDate").toString().split(" ")[0]);
            }
            if (map.get("effectiveDate") == null) continue;
            map.put("effectiveDate", map.get("effectiveDate").toString().split(" ")[0]);
        }
        return dataList;
    }
}

