/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseEnquiryItemExcelServiceImpl")
public class PurchaseEnquiryItemExcelServiceImpl
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemExcelServiceImpl.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    private String headId;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchaseEnquiryItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setHeadId(this.headId);
        List configItemList = this.getTemplate(dto).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        editColumn.addAll(MATER_STRING);
        Map taxMap = this.invokeBaseRpcService.getAllTax(TenantContext.getTenant());
        for (Map<String, Object> data : dataList) {
            Field[] fields;
            String materialNumber;
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode)) {
                Assert.isTrue((boolean)taxMap.containsKey(taxCode), (String)I18nUtil.translate((String)"", (String)("\u7a0e\u7801\uff1a" + taxCode + "\u4e0d\u5b58\u5728")));
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!StringUtils.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHeadDTO materialHead = this.purchaseMaterialHeadLocalRpcService.getMaterialHeadByNumber(materialNumber);
            if (null == materialHead) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801\uff1a" + materialNumber + "\u4e0d\u5b58\u5728")));
            }
            for (Field field : fields = ConvertUtils.getAllFields((Object)materialHead)) {
                if (!MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get(materialHead));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return dataList;
    }
}

