/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingScopeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStartWayEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.service.PublicEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEbiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseEbiddingHeadMapper, PurchaseEbiddingHead>
implements PurchaseEbiddingHeadService,
PurchaseExecuteReviewService {
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;
    @Autowired
    private PublicEbiddingService publicEbiddingService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    private static final String START_PRICE_FLAG = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> purchaseEbiddingItemList, List<PurchaseEbiddingSupplier> purchaseEbiddingSupplierList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        String resultAuditStatus = START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        head.setResultAuditStatus(resultAuditStatus);
        String auditStatus = START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        head.setAuditStatus(auditStatus);
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        head.setCurrentRound(1);
        ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        this.insertData(head, purchaseEbiddingItemList, purchaseEbiddingSupplierList, purchaseAttachmentDemandList);
        this.goBackDemand(purchaseEbiddingItemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> purchaseEbiddingItemList, List<PurchaseEbiddingSupplier> purchaseEbiddingSupplierList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        String resultAuditStatus = START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        head.setResultAuditStatus(resultAuditStatus);
        String auditStatus = START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
        head.setAuditStatus(auditStatus);
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        this.insertData(head, purchaseEbiddingItemList, purchaseEbiddingSupplierList, purchaseAttachmentDemandList);
    }

    private void deleteSubTable(String headId) {
        this.purchaseEbiddingItemService.deleteByMainId(headId);
        this.purchaseEbiddingSupplierService.deleteByMainId(headId);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EbiddingStatusEnum.NEW.getValue().equals(head.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseEbiddingItemService.deleteByMainId(id);
        this.purchaseEbiddingSupplierService.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
    }

    private void insertData(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList) {
        String headId = head.getId();
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            for (PurchaseEbiddingItem item : itemList) {
                item.setId(null);
                item.setHeadId(headId);
                item.setEbiddingNumber(head.getEbiddingNumber());
                item.setItemStatus(EbiddingStatusEnum.NEW.getValue());
                item.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                item.setSendStatus("0");
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEbiddingItemService.saveBatch(itemList, 2000);
        }
        if (CollectionUtil.isNotEmpty(supplierList)) {
            int supplierItemNumber = 1;
            for (PurchaseEbiddingSupplier supplier : supplierList) {
                supplier.setId(null);
                supplier.setHeadId(headId);
                supplier.setEbiddingNumber(head.getEbiddingNumber());
                supplier.setItemNumber(String.valueOf(supplierItemNumber++));
                SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            }
            this.purchaseEbiddingSupplierService.saveBatch(supplierList, 2000);
        }
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, headId, "ebidding");
    }

    @Override
    public void goBackDemand(List<PurchaseEbiddingItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List<String> idList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).map(PurchaseEbiddingItem::getSourceItemId).distinct().collect(Collectors.toList());
            this.purchaseRequestItemService.updateStatusById(idList, status);
        }
    }

    public static void checkAndSetParam(PurchaseEbiddingHeadVO headVO) {
        Date beginTime = headVO.getBeginTime();
        BigDecimal keepMinute = headVO.getKeepMinute();
        Assert.notNull((Object)beginTime, (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)beginTime.after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notNull((Object)headVO.getChangeRange(), (String)I18nUtil.translate((String)"", (String)"\u4ef7\u683c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRangeUnit(), (String)I18nUtil.translate((String)"", (String)"\u5e45\u5ea6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
        Integer participateQuantity = headVO.getParticipateQuantity();
        Assert.notNull((Object)participateQuantity, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u53c2\u4e0e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        headVO.setInviteQuantity(supplierList.size());
        String ebiddingScope = StrUtil.isNotBlank((CharSequence)headVO.getEbiddingScope()) ? headVO.getEbiddingScope() : EbiddingScopeEnum.INVITE.getValue();
        headVO.setEbiddingScope(ebiddingScope);
        if (EbiddingScopeEnum.INVITE.getValue().equals(ebiddingScope)) {
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((participateQuantity.compareTo(headVO.getInviteQuantity()) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u53c2\u4e0e\u6570\u91cf"));
        }
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (START_PRICE_FLAG.equals(headVO.getSetStartPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getStartTotalAmount(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getTargetTotalAmount(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u7a0e\u7387\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f"));
        } else if (checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.hasText((String)headVO.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.hasText((String)headVO.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            Assert.notNull((Object)headVO.getEchoEndTime(), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().before(beginTime), (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4"));
        }
        if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String delayRule = headVO.getDelayRule();
        if (EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(delayRule)) {
            Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        } else if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
            Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)headVO.getDelayCount(), (String)I18nUtil.translate((String)"", (String)"\u53ef\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(ebiddingScope)) {
            Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"", (String)"\u516c\u5f00\u7ade\u4ef7\uff0c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Date time = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? headVO.getEchoEndTime() : headVO.getBeginTime();
            String message = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? "\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5e94\u6807\u622a\u6b62\u65f6\u95f4" : "\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4";
            Assert.isTrue((boolean)time.after(headVO.getApplyEndTime()), (String)I18nUtil.translate((String)"", (String)message));
        }
        List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseEbiddingItem item : itemList) {
            PurchaseEbiddingHeadServiceImpl.headToItem(headVO, item);
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice())) {
                    Assert.notNull((Object)item.getTargetPrice(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (START_PRICE_FLAG.equals(headVO.getSetStartPrice())) {
                    Assert.notNull((Object)item.getStartPrice(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (!START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
            if (!START_PRICE_FLAG.equals(headVO.getMustMaterialNumber())) continue;
            Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List needEchoList = headVO.getPurchaseAttachmentDemandList().stream().filter(demand -> START_PRICE_FLAG.equals(demand.getRequired())).filter(demand -> StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needEchoList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"", (String)(StageTypeEnum.QUOTE.getDesc() + "\u9644\u4ef6\u5fc5\u4f20\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f")));
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            headVO.setEbiddingStatus(EbiddingStatusEnum.WAIT_REPLY.getValue());
        } else {
            headVO.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
        }
        DateTime endTime = DateUtil.offsetSecond((Date)beginTime, (int)SysUtil.minuteToSecond((BigDecimal)keepMinute, (int)1));
        headVO.setEndTime((Date)endTime);
        headVO.setStartTime(beginTime);
        headVO.setCurrentRound(headVO.getCurrentRound() == null ? 1 : headVO.getCurrentRound());
        LoginUser user = SysUtil.getLoginUser();
        headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        headVO.setPublishTime(new Date());
        if (START_PRICE_FLAG.equals(headVO.getResultAudit())) {
            headVO.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            headVO.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private static void headToItem(PurchaseEbiddingHead head, PurchaseEbiddingItem item) {
        item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
        item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
        item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHeadServiceImpl.checkAndSetParam(headVO);
        if (START_PRICE_FLAG.equals(headVO.getPublishAudit())) {
            Assert.isTrue((boolean)AuditStatusEnum.AUDIT_FINISH.getValue().equals(headVO.getAuditStatus()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u53ef\u53d1\u5e03"));
        }
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseHead));
        List<PurchaseEbiddingItem> purchaseItemList = headVO.getPurchaseEbiddingItemList();
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        if (StrUtil.isBlank((CharSequence)purchaseHead.getId())) {
            ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)purchaseHead);
        } else {
            int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)purchaseHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.deleteSubTable(purchaseHead.getId());
        }
        if (START_PRICE_FLAG.equals(purchaseHead.getNeedEcho())) {
            EbiddingJobUtil.createFailedJob(purchaseHead, purchaseHead.getEchoEndTime());
        }
        if (EbiddingStartWayEnum.AUTO.getValue().equals(purchaseHead.getStartWay())) {
            EbiddingJobUtil.createStartJob(purchaseHead, purchaseHead.getBeginTime());
        }
        this.insertInitTable(purchaseHead.getId(), purchaseItemList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(purchaseHead, purchaseItemList, supplierList, headVO.getPurchaseAttachmentDemandList());
        } else {
            this.insertData(purchaseHead, purchaseItemList, supplierList, headVO.getPurchaseAttachmentDemandList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            this.publicEbiddingService.publishNotice(purchaseHead);
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, String> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", value);
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    private void insertInitTable(String headId, List<PurchaseEbiddingItem> itemList) {
        JSONObject object = new JSONObject();
        object.put("relationId", (Object)headId);
        object.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(object.toJSONString());
    }

    private AttachmentSendDTO publishEbidding(PurchaseEbiddingHead purchaseHead, List<PurchaseEbiddingItem> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> demandList) {
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = purchaseItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEbiddingItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseEbiddingItem> addPurchaseItemList = new ArrayList<PurchaseEbiddingItem>();
        int supplierItemNumber = 1;
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)purchaseHead);
            supplier.setId(null);
            supplier.setEbiddingNumber(purchaseHead.getEbiddingNumber());
            supplier.setHeadId(purchaseHead.getId());
            String replyStatus = START_PRICE_FLAG.equals(purchaseHead.getNeedEcho()) ? EbiddingReplyStatusEnum.WAIT_REPLY.getValue() : EbiddingReplyStatusEnum.NOT_NEED.getValue();
            supplier.setReplyStatus(replyStatus);
            supplier.setCurrentRound(purchaseHead.getCurrentRound());
            supplier.setItemNumber(String.valueOf(supplierItemNumber++));
            int itemNumber = 1;
            for (PurchaseEbiddingItem item2 : purchaseItemList) {
                PurchaseEbiddingItem buyItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)buyItem));
                SysUtil.setSysParam((BaseEntity)buyItem, (BaseEntity)purchaseHead);
                buyItem.setId(null);
                buyItem.setRelationId(IdWorker.getIdStr());
                buyItem.setHeadId(purchaseHead.getId());
                buyItem.setEbiddingNumber(purchaseHead.getEbiddingNumber());
                buyItem.setItemNumber(String.valueOf(itemNumber++));
                buyItem.setToElsAccount(supplier.getToElsAccount());
                buyItem.setSupplierCode(supplier.getSupplierCode());
                buyItem.setSupplierName(supplier.getSupplierName());
                buyItem.setItemStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                buyItem.setCurrentRound(purchaseHead.getCurrentRound());
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item2.getMaterialNumber() + supplier.getToElsAccount());
                    buyItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                buyItem.setExpiryDate(item2.getExpiryDate());
                buyItem.setEffectiveDate(item2.getEffectiveDate());
                addPurchaseItemList.add(buyItem);
            }
        }
        this.purchaseEbiddingItemService.saveBatch(addPurchaseItemList, 2000);
        this.purchaseEbiddingSupplierService.saveBatch(supplierList, 2000);
        Map<String, String> idMap = this.saleEbiddingHeadService.add(purchaseHead, addPurchaseItemList, supplierList);
        AttachmentSendDTO sendDTO = this.sendAttachment(purchaseHead, idMap, demandList);
        super.sendMsg(purchaseHead.getElsAccount(), toElsAccountList, (Object)purchaseHead, this.getReceiveParamMap(idMap), "ebidding", "publish");
        return sendDTO;
    }

    private AttachmentSendDTO sendAttachment(PurchaseEbiddingHead purchaseHead, Map<String, String> idMap, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(purchaseHead.getId());
        sendVO.setElsAccount(purchaseHead.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        for (String elsAccount : idMap.keySet()) {
            toSend.put(idMap.get(elsAccount), elsAccount);
        }
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(purchaseAttachmentDemandList, purchaseHead.getId(), "ebidding", idMap);
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingSupplier> webSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.purchaseEbiddingSupplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingSupplier> supplierList = webSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        this.publishEbidding(dbHead, itemList, supplierList, demandList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (PurchaseEbiddingSupplier supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startBidding(String id) {
        ArrayList<String> purchaseItemIds = new ArrayList<String>();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseEbiddingHead updatePurchaseHead = new PurchaseEbiddingHead();
        updatePurchaseHead.setId(id);
        updatePurchaseHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String itemNumber = StrUtil.isNotBlank((CharSequence)dbHead.getCurrentItemNumber()) ? dbHead.getCurrentItemNumber() : START_PRICE_FLAG;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseEbiddingItem::getHeadId, (Object)id);
            queryWrapper.lambda().eq(PurchaseEbiddingItem::getItemNumber, (Object)itemNumber);
            List itemList = this.purchaseEbiddingItemService.list((Wrapper)queryWrapper);
            updatePurchaseHead.setCurrentItemNumber(itemNumber);
            updatePurchaseHead.setCurrentMaterialDesc(((PurchaseEbiddingItem)((Object)itemList.get(0))).getMaterialDesc());
            updatePurchaseHead.setCurrentDelayCount(0);
            itemList.forEach(item -> {
                item.setItemStatus(EbiddingStatusEnum.BIDDING.getValue());
                purchaseItemIds.add(item.getId());
            });
            this.purchaseEbiddingItemService.updateBatchById(itemList);
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            updatePurchaseHead.setCurrentMaterialDesc(currentMaterialDesc);
            List<PurchaseEbiddingItem> items = this.purchaseEbiddingItemService.selectByMainId(id);
            items.forEach(item -> {
                item.setItemStatus(EbiddingStatusEnum.BIDDING.getValue());
                purchaseItemIds.add(item.getId());
            });
            this.purchaseEbiddingItemService.updateBatchById(items);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)updatePurchaseHead);
        this.jobUpdateSaleHead(updatePurchaseHead, dbHead, EbiddingStatusEnum.BIDDING.getValue(), purchaseItemIds);
        EbiddingJobUtil.createEndJob(dbHead, dbHead.getEndTime());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endBidding(String id) {
        ArrayList<String> purchaseItemIds = new ArrayList<String>();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(id);
        updateHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String itemNumber = String.valueOf(Integer.parseInt(dbHead.getCurrentItemNumber()) + 1);
            PurchaseEbiddingItem nextItem = this.purchaseEbiddingItemService.selectOneByMainIdAndItemNumber(id, itemNumber);
            if (nextItem != null) {
                updateHead.setCurrentItemNumber(itemNumber);
                updateHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                updateHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                updateHead.setBeginTime((Date)DateUtil.offsetSecond((Date)dbHead.getEndTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                updateHead.setEndTime((Date)DateUtil.offsetSecond((Date)updateHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                updateHead.setCurrentDelayCount(0);
                EbiddingJobUtil.createStartJob(updateHead, updateHead.getBeginTime());
            } else {
                updateHead.setCurrentItemNumber("");
                updateHead.setCurrentMaterialDesc("");
                updateHead.setBeginTime(dbHead.getBeginTime());
                updateHead.setEndTime(dbHead.getEndTime());
                updateHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
            }
            QueryWrapper itemQueryWrapper = new QueryWrapper();
            itemQueryWrapper.lambda().eq(PurchaseEbiddingItem::getHeadId, (Object)id);
            itemQueryWrapper.lambda().eq(PurchaseEbiddingItem::getItemNumber, (Object)dbHead.getCurrentItemNumber());
            List currentItemList = this.purchaseEbiddingItemService.list((Wrapper)itemQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)currentItemList)) {
                UpdateWrapper itemUpdateWrapper = new UpdateWrapper();
                itemUpdateWrapper.lambda().eq(PurchaseEbiddingItem::getHeadId, (Object)id);
                itemUpdateWrapper.lambda().eq(PurchaseEbiddingItem::getItemNumber, (Object)dbHead.getCurrentItemNumber());
                itemUpdateWrapper.lambda().set(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingStatusEnum.BIDDING_END.getValue());
                this.purchaseEbiddingItemService.update((Wrapper)itemUpdateWrapper);
                List itemList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                purchaseItemIds.addAll(itemList);
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            updateHead.setCurrentMaterialDesc(currentMaterialDesc);
        }
        if (EbiddingStatusEnum.BIDDING_END.getValue().equals(updateHead.getEbiddingStatus())) {
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            long count = itemList.stream().filter(item -> item.getQuoteCount() != null && item.getQuoteCount() > 0).map(PurchaseEbiddingItem::getToElsAccount).distinct().count();
            if (count < (long)dbHead.getParticipateQuantity().intValue()) {
                updateHead.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue());
            }
            if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                itemList.forEach(item -> item.setItemStatus(EbiddingStatusEnum.BIDDING_END.getValue()));
                this.purchaseEbiddingItemService.updateBatchById(itemList);
            }
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)updateHead);
        this.jobUpdateSaleHead(updateHead, null, EbiddingStatusEnum.BIDDING_END.getValue(), purchaseItemIds);
    }

    private void jobUpdateSaleHead(PurchaseEbiddingHead updateHead, PurchaseEbiddingHead dbHead, String itemStatus, List<String> purchaseItemIds) {
        SaleEbiddingHead saleHead = new SaleEbiddingHead();
        saleHead.setEbiddingStatus(updateHead.getEbiddingStatus());
        saleHead.setCurrentItemNumber(updateHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(updateHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead == null ? updateHead.getBeginTime() : dbHead.getBeginTime());
        saleHead.setStartTime(dbHead == null ? updateHead.getStartTime() : dbHead.getStartTime());
        saleHead.setEndTime(dbHead == null ? updateHead.getEndTime() : dbHead.getEndTime());
        saleHead.setCurrentDelayCount(updateHead.getCurrentDelayCount());
        this.saleEbiddingHeadService.update((Object)saleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)updateHead.getId()));
        if (purchaseItemIds != null && purchaseItemIds.size() > 0) {
            UpdateWrapper updateItem = new UpdateWrapper();
            updateItem.lambda().set(SaleEbiddingItem::getItemStatus, (Object)itemStatus);
            updateItem.lambda().in(SaleEbiddingItem::getRelationId, purchaseItemIds);
            this.saleEbiddingItemService.update((Wrapper)updateItem);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualStartBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(dbHead.getBeginTime()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u53ef\u5f00\u542f\u5f85\u7ade\u4ef7\u7684\u5355\u636e"));
        PurchaseEbiddingHead update = new PurchaseEbiddingHead();
        update.setId(headVO.getId());
        update.setStartTime(currentTime);
        DateTime endTime = DateUtil.offsetSecond((Date)currentTime, (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1));
        update.setEndTime((Date)endTime);
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)update);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.startBidding(headVO.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualEndBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead purchaseHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(purchaseHead.getEndTime()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u7ed3\u675f\u7ade\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(purchaseHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u7ed3\u675f\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff01"));
        this.endBidding(headVO.getId());
    }

    private Map<String, BigDecimal> getStartPriceMap(PurchaseEbiddingHeadVO headVO, List<PurchaseEbiddingItem> ebiddingBuyItemList) {
        HashMap<String, BigDecimal> startPriceMap = new HashMap<String, BigDecimal>(16);
        String ebiddingType = headVO.getEbiddingType();
        String startPriceFlag = headVO.getStartPriceFlag();
        if (START_PRICE_FLAG.equals(startPriceFlag)) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Map<String, List<PurchaseEbiddingItem>> itemMap = ebiddingBuyItemList.parallelStream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List itemList = itemMap.get(itemNumber).parallelStream().filter(item -> item.getPrice() != null).collect(Collectors.toList());
                    if (itemList.isEmpty()) continue;
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                        BigDecimal maxPrice = itemList.parallelStream().max(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                        startPriceMap.put(itemNumber, maxPrice);
                        continue;
                    }
                    BigDecimal minPrice = itemList.parallelStream().min(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                    startPriceMap.put(itemNumber, minPrice);
                }
            } else {
                List itemList = ebiddingBuyItemList.parallelStream().filter(item -> item.getTaxAmount() != null).collect(Collectors.toList());
                if (!itemList.isEmpty()) {
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                        BigDecimal maxTotalAmount = itemList.parallelStream().max(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), maxTotalAmount);
                    } else {
                        BigDecimal minTotalAmount = itemList.parallelStream().min(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), minTotalAmount);
                    }
                }
            }
        }
        return startPriceMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createNewRound(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u521b\u5efa\u65b0\u8f6e\u6b21"));
        String startPriceFlag = headVO.getStartPriceFlag();
        List<PurchaseEbiddingItem> purchaseEbiddingItemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        Map<String, BigDecimal> startPriceMap = this.getStartPriceMap(headVO, purchaseEbiddingItemList);
        for (Object purchaseItem : initItemList) {
            if (!START_PRICE_FLAG.equals(startPriceFlag)) continue;
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                ((PurchaseEbiddingItem)((Object)purchaseItem)).setStartPrice(startPriceMap.get(((PurchaseEbiddingItem)((Object)purchaseItem)).getItemNumber()));
                continue;
            }
            headVO.setStartTotalAmount(startPriceMap.get(headId));
        }
        headVO.setPurchaseEbiddingItemList(initItemList);
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            supplier.setReplyTime(null);
        }
        headVO.setPurchaseEbiddingSupplierList(supplierList);
        headVO.setCurrentRound(headVO.getCurrentRound() + 1);
        headVO.setCurrentDelayCount(0);
        headVO.setReplyQuantity(0);
        headVO.setId(null);
        this.publish(headVO);
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.NEW_ROUND.getValue());
        purchaseHead.setId(headId);
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)purchaseHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    private void checkConfirm(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> purchaseItemList) {
        if (START_PRICE_FLAG.equals(dbHead.getQuotaWay())) {
            List<PurchaseEbiddingItem> acceptList = purchaseItemList.stream().filter(item -> EbiddingStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(acceptList)) {
                acceptList.forEach(item -> {
                    Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                });
                Map<String, List<PurchaseEbiddingItem>> itemMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List<PurchaseEbiddingItem> list = itemMap.get(itemNumber);
                    BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Assert.isTrue((quotaTotal.compareTo(new BigDecimal(100)) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01"));
                }
            }
        } else {
            Map<String, List<PurchaseEbiddingItem>> map = purchaseItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
            map.forEach((key, value) -> {
                List<PurchaseEbiddingItem> acceptList = value.stream().filter(item -> EbiddingStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                acceptList.forEach(item -> Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807")));
                Assert.isTrue((acceptList.size() <= 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u540c\u4e00\u4e2a\u7269\u6599\u884c\uff0c\u6700\u591a\u53ea\u53ef\u4e2d\u6807\u4e00\u5bb6\u4f9b\u5e94\u5546"));
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u5b9a\u4ef7"));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(headVO.getId());
        dbItemList.forEach(item -> {
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
            }
            String itemStatus = item.getItemStatus();
            boolean flag = !EbiddingStatusEnum.BID_WIN.getValue().equals(itemStatus) && !EbiddingStatusEnum.UN_BID_WIN.getValue().equals(itemStatus);
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u672a\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u5b9a\u4ef7"));
        });
        List<PurchaseEbiddingSupplierVO> supplierVOList = headVO.getPurchaseEbiddingSupplierQuoteList();
        ArrayList<PurchaseEbiddingItem> purchaseItemList = new ArrayList<PurchaseEbiddingItem>();
        for (PurchaseEbiddingSupplierVO purchaseEbiddingSupplierVO : supplierVOList) {
            purchaseItemList.addAll(purchaseEbiddingSupplierVO.getPurchaseEbiddingItemList());
        }
        this.checkConfirm(dbHead, purchaseItemList);
        ArrayList<PurchaseEbiddingSupplier> supplierList = new ArrayList<PurchaseEbiddingSupplier>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item2 : purchaseItemList) {
                String itemStatus = EbiddingStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingStatusEnum.BID_WIN.getValue() : EbiddingStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
            }
            Map<String, String> map = purchaseItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            map.forEach((key, value) -> {
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItem item3 : purchaseItemList) {
                String itemStatus = EbiddingStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus()) ? EbiddingStatusEnum.BID_WIN.getValue() : EbiddingStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus()) ? item3.getQuota() : null;
                item3.setId(null);
                item3.setQuota(quota);
                item3.setItemStatus(itemStatus);
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item3.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
        }
        this.purchaseEbiddingItemService.updateBidResultBatch(purchaseItemList);
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, purchaseItemList, supplierList);
            this.goBackDemand(purchaseItemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItem> list = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecord(dbHead, list);
            }
        }
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> purchaseItemList, List<PurchaseEbiddingSupplier> supplierList) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_SUCCESS.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.confirmBid(dbHead, purchaseItemList, supplierList);
        if (!PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) {
            List<Object> toElsAccountList = new ArrayList();
            List<PurchaseEbiddingSupplier> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                toElsAccountList = dbSupplierList.stream().filter(supplier -> EbiddingStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                toElsAccountList = dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
            }
            List<SaleEbiddingHead> saleEbiddingHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            for (SaleEbiddingHead saleEbiddingHead : saleEbiddingHeadList) {
                JSONObject urlParam = new JSONObject();
                urlParam.put("id", (Object)saleEbiddingHead.getId());
                urlParam.put("templateNumber", (Object)saleEbiddingHead.getTemplateNumber());
                urlParam.put("templateVersion", (Object)saleEbiddingHead.getTemplateVersion());
                urlParam.put("busAccount", (Object)saleEbiddingHead.getBusAccount());
                receiveParamMap.put(saleEbiddingHead.getElsAccount(), urlParam);
            }
            for (PurchaseEbiddingItem item : purchaseItemList) {
                if (!toElsAccountList.contains(item.getToElsAccount())) continue;
                item.setKeyWord(SysUtil.getLoginUser().getEnterpriseName());
                if (EbiddingStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())) {
                    super.sendMsg(dbHead.getElsAccount(), item.getToElsAccount(), (Object)item, receiveParamMap, "ebidding", "confirm");
                    continue;
                }
                super.sendMsg(dbHead.getElsAccount(), item.getToElsAccount(), (Object)item, receiveParamMap, "ebidding", "refundPurchase");
            }
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.INVALID.getValue());
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        itemList.forEach(item -> item.setItemStatus(EbiddingStatusEnum.INVALID.getValue()));
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        this.saleEbiddingHeadService.cancel(dbHead, itemList);
        EbiddingJobUtil.deleteAllJob(dbHead);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(head.getEbiddingWay())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(head.getPurchaseGroup());
                records.setPurchaseOrg(head.getPurchaseOrg());
                records.setCompany(head.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(head.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItem> updateList = new ArrayList<PurchaseEbiddingItem>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseEbiddingItem update = new PurchaseEbiddingItem();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((!AuditStatusEnum.AUDIT_DOING.getValue().equals(dbHead.getResultAuditStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u53ef\u6094\u6807"));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        itemList.forEach(item -> {
            String itemStatus = item.getItemStatus();
            boolean flag = EbiddingStatusEnum.BID_WIN.getValue().equals(itemStatus) || EbiddingStatusEnum.UN_BID_WIN.getValue().equals(itemStatus);
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"", (String)"\u5df2\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u6094\u6807"));
            item.setSendStatus("0");
        });
        String regretFlag = headVO.getRegretFlag();
        RegretFlagEnum regretFlagEnum = RegretFlagEnum.getEnumByValue(regretFlag);
        switch (regretFlagEnum) {
            case RE_SOURCE: {
                this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
            }
            case NOT_SOURCE: {
                this.regret(dbHead, itemList, true);
                break;
            }
            case RE_PRICED: {
                this.regret(dbHead, itemList, false);
                break;
            }
        }
    }

    private void regret(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, boolean flag) {
        if (flag) {
            itemList.forEach(item -> item.setItemStatus(EbiddingStatusEnum.BID_FAILED.getValue()));
        } else {
            itemList.forEach(item -> item.setItemStatus(EbiddingStatusEnum.BIDDING_END.getValue()));
        }
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        dbHead.setEbiddingStatus(flag ? EbiddingStatusEnum.BID_FAILED.getValue() : EbiddingStatusEnum.BIDDING_END.getValue());
        dbHead.setResultAuditStatus(flag ? dbHead.getResultAuditStatus() : AuditStatusEnum.AUDIT_NEW.getValue());
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saleEbiddingHeadService.regret(dbHead, itemList);
        String sourceNumber = dbHead.getEbiddingNumber();
        List<String> itemNumberList = itemList.stream().map(PurchaseEbiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.EBIDDING.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEbiddingHead dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId());
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        ArrayList supplierList = Lists.newArrayList();
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getItemStatus).distinct().collect(Collectors.toList());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        AttachmentSendDTO sendVO = this.publishEbidding(dbHead, initItemList, supplierList, demandList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.invokeBaseRpcService.updateSaleFile(sendVO);
    }
}

