/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.enquiry.entity.EnquirySubstituteHead;
import com.els.modules.enquiry.entity.EnquirySubstituteItem;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.EnquirySubstituteHeadMapper;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class EnquirySubstituteHeadServiceImpl
extends BaseServiceImpl<EnquirySubstituteHeadMapper, EnquirySubstituteHead>
implements EnquirySubstituteHeadService {
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;

    private List<EnquirySubstituteItem> copyItem(List<SaleEnquiryItem> saleItemList) {
        ArrayList<EnquirySubstituteItem> substituteItemList = new ArrayList<EnquirySubstituteItem>();
        for (SaleEnquiryItem saleItem : saleItemList) {
            EnquirySubstituteItem item = new EnquirySubstituteItem();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)item));
            substituteItemList.add(item);
        }
        return substituteItemList;
    }

    private List<EnquirySubstituteHead> copyHead(List<SaleEnquiryHead> saleHeadList) {
        ArrayList<EnquirySubstituteHead> substituteHeadList = new ArrayList<EnquirySubstituteHead>();
        for (SaleEnquiryHead saleHead : saleHeadList) {
            EnquirySubstituteHead head = new EnquirySubstituteHead();
            BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)head));
            substituteHeadList.add(head);
        }
        return substituteHeadList;
    }

    @Override
    public void add(List<SaleEnquiryHead> saleHeadList, List<SaleEnquiryItem> saleItemList, List<EnquirySupplierList> supplierList) {
        List needInsertSupplier = supplierList.stream().filter(supplier -> "0".equals(supplier.getNeedCoordination())).map(EnquirySupplierList::getToElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needInsertSupplier)) {
            List<SaleEnquiryHead> needInsertHeadList = saleHeadList.stream().filter(head -> needInsertSupplier.contains(head.getElsAccount())).collect(Collectors.toList());
            List<EnquirySubstituteHead> insertHeadList = this.copyHead(needInsertHeadList);
            this.saveBatch(insertHeadList, 2000);
            List insertHeadId = needInsertHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<SaleEnquiryItem> needInsertItemList = saleItemList.stream().filter(item -> insertHeadId.contains(item.getHeadId())).collect(Collectors.toList());
            List<EnquirySubstituteItem> insertItemList = this.copyItem(needInsertItemList);
            this.enquirySubstituteItemService.saveBatch(insertItemList);
        }
    }

    @Override
    public void save(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    @Override
    public void quote(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    private void updateMain(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        String supplierId;
        EnquirySupplierList supplier;
        if (CollectionUtil.isNotEmpty(updateItemList) && "0".equals((supplier = (EnquirySupplierList)((Object)this.enquirySupplierListService.getById((Serializable)((Object)(supplierId = updateItemList.get(0).getSupplierId()))))).getNeedCoordination())) {
            EnquirySubstituteHead head = new EnquirySubstituteHead();
            BeanUtils.copyProperties((Object)((Object)updateHead), (Object)((Object)head));
            boolean b = this.updateById((Object)head);
            Assert.isTrue((boolean)b, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            List<EnquirySubstituteItem> updateList = this.copyItem(updateItemList);
            this.enquirySubstituteItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void updateQuoteEntTime(String purchaseHeadId, Date quoteEndTime, List<String> idList) {
        List<EnquirySubstituteHead> headList = ((EnquirySubstituteHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            headList.forEach(head -> {
                head.setQuoteEndTime(quoteEndTime);
                if (EnquiryStatusEnum.NO_QUOTE.getValue().equals(head.getEnquiryStatus())) {
                    head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
                }
            });
            List itemList = this.enquirySubstituteItemService.listByIds(idList);
            for (EnquirySubstituteItem item : itemList) {
                item.setQuoteEndTime(quoteEndTime);
                if (!EnquiryStatusEnum.NO_QUOTE.getValue().equals(item.getItemStatus())) continue;
                item.setItemStatus(EnquiryStatusEnum.QUOTING.getValue());
            }
            this.enquirySubstituteItemService.updateBatchById(itemList);
        }
    }

    @Override
    public void openBid(String purchaseHeadId, List<String> idList) {
        List<EnquirySubstituteHead> headList = ((EnquirySubstituteHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            Map<String, List<EnquirySubstituteHead>> accountHeadMap = headList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            List itemList = this.enquirySubstituteItemService.listByIds(idList);
            Map<String, List<EnquirySubstituteItem>> accountItemMap = itemList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            accountItemMap.forEach((key, value) -> {
                List accountHeadList = (List)accountHeadMap.get(key);
                List quotingList = value.stream().filter(item -> EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                String enquiryStatus = value.size() == quotingList.size() ? EnquiryStatusEnum.NO_QUOTE.getValue() : EnquiryStatusEnum.BARGAIN.getValue();
                accountHeadList.forEach(head -> head.setEnquiryStatus(enquiryStatus));
            });
            headList.forEach(head -> {
                String key = head.getElsAccount();
                head.setEnquiryStatus(((EnquirySubstituteHead)((Object)((Object)((List)accountHeadMap.get(key)).get(0)))).getEnquiryStatus());
            });
            this.updateBatchById(headList);
            itemList.forEach(item -> {
                String itemStatus = EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus()) ? EnquiryStatusEnum.NO_QUOTE.getValue() : item.getItemStatus();
                item.setItemStatus(itemStatus);
            });
            this.enquirySubstituteItemService.updateBatchById(itemList);
        }
    }

    @Override
    public void reQuote(List<SaleEnquiryItem> reQuoteList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(reQuoteList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<SaleEnquiryItem> pricedList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(pricedList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            if (EnquiryStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus())) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.PRICED.getValue()));
            }
        }
    }

    @Override
    public void cancel(String purchaseHeadId) {
        List<EnquirySubstituteHead> headList = ((EnquirySubstituteHeadMapper)this.baseMapper).selectByMainId(purchaseHeadId);
        if (CollectionUtil.isNotEmpty(headList)) {
            headList.forEach(head -> head.setEnquiryStatus(EnquiryStatusEnum.CANCEL.getValue()));
            this.updateBatchById(headList);
            List headIdList = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.enquirySubstituteItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEnquiryItem::getHeadId, headIdList)).set(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        }
    }

    @Override
    public void regret(PurchaseEnquiryHead head, List<SaleEnquiryItem> regretList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(regretList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            List elsAccountList = updateList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getElsAccount, elsAccountList)).eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)head.getEnquiryStatus()));
        }
    }

    private List<EnquirySubstituteItem> getUpdateItemList(List<SaleEnquiryItem> itemList) {
        List<EnquirySubstituteItem> substituteItemList = new ArrayList<EnquirySubstituteItem>();
        List supplierIds = itemList.stream().map(SaleEnquiryItem::getSupplierId).collect(Collectors.toList());
        List supplierIdList = this.enquirySupplierListService.listByIds(supplierIds).stream().filter(supplier -> "0".equals(supplier.getNeedCoordination())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierIdList)) {
            List<SaleEnquiryItem> updateItemList = itemList.stream().filter(item -> supplierIdList.contains(item.getSupplierId())).collect(Collectors.toList());
            substituteItemList = this.copyItem(updateItemList);
        }
        return substituteItemList;
    }
}

