/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingNotice;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingNoticeService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingProjectHead"})
@Api(tags={"\u62db\u6807\u9879\u76ee\u5934"})
public class PurchaseBiddingProjectHeadController
extends BaseController<PurchaseBiddingProjectHead, PurchaseBiddingProjectHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBiddingProjectHeadController.class);
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseBiddingNoticeService purchaseBiddingNoticeService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SearSourMaterValidService validService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryPageList(PurchaseBiddingProjectHead purchaseBiddingProjectHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingProjectHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:list"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryTabsCount(PurchaseBiddingProjectHead purchaseBiddingProjectHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)purchaseBiddingProjectHead.getId())) {
            ids = purchaseBiddingProjectHead.getId().replace(" ", "").split(",");
            purchaseBiddingProjectHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select(new String[]{"project_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"project_status");
        List list = ((PurchaseBiddingProjectHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingProjectHead::getProjectStatus, PurchaseBiddingProjectHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "project_status", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:add"})
    @SrmValidated
    public Result<?> add(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.saveMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        return Result.ok((Object)((Object)purchaseBiddingProjectHead));
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:edit"})
    public Result<?> edit(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.updateMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingProjectHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBiddingProjectHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(id);
        return Result.ok((Object)((Object)purchaseBiddingProjectHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:publish"})
    @SrmValidated
    public Result<?> publish(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        this.purchaseBiddingProjectHeadService.publishBiddingProject(purchaseBiddingProjectHeadPage.getId());
        return Result.ok((Object)3);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingHeadByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingHeadListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingHeadList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingItemByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingItemListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a")
    @GetMapping(value={"/queryPurchaseBiddingNoticeByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingNoticeListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingNoticeList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6")
    @GetMapping(value={"/queryPurchaseBiddingSpecialistByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> queryPurchaseBiddingSpecialistListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingSpecialistList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546")
    @GetMapping(value={"/querybiddingSupplierByMainId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:queryById"})
    public Result<?> querybiddingSupplierListByMainId(@RequestParam(name="id") String id) {
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        return Result.ok((Object)biddingSupplierList);
    }

    @ApiOperation(value="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236", notes="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236")
    @PostMapping(value={"/copyData"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:copyData"})
    public Result<?> copyData(@RequestBody PurchaseBiddingProjectHead purchaseBiddingProjectHead) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(purchaseBiddingProjectHead.getId());
        this.purchaseBiddingProjectHeadService.copyData(purchaseBiddingProjectHeadVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u9879\u76ee\u7ba1\u7406", value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305", notes="\u9700\u6c42\u6c60\u8f6c\u62db\u6807\u591a\u5305")
    @PostMapping(value={"/requestToBiddingProject"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:requestToBiddingProject"})
    public Result<?> requestToBidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String flag;
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        boolean allowMultipleSources = false;
        if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
            allowMultipleSources = true;
        }
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseBiddingProjectHead head = new PurchaseBiddingProjectHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        head.setProjectStatus("0");
        ArrayList<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List collect1 = requestItemList.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        List purchaseRequestItems = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, collect1)).list();
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("2", ((PurchaseRequestItem)((Object)purchaseRequestItems.get(0))).getPurchaseOrg(), purchaseRequestItems);
        for (PurchaseRequestItem requestItem : purchaseRequestItems) {
            if (!allowMultipleSources && !arrayList.contains(requestItem.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseBiddingItem item2 = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item2));
            item2.setId(null);
            item2.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item2.setSourceNumber(requestItem.getRequestNumber());
            item2.setSourceItemNumber(requestItem.getItemNumber());
            item2.setSourceItemId(requestItem.getId());
            item2.setPriceUnit(requestItem.getUnitPrice());
            item2.setPurchaseUnit(requestItem.getPurchaseUnit());
            item2.setRequireQuantity(requestItem.getQuantity());
            item2.setRequireDate(requestItem.getApplyDate());
            item2.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            item2.setItemStatus(BiddingItemStatusEnum.NEW.getValue());
            itemList.add(item2);
        }
        head.setDocumentId(requestItemList.get(0).getDocumentId());
        if (StringUtils.isNotBlank((CharSequence)requestItemList.get(0).getDocumentId())) {
            head.setDocumentParentId(requestItemList.get(0).getHeadId());
        }
        head.setCompany(requestItemList.get(0).getCompany());
        head.setPurchaseGroup(requestItemList.get(0).getPurchaseGroup());
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setProjectNumber(this.invokeBaseRpcService.getNextCode("srmBiddingProjectNumber", (Object)head));
        this.purchaseBiddingProjectHeadService.saveMain(head, new ArrayList<PurchaseBiddingHead>(), itemList, new ArrayList<PurchaseBiddingNotice>(), new ArrayList<PurchaseBiddingSpecialist>(), new ArrayList<BiddingSupplier>());
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_sYBLRWYBtyLWWWWWWW_48162811", (String)"\u8f6c\u62db\u6807\uff08\u591a\u5305\uff09\u6210\u529f,\u62db\u6807\u9879\u76ee\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getProjectNumber()}));
    }

    private PurchaseBiddingProjectHeadVO queryDataById(String id) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = new PurchaseBiddingProjectHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHead), (Object)((Object)purchaseBiddingProjectHeadVO));
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingHeadList(purchaseBiddingHeadList);
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingNoticeList(purchaseBiddingNoticeList);
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setBiddingSupplierList(biddingSupplierList);
        return purchaseBiddingProjectHeadVO;
    }
}

