/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.ebidding.utils.CompareIPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingItemServiceImpl
extends ServiceImpl<PurchaseBiddingItemMapper, PurchaseBiddingItem>
implements PurchaseBiddingItemService {
    @Autowired
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;

    @Override
    public List<PurchaseBiddingItem> selectByMainId(String mainId) {
        return this.purchaseBiddingItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchaseBiddingItem> queryBiddingByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.inSql(PurchaseBiddingItem::getBiddingNumber, "select bidding_number from purchase_bidding_head where bidding_status=5 ");
        lambdaQueryWrapper.eq(PurchaseBiddingItem::getItemStatus, (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        lambdaQueryWrapper.in(PurchaseBiddingItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseBiddingItem::getMaterialNumber)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseBiddingItem::getMaterialNumber, (Object)"");
            });
        });
        List purchaseBiddingItems = this.purchaseBiddingItemMapper.selectList((Wrapper)lambdaQueryWrapper);
        return purchaseBiddingItems;
    }

    @Override
    public void delete(Wrapper<PurchaseBiddingItem> queryWrapper) {
        this.purchaseBiddingItemMapper.delete(queryWrapper);
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(List<PurchaseBiddingItem> purchaseBiddingItemList) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List accountIpList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        Map<String, PurchaseBiddingItem> supplierMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(PurchaseBiddingItem::getToElsAccount, Function.identity(), (supplier1, supplier2) -> supplier2));
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareBiddingIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    private void compareIp(String sourceAccountIp, String targetAccountIp, Map<String, PurchaseBiddingItem> supplierMap, List<SupplierRelationFindResultVO> result) {
        String sourceAccount = sourceAccountIp.split("_")[0];
        String targetAccount = targetAccountIp.split("_")[0];
        String sourceIp = sourceAccountIp.split("_")[1];
        String targetIp = targetAccountIp.split("_")[1];
        Map<String, List<SupplierRelationFindResultVO>> resultMap = null;
        if (result != null && result.size() > 0) {
            resultMap = result.stream().collect(Collectors.groupingBy(o -> o.getSourceName() + ":" + o.getToName() + ":" + o.getType() + ":" + o.getResult()));
        }
        if (sourceIp.equals(targetIp)) {
            PurchaseBiddingItem sourceSupplier = supplierMap.get(sourceAccount);
            PurchaseBiddingItem targetSupplier = supplierMap.get(targetAccount);
            SupplierRelationFindResultVO vo = new SupplierRelationFindResultVO();
            vo.setSourceName(sourceSupplier.getSupplierName());
            vo.setToName(targetSupplier.getSupplierName());
            vo.setType(RiskTypeEnum.QUOTE_IP.getValue());
            vo.setResult(sourceIp);
            String key = vo.getSourceName() + ":" + vo.getToName() + ":" + vo.getType() + ":" + vo.getResult();
            if (resultMap == null || resultMap != null && resultMap.get(key) == null) {
                result.add(vo);
            }
        }
    }
}

