/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class PurchaseRequestAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseRequestHeadVO headVO = (PurchaseRequestHeadVO)((Object)JSON.parseObject((String)params, PurchaseRequestHeadVO.class));
        headVO.setWorkFlowType(outputParamVO.getBpmnType());
        this.checkParams(headVO);
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    private void checkParams(PurchaseRequestHeadVO requestHead) {
        Assert.notEmpty(requestHead.getPurchaseRequestItemList(), (String)I18nUtil.translate((String)"i18n_alert_empty_addLine", (String)"\u8bf7\u6dfb\u52a0\u884c\u9879\u76ee"));
        requestHead.getPurchaseRequestItemList().forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cTVWRlTfUQ_49d1f2c", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_cXjnRVRxOLVWVKItbWsLDWSNVRGRsLDRHIdjRKVRW_306d9a1f", (String)"\u884c\u4e0a\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u4e2d\u7ef4\u62a4,\u6216\u8005\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u5173\u8054\u7ec4\u7ec7!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getCompany()), (String)I18nUtil.translate((String)"i18n_alert_cXjRCooxOLVWVKVRGRsLDRHIdjXtESVRW_c851671b", (String)"\u884c\u4e0a\u7684\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7!"));
        });
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
            this.purchaseRequestHeadService.toDemandPool(inputParamVO.getBusinessId());
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
        String businessId = inputParamVO.getBusinessId();
        this.budgetManageRpcService.refundOfOccupiedAmount(businessId);
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)businessId)));
        this.purchaseRequestHeadService.updateById((Object)purchaseRequestHead);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseRequestHead head = new PurchaseRequestHead();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseRequestHeadMapper.updateById((Object)head);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(inputParamVO.getBusinessId());
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            purchaseRequestItems.forEach(item -> {
                item.setAuditStatus(outputParamVO.getAuditStatus());
                item.setFlowId(outputParamVO.getProcessRootId());
            });
            this.purchaseRequestItemMapper.updateBatchById(purchaseRequestItems);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

