/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSAgainException;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingScopeEnum;
import com.els.modules.ebidding.enumerate.EbiddingStartWayEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.service.PublicEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import com.els.modules.ebidding.vo.PurchaseAwardOpinionVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingConfirmVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingPrintVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.inquiry.rpc.service.InquiryWorkflowAuditDataRpcService;
import com.els.modules.inquiry.service.PublishToB2BService;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.workflow.dto.A1FlowTaskTrajectoryDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEbiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseEbiddingHeadMapper, PurchaseEbiddingHead>
implements PurchaseEbiddingHeadService,
PurchaseExecuteReviewService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingHeadServiceImpl.class);
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Autowired
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Autowired
    @Lazy
    private PublicEbiddingService publicEbiddingService;
    @Autowired
    private PublishToB2BService publishToB2BService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Autowired
    private RedisUtil redis;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Resource
    private InquiryWorkflowAuditDataRpcService workflowAuditDataService;
    private static final String START_PRICE_FLAG = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        SysUtil.setNullCreate((BaseEntity)head);
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        head.setCurrentRound(head.getCurrentRound() == null ? 1 : head.getCurrentRound());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        if (StringUtils.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.sendLink(head, itemList);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        head.setResultAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setAuditStatus(START_PRICE_FLAG.equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        this.deleteSubTable(head.getId());
        this.insertData(head, itemList, supplierList, attachmentDemandList, confirmList);
        this.sendLink(head, itemList);
    }

    @Override
    @SrmTransaction
    public void copy(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        this.saveMain(head, itemList, supplierList, attachmentDemandList, confirmList);
    }

    private void sendLink(PurchaseEbiddingHead headVO, List<PurchaseEbiddingItem> items) {
        JSONArray objects = new JSONArray();
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"ebidding");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", (Object)headVO.getDocumentParentId());
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(items)) {
            for (PurchaseEbiddingItem item : items) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)item.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"ebidding");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)item.getId());
                objectItem.put("businessParentId", (Object)item.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)head.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("ebiddingHeadId", head.getDocumentId(), head.getDocumentParentId(), head.getId());
        }
        Assert.isTrue((boolean)EbiddingStatusEnum.NEW.getValue().equals(head.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.deleteSubTable(id);
    }

    private void deleteSubTable(String headId) {
        List<PurchaseEbiddingItem> items = this.purchaseEbiddingItemService.selectByMainId(headId);
        if (!CollectionUtils.isEmpty(items)) {
            List stringList = items.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        this.purchaseEbiddingItemService.deleteByMainId(headId);
        this.purchaseEbiddingSupplierService.deleteByMainId(headId);
        this.purchaseEbiddingConfirmService.deleteByMainId(headId);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    private void insertData(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> attachmentDemandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        this.purchaseEbiddingItemService.addBatch(head, itemList);
        this.purchaseEbiddingSupplierService.addBatch(head, supplierList);
        this.purchaseEbiddingConfirmService.addBatch(head, confirmList);
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(attachmentDemandList, head.getId(), "ebidding");
    }

    @Override
    public void goBackDemand(List<PurchaseEbiddingItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List<String> idList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEbiddingItem::getSourceItemId).distinct().collect(Collectors.toList());
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseEbiddingItemService.lambdaQuery().in(PurchaseEbiddingItem::getSourceItemId, idList)).notIn(PurchaseEbiddingItem::getHeadId, headIdList)).list();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEbiddingItem::getSourceItemId, p -> {
                        ArrayList<PurchaseEbiddingItem> enquiryItems = new ArrayList<PurchaseEbiddingItem>();
                        enquiryItems.add((PurchaseEbiddingItem)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    Set<String> strings = collect.keySet();
                    for (String string : strings) {
                        List purchaseEbiddingItems = collect.get(string);
                        if (purchaseEbiddingItems.isEmpty()) continue;
                        List collect2 = purchaseEbiddingItems.stream().map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
                        List purchaseEbiddingHeads = this.listByIds(collect2);
                        List collect3 = purchaseEbiddingHeads.stream().filter(item -> EbiddingStatusEnum.BID_SUCCESS.equals(item.getEbiddingStatus())).collect(Collectors.toList());
                        if (collect3.isEmpty()) {
                            ListDauctionsBuilt.add(string);
                            continue;
                        }
                        ListCompletionOfTheAuction.add(string);
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    this.purchaseRequestItemService.updateStatusById(idList, status);
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    private void checkAndSetParam(PurchaseEbiddingHeadVO headVO) {
        List purchaseEbiddingConfirmList;
        List startPriceList;
        Date beginTime = headVO.getBeginTime();
        Assert.notNull((Object)beginTime, (String)I18nUtil.translate((String)"i18n_alert_OuvKKIxOLVW_50f9240f", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)beginTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKIlTfUAPKIW_22eb88a", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01"));
        BigDecimal keepMinute = headVO.getKeepMinute();
        Assert.notNull((Object)headVO.getChangeRange(), (String)I18nUtil.translate((String)"i18n_alert_umDiBzxOLV_2cd60c7", (String)"\u4ef7\u683c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getRangeUnit(), (String)I18nUtil.translate((String)"i18n_alert_BztLxOLV_3b65a2e9", (String)"\u5e45\u5ea6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.notNull((Object)keepMinute, (String)I18nUtil.translate((String)"i18n_alert_uTKIWzsWKIxOLVW_78c93f21", (String)"\u6301\u7eed\u65f6\u95f4\uff08\u5206\u949f\uff09\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (START_PRICE_FLAG.equals(headVO.getPurchaseAutoQuote()) && !EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getSetStartPrice()), (String)I18nUtil.translate((String)"i18n_alert_JOsuWlTGRAAu_6bbab75f", (String)"\u81ea\u52a8\u62a5\u4ef7\uff0c\u5fc5\u987b\u8bbe\u7f6e\u8d77\u62cd\u4ef7"));
        }
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getKeepMinute()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)headVO.getBeforeEndMinute())) {
            Integer keepMinute1 = Double.valueOf(String.valueOf(headVO.getKeepMinute())).intValue();
            Assert.isTrue((headVO.getBeforeEndMinute() <= keepMinute1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__yWPORzslTXUuTKI_8cb9e8b0", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6301\u7eed\u65f6\u95f4"));
        }
        Integer participateQuantity = headVO.getParticipateQuantity();
        Assert.notNull((Object)participateQuantity, (String)I18nUtil.translate((String)"i18n_alert_sUWRxOLV_988f07b", (String)"\u53c2\u4e0e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        headVO.setInviteQuantity(supplierList.size());
        String ebiddingScope = StrUtil.isNotBlank((CharSequence)headVO.getEbiddingScope()) ? headVO.getEbiddingScope() : EbiddingScopeEnum.INVITE.getValue();
        headVO.setEbiddingScope(ebiddingScope);
        if (EbiddingScopeEnum.INVITE.getValue().equals(ebiddingScope)) {
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXABxOLV_453a9d0e", (String)"\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((participateQuantity.compareTo(headVO.getInviteQuantity()) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RdXjWRlTfUsUWR_3340063e", (String)"\u4f9b\u5e94\u5546\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u53c2\u4e0e\u6570\u91cf"));
        }
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (START_PRICE_FLAG.equals(headVO.getSetStartPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getStartTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHAAuxOLV_8dad61ef", (String)"\u5934\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((headVO.getStartTotalAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice()) && checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.notNull((Object)headVO.getTargetTotalAmount(), (String)I18nUtil.translate((String)"i18n_alert_eVHIBuxOLV_6094452c", (String)"\u5934\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_RdXfIWTPdBlTLK_542b7b05", (String)"\u4f9b\u5e94\u5546\u7a0e\u7387\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f"));
        } else if (checkWayList.contains(headVO.getEbiddingWay())) {
            Assert.hasText((String)headVO.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_eVHfoxOLV_ffe669a5", (String)"\u5934\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.hasText((String)headVO.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_eVHfIxOLV_c0d1322b", (String)"\u5934\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (START_PRICE_FLAG.equals(headVO.getNeedEcho())) {
            Assert.notNull((Object)headVO.getEchoEndTime(), (String)I18nUtil.translate((String)"i18n_alert_dByRKIxOLV_29c03139", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTfUAPKI_bc6345de", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((boolean)headVO.getEchoEndTime().before(beginTime), (String)I18nUtil.translate((String)"i18n_alert_dByRKIlTXUOuvKKI_e41cb500", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4"));
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Assert.notNull((Object)headVO.getIntervalMinute(), (String)I18nUtil.translate((String)"i18n_alert_ImKIxOLV_f1534aee", (String)"\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((headVO.getIntervalMinute().compareTo(BigDecimal.ONE) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ImKIlTfUEUW_39975591", (String)"\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1"));
            }
            String delayRule = headVO.getDelayRule();
            if (EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                Assert.notNull((Object)headVO.getBeforeEndMinute(), (String)I18nUtil.translate((String)"i18n_alert_yWPORzsxOLV_61d00fc1", (String)"\u7ed3\u675f\u524d\u591a\u5c11\u5206\u949f\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayMinute(), (String)I18nUtil.translate((String)"i18n_alert_OAzsWxOLV_1b9f0ebe", (String)"\u5ef6\u671f\u5206\u949f\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notNull((Object)headVO.getDelayCount(), (String)I18nUtil.translate((String)"i18n_alert_qOAmWxOLV_b027dc17", (String)"\u53ef\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (EbiddingScopeEnum.PUBLIC.getValue().equals(ebiddingScope)) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_RvOuWsRyRKIxOLV_e89e5a4d", (String)"\u516c\u5f00\u7ade\u4ef7\uff0c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Date time = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? headVO.getEchoEndTime() : headVO.getBeginTime();
                String message = START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUdByRKI_3a02a1dc", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5e94\u6807\u622a\u6b62\u65f6\u95f4") : I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUOuvKKI_1d1b5655", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4");
                Assert.isTrue((boolean)time.after(headVO.getApplyEndTime()), (String)message);
            }
        } else if (headVO.getPurchaseAutoQuote().equals(START_PRICE_FLAG) && (CollectionUtils.isEmpty(startPriceList = headVO.getPurchaseEbiddingItemList().stream().filter(e -> e.getStartPrice().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())) || headVO.getPurchaseEbiddingItemList().size() != startPriceList.size())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
        }
        List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_cVHxOLV_c6f5290a", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseEbiddingItem item : itemList) {
            PurchaseEbiddingHeadServiceImpl.headToItem(headVO, item);
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                if (START_PRICE_FLAG.equals(headVO.getSendTargetPrice())) {
                    Assert.notNull((Object)item.getTargetPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHIBuxOLV_c33b9114", (String)"\u884c\u4fe1\u606f\u76ee\u6807\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (START_PRICE_FLAG.equals(headVO.getSetStartPrice())) {
                    Assert.notNull((Object)item.getStartPrice(), (String)I18nUtil.translate((String)"i18n_alert_cVHAAuxOLV_f054add7", (String)"\u884c\u4fe1\u606f\u8d77\u62cd\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.isTrue((item.getStartPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__AAtudrfUW_6a4d7760", (String)"\u8d77\u62cd\u5355\u4ef7\u5e94\u8be5\u5927\u4e8e0"));
                }
                if (!START_PRICE_FLAG.equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
            if (START_PRICE_FLAG.equals(headVO.getMustMaterialNumber())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_cVHSLAoxOLV_f66aee85", (String)"\u884c\u4fe1\u606f\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (item.getDeliveryDate() != null) continue;
            item.setDeliveryDate(item.getRequireDate());
            Assert.notNull((Object)item.getDeliveryDate(), (String)I18nUtil.translate((String)"i18n_alert_JSBAxOLV_b871c9ad", (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List needEchoList = headVO.getPurchaseAttachmentDemandList().stream().filter(demand -> START_PRICE_FLAG.equals(demand.getRequired())).filter(demand -> StageTypeEnum.RESPONSE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needEchoList)) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWBIlVWTPdBlTLK_1eae1d00", (String)"[${0}]\u9644\u4ef6\u5fc5\u4f20\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        if (CollectionUtil.isNotEmpty(purchaseEbiddingConfirmList = headVO.getPurchaseEbiddingConfirmList().stream().filter(confirm -> START_PRICE_FLAG.equals(confirm.getMust())).collect(Collectors.toList()))) {
            Assert.isTrue((boolean)START_PRICE_FLAG.equals(headVO.getNeedEcho()), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWjRLdlSWTPdBlTLK_74e3d92d", (String)"[${0}]\u6709\u786e\u8ba4\u9879\u5fc5\u586b\uff0c\u9700\u8981\u5e94\u6807\u5fc5\u987b\u4e3a\u662f", (String[])new String[]{StageTypeEnum.RESPONSE.getDesc()}));
        }
        headVO.setEbiddingStatus(START_PRICE_FLAG.equals(headVO.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        DateTime endTime = DateUtil.offsetSecond((Date)beginTime, (int)SysUtil.minuteToSecond((BigDecimal)keepMinute, (int)1));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            headVO.setEndTime((Date)endTime);
        }
        headVO.setStartTime(beginTime);
        headVO.setCurrentRound(headVO.getCurrentRound() == null ? 1 : headVO.getCurrentRound());
        LoginUser user = SysUtil.getLoginUser();
        headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
        headVO.setPublishTime(new Date());
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && !EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
            headVO.setIntervalMinute(BigDecimal.ZERO);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(headVO.getDelayRule())) {
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if (EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod()) && EbiddingDelayRuleEnum.UNLIMITED_DELAY_COUNT.getValue().equals(headVO.getDelayRule())) {
            headVO.setDelayCount(0);
        }
        if (!EbiddingMethodEnum.BRITISH.getValue().equals(headVO.getEbiddingMethod())) {
            headVO.setKeepMinute(BigDecimal.ZERO);
            headVO.setIntervalMinute(BigDecimal.ZERO);
            headVO.setDelayRule("");
            headVO.setBeforeEndMinute(0);
            headVO.setDelayMinute(0);
            headVO.setDelayCount(0);
        }
        if ("0".equals(headVO.getNeedEcho())) {
            headVO.setEchoEndTime(null);
        }
        if (EbiddingScopeEnum.INVITE.getValue().equals(headVO.getEbiddingScope())) {
            headVO.setApplyEndTime(null);
        }
    }

    private static void headToItem(PurchaseEbiddingHead head, PurchaseEbiddingItem item) {
        List<String> checkWayList = Arrays.asList(EbiddingWayEnum.PACKAGE.getValue(), EbiddingWayEnum.BATCH.getValue());
        if (checkWayList.contains(head.getEbiddingWay())) {
            item.setTaxRate(StrUtil.isBlank((CharSequence)head.getTaxRate()) ? item.getTaxRate() : head.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)head.getTaxCode()) ? item.getTaxCode() : head.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)head.getCurrency()) ? item.getCurrency() : head.getCurrency());
        } else {
            item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
            item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
            item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
        }
        item.setEffectiveDate(item.getEffectiveDate() == null ? head.getEffectiveDate() : item.getEffectiveDate());
        item.setExpiryDate(item.getExpiryDate() == null ? head.getExpiryDate() : item.getExpiryDate());
    }

    private boolean publishAudit(PurchaseEbiddingHeadVO headVO) {
        if (START_PRICE_FLAG.equals(headVO.getPublishAudit()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(headVO.getAuditStatus())) {
            List<PurchaseEbiddingItem> itemList = headVO.getPurchaseEbiddingItemList();
            List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
            List<PurchaseAttachmentDemandDTO> demandList = headVO.getPurchaseAttachmentDemandList();
            List<PurchaseEbiddingConfirmVO> confirmList = headVO.getPurchaseEbiddingConfirmList();
            if (StrUtil.isBlank((CharSequence)headVO.getId())) {
                this.saveMain(headVO, itemList, supplierList, demandList, confirmList);
            } else {
                this.updateMain(headVO, itemList, supplierList, demandList, confirmList);
            }
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(headVO.getId());
            dto.setBusinessType("publishEbidding");
            dto.setAuditSubject("\u7ade\u4ef7\u53d1\u5e03\u524d\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + headVO.getEbiddingNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
            return true;
        }
        return false;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEbiddingHeadVO headVO) {
        this.checkAndSetParam(headVO);
        if (this.publishAudit(headVO)) {
            return;
        }
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            ((PurchaseEbiddingHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            int count = ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)head);
            this.updatePurchaseEbiddingHead(head);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            this.deleteSubTable(head.getId());
        }
        if (EbiddingStartWayEnum.AUTO.getValue().equals(head.getStartWay())) {
            EbiddingJobUtil.createStartJob(head, head.getBeginTime());
        }
        this.insertInitTable(head.getId(), headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingConfirmList());
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        this.handleEnquirySupplierList(head, supplierList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEbidding(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            this.insertData(head, headVO.getPurchaseEbiddingItemList(), supplierList, headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        if (EbiddingScopeEnum.PUBLIC.getValue().equals(headVO.getEbiddingScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                this.publicEbiddingService.publishNotice(head);
                if (publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                    this.publishToB2BService.publishToB2B(head, headVO.getPurchaseEbiddingItemList());
                }
            }
        }
    }

    private void handleEnquirySupplierList(PurchaseEbiddingHead head, List<PurchaseEbiddingSupplier> supplierList) {
        if (CollectionUtils.isEmpty(supplierList)) {
            return;
        }
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataDTOS = this.inquiryInvokeSupplierRpcService.selectSupplerList(head.getElsAccount(), toElsAccountList);
        supplierList.forEach(e -> supplierMasterDataDTOS.forEach(a -> {
            if (e.getToElsAccount().equals(a.getToElsAccount())) {
                e.setNeedCoordination(a.getNeedCoordination());
            }
        }));
    }

    private void updatePurchaseEbiddingHead(PurchaseEbiddingHead head) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)head.getId());
        updateWrapper.set(PurchaseEbiddingHead::getIntervalMinute, (Object)head.getIntervalMinute());
        updateWrapper.set(PurchaseEbiddingHead::getBeforeEndMinute, (Object)head.getBeforeEndMinute());
        updateWrapper.set(PurchaseEbiddingHead::getDelayCount, (Object)head.getDelayCount());
        updateWrapper.set(PurchaseEbiddingHead::getDelayMinute, (Object)head.getDelayMinute());
        updateWrapper.set(PurchaseEbiddingHead::getKeepMinute, (Object)head.getKeepMinute());
        updateWrapper.set(PurchaseEbiddingHead::getDelayRule, (Object)head.getDelayRule());
        updateWrapper.set(PurchaseEbiddingHead::getEchoEndTime, (Object)head.getEchoEndTime());
        updateWrapper.set(PurchaseEbiddingHead::getApplyEndTime, (Object)head.getApplyEndTime());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, String> idMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(idMap)) {
            idMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", value);
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    private void insertInitTable(String headId, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingConfirmVO> confirmList) {
        JSONObject itemObject = new JSONObject();
        itemObject.put("relationId", (Object)headId);
        itemObject.put("businessType", (Object)"item");
        itemObject.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(itemObject.toJSONString());
        JSONObject confirmObject = new JSONObject();
        confirmObject.put("relationId", (Object)headId);
        confirmObject.put("businessType", (Object)"confirm");
        confirmObject.put("businessInfoJson", (Object)JSON.toJSONString(confirmList));
        InitTableMqUtil.sendInitMsg(confirmObject.toJSONString());
    }

    private AttachmentSendDTO publishEbidding(PurchaseEbiddingHead head, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList, List<PurchaseAttachmentDemandDTO> demandList, List<PurchaseEbiddingConfirmVO> confirmList) {
        List<String> toElsAccountList = supplierList.stream().map(PurchaseEbiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEbiddingItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        this.purchaseEbiddingSupplierService.publish(head, supplierList);
        List<PurchaseEbiddingItem> insertItemList = this.purchaseEbiddingItemService.publish(head, itemList, supplierList, relationMap);
        List<PurchaseEbiddingConfirm> insertConfirmList = this.purchaseEbiddingConfirmService.publish(head, confirmList, supplierList);
        Map<String, String> idMap = this.saleEbiddingHeadService.publish(head, insertItemList, supplierList, insertConfirmList);
        AttachmentSendDTO sendDTO = this.sendAttachment(head, idMap, demandList);
        super.sendMsg(head.getElsAccount(), toElsAccountList, (Object)head, this.getReceiveParamMap(idMap), "ebidding", "publish");
        return sendDTO;
    }

    private AttachmentSendDTO sendAttachment(PurchaseEbiddingHead purchaseHead, Map<String, String> idMap, List<PurchaseAttachmentDemandDTO> demandList) {
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(purchaseHead.getId());
        sendVO.setElsAccount(purchaseHead.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        for (String elsAccount : idMap.keySet()) {
            toSend.put(idMap.get(elsAccount), elsAccount);
        }
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, purchaseHead.getId(), "ebidding", idMap);
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingSupplier> webSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.purchaseEbiddingSupplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<PurchaseEbiddingSupplier> supplierList = webSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List itemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        this.publishEbidding(dbHead, itemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (PurchaseEbiddingSupplier supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startBidding(String id) {
        List<PurchaseEbiddingItem> quoteList;
        List<String> itemIdList;
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(dbItemList);
                quoteList = dbItemList;
            } else {
                String itemNumber = StrUtil.isNotBlank((CharSequence)dbHead.getCurrentItemNumber()) ? dbHead.getCurrentItemNumber() : START_PRICE_FLAG;
                List<PurchaseEbiddingItem> updateList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                dbHead.setCurrentItemNumber(itemNumber);
                dbHead.setCurrentMaterialDesc(((PurchaseEbiddingItem)((Object)updateList.get(0))).getMaterialDesc());
                dbHead.setCurrentDelayCount(0);
                updateList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                itemIdList = updateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.purchaseEbiddingItemService.updateBatchById(updateList);
                quoteList = updateList;
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
            itemIdList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            quoteList = dbItemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItem>(Comparator.comparing(PurchaseEbiddingItem::getToElsAccount))), ArrayList::new));
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.startEbidding(dbHead, itemIdList);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            EbiddingJobUtil.createEndJob(dbHead, dbHead.getEndTime());
        } else if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            this.autoQuotePrice(dbHead, quoteList);
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
        List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        log.info("PurchaseEbiddingHeadServiceImpl \u5f00\u542f\u7ade\u4ef7\u5904\u7406\u903b\u8f91\u7ed3\u675f\uff0c\u5373\u5c06\u53d1\u9001\u6d88\u606f\u901a\u77e5\u4f9b\u5e94\u5546");
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            SaleEbiddingHead sale = saleHeadList.stream().filter(saleHead -> saleHead.getElsAccount().equals(supplier.getToElsAccount())).findFirst().orElse(new SaleEbiddingHead());
            supplier.setKeyWord(sale.getPurchaseName());
            log.info("PurchaseEbiddingHeadServiceImpl \u7ade\u4ef7\u5f00\u542f\u53d1\u9001\u6d88\u606f\u7ed9:{}", (Object)supplier.getToElsAccount());
            super.sendMsg(dbHead.getElsAccount(), supplier.getToElsAccount(), (Object)supplier, receiveParamMap, "ebidding", "start");
        }
        log.info("PurchaseEbiddingHeadServiceImpl \u5f00\u542f\u7ade\u4ef7\u5904\u7406\u903b\u8f91\u7ed3\u675f\uff0c\u5df2\u7ecf\u53d1\u9001\u6d88\u606f\u901a\u77e5\u4f9b\u5e94\u5546");
    }

    private Map<String, JSONObject> getReceiveParamMap(String headId) {
        List<SaleEbiddingHead> dbSaleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        for (SaleEbiddingHead saleHead : dbSaleHeadList) {
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleHead.getId());
            urlParam.put("templateNumber", (Object)saleHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleHead.getTemplateVersion());
            urlParam.put("templateAccount", (Object)saleHead.getTemplateAccount());
            urlParam.put("busAccount", (Object)saleHead.getBusAccount());
            receiveParamMap.put(saleHead.getElsAccount(), urlParam);
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void endBidding(String id, List<String> itemNumberList) {
        ArrayList<String> itemIdList = new ArrayList<String>();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING_END.getValue());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations())) {
                List<PurchaseEbiddingItem> currentItemList = dbItemList.stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
                currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                itemIdList.addAll(idList);
                this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                List biddingEndList = dbItemList.stream().filter(item -> EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                dbHead.setEbiddingStatus(dbItemList.size() == biddingEndList.size() ? EbiddingStatusEnum.BIDDING_END.getValue() : EbiddingStatusEnum.BIDDING.getValue());
            } else {
                String currentItemNumber = dbHead.getCurrentItemNumber();
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                PurchaseEbiddingItem nextItem = this.purchaseEbiddingItemService.selectOneByMainIdAndItemNumber(id, nextItemNumber);
                if (nextItem != null) {
                    dbHead.setCurrentItemNumber(nextItemNumber);
                    dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                    dbHead.setCurrentDelayCount(0);
                    if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
                        dbHead.setBeginTime((Date)DateUtil.offsetSecond((Date)dbHead.getEndTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                        dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                        EbiddingJobUtil.createStartJob(dbHead, dbHead.getBeginTime());
                    } else {
                        dbHead.setEbiddingStatus(EbiddingStatusEnum.BIDDING.getValue());
                        List<PurchaseEbiddingItem> nextItemList = dbItemList.stream().filter(item -> nextItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                        nextItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.updateBatchById(nextItemList);
                        SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
                        saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItem::getRelationId, (Collection)nextItemList.stream().map(BaseEntity::getId).collect(Collectors.toList()))).set(SaleEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BIDDING.getValue()));
                        this.autoQuotePrice(dbHead, nextItemList);
                    }
                } else {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setBeginTime(dbHead.getBeginTime());
                    dbHead.setEndTime(dbHead.getEndTime());
                    dbHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                }
                List<PurchaseEbiddingItem> currentItemList = dbItemList.stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(currentItemList)) {
                    currentItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
                    this.purchaseEbiddingItemService.updateBatchById(currentItemList);
                    List idList = currentItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    itemIdList.addAll(idList);
                }
            }
        } else {
            String currentMaterialDesc = EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay()) ? EbiddingWayEnum.PACKAGE.getDesc() : EbiddingWayEnum.BATCH.getDesc();
            dbHead.setCurrentMaterialDesc(currentMaterialDesc);
            dbItemList.forEach(item -> item.setItemStatus(EbiddingItemStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            List idList = dbItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            itemIdList.addAll(idList);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEbiddingHeadService.endEbidding(dbHead, itemIdList);
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void autoQuotePrice(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> quoteList) {
        if (START_PRICE_FLAG.equals(dbHead.getPurchaseAutoQuote())) {
            List<SaleEbiddingHead> saleList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId());
            List biddingList = saleList.stream().filter(sale -> EbiddingStatusEnum.BIDDING.getValue().equals(sale.getEbiddingStatus())).map(BaseEntity::getElsAccount).collect(Collectors.toList());
            log.info("autoQuotePrice->quoteList:{}", (Object)JSONObject.toJSONString(quoteList));
            for (PurchaseEbiddingItem dbItem : quoteList) {
                BigDecimal quotePrice;
                if (!biddingList.contains(dbItem.getToElsAccount())) continue;
                PurchaseEbiddingItem quoteItem = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
                this.purchaseEbiddingItemHisService.queryAddQuoteSite(dbHead, quoteItem);
                log.info("autoQuotePrice->quoteItem:{}", (Object)JSONObject.toJSONString((Object)((Object)quoteItem)));
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
                } else {
                    BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
                }
                if (quotePrice == null || quotePrice.compareTo(BigDecimal.ZERO) == 0) continue;
                this.quote(dbHead, dbItem, quoteItem);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualStartBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.after(dbHead.getBeginTime()), (String)I18nUtil.translate((String)"i18n_alert_OuvKKILuWPxOvAOuW_ecf2e58b", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u542f\u7ade\u4ef7\uff01"));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjoOunodBntFqvA_7f51a7cc", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u548c\u5f85\u5e94\u6807\u7684\u5355\u636e\u53ef\u5f00\u542f"));
        PurchaseEbiddingHead update = new PurchaseEbiddingHead();
        update.setId(headVO.getId());
        update.setStartTime(currentTime);
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            DateTime endTime = DateUtil.offsetSecond((Date)currentTime, (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1));
            update.setEndTime((Date)endTime);
        }
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)update);
        this.startBidding(headVO.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void manualEndBid(PurchaseEbiddingHeadVO headVO) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Date currentTime = new Date();
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_ROyWOusntFW_48f68479", (String)"\u53ea\u80fd\u7ed3\u675f\u7ade\u4ef7\u4e2d\u7684\u5355\u636e\uff01"));
        if (EbiddingMethodEnum.BRITISH.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)currentTime.after(dbHead.getEndTime()), (String)I18nUtil.translate((String)"i18n_alert_OuyWKILuWxOyWOuW_5c8cb549", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u7ed3\u675f\u7ade\u4ef7\uff01"));
        }
        ArrayList<String> itemNumberList = new ArrayList<String>();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod()) && START_PRICE_FLAG.equals(dbHead.getRespectiveQuotations()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            Assert.notEmpty(headVO.getPurchaseEbiddingItemList(), (String)I18nUtil.translate((String)"i18n_alert_ViFTPyWOujSL_a62fc5f7", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u675f\u7ade\u4ef7\u7684\u7269\u6599"));
            headVO.getPurchaseEbiddingItemList().forEach(item -> itemNumberList.add(item.getItemNumber()));
        }
        this.endBidding(dbHead.getId(), itemNumberList);
    }

    private Map<String, BigDecimal> getStartPriceMap(PurchaseEbiddingHeadVO headVO, List<PurchaseEbiddingItem> dbItemList) {
        HashMap<String, BigDecimal> startPriceMap = new HashMap<String, BigDecimal>(16);
        String startPriceFlag = headVO.getStartPriceFlag();
        if (START_PRICE_FLAG.equals(startPriceFlag)) {
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                Map<String, List<PurchaseEbiddingItem>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
                for (String itemNumber : itemMap.keySet()) {
                    List itemList = itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                    if (itemList.isEmpty()) continue;
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxPrice = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                        startPriceMap.put(itemNumber, maxPrice);
                        continue;
                    }
                    BigDecimal minPrice = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getPrice)).map(PurchaseEbiddingItem::getPrice).orElse(null);
                    startPriceMap.put(itemNumber, minPrice);
                }
            } else {
                List itemList = dbItemList.stream().filter(item -> item.getTaxAmount() != null && item.getTaxAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
                if (!itemList.isEmpty()) {
                    if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(headVO.getEbiddingType())) {
                        BigDecimal maxTotalAmount = itemList.stream().max(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), maxTotalAmount);
                    } else {
                        BigDecimal minTotalAmount = itemList.stream().min(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount)).map(PurchaseEbiddingItem::getTotalAmount).orElse(null);
                        startPriceMap.put(headVO.getId(), minTotalAmount);
                    }
                }
            }
        }
        return startPriceMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createNewRound(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING_END.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_OuyWjtFnqcIVVm_91ffe3ea", (String)"\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u624d\u53ef\u521b\u5efa\u65b0\u8f6e\u6b21"));
        String startPriceFlag = headVO.getStartPriceFlag();
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId, "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        Map<String, BigDecimal> startPriceMap = this.getStartPriceMap(headVO, dbItemList);
        for (PurchaseEbiddingItem item : initItemList) {
            if (!START_PRICE_FLAG.equals(startPriceFlag)) continue;
            if (EbiddingWayEnum.SINGLE.getValue().equals(headVO.getEbiddingWay())) {
                item.setStartPrice(startPriceMap.get(item.getItemNumber()));
                continue;
            }
            headVO.setStartTotalAmount(startPriceMap.get(headId));
            break;
        }
        headVO.setPurchaseEbiddingItemList(initItemList);
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        headVO.setPurchaseEbiddingConfirmList(confirmList);
        List<PurchaseEbiddingSupplier> supplierList = headVO.getPurchaseEbiddingSupplierList();
        supplierList.forEach(supplier -> supplier.setReplyTime(null));
        headVO.setPurchaseEbiddingSupplierList(supplierList);
        headVO.setAuditStatus(START_PRICE_FLAG.equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus(START_PRICE_FLAG.equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setCurrentRound(headVO.getCurrentRound() + 1);
        headVO.setCurrentDelayCount(0);
        headVO.setReplyQuantity(0);
        headVO.setId(null);
        this.publish(headVO);
        PurchaseEbiddingHead purchaseHead = new PurchaseEbiddingHead();
        purchaseHead.setId(headId);
        purchaseHead.setEbiddingStatus(EbiddingStatusEnum.NEW_ROUND.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)purchaseHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitPrice(PurchaseEbiddingHead dbHead, PurchaseAwardOpinionVO opinionVO, List<PurchaseEbiddingItem> dbItemList) {
        ArrayList<PurchaseEbiddingItem> itemList = new ArrayList<PurchaseEbiddingItem>();
        List<PurchaseEbiddingSupplierVO> supplierVOList = opinionVO.getPurchaseEbiddingSupplierQuoteList();
        for (PurchaseEbiddingSupplierVO purchaseEbiddingSupplierVO : supplierVOList) {
            itemList.addAll(purchaseEbiddingSupplierVO.getPurchaseEbiddingItemList());
        }
        this.checkSubmitPrice(dbHead, itemList, opinionVO.getAcceptMinPrice());
        this.purchaseAwardOpinionService.save((Object)opinionVO);
        ArrayList<PurchaseEbiddingSupplier> supplierList = new ArrayList<PurchaseEbiddingSupplier>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItem item2 : itemList) {
                item2.setQuota((BigDecimal)(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : (item2.getQuota() == null ? null : BigDecimal.ZERO)));
                item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue());
            }
            this.purchaseEbiddingItemService.updateBatchById(itemList);
            Map<String, String> map = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
            map.forEach((key, value) -> {
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount((String)key);
                supplier.setBiddingStatus((String)value);
                supplierList.add(supplier);
            });
        } else {
            for (PurchaseEbiddingItem item2 : itemList) {
                String itemStatus = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? EbiddingItemStatusEnum.BID_WIN.getValue() : EbiddingItemStatusEnum.UN_BID_WIN.getValue();
                BigDecimal quota = EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus()) ? item2.getQuota() : null;
                item2.setQuota(quota);
                item2.setItemStatus(itemStatus);
                PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
                supplier.setHeadId(dbHead.getId());
                supplier.setToElsAccount(item2.getToElsAccount());
                supplier.setQuota(quota == null ? null : quota.toString());
                supplier.setBiddingStatus(itemStatus);
                supplierList.add(supplier);
            }
            this.purchaseEbiddingItemService.updateBidByHeadId(itemList);
        }
        this.purchaseEbiddingSupplierService.updateBidResultBatch(supplierList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, itemList, supplierList);
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEbiddingItem> list = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.generatePriceRecord(dbHead, list);
            }
        } else {
            AuditInputParamDTO auditInputParamDTO = new AuditInputParamDTO();
            auditInputParamDTO.setBusinessId(dbHead.getId());
            auditInputParamDTO.setBusinessType("resultEbidding");
            auditInputParamDTO.setAuditSubject("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6279\uff0c\u5355\u53f7\uff1a" + dbHead.getEbiddingNumber());
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemList(dbItemList);
            auditInputParamDTO.setParams(JSONObject.toJSONString((Object)((Object)headVO)));
            this.inquiryInvokeWorkFlowRpcService.submit(auditInputParamDTO);
        }
    }

    private void checkSubmitPrice(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, String acceptMinPrice) {
        Map<String, List<PurchaseEbiddingItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getItemNumber, PurchaseEbiddingItem::getItemStatus, (oldVal, newVal) -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(newVal) ? newVal : oldVal));
        ArrayList<String> checkList = new ArrayList<String>();
        for (String itemNumber : itemMap.keySet()) {
            List<PurchaseEbiddingItem> list;
            String itemStatus = itemStatusMap.get(itemNumber);
            if (START_PRICE_FLAG.equals(acceptMinPrice) && !EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus)) {
                list = itemMap.get(itemNumber);
                List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(dbHead.getEbiddingType()).sort(dbHead.getEbiddingWay(), list);
                if (CollectionUtil.isNotEmpty(sortList)) {
                    PurchaseEbiddingItem appropriate = sortList.get(0);
                    for (PurchaseEbiddingItem item2 : list) {
                        if (!item2.getId().equals(appropriate.getId())) continue;
                        item2.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue());
                        BigDecimal quota = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay()) ? BigDecimal.valueOf(100L) : appropriate.getRequireQuantity();
                        item2.setQuota(quota);
                    }
                    continue;
                }
                list.forEach(item -> {
                    item.setItemStatus(EbiddingItemStatusEnum.UN_BID_WIN.getValue());
                    item.setQuota(null);
                });
                continue;
            }
            if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(itemStatus) || (list = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemMap.get(itemNumber).stream().filter(item -> item.getPrice() != null && item.getPrice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()) : itemMap.get(itemNumber).stream().filter(item -> item.getTotalAmount() != null && item.getTotalAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList())).isEmpty()) continue;
            checkList.add(itemNumber);
        }
        if (!checkList.isEmpty()) {
            List materialList = itemList.stream().filter(item -> checkList.contains(item.getItemNumber())).map(PurchaseEbiddingItem::getMaterialDesc).distinct().collect(Collectors.toList());
            String message = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLexusBW_39c42088", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLexusBW_86c45c09", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u9ad8\u4ef7\u4e2d\u6807\uff1f")) : (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? I18nUtil.translate((String)"i18n_alert_WWWWWLlBWKQCLenusBW_1148a9fe", (String)"${0} \u672a\u6388\u6807\uff0c\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f", (String[])new String[]{String.join((CharSequence)"\uff0c", materialList)}) : I18nUtil.translate((String)"i18n_alert_KQCLenusBW_5e48e57f", (String)"\u662f\u5426\u9ed8\u8ba4\u6700\u4f4e\u4ef7\u4e2d\u6807\uff1f"));
            throw new ELSAgainException(message);
        }
        List<PurchaseEbiddingItem> acceptList = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(acceptList)) {
            acceptList.forEach(item -> {
                Assert.isTrue((item.getPrice() != null || item.getTotalAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LsujRdXxqsB_92e6b4a1", (String)"\u672a\u62a5\u4ef7\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4e2d\u6807"));
                if (QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzlvlTfUW_88b8f618", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                } else {
                    Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_sBjWFWvzWRlTfUW_8d48d2f0", (String)"\u4e2d\u6807\u7684\u6570\u636e\uff0c\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
            });
            Map<String, List<PurchaseEbiddingItem>> acceptMap = acceptList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getItemNumber));
            for (String itemNumber : acceptMap.keySet()) {
                List<PurchaseEbiddingItem> list = acceptMap.get(itemNumber);
                BigDecimal quotaTotal = list.stream().map(PurchaseEbiddingItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean isScale = QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay());
                BigDecimal quota = isScale ? BigDecimal.valueOf(100L) : list.get(0).getRequireQuantity();
                String message = isScale ? I18nUtil.translate((String)"i18n_alert_vzlvRnlTEUWWWW_ffbb0603", (String)"\u62c6\u5206\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01") : I18nUtil.translate((String)"i18n_alert_vzWRRnlTEUTVWRW_11dd4a65", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff01");
                Assert.isTrue((quotaTotal.compareTo(quota) == 0 ? 1 : 0) != 0, (String)message);
            }
        }
    }

    @Override
    public void priced(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> itemList, List<PurchaseEbiddingSupplier> supplierList) {
        block12: {
            List limit;
            List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
            Date pricedTime = new Date();
            dbItemList.forEach(item -> item.setPricedTime(pricedTime));
            this.purchaseEbiddingItemService.updateBatchById(dbItemList);
            dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_SUCCESS.getValue());
            BigDecimal ebiddingAmount = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : ((limit = itemList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).limit(1L).collect(Collectors.toList())).isEmpty() ? BigDecimal.ZERO : ((PurchaseEbiddingItem)((Object)limit.get(0))).getTotalAmount());
            dbHead.setEbiddingAmount(ebiddingAmount);
            if (dbHead.getProjectBudget() != null && dbHead.getProjectBudget().compareTo(BigDecimal.ZERO) != 0) {
                dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(ebiddingAmount));
                if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
                    dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 6, 4).multiply(BigDecimal.valueOf(100L)));
                }
            }
            ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
            this.saleEbiddingHeadService.priced(dbHead, itemList, supplierList);
            if (PricingNoticeEnum.NOT.getValue().equals(dbHead.getPricingNotice())) break block12;
            ArrayList sendAccountList = new ArrayList();
            List<PurchaseEbiddingSupplier> dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
            if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(supplier.getBiddingStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            } else if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice()) && START_PRICE_FLAG.equals(dbHead.getNeedEcho())) {
                sendAccountList.addAll(dbSupplierList.stream().filter(supplier -> EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus())).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList()));
            }
            List<PurchaseEbiddingItem> sendItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> sendAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
            sendItemList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getEnterpriseName()));
            if (CollectionUtil.isNotEmpty(sendItemList)) {
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(dbHead.getId());
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    for (PurchaseEbiddingItem item2 : sendItemList) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item2.getItemStatus())) {
                            super.sendMsg(dbHead.getElsAccount(), item2.getToElsAccount(), (Object)item2, receiveParamMap, "ebidding", "confirm");
                            continue;
                        }
                        super.sendMsg(dbHead.getElsAccount(), item2.getToElsAccount(), (Object)item2, receiveParamMap, "ebidding", "refundPurchase");
                    }
                } else {
                    sendItemList.forEach(item -> item.setPrice(item.getTotalAmount()));
                    Map packageMap = sendItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getToElsAccount, Function.identity(), (newVal, oldVal) -> {
                        String materialNumber = oldVal.getMaterialNumber();
                        oldVal.setMaterialNumber(materialNumber + "," + newVal.getMaterialNumber());
                        BigDecimal oldRequireQuantity = oldVal.getRequireQuantity() == null ? BigDecimal.ZERO : oldVal.getRequireQuantity();
                        BigDecimal newRequireQuantity = newVal.getRequireQuantity() == null ? BigDecimal.ZERO : newVal.getRequireQuantity();
                        oldVal.setRequireQuantity(oldRequireQuantity.add(newRequireQuantity));
                        return oldVal;
                    }));
                    for (PurchaseEbiddingItem item3 : packageMap.values()) {
                        if (EbiddingItemStatusEnum.BID_WIN.getValue().equals(item3.getItemStatus())) {
                            super.sendMsg(dbHead.getElsAccount(), item3.getToElsAccount(), (Object)item3, receiveParamMap, "ebidding", "confirm");
                            continue;
                        }
                        super.sendMsg(dbHead.getElsAccount(), item3.getToElsAccount(), (Object)item3, receiveParamMap, "ebidding", "refundPurchase");
                    }
                }
            }
        }
    }

    @Override
    public void cancel(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.INVALID.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
        this.saleEbiddingHeadService.remove((Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId()));
        EbiddingJobUtil.deleteAllJob(dbHead);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.inquiryInvokeMessageRpcService.delNotice(dbHead.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        this.checkQuotePrice(dbHead, dbItem, quoteItem);
        this.computeQuotePrice(dbHead, dbItem, quoteItem);
        List saleHeadList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> dbItem.getToElsAccount().equals(head.getElsAccount())).collect(Collectors.toList());
        SaleEbiddingHead dbSaleHead = (SaleEbiddingHead)((Object)saleHeadList.get(0));
        this.purchaseEbiddingItemHisService.save(quoteItem, dbSaleHead);
        RedisUtil redis = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redis.publish("quote-price-topic", (Object)dbHead.getId());
    }

    private void checkQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        BigDecimal startPrice;
        PurchaseEbiddingItemHis dbHisItem;
        List dbHisList = this.purchaseEbiddingItemHisService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)dbItem.getId())).orderByDesc(PurchaseEbiddingItemHis::getQuoteTime));
        PurchaseEbiddingItemHis purchaseEbiddingItemHis = dbHisItem = dbHisList.isEmpty() ? new PurchaseEbiddingItemHis() : (PurchaseEbiddingItemHis)((Object)dbHisList.get(0));
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            startPrice = dbItem.getStartPrice();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetPrice() : dbHisItem.getPrice();
        } else {
            startPrice = dbHead.getStartTotalAmount();
            webPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(dbHead.getQuoteType()) ? dbHisItem.getNetTotalAmount() : dbHisItem.getTotalAmount();
        }
        if (startPrice != null && startPrice.compareTo(BigDecimal.ZERO) != 0 && START_PRICE_FLAG.equals(dbHead.getSetStartPrice())) {
            if (EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
            if (EbiddingTypeEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType())) {
                Assert.isTrue((startPrice.compareTo(webPrice) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
            }
        }
        if (dbPrice != null && dbPrice.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal changeRange;
            BigDecimal bigDecimal = changeRange = EbiddingRangeUnitEnum.PERCENT.getValue().equals(dbHead.getRangeUnit()) ? dbPrice.multiply(dbHead.getChangeRange().divide(BigDecimal.valueOf(100L), 6, 4)) : dbHead.getChangeRange();
            boolean flag = EbiddingTypeEnum.FORWARD_BID.getValue().equals(dbHead.getEbiddingType()) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
        }
    }

    private void computeQuotePrice(PurchaseEbiddingHead dbHead, PurchaseEbiddingItem dbItem, PurchaseEbiddingItem quoteItem) {
        BigDecimal taxRate;
        BigDecimal bigDecimal = taxRate = StrUtil.isNotBlank((CharSequence)dbItem.getTaxRate()) ? new BigDecimal(dbItem.getTaxRate()) : BigDecimal.ZERO;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            BigDecimal bigDecimal2 = requireQuantity = dbItem.getRequireQuantity() == null ? BigDecimal.ONE : dbItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = netPrice.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
            BigDecimal totalAmount = quoteItem.getTotalAmount();
            BigDecimal netTotalAmount = totalAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            quoteItem.setNetTotalAmount(netTotalAmount);
        } else {
            BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
            BigDecimal totalAmount = netTotalAmount.multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L), 6, 4)));
            quoteItem.setTotalAmount(totalAmount);
        }
        quoteItem.setQuoteTime(new Date());
        quoteItem.setQuoteCount(dbItem.getQuoteCount() == null ? 1 : dbItem.getQuoteCount() + 1);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !START_PRICE_FLAG.equals(dbHead.getTest())) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setCompany(dbHead.getCompany());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.EBIDDING.getValue());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setSourceNumber(dbHead.getEbiddingNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setSourceItemNumber(item.getItemNumber());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEbiddingItem> updateList = new ArrayList<PurchaseEbiddingItem>();
            for (PurchaseEbiddingItem item : acceptList) {
                PurchaseEbiddingItem update = new PurchaseEbiddingItem();
                update.setId(item.getId());
                update.setSendStatus(START_PRICE_FLAG);
                updateList.add(update);
            }
            this.purchaseEbiddingItemService.updateBatchById(updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEbiddingHeadVO headVO) {
        String headId = headVO.getId();
        String regretFlag = headVO.getRegretFlag();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)EbiddingStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_IlBntFnqMB_6899e661", (String)"\u5df2\u6388\u6807\u7684\u5355\u636e\u624d\u53ef\u6094\u6807"));
        dbHead.setEbiddingStatus(EbiddingStatusEnum.REGRET.getValue());
        dbHead.setResultAuditStatus(START_PRICE_FLAG.equals(dbHead.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEbiddingHeadMapper)this.baseMapper).updateById((Object)dbHead);
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        itemList.forEach(item -> {
            item.setItemStatus(EbiddingItemStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuota(item.getQuota() == null ? null : BigDecimal.ZERO);
            item.setSendStatus("0");
            item.setAuditStatus(dbHead.getResultAuditStatus());
        });
        this.purchaseEbiddingItemService.updateBatchById(itemList);
        if (RegretFlagEnum.RE_SOURCE.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        } else if (RegretFlagEnum.RE_PRICED.getValue().equals(regretFlag)) {
            this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue());
        }
        this.saleEbiddingHeadService.regret(dbHead, itemList);
        String sourceNumber = dbHead.getEbiddingNumber();
        List<String> itemNumberList = itemList.stream().map(PurchaseEbiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.EBIDDING.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    public void failed(PurchaseEbiddingHead dbHead) {
        dbHead.setEbiddingStatus(EbiddingStatusEnum.BID_FAILED.getValue());
        this.updateById((Object)dbHead);
        this.saleEbiddingHeadService.failed(dbHead);
        EbiddingJobUtil.deleteAllJob(dbHead);
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public JSONObject getEbinddingDataById(String id) {
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        headVO.setPurchaseEbiddingItemList(dbItemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getEbinddingDataById(List<String> idList) {
        JSONArray array = new JSONArray();
        for (String id : idList) {
            array.add((Object)this.getEbinddingDataById(id));
        }
        return array;
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_UJKIIRWxqUJ_b9732d1b", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEbiddingHead dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "item");
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        ArrayList supplierList = Lists.newArrayList();
        PurchaseEbiddingSupplier supplier = new PurchaseEbiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getItemStatus).distinct().collect(Collectors.toList());
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId(), "confirm");
        List confirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        dbHead.setEbiddingStatus(START_PRICE_FLAG.equals(dbHead.getNeedEcho()) ? EbiddingStatusEnum.WAIT_REPLY.getValue() : EbiddingStatusEnum.WAIT_BIDDING.getValue());
        this.updateById((Object)dbHead);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getId());
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(dbHead.getId());
            attachment.setBusinessType("ebidding");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        AttachmentSendDTO sendVO = this.publishEbidding(dbHead, initItemList, supplierList, demandList, confirmList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.EBIDDING.getValue(), dbHead.getEbiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.saveSaleAttachment(purchaseAttachmentList, sendVO);
    }

    private void saveSaleAttachment(List<PurchaseAttachmentDTO> purchaseAttachmentList, AttachmentSendDTO sendVO) {
        ArrayList saleAttachmentDTOList = new ArrayList();
        String saleHeadId = sendVO.getToSend().keySet().stream().findFirst().map(Object::toString).orElse("");
        purchaseAttachmentList.forEach(e -> {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)e, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setHeadId(saleHeadId);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setSendStatus(START_PRICE_FLAG);
            saleAttachmentDTOList.add(saleAttachmentDTO);
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
    }

    @Override
    public PurchaseEbiddingPrintVO printById(String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseEbiddingPrintVO printVO = new PurchaseEbiddingPrintVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)printVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        String ebiddingWay = dbHead.getEbiddingWay();
        String ebiddingType = dbHead.getEbiddingType();
        dbItemList = this.rankEbiddingItemData(dbItemList, ebiddingWay, ebiddingType);
        this.processFirstQuotePrice(id, dbHead, dbItemList);
        printVO.setPurchaseEbiddingItemList(dbItemList);
        List<PurchaseEbiddingSupplier> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        printVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        printVO.setPurchaseAwardOpinionList(this.purchaseAwardOpinionService.selectByMainId(id));
        if (printVO.getPurchaseAwardOpinionList().size() > 0) {
            printVO.setPricingInstructions(printVO.getPurchaseAwardOpinionList().get(0).getAwardOpinion());
        }
        if (!ObjectUtils.isEmpty((Object)printVO.getResultFlowId())) {
            List<A1FlowTaskTrajectoryDTO> a1FlowTaskTrajectoryEntityList = this.workflowAuditDataService.queryA1FlowTaskTrajectoryList(printVO.getResultFlowId());
            StringBuilder resultOpinion = new StringBuilder();
            StringBuilder resultOpinionPeople = new StringBuilder();
            int count = 1;
            for (A1FlowTaskTrajectoryDTO a1FlowTaskTrajectoryEntity : a1FlowTaskTrajectoryEntityList) {
                resultOpinion.append(count + "\u3001" + a1FlowTaskTrajectoryEntity.getOpinion() + "\uff1b");
                resultOpinionPeople.append(count + "\u3001" + a1FlowTaskTrajectoryEntity.getUserName() + "\uff1b");
                ++count;
            }
            printVO.setResultOpinion(resultOpinion.toString());
            printVO.setResultOpinionPeople(resultOpinionPeople.toString());
        }
        printVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        printVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        printVO.setPurchaseAttachmentList(attachmentList);
        printVO.setSupplierCounts(dbSupplierList.size());
        return printVO;
    }

    private void processFirstQuotePrice(String headId, PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)headId);
        wrapper.eq((Object)"quote_count", (Object)1);
        List itemHisList = this.purchaseEbiddingItemHisService.list((Wrapper)wrapper);
        if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
            Map<String, List<PurchaseEbiddingItemHis>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount()));
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItemHis> hisList = toElsAccountMap.get(deItem.getToElsAccount());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHis his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetTotalAmount());
            }
        } else {
            Map<String, List<PurchaseEbiddingItemHis>> toElsAccountMap = itemHisList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + ":" + o.getMaterialDesc()));
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItemHis> hisList = toElsAccountMap.get(deItem.getToElsAccount() + ":" + deItem.getMaterialDesc());
                if (hisList == null || hisList.size() <= 0) continue;
                PurchaseEbiddingItemHis his = hisList.get(0);
                deItem.setFirstQuotePrice(his.getNetPrice());
            }
        }
    }

    private List<PurchaseEbiddingItem> rankEbiddingItemData(List<PurchaseEbiddingItem> dbItemList, String ebiddingWay, String ebiddingType) {
        if (EbiddingWayEnum.PACKAGE.getValue().equals(ebiddingWay)) {
            String itemNumber = START_PRICE_FLAG;
            List items = dbItemList.stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
            List<PurchaseEbiddingItem> filterList = dbItemList.stream().filter(item -> item.getMaterialDesc().equals(((PurchaseEbiddingItem)((Object)((Object)items.get(0)))).getMaterialDesc())).collect(Collectors.toList());
            this.rank(filterList, ebiddingWay, ebiddingType);
            Map<String, List<PurchaseEbiddingItem>> filterSortMap = filterList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            Map<String, List<PurchaseEbiddingItem>> deItemMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getFactory()));
            for (Map.Entry<String, List<PurchaseEbiddingItem>> entry : deItemMap.entrySet()) {
                List<PurchaseEbiddingItem> filterMapItemList = filterSortMap.get(entry.getKey());
                if (filterMapItemList == null || filterMapItemList.size() <= 0) continue;
                for (PurchaseEbiddingItem dbMapItem : entry.getValue()) {
                    dbMapItem.setQuoteRank(filterMapItemList.get(0).getQuoteRank());
                }
            }
            for (PurchaseEbiddingItem deItem : dbItemList) {
                List<PurchaseEbiddingItem> sortList = filterSortMap.get(deItem.getToElsAccount() + "-" + deItem.getItemNumber());
                if (sortList == null || sortList.size() <= 0) continue;
                PurchaseEbiddingItem sortItem = sortList.get(0);
                deItem.setQuoteRank(sortItem.getQuoteRank());
            }
            dbItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)).thenComparing(PurchaseEbiddingItem::getItemNumber));
        } else {
            ArrayList<PurchaseEbiddingItem> sortItemList = new ArrayList<PurchaseEbiddingItem>();
            Map<String, List<PurchaseEbiddingItem>> itemNumberMap = dbItemList.stream().collect(Collectors.groupingBy(o -> o.getMaterialDesc()));
            for (Map.Entry<String, List<PurchaseEbiddingItem>> entry : itemNumberMap.entrySet()) {
                List<PurchaseEbiddingItem> itemList = entry.getValue();
                if (itemList == null || itemList.size() <= 0) continue;
                this.rank(itemList, ebiddingWay, ebiddingType);
                sortItemList.addAll(itemList);
            }
            Boolean flag = true;
            for (PurchaseEbiddingItem purchaseEbiddingItem : sortItemList) {
                if (!ObjectUtils.isEmpty((Object)purchaseEbiddingItem.getQuoteRank())) continue;
                flag = false;
                break;
            }
            if (flag.booleanValue()) {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getMaterialDesc, Comparator.nullsLast(String::compareTo)).thenComparing(PurchaseEbiddingItem::getQuoteRank));
            } else {
                sortItemList.sort(Comparator.comparing(PurchaseEbiddingItem::getMaterialDesc, Comparator.nullsLast(String::compareTo)));
            }
            dbItemList = sortItemList;
        }
        return dbItemList;
    }

    private void rank(List<PurchaseEbiddingItem> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItem> sortList = EbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItem purchaseEbiddingItem : itemList) {
                if (!purchaseEbiddingItem.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                purchaseEbiddingItem.setQuoteRank(rank);
                continue block0;
            }
        }
        Map<String, List<PurchaseEbiddingItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getMaterialDesc()));
        for (Map.Entry entry : itemMap.entrySet()) {
            List itemSortList = (List)entry.getValue();
            if (itemSortList == null || itemSortList.size() <= 1) continue;
            itemSortList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
            for (int i = 1; i < itemSortList.size(); ++i) {
                PurchaseEbiddingItem firstItem = (PurchaseEbiddingItem)((Object)itemSortList.get(i - 1));
                PurchaseEbiddingItem secondItem = (PurchaseEbiddingItem)((Object)itemSortList.get(i));
                if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
                    if (firstItem.getPrice() == null || secondItem.getPrice() == null || firstItem.getPrice().compareTo(secondItem.getPrice()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                    secondItem.setQuoteRank(firstItem.getQuoteRank());
                    continue;
                }
                if (firstItem.getTotalAmount() == null || secondItem.getTotalAmount() == null || firstItem.getTotalAmount().compareTo(secondItem.getTotalAmount()) != 0 || !firstItem.getQuoteTime().equals(secondItem.getQuoteTime())) continue;
                secondItem.setQuoteRank(firstItem.getQuoteRank());
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }
}

