/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.cost.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.enquiry.cost.entity.CostField;
import com.els.modules.enquiry.cost.service.CostFieldService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868"})
@RestController
@RequestMapping(value={"/cost/costField"})
public class CostFieldController
extends BaseController<CostField, CostFieldService> {
    @Autowired
    private CostFieldService costFieldService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u4f01\u4e1a\u7ea7)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u4f01\u4e1a\u7ea7)")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(CostField costField, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)costField), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)this.getTenantId());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.costFieldService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u5e73\u53f0\u7ea7)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u5e73\u53f0\u7ea7)")
    @GetMapping(value={"/listSys"})
    public Result<?> querySysPageList(CostField costField, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)costField), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.costFieldService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CostField costField) {
        Assert.hasText((String)costField.getFieldName(), (String)I18nUtil.translate((String)"i18n_alert_JORxOLV_628c651f", (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String elsAccount = this.getTenantId();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List list = this.costFieldService.list((Wrapper)queryWrapper).stream().map(CostField::getFieldName).collect(Collectors.toList());
        Assert.isTrue((!list.contains(costField.getFieldName()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_JORIMKWxqVBmN_772c088e", (String)"\u5b57\u6bb5\u540d\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u63d2\u5165"));
        costField.setElsAccount(elsAccount);
        this.costFieldService.saveCostField(costField);
        return Result.ok((Object)((Object)costField));
    }

    @SrmValidated
    @AutoLog(value="\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody CostField costField) {
        this.costFieldService.updateCostField(costField);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.costFieldService.delCostField(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.costFieldService.delBatchCostField(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6210\u672c\u7ec4\u6210\u5b57\u6bb5\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CostField costField = (CostField)((Object)this.costFieldService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)costField));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u6bb5", notes="\u67e5\u8be2\u6240\u6709\u5b57\u6bb5")
    @GetMapping(value={"/queryAll"})
    public Result<?> queryAll() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)this.getTenantId());
        List list = this.costFieldService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            LambdaQueryWrapper sysQuery = new LambdaQueryWrapper();
            sysQuery.eq(BaseEntity::getElsAccount, (Object)"100000");
            List sysList = this.costFieldService.list((Wrapper)sysQuery);
            return Result.ok((Object)sysList);
        }
        return Result.ok((Object)list);
    }
}

