/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.priceEvaluationManagement.entity.PurchaseBaseMaterialPrice;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseBaseMaterialPriceStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchaseBaseMaterialPriceService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseBaseMaterialExcelHandler")
public class PurchaseBaseMaterialExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBaseMaterialExcelHandler.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseBaseMaterialPriceService purchaseBaseMaterialPriceService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("purchaseBaseMaterialPrice");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u57fa\u7840\u6750\u6599\u4ef7\u683c\u6ca1\u6709\u9ed8\u8ba4\u7684\u4e1a\u52a1\u6a21\u677f,\u6682\u65f6\u4e0d\u80fd\u5bfc\u5165\u521b\u5efa\u57fa\u7840\u6750\u6599\u4ef7\u683c!"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        ArrayList<PurchaseBaseMaterialPrice> baseMaterialPriceList = new ArrayList<PurchaseBaseMaterialPrice>();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("purchaseBaseMaterialPriceNumber", null, totalCount);
        for (Map data : dataList) {
            PurchaseBaseMaterialPrice baseMaterialPrice = (PurchaseBaseMaterialPrice)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseBaseMaterialPrice.class));
            baseMaterialPriceList.add(baseMaterialPrice);
        }
        int i = 0;
        for (PurchaseBaseMaterialPrice baseMaterialPrice : baseMaterialPriceList) {
            baseMaterialPrice.setTemplateAccount(templateHeadDTO.getElsAccount());
            baseMaterialPrice.setTemplateVersion(templateHeadDTO.getTemplateVersion() + "");
            baseMaterialPrice.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            baseMaterialPrice.setTemplateName(templateHeadDTO.getTemplateName());
            baseMaterialPrice.setBusAccount(loginUser.getElsAccount());
            baseMaterialPrice.setDocumentNumber((String)nextCodes.get(i));
            baseMaterialPrice.setDocumentStatus(PurchaseBaseMaterialPriceStatusEnum.NEW.getValue());
            BigDecimal taxRate = BigDecimal.ONE.add(new BigDecimal(baseMaterialPrice.getTaxRate()).divide(new BigDecimal("100")));
            BigDecimal netPrice = baseMaterialPrice.getPrice().divide(taxRate, 4, 4);
            baseMaterialPrice.setNetPrice(netPrice);
            ++i;
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        this.purchaseBaseMaterialPriceService.saveBatch(baseMaterialPriceList, 200);
        return dataList;
    }
}

