/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.EnquiryItemEvaluationStatusEnum;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManageBaseMaterialItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManageClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManageHead;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManagePriceItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManageProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.entity.PurchaseProcessingProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationManagementStatusEnum;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationStandardStatusEnum;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceItemStatusEnum;
import com.els.modules.priceEvaluationManagement.mapper.PurchasePriceEvaluationManageHeadMapper;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageBaseMaterialItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManagePriceItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageProcedurePriceItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationStandardHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchaseProcessingProcedurePriceItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePriceEvaluationManageHeadServiceImpl
extends BaseServiceImpl<PurchasePriceEvaluationManageHeadMapper, PurchasePriceEvaluationManageHead>
implements PurchasePriceEvaluationManageHeadService {
    @Autowired
    private PurchasePriceEvaluationManagePriceItemService purchasePriceEvaluationManagePriceItemService;
    @Autowired
    private PurchasePriceEvaluationManageBaseMaterialItemService purchasePriceEvaluationManageBaseMaterialItemService;
    @Autowired
    private PurchasePriceEvaluationManageProcedurePriceItemService purchasePriceEvaluationManageProcedurePriceItemService;
    @Autowired
    private PurchasePriceEvaluationManageClassifyItemService purchasePriceEvaluationManageClassifyItemService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private PurchasePriceEvaluationStandardHeadService purchasePriceEvaluationStandardHeadService;
    @Autowired
    private PurchasePriceEvaluationItemService purchasePriceEvaluationItemService;
    @Autowired
    private PurchaseProcessingProcedurePriceItemService purchaseProcessingProcedurePriceItemService;
    @Autowired
    private PurchaseManagementClassifyItemService purchaseManagementClassifyItemService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList, List<PurchasePriceEvaluationManageBaseMaterialItem> purchasePriceEvaluationManageBaseMaterialItemList, List<PurchasePriceEvaluationManageProcedurePriceItem> purchasePriceEvaluationManageProcedurePriceItemList, List<PurchasePriceEvaluationManageClassifyItem> purchasePriceEvaluationManageClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ((PurchasePriceEvaluationManageHeadMapper)this.baseMapper).insert((Object)purchasePriceEvaluationManageHead);
        if ("0".equals(purchasePriceEvaluationManageHead.getIsAudit()) || StringUtils.isEmpty((CharSequence)purchasePriceEvaluationManageHead.getIsAudit())) {
            purchasePriceEvaluationManageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        super.setHeadDefaultValue((BaseEntity)purchasePriceEvaluationManageHead);
        this.insertData(purchasePriceEvaluationManageHead, purchasePriceEvaluationManagePriceItemList, purchasePriceEvaluationManageBaseMaterialItemList, purchasePriceEvaluationManageProcedurePriceItemList, purchasePriceEvaluationManageClassifyItemList, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList, List<PurchasePriceEvaluationManageBaseMaterialItem> purchasePriceEvaluationManageBaseMaterialItemList, List<PurchasePriceEvaluationManageProcedurePriceItem> purchasePriceEvaluationManageProcedurePriceItemList, List<PurchasePriceEvaluationManageClassifyItem> purchasePriceEvaluationManageClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int count;
        if ("0".equals(purchasePriceEvaluationManageHead.getIsAudit()) || StringUtils.isEmpty((CharSequence)purchasePriceEvaluationManageHead.getIsAudit())) {
            purchasePriceEvaluationManageHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        Assert.isTrue(((count = ((PurchasePriceEvaluationManageHeadMapper)this.baseMapper).updateById((Object)purchasePriceEvaluationManageHead)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchasePriceEvaluationManagePriceItemService.deleteByMainId(purchasePriceEvaluationManageHead.getId());
        this.purchasePriceEvaluationManageBaseMaterialItemService.deleteByMainId(purchasePriceEvaluationManageHead.getId());
        this.purchasePriceEvaluationManageProcedurePriceItemService.deleteByMainId(purchasePriceEvaluationManageHead.getId());
        this.purchasePriceEvaluationManageClassifyItemService.deleteByMainId(purchasePriceEvaluationManageHead.getId());
        this.baseRpcService.deletePurchaseAttachmentByMainId(purchasePriceEvaluationManageHead.getId());
        this.insertData(purchasePriceEvaluationManageHead, purchasePriceEvaluationManagePriceItemList, purchasePriceEvaluationManageBaseMaterialItemList, purchasePriceEvaluationManageProcedurePriceItemList, purchasePriceEvaluationManageClassifyItemList, purchaseAttachmentList);
    }

    private void insertData(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList, List<PurchasePriceEvaluationManageBaseMaterialItem> purchasePriceEvaluationManageBaseMaterialItemList, List<PurchasePriceEvaluationManageProcedurePriceItem> purchasePriceEvaluationManageProcedurePriceItemList, List<PurchasePriceEvaluationManageClassifyItem> purchasePriceEvaluationManageClassifyItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchasePriceEvaluationManagePriceItemList)) {
            for (PurchasePriceEvaluationManagePriceItem purchasePriceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
                purchasePriceEvaluationManagePriceItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePriceEvaluationManagePriceItem, (BaseEntity)purchasePriceEvaluationManageHead);
            }
            this.purchasePriceEvaluationManagePriceItemService.saveBatch(purchasePriceEvaluationManagePriceItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchasePriceEvaluationManageBaseMaterialItemList)) {
            for (PurchasePriceEvaluationManageBaseMaterialItem purchasePriceEvaluationManageBaseMaterialItem : purchasePriceEvaluationManageBaseMaterialItemList) {
                purchasePriceEvaluationManageBaseMaterialItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePriceEvaluationManageBaseMaterialItem, (BaseEntity)purchasePriceEvaluationManageHead);
            }
            this.purchasePriceEvaluationManageBaseMaterialItemService.saveBatch(purchasePriceEvaluationManageBaseMaterialItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchasePriceEvaluationManageProcedurePriceItemList)) {
            for (PurchasePriceEvaluationManageProcedurePriceItem purchasePriceEvaluationManageProcedurePriceItem : purchasePriceEvaluationManageProcedurePriceItemList) {
                purchasePriceEvaluationManageProcedurePriceItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePriceEvaluationManageProcedurePriceItem, (BaseEntity)purchasePriceEvaluationManageHead);
            }
            this.purchasePriceEvaluationManageProcedurePriceItemService.saveBatch(purchasePriceEvaluationManageProcedurePriceItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchasePriceEvaluationManageClassifyItemList)) {
            for (PurchasePriceEvaluationManageClassifyItem purchasePriceEvaluationManageClassifyItem : purchasePriceEvaluationManageClassifyItemList) {
                purchasePriceEvaluationManageClassifyItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePriceEvaluationManageClassifyItem, (BaseEntity)purchasePriceEvaluationManageHead);
            }
            this.purchasePriceEvaluationManageClassifyItemService.saveBatch(purchasePriceEvaluationManageClassifyItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setHeadId(purchasePriceEvaluationManageHead.getId());
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchasePriceEvaluationManageHead);
            }
            this.baseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchasePriceEvaluationManagePriceItemService.deleteByMainId(id);
        this.purchasePriceEvaluationManageBaseMaterialItemService.deleteByMainId(id);
        this.purchasePriceEvaluationManageProcedurePriceItemService.deleteByMainId(id);
        this.purchasePriceEvaluationManageClassifyItemService.deleteByMainId(id);
        this.baseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchasePriceEvaluationManageHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePriceEvaluationManagePriceItemService.deleteByMainId(serializable.toString());
            this.purchasePriceEvaluationManageBaseMaterialItemService.deleteByMainId(serializable.toString());
            this.purchasePriceEvaluationManageProcedurePriceItemService.deleteByMainId(serializable.toString());
            this.purchasePriceEvaluationManageClassifyItemService.deleteByMainId(serializable.toString());
            this.baseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchasePriceEvaluationManageHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void generateEvaluationPriceDocument(PurchaseEnquiryHeadVO headVO, List<PurchaseEnquiryItem> purchaseEnquiryItemList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper priceEvaluationStandardHeadLambdaQueryWrapper = new LambdaQueryWrapper();
        priceEvaluationStandardHeadLambdaQueryWrapper.eq(PurchasePriceEvaluationStandardHead::getDocumentStatus, (Object)PurchasePriceEvaluationStandardStatusEnum.START.getValue());
        priceEvaluationStandardHeadLambdaQueryWrapper.orderBy(true, false, (Object[])new SFunction[]{BaseEntity::getCreateTime});
        List purchasePriceEvaluationStandardHeadList = this.purchasePriceEvaluationStandardHeadService.list((Wrapper)priceEvaluationStandardHeadLambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)purchasePriceEvaluationStandardHeadList)) {
            throw new ELSBootException("\u6838\u4ef7\u6807\u51c6\u4e2d\u6ca1\u6709\u72b6\u6001\u4e3a\u542f\u7528\u7684\u5355\u636e");
        }
        ArrayList<PurchaseEnquiryItem> enquiryItemList = new ArrayList<PurchaseEnquiryItem>();
        ArrayList<PurchaseEnquiryItem> refuseEnquiryItemList = new ArrayList<PurchaseEnquiryItem>();
        for (PurchaseEnquiryItem purchaseEnquiryItem : purchaseEnquiryItemList) {
            List priceEvaluationStandardHeadListByMaterial = purchasePriceEvaluationStandardHeadList.stream().filter(item -> purchaseEnquiryItem.getMaterialId().equals(item.getMaterialId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(priceEvaluationStandardHeadListByMaterial)) {
                throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + purchaseEnquiryItem.getMaterialNumber() + "]\u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u6838\u4ef7\u6807\u51c6\u7684\u5355\u636e,\u8bf7\u68c0\u67e5!");
            }
            PurchaseEnquiryItem enquiryItem = new PurchaseEnquiryItem();
            enquiryItem.setId(purchaseEnquiryItem.getId());
            enquiryItemList.add(enquiryItem);
            PurchasePriceEvaluationStandardHead priceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)priceEvaluationStandardHeadListByMaterial.get(0));
            BigDecimal enquiryPrice = purchaseEnquiryItem.getPrice() == null ? BigDecimal.ZERO : purchaseEnquiryItem.getPrice();
            BigDecimal evluationPrice = priceEvaluationStandardHead.getPrice() == null ? BigDecimal.ZERO : priceEvaluationStandardHead.getPrice();
            BigDecimal result = enquiryPrice.divide(evluationPrice, 2, 1).subtract(BigDecimal.ONE);
            if (result.compareTo(priceEvaluationStandardHead.getNegativeRange()) >= 0 && result.compareTo(priceEvaluationStandardHead.getForwardRange()) <= 0) {
                enquiryItem.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.EVALUATION_SUCCESS.getValue());
                continue;
            }
            enquiryItem.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.WAIT_EVAUATION.getValue());
            refuseEnquiryItemList.add(purchaseEnquiryItem);
        }
        this.purchaseEnquiryItemService.updateBatchById(enquiryItemList);
        List<String> priceEvaluationStandardIds = purchasePriceEvaluationStandardHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemAllList = this.purchasePriceEvaluationItemService.listByHeadId(priceEvaluationStandardIds);
        List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemAllList = this.purchaseProcessingProcedurePriceItemService.listByHeadId(priceEvaluationStandardIds);
        List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemAllList = this.purchaseManagementClassifyItemService.listByHeadId(priceEvaluationStandardIds);
        List dbpurchaseAttachmentDTOList = this.baseRpcService.selectPurchaseAttachmentByMainId(headVO.getId());
        ArrayList<PurchasePriceEvaluationManageHead> purchasePriceEvaluationManageHeadList = new ArrayList<PurchasePriceEvaluationManageHead>();
        ArrayList<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList = new ArrayList<PurchasePriceEvaluationManagePriceItem>();
        ArrayList<PurchasePriceEvaluationManageBaseMaterialItem> purchasePriceEvaluationManageBaseMaterialItemList = new ArrayList<PurchasePriceEvaluationManageBaseMaterialItem>();
        ArrayList<PurchasePriceEvaluationManageProcedurePriceItem> purchasePriceEvaluationManageProcedurePriceItemList = new ArrayList<PurchasePriceEvaluationManageProcedurePriceItem>();
        ArrayList<PurchasePriceEvaluationManageClassifyItem> purchasePriceEvaluationManageClassifyItemList = new ArrayList<PurchasePriceEvaluationManageClassifyItem>();
        Map<String, PurchaseInformationRecordsDTO> informationRecordsDTOMap = this.getEnquiryMaterialPriceInforRecord(headVO, refuseEnquiryItemList);
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
        for (PurchaseEnquiryItem purchaseEnquiryItem : refuseEnquiryItemList) {
            List priceEvaluationStandardHeadListByMaterial = purchasePriceEvaluationStandardHeadList.stream().filter(item -> purchaseEnquiryItem.getMaterialId().equals(item.getMaterialId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(priceEvaluationStandardHeadListByMaterial)) {
                throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + purchaseEnquiryItem.getMaterialNumber() + "]\u6ca1\u6709\u542f\u7528\u72b6\u6001\u7684\u6838\u4ef7\u6807\u51c6\u7684\u5355\u636e,\u8bf7\u68c0\u67e5!");
            }
            PurchasePriceEvaluationStandardHead priceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)priceEvaluationStandardHeadListByMaterial.get(0));
            List purchasePriceEvaluationItems = purchasePriceEvaluationItemAllList.stream().filter(item -> priceEvaluationStandardHead.getId().equals(item.getHeadId())).collect(Collectors.toList());
            List purchaseProcessingProcedurePriceItems = purchaseProcessingProcedurePriceItemAllList.stream().filter(item -> priceEvaluationStandardHead.getId().equals(item.getHeadId())).collect(Collectors.toList());
            List purchaseManagementClassifyItems = purchaseManagementClassifyItemAllList.stream().filter(item -> priceEvaluationStandardHead.getId().equals(item.getHeadId())).collect(Collectors.toList());
            PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead = new PurchasePriceEvaluationManageHead();
            try {
                BeanUtils.copyProperties((Object)((Object)priceEvaluationStandardHead), (Object)((Object)purchasePriceEvaluationManageHead));
                purchasePriceEvaluationManageHead.setId(IdWorker.getIdStr());
                purchasePriceEvaluationManageHead.setBusAccount(loginUser.getElsAccount());
                purchasePriceEvaluationManageHead.setDocumentNumber(this.baseRpcService.getNextCode("purchasePriceEvaluationManageHeadNumber", (Object)purchasePriceEvaluationManageHead));
                purchasePriceEvaluationManageHead.setDocumentStatus(PurchasePriceEvaluationManagementStatusEnum.WAIT_EVALUATION_PRICE.getValue());
                purchasePriceEvaluationManageHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                purchasePriceEvaluationManageHead.setTemplateAccount(priceEvaluationStandardHead.getManagementTemplateAccount());
                purchasePriceEvaluationManageHead.setTemplateName(priceEvaluationStandardHead.getManagementTemplateName());
                purchasePriceEvaluationManageHead.setTemplateNumber(priceEvaluationStandardHead.getManagementTemplateNumber());
                purchasePriceEvaluationManageHead.setTemplateVersion(priceEvaluationStandardHead.getManagementTemplateVersion() + "");
                purchasePriceEvaluationManageHead.setIsAudit("0");
                purchasePriceEvaluationManageHead.setCreateTime(new Date());
                purchasePriceEvaluationManageHead.setUpdateTime(new Date());
                purchasePriceEvaluationManageHead.setSourceNumber(purchaseEnquiryItem.getEnquiryNumber());
                purchasePriceEvaluationManageHead.setSourceId(purchaseEnquiryItem.getHeadId());
                purchasePriceEvaluationManageHead.setCreateBy(purchaseEnquiryItem.getCreateBy());
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new ELSBootException("\u6838\u4ef7\u6807\u51c6\u590d\u5236\u5931\u8d25");
            }
            purchasePriceEvaluationManageHeadList.add(purchasePriceEvaluationManageHead);
            PurchasePriceEvaluationManagePriceItem evaluationManagePriceItem = new PurchasePriceEvaluationManagePriceItem();
            PurchaseInformationRecordsDTO informationRecordsDTO = informationRecordsDTOMap.get(purchaseEnquiryItem.getMaterialNumber());
            try {
                BeanUtils.copyProperties((Object)((Object)purchaseEnquiryItem), (Object)((Object)evaluationManagePriceItem));
                evaluationManagePriceItem.setId(IdWorker.getIdStr());
                evaluationManagePriceItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                evaluationManagePriceItem.setItemStatus(PurchasePriceItemStatusEnum.NEW.getValue());
                evaluationManagePriceItem.setSourceItemId(purchaseEnquiryItem.getId());
                if (informationRecordsDTO != null) {
                    evaluationManagePriceItem.setFinalPrice(informationRecordsDTO.getPrice());
                    evaluationManagePriceItem.setNetPrice(informationRecordsDTO.getNetPrice());
                }
                BigDecimal price = evaluationManagePriceItem.getPrice();
                BigDecimal evaluationStandardPrice = priceEvaluationStandardHead.getPrice();
                if (evaluationStandardPrice == null || BigDecimal.ZERO.compareTo(evaluationStandardPrice) == 0) {
                    evaluationStandardPrice = BigDecimal.ZERO;
                }
                BigDecimal superEvaluationPrice = null;
                superEvaluationPrice = BigDecimal.ZERO.compareTo(evaluationStandardPrice) == 0 ? BigDecimal.ZERO : price.subtract(evaluationStandardPrice).divide(evaluationStandardPrice, 6, RoundingMode.HALF_UP);
                String evaluationPriceStander = superEvaluationPrice.multiply(new BigDecimal("100")).toString();
                evaluationManagePriceItem.setEvaluationPriceStander(evaluationPriceStander);
                evaluationManagePriceItem.setSourceNumber(purchaseEnquiryItem.getEnquiryNumber());
                evaluationManagePriceItem.setSourceItemNumber(purchaseEnquiryItem.getItemNumber());
                evaluationManagePriceItem.setSourceId(purchaseEnquiryItem.getHeadId());
                evaluationManagePriceItem.setSourceItemId(purchaseEnquiryItem.getId());
            }
            catch (Exception e) {
                this.log.error(e.toString());
                throw new ELSBootException("\u62a5\u4ef7\u4fe1\u606f\u590d\u5236\u5931\u8d25", (Throwable)e, new String[0]);
            }
            purchasePriceEvaluationManagePriceItemList.add(evaluationManagePriceItem);
            for (PurchasePriceEvaluationItem purchasePriceEvaluationItem : purchasePriceEvaluationItems) {
                PurchasePriceEvaluationManageBaseMaterialItem priceEvaluationManageBaseMaterialItem = new PurchasePriceEvaluationManageBaseMaterialItem();
                try {
                    BeanUtils.copyProperties((Object)((Object)purchasePriceEvaluationItem), (Object)((Object)priceEvaluationManageBaseMaterialItem));
                    priceEvaluationManageBaseMaterialItem.setId(IdWorker.getIdStr());
                    priceEvaluationManageBaseMaterialItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                    priceEvaluationManageBaseMaterialItem.setPurchaseRemark(purchasePriceEvaluationItem.getRemark());
                }
                catch (Exception e) {
                    this.log.error(e.toString());
                    throw new ELSBootException("\u6750\u6599\u6210\u672c\u590d\u5236\u5931\u8d25", (Throwable)e, new String[0]);
                }
                purchasePriceEvaluationManageBaseMaterialItemList.add(priceEvaluationManageBaseMaterialItem);
            }
            for (PurchaseProcessingProcedurePriceItem purchaseProcessingProcedurePriceItem : purchaseProcessingProcedurePriceItems) {
                PurchasePriceEvaluationManageProcedurePriceItem priceEvaluationManageProcedurePriceItem = new PurchasePriceEvaluationManageProcedurePriceItem();
                try {
                    BeanUtils.copyProperties((Object)((Object)purchaseProcessingProcedurePriceItem), (Object)((Object)priceEvaluationManageProcedurePriceItem));
                    priceEvaluationManageProcedurePriceItem.setId(IdWorker.getIdStr());
                    priceEvaluationManageProcedurePriceItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                    priceEvaluationManageProcedurePriceItem.setPurchaseRemark(purchaseProcessingProcedurePriceItem.getRemark());
                }
                catch (Exception e) {
                    this.log.error(e.toString());
                    throw new ELSBootException("\u52a0\u5de5\u6210\u672c\u590d\u5236\u5931\u8d25", (Throwable)e, new String[0]);
                }
                purchasePriceEvaluationManageProcedurePriceItemList.add(priceEvaluationManageProcedurePriceItem);
            }
            for (PurchaseManagementClassifyItem managementClassifyItem : purchaseManagementClassifyItems) {
                PurchasePriceEvaluationManageClassifyItem evaluationManageClassifyItem = new PurchasePriceEvaluationManageClassifyItem();
                try {
                    BeanUtils.copyProperties((Object)((Object)managementClassifyItem), (Object)((Object)evaluationManageClassifyItem));
                    evaluationManageClassifyItem.setId(IdWorker.getIdStr());
                    evaluationManageClassifyItem.setHeadId(purchasePriceEvaluationManageHead.getId());
                }
                catch (Exception e) {
                    this.log.error(e.toString());
                    throw new ELSBootException("\u5176\u4ed6\u8d39\u7528\u590d\u5236\u5931\u8d25", (Throwable)e, new String[0]);
                }
                purchasePriceEvaluationManageClassifyItemList.add(evaluationManageClassifyItem);
            }
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : dbpurchaseAttachmentDTOList) {
                PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
                try {
                    BeanUtils.copyProperties((Object)purchaseAttachmentDTO, (Object)attachmentDTO);
                    attachmentDTO.setId(IdWorker.getIdStr());
                    attachmentDTO.setHeadId(purchasePriceEvaluationManageHead.getId());
                    attachmentDTO.setBusinessType("purchasePriceEvaluationManageHead");
                }
                catch (Exception e) {
                    this.log.error(e.toString());
                    throw new ELSBootException("\u9644\u4ef6\u4fe1\u606f\u590d\u5236\u5931\u8d25", (Throwable)e, new String[0]);
                }
                purchaseAttachmentDTOList.add(attachmentDTO);
            }
        }
        this.saveBatch(purchasePriceEvaluationManageHeadList, 200);
        this.purchasePriceEvaluationManagePriceItemService.saveBatch(purchasePriceEvaluationManagePriceItemList, 20);
        this.purchasePriceEvaluationManageBaseMaterialItemService.saveBatch(purchasePriceEvaluationManageBaseMaterialItemList, 200);
        this.purchasePriceEvaluationManageProcedurePriceItemService.saveBatch(purchasePriceEvaluationManageProcedurePriceItemList, 200);
        this.purchasePriceEvaluationManageClassifyItemService.saveBatch(purchasePriceEvaluationManageClassifyItemList, 200);
        this.baseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentDTOList);
    }

    private Map<String, PurchaseInformationRecordsDTO> getEnquiryMaterialPriceInforRecord(PurchaseEnquiryHeadVO headVO, List<PurchaseEnquiryItem> refuseEnquiryItemList) {
        HashMap<String, PurchaseInformationRecordsDTO> informationRecordsDTOMap = new HashMap<String, PurchaseInformationRecordsDTO>();
        if (!CollectionUtils.isEmpty(refuseEnquiryItemList)) {
            for (PurchaseEnquiryItem enquiryItem : refuseEnquiryItemList) {
                ArrayList<String> toElsAccounts = new ArrayList<String>();
                toElsAccounts.add(enquiryItem.getToElsAccount());
                List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectList(toElsAccounts, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), enquiryItem.getMaterialNumber(), headVO.getPurchaseOrg());
                if (CollectionUtils.isEmpty(purchaseInformationRecordsList)) continue;
                informationRecordsDTOMap.put(enquiryItem.getMaterialNumber(), purchaseInformationRecordsList.get(0));
            }
        }
        return informationRecordsDTOMap;
    }

    @Override
    public void cancel(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead) {
        PurchasePriceEvaluationManageHead dbPurchasePriceEvaluationManagement = (PurchasePriceEvaluationManageHead)((Object)this.getById((Serializable)((Object)purchasePriceEvaluationManageHead.getId())));
        if (dbPurchasePriceEvaluationManagement == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u65e0\u6b64\u5355\u636e");
        }
        if (!PurchasePriceEvaluationManagementStatusEnum.WAIT_EVALUATION_PRICE.getValue().equals(dbPurchasePriceEvaluationManagement.getDocumentStatus()) && !PurchasePriceEvaluationManagementStatusEnum.RETURNED.getValue().equals(dbPurchasePriceEvaluationManagement.getDocumentStatus())) {
            throw new ELSBootException("\u5f53\u524d\u72b6\u6001\u975e\u5f85\u6838\u4ef7\u4e0e\u5df2\u9000\u56de\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u8bf7\u68c0\u67e5\u5355\u636e");
        }
        PurchasePriceEvaluationManageHead priceEvaluationManageHead = new PurchasePriceEvaluationManageHead();
        priceEvaluationManageHead.setId(purchasePriceEvaluationManageHead.getId());
        priceEvaluationManageHead.setDocumentStatus(PurchasePriceEvaluationManagementStatusEnum.CANCELED.getValue());
        priceEvaluationManageHead.setDataVersion(purchasePriceEvaluationManageHead.getDataVersion());
        this.updateById((Object)priceEvaluationManageHead);
    }

    @Override
    public void acceptItem(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList) {
        if (CollectionUtils.isEmpty(purchasePriceEvaluationManagePriceItemList)) {
            throw new ELSBootException("\u9009\u62e9\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<PurchasePriceEvaluationManagePriceItem> priceEvaluationManagePriceItemList = new ArrayList<PurchasePriceEvaluationManagePriceItem>();
        for (PurchasePriceEvaluationManagePriceItem purchasePriceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
            PurchasePriceEvaluationManagePriceItem priceEvaluationManagePriceItem = new PurchasePriceEvaluationManagePriceItem();
            priceEvaluationManagePriceItem.setId(purchasePriceEvaluationManagePriceItem.getId());
            priceEvaluationManagePriceItem.setItemStatus(PurchasePriceItemStatusEnum.ACCEPT.getValue());
            priceEvaluationManagePriceItemList.add(priceEvaluationManagePriceItem);
        }
        this.purchasePriceEvaluationManagePriceItemService.updateBatchById(priceEvaluationManagePriceItemList);
    }

    @Override
    public void refuseItem(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList) {
        if (CollectionUtils.isEmpty(purchasePriceEvaluationManagePriceItemList)) {
            throw new ELSBootException("\u9009\u62e9\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<PurchasePriceEvaluationManagePriceItem> priceEvaluationManagePriceItemList = new ArrayList<PurchasePriceEvaluationManagePriceItem>();
        for (PurchasePriceEvaluationManagePriceItem purchasePriceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
            PurchasePriceEvaluationManagePriceItem priceEvaluationManagePriceItem = new PurchasePriceEvaluationManagePriceItem();
            priceEvaluationManagePriceItem.setId(purchasePriceEvaluationManagePriceItem.getId());
            priceEvaluationManagePriceItem.setItemStatus(PurchasePriceItemStatusEnum.REFUSE.getValue());
            priceEvaluationManagePriceItemList.add(priceEvaluationManagePriceItem);
        }
        this.purchasePriceEvaluationManagePriceItemService.updateBatchById(priceEvaluationManagePriceItemList);
    }

    @Override
    public void refund(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList) {
        List<PurchasePriceEvaluationManagePriceItem> priceEvaluationManagePriceItemList = this.purchasePriceEvaluationManagePriceItemService.selectByMainId(purchasePriceEvaluationManageHead.getId());
        for (PurchasePriceEvaluationManagePriceItem purchasePriceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
            PurchasePriceEvaluationManagePriceItem priceEvaluationManagePriceItem = new PurchasePriceEvaluationManagePriceItem();
            priceEvaluationManagePriceItem.setId(purchasePriceEvaluationManagePriceItem.getId());
            priceEvaluationManagePriceItem.setItemStatus(PurchasePriceItemStatusEnum.REFUSE.getValue());
            priceEvaluationManagePriceItem.setSourceItemId(purchasePriceEvaluationManagePriceItem.getSourceItemId());
            priceEvaluationManagePriceItemList.add(priceEvaluationManagePriceItem);
        }
        this.purchasePriceEvaluationManagePriceItemService.updateBatchById(priceEvaluationManagePriceItemList);
        PurchasePriceEvaluationManageHead dbPurchasePriceEvaluationManageHead = (PurchasePriceEvaluationManageHead)((Object)this.getById((Serializable)((Object)purchasePriceEvaluationManageHead.getId())));
        PurchasePriceEvaluationManageHead priceEvaluationManageHead = new PurchasePriceEvaluationManageHead();
        priceEvaluationManageHead.setId(purchasePriceEvaluationManageHead.getId());
        priceEvaluationManageHead.setDocumentStatus(PurchasePriceEvaluationManagementStatusEnum.RETURNED.getValue());
        priceEvaluationManageHead.setDataVersion(purchasePriceEvaluationManageHead.getDataVersion());
        priceEvaluationManageHead.setRemark(dbPurchasePriceEvaluationManageHead.getRemark() + "_" + purchasePriceEvaluationManageHead.getRemark());
        this.updateById((Object)priceEvaluationManageHead);
        this.updataEnquiryItem(priceEvaluationManagePriceItemList);
    }

    @Override
    public void accept(PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead, List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList) {
        List<PurchasePriceEvaluationManagePriceItem> priceEvaluationManagePriceItemList = this.purchasePriceEvaluationManagePriceItemService.selectByMainId(purchasePriceEvaluationManageHead.getId());
        for (PurchasePriceEvaluationManagePriceItem purchasePriceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
            if (!PurchasePriceItemStatusEnum.NEW.getValue().equals(purchasePriceEvaluationManagePriceItem.getItemStatus())) continue;
            PurchasePriceEvaluationManagePriceItem priceEvaluationManagePriceItem = new PurchasePriceEvaluationManagePriceItem();
            priceEvaluationManagePriceItem.setId(purchasePriceEvaluationManagePriceItem.getId());
            priceEvaluationManagePriceItem.setItemStatus(PurchasePriceItemStatusEnum.ACCEPT.getValue());
            priceEvaluationManagePriceItem.setSourceItemId(purchasePriceEvaluationManagePriceItem.getSourceItemId());
            priceEvaluationManagePriceItemList.add(priceEvaluationManagePriceItem);
        }
        this.purchasePriceEvaluationManagePriceItemService.updateBatchById(priceEvaluationManagePriceItemList);
        PurchasePriceEvaluationManageHead dbPriceEvaluationManageHead = (PurchasePriceEvaluationManageHead)((Object)this.getById((Serializable)((Object)purchasePriceEvaluationManageHead.getId())));
        if ("0".equals(dbPriceEvaluationManageHead.getIsAudit())) {
            PurchasePriceEvaluationManageHead dbPurchasePriceEvaluationManageHead = (PurchasePriceEvaluationManageHead)((Object)this.getById((Serializable)((Object)purchasePriceEvaluationManageHead.getId())));
            PurchasePriceEvaluationManageHead priceEvaluationManageHead = new PurchasePriceEvaluationManageHead();
            priceEvaluationManageHead.setId(purchasePriceEvaluationManageHead.getId());
            priceEvaluationManageHead.setDocumentStatus(PurchasePriceEvaluationManagementStatusEnum.HAD_EVALUATION_PRING.getValue());
            priceEvaluationManageHead.setRemark(dbPurchasePriceEvaluationManageHead.getRemark() + "_" + purchasePriceEvaluationManageHead.getRemark());
            this.updateById((Object)priceEvaluationManageHead);
            this.updataEnquiryItem(priceEvaluationManagePriceItemList);
        }
    }

    @Override
    public void updataEnquiryItem(List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList) {
        ArrayList<PurchaseEnquiryItem> enquiryItemList = new ArrayList<PurchaseEnquiryItem>();
        for (PurchasePriceEvaluationManagePriceItem priceEvaluationManagePriceItem : purchasePriceEvaluationManagePriceItemList) {
            PurchaseEnquiryItem enquiryItem = new PurchaseEnquiryItem();
            if (PurchasePriceItemStatusEnum.ACCEPT.getValue().equals(priceEvaluationManagePriceItem.getItemStatus())) {
                enquiryItem.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.EVALUATION_SUCCESS.getValue());
            } else if (PurchasePriceItemStatusEnum.REFUSE.getValue().equals(priceEvaluationManagePriceItem.getItemStatus())) {
                enquiryItem.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.EVALUATION_REFUSE.getValue());
            }
            enquiryItem.setId(priceEvaluationManagePriceItem.getSourceItemId());
            enquiryItemList.add(enquiryItem);
        }
        this.purchaseEnquiryItemService.updateBatchById(enquiryItemList);
    }
}

