/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.mapper.PurchaseTenderEvaluationGroupMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPriceRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadViewVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderEvaluationGroupServiceImpl
extends BaseServiceImpl<PurchaseTenderEvaluationGroupMapper, PurchaseTenderEvaluationGroup>
implements PurchaseTenderEvaluationGroupService {
    @Autowired
    private PurchaseTenderEvaluationRegulationInfoService regulationInfoService;
    @Autowired
    private PurchaseTenderEvaluationPriceRegulationInfoService priceRegulationInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;

    @Override
    public void add(PurchaseTenderEvaluationGroup purchaseTenderEvaluationGroup) {
        ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).insert((Object)purchaseTenderEvaluationGroup);
    }

    @Override
    public void edit(PurchaseTenderEvaluationGroup purchaseTenderEvaluationGroup) {
        int count = ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).updateById((Object)purchaseTenderEvaluationGroup);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByMainId(String headId) {
        ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).deleteByMainId(headId);
    }

    @Override
    public void addTenderEvaluationInfo(PurchaseTenderProjectAttachmentHead attachmentHead, List<PurchaseTenderEvaluationGroupVO> tenderEvaluationInfoVoList) {
        ArrayList purchaseTenderEvaluationRegulationInfoList = new ArrayList(10);
        ArrayList purchaseTenderEvaluationPriceRegulationInfoList = new ArrayList(10);
        List purchaseTenderEvaluationGroupList = tenderEvaluationInfoVoList.stream().map(tenderEvaluationInfoVo -> {
            PurchaseTenderEvaluationPriceRegulationInfo purchaseTenderEvaluationPriceRegulationInfo;
            tenderEvaluationInfoVo.setId(IdWorker.getIdStr());
            tenderEvaluationInfoVo.setSubpackageId(attachmentHead.getSubpackageId());
            tenderEvaluationInfoVo.setHeadId(attachmentHead.getId());
            tenderEvaluationInfoVo.setTenderProjectId(attachmentHead.getTenderProjectId());
            tenderEvaluationInfoVo.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderEvaluationInfoVo.setCheckType(attachmentHead.getCheckType());
            List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = tenderEvaluationInfoVo.getTenderEvaluationTemplateRegulationInfoList();
            if (CollectionUtil.isNotEmpty(regulationInfoList)) {
                for (PurchaseTenderEvaluationRegulationInfo tenderEvaluationRegulationInfo : tenderEvaluationInfoVo.getTenderEvaluationTemplateRegulationInfoList()) {
                    tenderEvaluationRegulationInfo.setSubpackageId(attachmentHead.getSubpackageId());
                    tenderEvaluationRegulationInfo.setTenderProjectId(attachmentHead.getTenderProjectId());
                    tenderEvaluationRegulationInfo.setHeadId(attachmentHead.getId());
                    tenderEvaluationRegulationInfo.setGroupId(tenderEvaluationInfoVo.getId());
                    tenderEvaluationRegulationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                    purchaseTenderEvaluationRegulationInfoList.add(tenderEvaluationRegulationInfo);
                }
            }
            if (null != (purchaseTenderEvaluationPriceRegulationInfo = tenderEvaluationInfoVo.getTenderEvaluationTemplatePriceRegulationInfo())) {
                purchaseTenderEvaluationPriceRegulationInfo.setSubpackageId(attachmentHead.getSubpackageId());
                purchaseTenderEvaluationPriceRegulationInfo.setTenderProjectId(attachmentHead.getTenderProjectId());
                purchaseTenderEvaluationPriceRegulationInfo.setHeadId(attachmentHead.getId());
                purchaseTenderEvaluationPriceRegulationInfo.setGroupId(tenderEvaluationInfoVo.getId());
                purchaseTenderEvaluationPriceRegulationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseTenderEvaluationPriceRegulationInfoList.add(purchaseTenderEvaluationPriceRegulationInfo);
            }
            PurchaseTenderEvaluationGroup purchaseTenderEvaluationGroup = new PurchaseTenderEvaluationGroup();
            BeanUtils.copyProperties((Object)tenderEvaluationInfoVo, (Object)((Object)purchaseTenderEvaluationGroup));
            return purchaseTenderEvaluationGroup;
        }).collect(Collectors.toList());
        this.saveBatch(purchaseTenderEvaluationGroupList, 2000);
        this.regulationInfoService.saveBatch(purchaseTenderEvaluationRegulationInfoList, 2000);
        this.priceRegulationInfoService.saveBatch(purchaseTenderEvaluationPriceRegulationInfoList, 2000);
    }

    @Override
    public List<PurchaseTenderEvaluationGroupVO> queryPurchaseTenderEvaluationInfoVo(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHand) {
        List<PurchaseTenderEvaluationGroup> evaluationInfoList = ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).selectByMainId(purchaseTenderProjectAttachmentHand.getId());
        if (CollectionUtil.isEmpty(evaluationInfoList)) {
            return new ArrayList<PurchaseTenderEvaluationGroupVO>();
        }
        List<String> groupIds = evaluationInfoList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = this.regulationInfoService.selectBatchIds(groupIds);
        Map<String, List<PurchaseTenderEvaluationRegulationInfo>> regulationInfoListMap = regulationInfoList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderEvaluationRegulationInfo::getGroupId));
        List<PurchaseTenderEvaluationPriceRegulationInfo> priceRegulationInfoList = this.priceRegulationInfoService.selectBatchIds(groupIds);
        Map<String, List<PurchaseTenderEvaluationPriceRegulationInfo>> priceRegulationInfoListMap = priceRegulationInfoList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderEvaluationPriceRegulationInfo::getGroupId));
        ArrayList voList = SysUtil.copyProperties(evaluationInfoList, PurchaseTenderEvaluationGroupVO.class);
        voList.stream().forEach(evaluationInfo -> {
            List regulationInfos = (List)regulationInfoListMap.get(evaluationInfo.getId());
            evaluationInfo.setTenderEvaluationTemplateRegulationInfoList(regulationInfos);
            List priceRegulationInfos = (List)priceRegulationInfoListMap.get(evaluationInfo.getId());
            if (priceRegulationInfos != null && priceRegulationInfos.size() > 0) {
                evaluationInfo.setTenderEvaluationTemplatePriceRegulationInfo((PurchaseTenderEvaluationPriceRegulationInfo)((Object)((Object)priceRegulationInfos.get(0))));
            }
        });
        return voList;
    }

    @Override
    public List<PurchaseTenderEvaluationGroup> queryEvaGroupBySubpackageId(String subpackageId) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        return ((PurchaseTenderEvaluationGroupMapper)this.baseMapper).selectBySubpackageId(subpackageId, tenderCheckType, processType, currentStep);
    }

    @Override
    public PurchaseTenderEvaluationGroupVO queryRegulationInfoByEvaGroupId(String evaGroupId) {
        PurchaseTenderEvaluationGroup evaluationGroup = (PurchaseTenderEvaluationGroup)((Object)this.getById((Serializable)((Object)evaGroupId)));
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = (PurchaseTenderEvaluationGroupVO)((Object)SysUtil.copyProperties((Object)((Object)evaluationGroup), PurchaseTenderEvaluationGroupVO.class));
        if (TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(evaluationGroup.getGroupType()) || TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaluationGroup.getGroupType())) {
            List<PurchaseTenderEvaluationPriceRegulationInfo> priceRegulationInfoList = this.priceRegulationInfoService.selectByMainId(evaluationGroup.getId());
            if (!priceRegulationInfoList.isEmpty()) {
                PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = priceRegulationInfoList.get(0);
                evaluationGroupVO.setTenderEvaluationTemplatePriceRegulationInfo(priceRegulationInfo);
            }
        } else {
            List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = this.regulationInfoService.selectByMainId(evaluationGroup.getId());
            evaluationGroupVO.setTenderEvaluationTemplateRegulationInfoList(regulationInfoList);
        }
        return evaluationGroupVO;
    }

    @Override
    public PurchaseTenderProjectAttachmentHeadViewVO queryEvaluationGroup(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadViewVO headViewVO = new PurchaseTenderProjectAttachmentHeadViewVO();
        PurchaseTenderProjectAttachmentHead attachmentHead = this.attachmentHeadService.getAttachmentHeadBySubpackageId(subpackageId);
        BeanUtils.copyProperties((Object)((Object)attachmentHead), (Object)((Object)headViewVO));
        List<PurchaseTenderEvaluationGroupVO> evaluationGroupVOList = this.queryPurchaseTenderEvaluationInfoVo(attachmentHead);
        headViewVO.setTenderEvaluationInfoVoList(evaluationGroupVOList);
        return headViewVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addEvaluationGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, List<PurchaseTenderEvaluationGroupVO> evaluationGroupVOList) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.addTenderEvaluationInfo(purchaseTenderProjectAttachmentHead, evaluationGroupVOList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editEvaluationGroup(PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead, List<PurchaseTenderEvaluationGroupVO> evaluationGroupVOList) {
        this.attachmentHeadService.saveOrUpdate((Object)purchaseTenderProjectAttachmentHead);
        this.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.regulationInfoService.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.priceRegulationInfoService.deleteByMainId(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.addTenderEvaluationInfo(purchaseTenderProjectAttachmentHead, evaluationGroupVOList);
    }
}

