/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.calibration.entity.BidWinningAffirmInform;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmInformEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmInfomMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.service.BidWinningAffirmInformService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmInformVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmItemVo;
import com.els.modules.tender.calibration.vo.BidWinningAffirmPriceItemVo;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageEvaBidTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.entity.SaleTenderProjectBidWinningAffirmItem;
import com.els.modules.tender.sale.service.SaleTenderProjectBidWinningAffirmItemService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BidWinningAffirmInformServiceImpl
extends BaseServiceImpl<BidWinningAffirmInfomMapper, BidWinningAffirmInform>
implements BidWinningAffirmInformService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private BidWinningAffirmHeadService bidWinningAffirmHeadService;
    @Autowired
    private SaleTenderProjectBidWinningAffirmItemService saleBidWinningAffirmItemService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = new BidWinningAffirmInform();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), (Object)((Object)purchaseTenderBidWinningAffirmInform));
        purchaseTenderBidWinningAffirmInform.setStatus(BidWinningAffirmInformEnum.NEW.getValue());
        ((BidWinningAffirmInfomMapper)this.baseMapper).insert((Object)purchaseTenderBidWinningAffirmInform);
        this.saveMain(purchaseTenderBidWinningAffirmInformVo, purchaseTenderBidWinningAffirmInform);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = new BidWinningAffirmInform();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), (Object)((Object)purchaseTenderBidWinningAffirmInform));
        int count = ((BidWinningAffirmInfomMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningAffirmInform);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saveMain(purchaseTenderBidWinningAffirmInformVo, purchaseTenderBidWinningAffirmInform);
    }

    @Override
    public BidWinningAffirmInformVo queryBySubpackageId(String subpackageId) {
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmItemList;
        BidWinningAffirmInformVo affirmInformVo = new BidWinningAffirmInformVo();
        List<BidWinningAffirmInform> bidWinningAffirmInformList = ((BidWinningAffirmInfomMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (!bidWinningAffirmInformList.isEmpty()) {
            BeanUtils.copyProperties((Object)((Object)bidWinningAffirmInformList.get(0)), (Object)((Object)affirmInformVo));
        }
        TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        affirmInformVo.setEvaluationType(subpackageInfo.getEvaluationType());
        if (!SubpackageEvaBidTypeEnum.OFF_LINE.getValue().equals(subpackageInfo.getEvaluationType())) {
            PurchaseTenderBidLetterFormatGroupVO formatGroupVO = this.attachmentHeadService.queryBidLetterFormatGroup(subpackageId);
            String quoteType = formatGroupVO.getQuoteType();
            affirmInformVo.setQuoteType(quoteType);
        }
        if (CollectionUtil.isEmpty(bidWinningAffirmItemList = this.bidWinningAffirmHeadService.queryAffirmItemVoList(subpackageId))) {
            return affirmInformVo;
        }
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = bidWinningAffirmItemList.stream().map(item -> {
            BidWinningAffirmItemVo itemVo = new BidWinningAffirmItemVo();
            BeanUtils.copyProperties((Object)item, (Object)((Object)itemVo));
            List PurchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(itemVo.getId());
            itemVo.setPurchaseAttachmentDemandDTOList(PurchaseAttachmentDTOList);
            return itemVo;
        }).collect(Collectors.toList());
        affirmInformVo.setBidWinningAffirmItemVoList(bidWinningAffirmItemVoList);
        return affirmInformVo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmInformVo affirmInformVo) {
        if (StringUtils.isNotBlank((CharSequence)affirmInformVo.getId())) {
            this.edit(affirmInformVo);
        } else {
            this.add(affirmInformVo);
        }
        BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo = this.queryBySubpackageId(affirmInformVo.getSubpackageId());
        this.checkParam(purchaseTenderBidWinningAffirmInformVo);
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList winningAffirmItems = SysUtil.copyProperties(bidWinningAffirmItemVoList, BidWinningAffirmItem.class);
        this.saveSaleBidWinningAffirmItem(purchaseTenderBidWinningAffirmInformVo.getSubpackageId(), winningAffirmItems);
        ArrayList<PurchaseAttachmentDTO> PurchaseAttachmentDTOArray = new ArrayList<PurchaseAttachmentDTO>();
        for (BidWinningAffirmItemVo bidWinningAffirmItemVo : bidWinningAffirmItemVoList) {
            if (!CollectionUtil.isNotEmpty(bidWinningAffirmItemVo.getPurchaseAttachmentDemandDTOList())) continue;
            PurchaseAttachmentDTOArray.addAll(bidWinningAffirmItemVo.getPurchaseAttachmentDemandDTOList());
        }
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(PurchaseAttachmentDTOArray, affirmInformVo.getId(), affirmInformVo.getSubpackageId(), affirmInformVo.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.TENDER_WINNING_AFFIRM_INFORM_PREFIX.getValue());
        BidWinningAffirmInform bidWinningAffirmInform = (BidWinningAffirmInform)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderBidWinningAffirmInformVo), BidWinningAffirmInform.class));
        bidWinningAffirmInform.setStatus(BidWinningAffirmInformEnum.ISSUE.getValue());
        this.updateById((Object)bidWinningAffirmInform);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmInform, TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_FINISH.getValue() + "");
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(bidWinningAffirmInform.getTenderProjectId()).append("&subpackageId=").append(bidWinningAffirmInform.getSubpackageId()).append("&businessId=").append(bidWinningAffirmInform.getId());
        List toElsAccountList = bidWinningAffirmItemVoList.stream().map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(affirmInformVo.getSubpackageId());
        this.sendMsg(TenantContext.getTenant(), toElsAccountList, purchaseTenderProjectInfoVO, urlParams.toString(), "tender", "tenderBidWinningAffirmInfo");
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSucceed(String id) {
        BidWinningAffirmInform bidWinningAffirmInform = (BidWinningAffirmInform)((Object)((BidWinningAffirmInfomMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmItemList = this.bidWinningAffirmHeadService.queryAffirmItemVoList(bidWinningAffirmInform.getSubpackageId());
        ArrayList bidWinningAffirmItems = SysUtil.copyProperties(bidWinningAffirmItemList, BidWinningAffirmItem.class);
        this.saveSaleBidWinningAffirmItem(bidWinningAffirmInform.getSubpackageId(), bidWinningAffirmItems);
    }

    private void saveSaleBidWinningAffirmItem(String subpackageId, List<BidWinningAffirmItem> itemList) {
        List saleItemList = itemList.stream().map(item -> {
            SaleTenderProjectBidWinningAffirmItem saleTenderProjectBidWinningAffirmItem = new SaleTenderProjectBidWinningAffirmItem();
            BeanUtils.copyProperties((Object)item, (Object)((Object)saleTenderProjectBidWinningAffirmItem));
            saleTenderProjectBidWinningAffirmItem.setElsAccount(saleTenderProjectBidWinningAffirmItem.getSupplierAccount());
            return saleTenderProjectBidWinningAffirmItem;
        }).collect(Collectors.toList());
        this.saleBidWinningAffirmItemService.deleteBySubpackageId(subpackageId);
        this.saleBidWinningAffirmItemService.saveBatch(saleItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BidWinningAffirmInform purchaseTenderBidWinningAffirmInform = (BidWinningAffirmInform)((Object)this.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTenderBidWinningAffirmInform.setFlowId(outputParamVO.getProcessRootId());
        purchaseTenderBidWinningAffirmInform.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        String subPackageStatus = null;
        String status = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_FINISH.getValue() + "";
            status = BidWinningAffirmInformEnum.ISSUE.getValue();
            this.publishSucceed(inputParamVO.getBusinessId());
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_REJECT.getValue() + "";
            status = BidWinningAffirmInformEnum.NEW.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_EDIT.getValue() + "";
            status = BidWinningAffirmInformEnum.NEW.getValue();
        } else {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_AUDIT.getValue() + "";
            status = BidWinningAffirmInformEnum.NOT_ISSUE.getValue();
        }
        purchaseTenderBidWinningAffirmInform.setAuditStatus(auditStatus);
        purchaseTenderBidWinningAffirmInform.setStatus(status);
        ((BidWinningAffirmInfomMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningAffirmInform);
        this.updateTenderProjectSubpackageInfo(purchaseTenderBidWinningAffirmInform, subPackageStatus);
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmInform purchaseTenderBidWinningAffirmInform, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)purchaseTenderBidWinningAffirmInform).subpackageId(purchaseTenderBidWinningAffirmInform.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    public BidWinningAffirmInform queryById(String id) {
        return (BidWinningAffirmInform)((Object)((BidWinningAffirmInfomMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    private void checkParam(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo) {
        Assert.hasText((String)purchaseTenderBidWinningAffirmInformVo.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_ba7b51", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        List<BidWinningAffirmItemVo> winningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(winningAffirmItemVoList), (String)I18nUtil.translate((String)"i18n_alert_sBeRLxOLVW_99104ebc", (String)"\u4e2d\u6807\u901a\u77e5\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        winningAffirmItemVoList.forEach(itemVo -> {
            List<PurchaseAttachmentDTO> PurchaseAttachmentDTOList = itemVo.getPurchaseAttachmentDemandDTOList();
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(PurchaseAttachmentDTOList), (String)I18nUtil.translate((String)"i18n_alert_sBeRLBIxOLVW_540b760a", (String)"\u4e2d\u6807\u901a\u77e5\u4eba\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        });
    }

    private void saveMain(BidWinningAffirmInformVo purchaseTenderBidWinningAffirmInformVo, BidWinningAffirmInform purchaseTenderBidWinningAffirmInform) {
        List<BidWinningAffirmItemVo> bidWinningAffirmItemVoList = purchaseTenderBidWinningAffirmInformVo.getBidWinningAffirmItemVoList();
        ArrayList PurchaseAttachmentDTOList = new ArrayList();
        ArrayList headIds = new ArrayList();
        bidWinningAffirmItemVoList.stream().forEach(item -> {
            List<PurchaseAttachmentDTO> PurchaseAttachmentDTOArray = item.getPurchaseAttachmentDemandDTOList();
            headIds.add(item.getId());
            PurchaseAttachmentDTOArray.parallelStream().forEach(attachment -> attachment.setHeadId(item.getId()));
            PurchaseAttachmentDTOList.addAll(PurchaseAttachmentDTOArray);
        });
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(headIds);
        if (!PurchaseAttachmentDTOList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(PurchaseAttachmentDTOList);
        }
        this.updateTenderProjectSubpackageInfo(purchaseTenderBidWinningAffirmInform, TenderProjectSubpackageStatusEnum.BID_WINNING_AFFIRM_INFORM_EDIT.getValue() + "");
    }
}

