/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringItem;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringHead;
import com.els.modules.tender.clarification.entity.SaleTenderMentoringItem;
import com.els.modules.tender.clarification.enumerate.TenderMentoringResponderTypeEnum;
import com.els.modules.tender.clarification.enumerate.TenderMentoringStatusEnum;
import com.els.modules.tender.clarification.mapper.PurchaseTenderMentoringHeadMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderMentoringHeadService;
import com.els.modules.tender.clarification.service.PurchaseTenderMentoringItemService;
import com.els.modules.tender.clarification.service.SaleTenderMentoringHeadService;
import com.els.modules.tender.clarification.vo.PurchaseTenderMentoringItemVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PurchaseTenderMentoringHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderMentoringHeadMapper, PurchaseTenderMentoringHead>
implements PurchaseTenderMentoringHeadService {
    @Autowired
    private PurchaseTenderMentoringItemService purchaseTenderMentoringItemService;
    @Lazy
    @Autowired
    private SaleTenderMentoringHeadService saleTenderMentoringHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;

    @Override
    @SrmTransaction
    public PurchaseTenderMentoringHead add(SaleTenderMentoringHead saleTenderMentoringHead, List<SaleTenderMentoringItem> saleTenderMentoringItems, List<SaleAttachmentDTO> saleAttachmentDTOS) {
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = new PurchaseTenderMentoringHead();
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.purchaseTenderProjectSubpackageInfoService.selectById(saleTenderMentoringHead.getSubpackageId());
        BeanUtils.copyProperties((Object)((Object)saleTenderMentoringHead), (Object)((Object)purchaseTenderMentoringHead), (String[])new String[]{"id"});
        purchaseTenderMentoringHead.setRelationId(saleTenderMentoringHead.getId());
        purchaseTenderMentoringHead.setId(IdWorker.getIdStr());
        purchaseTenderMentoringHead.setStatus(TenderMentoringStatusEnum.NEW.getValue());
        purchaseTenderMentoringHead.setElsAccount(purchaseTenderProjectSubpackageInfo.getElsAccount());
        ArrayList purchaseTenderMentoringItems = SysUtil.copyProperties(saleTenderMentoringItems, PurchaseTenderMentoringItem.class);
        purchaseTenderMentoringItems.forEach(item -> {
            item.setId(IdWorker.getIdStr());
            item.setHeadId(purchaseTenderMentoringHead.getId());
            item.setElsAccount(purchaseTenderProjectSubpackageInfo.getElsAccount());
        });
        ((PurchaseTenderMentoringHeadMapper)this.baseMapper).insert((Object)purchaseTenderMentoringHead);
        this.purchaseTenderMentoringItemService.saveBatch(purchaseTenderMentoringItems, 2000);
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOS)) {
            ArrayList purchaseAttachmentDTOS = SysUtil.copyProperties(saleAttachmentDTOS, PurchaseAttachmentDTO.class);
            purchaseAttachmentDTOS.forEach(purchaseAttachmentDTO -> {
                purchaseAttachmentDTO.setId(IdWorker.getIdStr());
                purchaseAttachmentDTO.setHeadId(purchaseTenderMentoringHead.getId());
                purchaseAttachmentDTO.setRelationId(((PurchaseTenderMentoringItem)((Object)((Object)purchaseTenderMentoringItems.get(0)))).getId());
            });
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentDTOS);
        }
        return purchaseTenderMentoringHead;
    }

    @Override
    @SrmTransaction
    public PurchaseTenderMentoringItem purchaseReply(PurchaseTenderMentoringItemVO purchaseTenderMentoringItemVO) {
        Assert.isTrue((boolean)StringUtils.hasText((String)purchaseTenderMentoringItemVO.getHeadId()), (String)I18nUtil.translate((String)"i18n_alert_eWWxOLV_70d999ff", (String)"\u5934Id\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseTenderMentoringItem purchaseTenderMentoringItem = (PurchaseTenderMentoringItem)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderMentoringItemVO), PurchaseTenderMentoringItem.class));
        purchaseTenderMentoringItem.setId(IdWorker.getIdStr());
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseTenderMentoringItem.setResponder(loginUser.getElsAccount());
        purchaseTenderMentoringItem.setResponderName(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        purchaseTenderMentoringItem.setResponderType(TenderMentoringResponderTypeEnum.RESPONDER.getValue());
        this.purchaseTenderMentoringItemService.save((Object)purchaseTenderMentoringItem);
        List<PurchaseAttachmentDTO> purchaseAttachmentList = purchaseTenderMentoringItemVO.getPurchaseAttachmentList();
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            purchaseAttachmentList.parallelStream().forEach(item -> {
                item.setHeadId(purchaseTenderMentoringItem.getHeadId());
                item.setRelationId(purchaseTenderMentoringItem.getId());
                item.setUploadElsAccount(loginUser.getElsAccount());
                item.setUploadSubAccount(loginUser.getSubAccount());
            });
            this.invokeBaseRpcService.updatePurchaseAttachmentBatchById(purchaseAttachmentList);
        }
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = (PurchaseTenderMentoringHead)((Object)((PurchaseTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderMentoringItem.getHeadId())));
        purchaseTenderMentoringHead.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        ((PurchaseTenderMentoringHeadMapper)this.baseMapper).updateById((Object)purchaseTenderMentoringHead);
        this.saleTenderMentoringHeadService.purchaseReply(purchaseTenderMentoringHead, purchaseTenderMentoringItem, purchaseAttachmentList);
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(purchaseTenderMentoringHead.getQuestioner());
        String operation = "purchaseReplyMentoring";
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(purchaseTenderMentoringHead.getCheckType())) {
            operation = "prePurchaseReplyMentoring";
        }
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(purchaseTenderMentoringHead.getTenderProjectId()).append("&subpackageId=").append(purchaseTenderMentoringHead.getSubpackageId());
        this.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)purchaseTenderMentoringHead, urlParams.toString(), "tender", operation);
        return purchaseTenderMentoringItem;
    }

    @Override
    @SrmTransaction
    public void saleReply(SaleTenderMentoringHead saleTenderMentoringHead, SaleTenderMentoringItem saleTenderMentoringItem, List<SaleAttachmentDTO> saleAttachmentList) {
        Assert.isTrue((boolean)StringUtils.hasText((String)saleTenderMentoringHead.getRelationId()), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVKHRvjW_e5feb3d4", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = (PurchaseTenderMentoringHead)((Object)((PurchaseTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleTenderMentoringHead.getRelationId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderMentoringHead)), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVXVsKW_103fda81", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        purchaseTenderMentoringHead.setStatus(TenderMentoringStatusEnum.REPLIED.getValue());
        purchaseTenderMentoringHead.setRelationId(saleTenderMentoringHead.getId());
        PurchaseTenderMentoringItem purchaseTenderMentoringItem = (PurchaseTenderMentoringItem)((Object)SysUtil.copyProperties((Object)((Object)saleTenderMentoringItem), PurchaseTenderMentoringItem.class));
        purchaseTenderMentoringItem.setId(IdWorker.getIdStr());
        purchaseTenderMentoringItem.setHeadId(purchaseTenderMentoringHead.getId());
        purchaseTenderMentoringItem.setElsAccount(purchaseTenderMentoringHead.getElsAccount());
        ((PurchaseTenderMentoringHeadMapper)this.baseMapper).updateById((Object)purchaseTenderMentoringHead);
        this.purchaseTenderMentoringItemService.save((Object)purchaseTenderMentoringItem);
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            ArrayList purchaseAttachmentDTOList = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
            purchaseAttachmentDTOList.parallelStream().forEach(item -> {
                item.setHeadId(purchaseTenderMentoringItem.getHeadId());
                item.setRelationId(purchaseTenderMentoringItem.getId());
            });
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentDTOList);
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentList, saleTenderMentoringItem.getId(), saleTenderMentoringItem.getSubpackageId(), saleTenderMentoringItem.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.ANSWER_QUESTIONS_PREFIX.getValue());
        }
    }

    @Override
    public void close(String id) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = (PurchaseTenderMentoringHead)((Object)((PurchaseTenderMentoringHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        purchaseTenderMentoringHead.setStatus(TenderMentoringStatusEnum.CLOSE.getValue());
        ((PurchaseTenderMentoringHeadMapper)this.baseMapper).updateById((Object)purchaseTenderMentoringHead);
    }

    @Override
    public void deleteMain(String id) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(PurchaseTenderMentoringItem::getHeadId, (Object)id);
        this.purchaseTenderMentoringItemService.remove((Wrapper)qw);
        this.removeById((Serializable)((Object)id));
    }
}

