/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PriceModel;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceHead;
import com.els.modules.tender.evaluation.entity.TenderEvaQuotedPriceItem;
import com.els.modules.tender.evaluation.enumerate.TenderEvaQuotedPriceHeadStatusEnum;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaQuotedPriceItemService;
import com.els.modules.tender.evaluation.vo.EvaQuotedPriceSortVO;
import com.els.modules.tender.evaluation.vo.TenderEvaQuotedPriceHeadVO;
import com.els.modules.tender.evaluation.vo.TenderEvaQuotedPriceItemVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/evaluation/tenderEvaQuotedPriceHead"})
@Api(tags={"\u8bc4\u6807\u62a5\u4ef7\u5934"})
public class TenderEvaQuotedPriceHeadController
extends BaseController<TenderEvaQuotedPriceHead, TenderEvaQuotedPriceHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TenderEvaQuotedPriceHeadController.class);
    @Autowired
    private TenderEvaQuotedPriceHeadService tenderEvaQuotedPriceHeadService;
    @Autowired
    private TenderEvaQuotedPriceItemService tenderEvaQuotedPriceItemService;
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryList(TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderEvaQuotedPriceHead), (Map)req.getParameterMap());
        queryWrapper.orderByDesc((Object)"stage");
        TenderFlagInjectionContext.setTenderCheckType("1");
        List list = this.tenderEvaQuotedPriceHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Result.ok();
        }
        Set<String> mainIds = list.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        List<TenderEvaQuotedPriceItem> tenderEvaQuotedPriceItems = this.tenderEvaQuotedPriceItemService.selectByMainIds(mainIds, null);
        ArrayList tenderEvaQuotedPriceItemVOS = SysUtil.copyProperties(tenderEvaQuotedPriceItems, TenderEvaQuotedPriceItemVO.class);
        List<String> supplierAccounts = tenderEvaQuotedPriceItems.stream().map(TenderEvaQuotedPriceItem::getSupplierAccount).collect(Collectors.toList());
        List<SaleTenderPriceOpenings> saleTenderPriceOpenings = this.saleTenderPriceOpeningsService.getSalePriceOpeningsBySubpackageId(tenderEvaQuotedPriceItems.get(0).getSubpackageId(), supplierAccounts, "1");
        Map<String, List<SaleTenderPriceOpenings>> priceOpeningsMap = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
        ArrayList allEvaQuotedPriceSortVOList = new ArrayList();
        priceOpeningsMap.forEach((bidLetterId, priceOpeningsList) -> this.build((List<SaleTenderPriceOpenings>)priceOpeningsList, allEvaQuotedPriceSortVOList));
        Map<String, List<EvaQuotedPriceSortVO>> evaQuotedPriceSortMap = allEvaQuotedPriceSortVOList.stream().collect(Collectors.groupingBy(EvaQuotedPriceSortVO::getItemId));
        for (TenderEvaQuotedPriceItemVO tenderEvaQuotedPriceItemVO : tenderEvaQuotedPriceItemVOS) {
            List<EvaQuotedPriceSortVO> evaQuotedPriceSortVOList = evaQuotedPriceSortMap.get(tenderEvaQuotedPriceItemVO.getId());
            tenderEvaQuotedPriceItemVO.setQuotedPrice(evaQuotedPriceSortVOList);
        }
        ArrayList tenderEvaQuotedPriceHeadVOS = SysUtil.copyProperties((List)list, TenderEvaQuotedPriceHeadVO.class);
        Map<String, List<TenderEvaQuotedPriceItemVO>> itemMap = tenderEvaQuotedPriceItemVOS.stream().collect(Collectors.groupingBy(TenderEvaQuotedPriceItem::getHeadId));
        for (TenderEvaQuotedPriceHeadVO headVO : tenderEvaQuotedPriceHeadVOS) {
            List<TenderEvaQuotedPriceItemVO> tenderEvaQuotedPriceItemList = itemMap.get(headVO.getId());
            if (TenderEvaQuotedPriceHeadStatusEnum.EVA_QUOTED_PRICE.getValue().equals(headVO.getStatus())) {
                for (TenderEvaQuotedPriceItemVO tenderEvaQuotedPriceItemVO : tenderEvaQuotedPriceItemList) {
                    tenderEvaQuotedPriceItemVO.setQuotedPrice(null);
                }
            }
            headVO.setTenderEvaQuotedPriceItemList(tenderEvaQuotedPriceItemList);
        }
        return Result.ok((Object)tenderEvaQuotedPriceHeadVOS);
    }

    private void build(List<SaleTenderPriceOpenings> saleTenderPriceOpenings, List<EvaQuotedPriceSortVO> allEvaQuotedPriceSortVOList) {
        ArrayList<EvaQuotedPriceSortVO> evaQuotedPriceSortVOList = new ArrayList<EvaQuotedPriceSortVO>();
        for (SaleTenderPriceOpenings saleTenderPriceOpening : saleTenderPriceOpenings) {
            List priceModels = JSONObject.parseArray((String)saleTenderPriceOpening.getPriceData(), PriceModel.class);
            if (CollectionUtil.isEmpty((Collection)priceModels)) continue;
            for (PriceModel priceModel : priceModels) {
                EvaQuotedPriceSortVO sortVO = new EvaQuotedPriceSortVO();
                sortVO.setTitle(priceModel.getTitle());
                sortVO.setItemId(saleTenderPriceOpening.getQuotedPriceItemId());
                sortVO.setPrice(priceModel.getPrice());
                sortVO.setSequence(priceModel.getSort());
                evaQuotedPriceSortVOList.add(sortVO);
            }
        }
        allEvaQuotedPriceSortVOList.addAll(evaQuotedPriceSortVOList);
    }

    @AutoLog(busModule="\u8bc4\u6807\u62a5\u4ef7\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> add(@RequestBody TenderEvaQuotedPriceHeadVO tenderEvaQuotedPriceHeadPage) {
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = new TenderEvaQuotedPriceHead();
        BeanUtils.copyProperties((Object)((Object)tenderEvaQuotedPriceHeadPage), (Object)((Object)tenderEvaQuotedPriceHead));
        ArrayList tenderEvaQuotedPriceItems = SysUtil.copyProperties(tenderEvaQuotedPriceHeadPage.getTenderEvaQuotedPriceItemList(), TenderEvaQuotedPriceItem.class);
        this.tenderEvaQuotedPriceHeadService.saveMain(tenderEvaQuotedPriceHead, tenderEvaQuotedPriceItems);
        return Result.ok((Object)((Object)tenderEvaQuotedPriceHead));
    }

    @AutoLog(busModule="\u7ed3\u675f\u62a5\u4ef7", value="\u7ed3\u675f\u62a5\u4ef7")
    @ApiOperation(value="\u7ed3\u675f\u62a5\u4ef7", notes="\u7ed3\u675f\u62a5\u4ef7")
    @GetMapping(value={"/finish"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> finish(@RequestParam(name="id") String id) {
        this.tenderEvaQuotedPriceHeadService.finish(id);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryByItemId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryByItemId(@RequestParam(name="itemId") String itemId) {
        TenderFlagInjectionContext.setTenderCheckType("1");
        TenderEvaQuotedPriceItem tenderEvaQuotedPriceItem = (TenderEvaQuotedPriceItem)((Object)this.tenderEvaQuotedPriceItemService.getById((Serializable)((Object)itemId)));
        TenderEvaQuotedPriceHead tenderEvaQuotedPriceHead = (TenderEvaQuotedPriceHead)((Object)this.tenderEvaQuotedPriceHeadService.getById((Serializable)((Object)tenderEvaQuotedPriceItem.getHeadId())));
        TenderFlagInjectionContext.setTenderCheckType("1");
        TenderFlagInjectionContext.setTenderProcessType(tenderEvaQuotedPriceHead.getProcessType());
        TenderFlagInjectionContext.setTenderCurrentStep(tenderEvaQuotedPriceHead.getCurrentStep());
        List<SaleTenderBidLetterVo> saleTenderBidLetterVos = this.saleTenderPriceOpeningsService.selectByQuotedPriceItemId(tenderEvaQuotedPriceItem);
        return Result.ok(saleTenderBidLetterVos);
    }
}

