/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaGroupSummaryResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaGroupSummaryResultMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaSettingHeadService;
import com.els.modules.tender.evaluation.vo.EvaGroupVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidEvaGroupSummaryResultServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaGroupSummaryResultMapper, PurchaseTenderProjectBidEvaGroupSummaryResult>
implements PurchaseTenderProjectBidEvaGroupSummaryResultService {
    @Autowired
    @Lazy
    private PurchaseTenderProjectEvaSettingHeadService evaSettingHeadService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectBidEvaRegulationResultService evaRegulationResultService;

    @Override
    public void add(PurchaseTenderProjectBidEvaGroupSummaryResult purchaseTenderProjectBidEvaGroupSummaryResult) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).insert((Object)purchaseTenderProjectBidEvaGroupSummaryResult);
    }

    @Override
    public void edit(PurchaseTenderProjectBidEvaGroupSummaryResult purchaseTenderProjectBidEvaGroupSummaryResult) {
        int count = ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).updateById((Object)purchaseTenderProjectBidEvaGroupSummaryResult);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SupplierEvaRankingVO> selectEvaGroupSummaryResultByMainId(String evaInfoId, String evaGroupId) {
        ArrayList<SupplierEvaRankingVO> result = new ArrayList<SupplierEvaRankingVO>();
        List<PurchaseTenderProjectBidEvaGroupSummaryResult> bidEvaGroupSummaryResultList = ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).selectByMainId(evaInfoId, evaGroupId);
        if (CollectionUtil.isEmpty(bidEvaGroupSummaryResultList)) {
            return result;
        }
        PurchaseTenderProjectBidEvaGroupSummaryResult summaryResult = bidEvaGroupSummaryResultList.get(0);
        List<EvaGroupVO> groupVOList = this.evaSettingHeadService.queryEvaGroupBySubpackageId(summaryResult.getSubpackageId());
        List<PurchaseTenderProjectBidEvaRegulationResult> bidEvaRegulationResultList = this.evaRegulationResultService.selectByEvaInfoId(evaInfoId, evaGroupId);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> bidEvaRegulationResultListSupplierAccountMap = bidEvaRegulationResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        boolean existPriceComparison = false;
        for (EvaGroupVO evaGroupVO : groupVOList) {
            if (!TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(evaGroupVO.getType())) continue;
            existPriceComparison = true;
            break;
        }
        Map<String, EvaGroupVO> evaGroupVOMap = groupVOList.stream().collect(Collectors.toMap(EvaGroupVO::getId, Function.identity()));
        Map<String, List<PurchaseTenderProjectBidEvaGroupSummaryResult>> supplierAccountListMap = bidEvaGroupSummaryResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaGroupSummaryResult::getSupplierAccount));
        for (String supplierAccount : supplierAccountListMap.keySet()) {
            SupplierEvaRankingVO rankingVO = new SupplierEvaRankingVO();
            List<PurchaseTenderProjectBidEvaGroupSummaryResult> summaryResults = supplierAccountListMap.get(supplierAccount);
            List<PurchaseTenderProjectBidEvaRegulationResult> evaRegulationResultList = bidEvaRegulationResultListSupplierAccountMap.get(supplierAccount);
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> bidEvaRegulationResultListMap = evaRegulationResultList.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getEvaGroupId));
            if (summaryResults.isEmpty()) continue;
            rankingVO.setSupplierAccount(summaryResults.get(0).getSupplierAccount());
            rankingVO.setSupplierName(summaryResults.get(0).getSupplierName());
            rankingVO.setExistPriceComparison(existPriceComparison);
            this.calculateResult(rankingVO, summaryResults, evaGroupVOMap, bidEvaRegulationResultListMap);
            result.add(rankingVO);
        }
        return result;
    }

    private void calculateResult(SupplierEvaRankingVO rankingVO, List<PurchaseTenderProjectBidEvaGroupSummaryResult> summaryResults, Map<String, EvaGroupVO> evaGroupVOMap, Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> bidEvaRegulationResultListMap) {
        Map groupResultListMap = summaryResults.stream().sorted(Comparator.comparingInt(PurchaseTenderProjectBidEvaGroupSummaryResult::getGroupOrderBy)).collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaGroupSummaryResult::getEvaGroupId, LinkedHashMap::new, Collectors.toList()));
        for (String groupId : groupResultListMap.keySet()) {
            List summaryResultList = (List)groupResultListMap.get(groupId);
            if (CollectionUtil.isEmpty((Collection)summaryResultList)) continue;
            PurchaseTenderProjectBidEvaGroupSummaryResult summaryResult = (PurchaseTenderProjectBidEvaGroupSummaryResult)((Object)summaryResultList.get(0));
            List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = bidEvaRegulationResultListMap.get(groupId);
            SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = SupplierEvaRankingVO.EvaGroupSummaryResult.builder().evaGroupId(summaryResult.getEvaGroupId()).evaGroupName(evaGroupVOMap.get(summaryResult.getEvaGroupId()) == null ? null : evaGroupVOMap.get(summaryResult.getEvaGroupId()).getName()).evaGroupType(summaryResult.getEvaGroupType()).totalScore(summaryResult.getScore()).totalQuote(summaryResult.getTotalQuote()).invalid(summaryResult.getInvalid()).orderBy(summaryResult.getOrderBy()).groupOrder(summaryResult.getGroupOrderBy()).weight(summaryResult.getWeight()).evaGroupResult(summaryResult.getResult()).build();
            rankingVO.setResultMap(groupId, evaGroupSummaryResult);
            if (!TenderEvaGroupTypeEnum.PRICE_COMPARISON.getValue().equals(summaryResult.getEvaGroupType())) continue;
            rankingVO.setOrder(summaryResult.getOrderBy());
            evaGroupSummaryResult.setSummaryRegulationResultList(regulationResultList);
        }
        Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> groupResultMap = rankingVO.getResult();
        BigDecimal totalScore = BigDecimal.ZERO;
        for (String key : groupResultMap.keySet()) {
            SupplierEvaRankingVO.EvaGroupSummaryResult summaryResult = groupResultMap.get(key);
            rankingVO.setInvalid(summaryResult.getInvalid());
            if ("1".equals(summaryResult.getInvalid())) break;
            totalScore = totalScore.add(summaryResult.getTotalScore() == null ? BigDecimal.ZERO : summaryResult.getTotalScore());
        }
        rankingVO.setTotalScore(totalScore);
    }

    @Override
    public void deleteByMainId(String evaInfoId, String evaGroupId) {
        ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).deleteByMainId(evaInfoId, evaGroupId);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaGroupSummaryResult> selectBySubpackageId(String subpackageId) {
        return ((PurchaseTenderProjectBidEvaGroupSummaryResultMapper)this.baseMapper).selectBySubpackageId(subpackageId, TenderFlagInjectionContext.getTenderCheckType());
    }

    @Override
    public List<SupplierEvaRankingVO> getSupplierEvaRanking(String evaInfoId) {
        List<SupplierEvaRankingVO> result = this.selectEvaGroupSummaryResultByMainId(evaInfoId, null);
        boolean existPriceComparison = result.get(0).isExistPriceComparison();
        ArrayList<SupplierEvaRankingVO> invalidSupplierList = new ArrayList<SupplierEvaRankingVO>();
        Iterator<SupplierEvaRankingVO> iterator = result.iterator();
        while (iterator.hasNext()) {
            SupplierEvaRankingVO next = iterator.next();
            if (!"1".equals(next.getInvalid())) continue;
            next.setResult(null);
            next.setTotalScore(BigDecimal.ZERO);
            invalidSupplierList.add(next);
            iterator.remove();
        }
        if (!existPriceComparison) {
            result.sort(Comparator.comparing(SupplierEvaRankingVO::getTotalScore).reversed());
            int order = 1;
            if (!result.isEmpty()) {
                LinkedHashMap<Double, Integer> orderByMap = new LinkedHashMap<Double, Integer>();
                for (SupplierEvaRankingVO supplierEvaRankingVO : result) {
                    BigDecimal totalScore = supplierEvaRankingVO.getTotalScore();
                    Integer index = (Integer)orderByMap.get(totalScore.doubleValue());
                    if (index == null) {
                        index = order;
                    }
                    supplierEvaRankingVO.setOrder(index);
                    orderByMap.put(totalScore.doubleValue(), index);
                    index = index + 1;
                    order = index;
                }
            }
        }
        result.addAll(invalidSupplierList);
        return result;
    }
}

