/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.price.handler;

import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="operationMinPriceStrategy")
public class OperationMinPriceStrategy
implements TemplatePriceStrategy {
    @Override
    public void priceScoreCalculate(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderEvaluationPrinciples evaluationPrinciples) {
        Integer score = evaluationGroupVO.getScore();
        BigDecimal evaGroupTotalScore = BigDecimal.valueOf(score.intValue());
        int summaryScorePrecision = 10;
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            BigDecimal evaGroupScope = regulationResultVO.getBasePrice().multiply(new BigDecimal(score)).divide(regulationResultVO.getEvaPrice(), summaryScorePrecision, 4);
            if (evaGroupScope.compareTo(evaGroupTotalScore) >= 0) {
                evaGroupScope = evaGroupTotalScore;
            }
            BigDecimal evaGroupWeightScope = evaGroupScope.multiply(regulationResultVO.getWeight()).divide(new BigDecimal(100), summaryScorePrecision, 4);
            regulationResultVO.setScore(evaGroupScope);
            regulationResultVO.setWeightScore(evaGroupWeightScope);
        }
        this.resultOrderByWeightScoreHighToLow(regulationCalList);
    }
}

