/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.excel;

import cn.hutool.core.util.StrUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectItem;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseProjectItemExcelServiceImpl")
public class PurchaseProjectItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseProjectItemExcelServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    private PurchaseTenderProjectItemService projectItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    private String headId;
    private String groupCode;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        this.groupCode = excelByConfigDTO.getGroupCode();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.projectHeadService.getById((Serializable)((Object)this.headId)));
            if (projectHead != null) {
                templateAccount = StringUtils.isNotBlank((CharSequence)projectHead.getTemplateAccount()) ? projectHead.getTemplateAccount() : projectHead.getElsAccount();
                templateVersion = String.valueOf(projectHead.getTemplateVersion());
                templateNumber = String.valueOf(projectHead.getTemplateNumber());
            }
        }
        TemplateHeadDTO templateConfig = this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
        List templateConfigItemList = templateConfig.getTemplateConfigItemList();
        Iterator iterator = templateConfigItemList.iterator();
        while (iterator.hasNext()) {
            TemplateConfigItemDTO next = (TemplateConfigItemDTO)iterator.next();
            if ("projectItemList".equals(next.getGroupCode())) continue;
            iterator.remove();
        }
        return templateConfig;
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseTenderProjectItem> itemList = this.projectItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchaseTenderProjectItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ExcelByConfigDTO excelByConfigDTO = excelImportDTO.getExcelByConfigDTO();
        List configItemList = this.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)this.groupCode)) {
            editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit()) && this.groupCode.equals(item.getGroupCode())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        }
        editColumn.addAll(Arrays.asList(excludeColumn));
        Map taxMap = this.invokeBaseRpcService.getAllTax(TenantContext.getTenant());
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Field[] fields;
            String materialNumber;
            Map data = (Map)iterator.next();
            HashMap errorData = new HashMap(data);
            List finalEditColumn = editColumn;
            data.forEach((key, value) -> {
                if (!finalEditColumn.contains(key)) {
                    data.put(key, null);
                }
            });
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode)) {
                if (!taxMap.containsKey(taxCode)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    iterator.remove();
                    continue;
                }
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!StringUtils.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHeadDTO materialHead = this.purchaseMaterialHeadLocalRpcService.getMaterialHeadByNumber(materialNumber);
            if (null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWxMK_44822940", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, errorData);
                iterator.remove();
                continue;
            }
            data.put("materialId", materialHead.getId());
            for (Field field : fields = ConvertUtils.getAllFields((Object)materialHead)) {
                if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get(materialHead));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

