/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.supplier.entity.TenderInvoiceInfo;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.service.TenderInvoiceInfoService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/sale/supplierTenderProjectPurchaseBid"})
@Api(tags={"\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u8d2d\u6807\u8868"})
public class SaleTenderProjectPurchaseBidController
extends BaseController<TenderProjectPurchaseBid, TenderProjectPurchaseBidService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderProjectPurchaseBidController.class);
    @Autowired
    private TenderProjectPurchaseBidService saleTenderProjectPurchaseBidService;
    @Autowired
    private TenderInvoiceInfoService saleTenderInvoiceInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(TenderProjectPurchaseBid TenderProjectPurchaseBid2, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)TenderProjectPurchaseBid2), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleTenderProjectPurchaseBidService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u8d2d\u6807-\u63d0\u4ea4", value="\u8d2d\u6807-\u63d0\u4ea4")
    @ApiOperation(value="\u8d2d\u6807-\u63d0\u4ea4", notes="\u8d2d\u6807-\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @SrmValidated
    public Result<?> submit(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidVO) {
        TenderProjectPurchaseBid purchaseBid = (TenderProjectPurchaseBid)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectPurchaseBidVO), TenderProjectPurchaseBid.class));
        this.build(purchaseBid);
        this.saleTenderProjectPurchaseBidService.saveOrUpdatePublish(purchaseBid, supplierTenderProjectPurchaseBidVO.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidVO.getAttachmentList());
        return Result.ok((Object)((Object)purchaseBid));
    }

    @AutoLog(busModule="\u8d2d\u6807-\u65b0\u589e", value="\u8d2d\u6807-\u65b0\u589e")
    @ApiOperation(value="\u8d2d\u6807-\u65b0\u589e", notes="\u8d2d\u6807-\u65b0\u589e")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @SrmValidated
    public Result<?> add(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidPage) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectPurchaseBidPage), TenderProjectPurchaseBid.class));
        this.build(tenderProjectPurchaseBid);
        this.saleTenderProjectPurchaseBidService.saveMain(tenderProjectPurchaseBid, supplierTenderProjectPurchaseBidPage.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidPage.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectPurchaseBid));
    }

    @AutoLog(busModule="\u8d2d\u6807-\u4fee\u6539", value="\u8d2d\u6807-\u4fee\u6539")
    @ApiOperation(value="\u8d2d\u6807-\u4fee\u6539", notes="\u8d2d\u6807-\u4fee\u6539")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> edit(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidPage) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectPurchaseBidPage), TenderProjectPurchaseBid.class));
        this.build(tenderProjectPurchaseBid);
        this.saleTenderProjectPurchaseBidService.updateMain(tenderProjectPurchaseBid, supplierTenderProjectPurchaseBidPage.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidPage.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectPurchaseBid));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectPurchaseBid saleTenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)this.saleTenderProjectPurchaseBidService.getById((Serializable)((Object)id)));
        if (ObjectUtil.isNull((Object)((Object)saleTenderProjectPurchaseBid))) {
            return Result.ok();
        }
        TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidVO = new TenderProjectPurchaseBidVO();
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectPurchaseBid), (Object)((Object)supplierTenderProjectPurchaseBidVO));
        List<TenderInvoiceInfo> saleTenderInvoiceInfoList = this.saleTenderInvoiceInfoService.selectByMainId(id);
        supplierTenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(saleTenderInvoiceInfoList);
        List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        this.saleTenderProjectPurchaseBidService.selectOrderInfo(supplierTenderProjectPurchaseBidVO);
        supplierTenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
        supplierTenderProjectPurchaseBidVO.setBusAccount(saleTenderProjectPurchaseBid.getPurchaseEnterpriseAccount());
        return Result.ok((Object)((Object)supplierTenderProjectPurchaseBidVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8d2d\u6807\u4fe1\u606f", notes="\u67e5\u8be2\u8d2d\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBidInfo"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryPurchaseBidInfo(@RequestParam(name="subpackageId") String subpackageId) {
        TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO = this.saleTenderProjectPurchaseBidService.queryPurchaseBidInfo(subpackageId);
        return Result.ok((Object)((Object)tenderProjectPurchaseBidVO));
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleTenderProjectPurchaseBidService.delete(id);
        return Result.ok();
    }

    private void build(TenderProjectPurchaseBid tenderProjectPurchaseBid) {
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectPurchaseBid.setSupplierAccount(loginUser.getElsAccount());
        tenderProjectPurchaseBid.setSupplierSubAccount(loginUser.getSubAccount());
        tenderProjectPurchaseBid.setSupplierName(loginUser.getEnterpriseName());
        tenderProjectPurchaseBid.setElsAccount(tenderProjectPurchaseBid.getSupplierAccount());
        tenderProjectPurchaseBid.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
    }
}

