/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginHead;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginItem;
import com.els.modules.tender.sale.entity.SaleTenderProjectRefund;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginHeadStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemMarginCollectionTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.sale.mapper.SaleTenderProjectMarginHeadMapper;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginItemService;
import com.els.modules.tender.sale.service.SaleTenderProjectRefundService;
import com.els.modules.tender.sale.vo.SaleTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginHead;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginItem;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleTenderProjectMarginHeadServiceImpl
extends BaseServiceImpl<SaleTenderProjectMarginHeadMapper, SaleTenderProjectMarginHead>
implements SaleTenderProjectMarginHeadService {
    @Autowired
    private SaleTenderProjectMarginItemService tenderProjectMarginItemService;
    @Autowired
    private SaleTenderProjectRefundService tenderProjectRefundService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectMarginHeadService purchaseTenderProjectMarginHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void add(TenderProjectSupplier tenderProjectSupplier) {
        List<SaleTenderProjectMarginHead> tenderProjectMarginHeadList = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(tenderProjectSupplier.getSubpackageId(), tenderProjectSupplier.getSupplierAccount());
        if (CollectionUtil.isNotEmpty(tenderProjectMarginHeadList)) {
            return;
        }
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        SaleTenderProjectMarginHead tenderProjectMarginHead = new SaleTenderProjectMarginHead();
        this.build(tenderProjectMarginHead, subpackageInfo, tenderProjectSupplier);
        ((SaleTenderProjectMarginHeadMapper)this.baseMapper).insert((Object)tenderProjectMarginHead);
        tenderProjectMarginHead.setElsAccount(tenderProjectSupplier.getPurchaseEnterpriseAccount());
        String idStr = tenderProjectMarginHead.getId();
        tenderProjectMarginHead.setId(tenderProjectMarginHead.getRelationId());
        tenderProjectMarginHead.setRelationId(idStr);
        tenderProjectMarginHead.setElsAccount(tenderProjectSupplier.getPurchaseEnterpriseAccount());
        this.purchaseTenderProjectMarginHeadService.add(tenderProjectMarginHead);
    }

    @Override
    public void addBatch(List<TenderProjectSupplier> tenderProjectSuppliers) {
        List<String> subpackageIds = tenderProjectSuppliers.stream().map(TenderProjectSupplier::getSubpackageId).distinct().collect(Collectors.toList());
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.subpackageInfoService.selectBatchIds(subpackageIds);
        Map subpackageInfoMap = purchaseTenderProjectSubpackageInfos.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<SaleTenderProjectMarginHead> saleTenderProjectMarginHeads = new ArrayList<SaleTenderProjectMarginHead>();
        for (TenderProjectSupplier tenderProjectSupplier : tenderProjectSuppliers) {
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)subpackageInfoMap.get(tenderProjectSupplier.getSubpackageId()));
            SaleTenderProjectMarginHead tenderProjectMarginHead = new SaleTenderProjectMarginHead();
            this.build(tenderProjectMarginHead, subpackageInfo, tenderProjectSupplier);
            saleTenderProjectMarginHeads.add(tenderProjectMarginHead);
        }
        ((SaleTenderProjectMarginHeadMapper)this.baseMapper).insertBatchSomeColumn(saleTenderProjectMarginHeads);
        this.purchaseTenderProjectMarginHeadService.addBatch(saleTenderProjectMarginHeads);
    }

    private void build(SaleTenderProjectMarginHead tenderProjectMarginHead, PurchaseTenderProjectSubpackageInfo subpackageInfo, TenderProjectSupplier tenderProjectSupplier) {
        tenderProjectMarginHead.setTenderProjectId(tenderProjectSupplier.getTenderProjectId());
        tenderProjectMarginHead.setSubpackageId(tenderProjectSupplier.getSubpackageId());
        tenderProjectMarginHead.setSupplierAccount(tenderProjectSupplier.getSupplierAccount());
        tenderProjectMarginHead.setSupplierName(tenderProjectSupplier.getSupplierName());
        tenderProjectMarginHead.setMarginNumber(this.invokeBaseRpcService.getNextCode("tenderProjectMarginNumber", (Object)tenderProjectMarginHead));
        BigDecimal dueAmount = subpackageInfo.getMargin() == null ? BigDecimal.ZERO : subpackageInfo.getMargin();
        tenderProjectMarginHead.setDueAmount(dueAmount);
        tenderProjectMarginHead.setPaidAmount(BigDecimal.ZERO);
        tenderProjectMarginHead.setGuaranteePaidAmount(BigDecimal.ZERO);
        tenderProjectMarginHead.setStatus(TenderProjectMarginHeadStatusEnum.UNPAID.getValue());
        tenderProjectMarginHead.setDeleted(CommonConstant.DEL_FLAG_0);
        tenderProjectMarginHead.setElsAccount(tenderProjectSupplier.getSupplierAccount());
        tenderProjectMarginHead.setId(IdWorker.getIdStr());
        tenderProjectMarginHead.setRelationId(IdWorker.getIdStr());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem addMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItemVO.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<SaleTenderProjectMarginHead> tenderProjectMarginHeadList = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(tenderProjectMarginItemVO.getSubpackageId(), tenderProjectMarginItemVO.getSupplierAccount());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderProjectMarginHeadList), (String)I18nUtil.translate((String)"i18n_field_LsRxqSusiHtH_a9f5ac19", (String)"\u672a\u62a5\u540d\u4e0d\u53ef\u6dfb\u52a0\u4fdd\u8bc1\u91d1\u8bb0\u5f55"));
        SaleTenderProjectMarginHead saleTenderProjectMarginHead = tenderProjectMarginHeadList.get(0);
        tenderProjectMarginItemVO.setHeadId(saleTenderProjectMarginHead.getId());
        tenderProjectMarginItemVO.setId(IdWorker.getIdStr());
        tenderProjectMarginItemVO.setElsAccount(saleTenderProjectMarginHead.getElsAccount());
        SaleTenderProjectMarginItemVO tenderProjectMarginItem = new SaleTenderProjectMarginItemVO();
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem));
        this.tenderProjectMarginItemService.save((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItem.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem editMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItemVO.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectMarginItem)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem), (String[])new String[]{"headId", "status", "supplierAccount", "supplierName", "elsAccount"});
        this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem submitMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_field_dIxOLVW_2db2c59c", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((TenderProjectMarginItemStatusEnum.UNCONFIRMED.getValue().equals(tenderProjectMarginItem.getStatus()) || TenderProjectMarginItemStatusEnum.REFUSED.getValue().equals(tenderProjectMarginItem.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_APzExqDJW_3f04fb46", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4!"));
        this.checkMarginItemParam(tenderProjectMarginItem);
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.SUBMIT.getValue());
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        PurchaseTenderProjectMarginItemVO purchaseTenderProjectMarginItemVO = (PurchaseTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), PurchaseTenderProjectMarginItemVO.class));
        ArrayList attachmentDTOList = SysUtil.copyProperties(tenderProjectMarginItemVO.getAttachmentDTOList(), PurchaseAttachmentDTO.class);
        purchaseTenderProjectMarginItemVO.setAttachmentDTOList(attachmentDTOList);
        purchaseTenderProjectMarginItemVO.setRelationId(tenderProjectMarginItemVO.getId());
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.purchaseTenderProjectMarginHeadService.addMargin(purchaseTenderProjectMarginItemVO);
        tenderProjectMarginItem.setRelationId(purchaseTenderProjectMarginItem.getId());
        boolean marginItemCount = this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_DJKmWAPcWFIKXWVVVXVSDJHrW_5e42679e", (String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        return tenderProjectMarginItem;
    }

    @Override
    public void confirmMargin(List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads, List<PurchaseTenderProjectMarginItem> purchaseTenderProjectMarginItems) {
        List<String> itemIds = purchaseTenderProjectMarginItems.stream().map(PurchaseTenderProjectMarginItem::getRelationId).collect(Collectors.toList());
        Map<String, PurchaseTenderProjectMarginHead> purchaseMarginHeadMap = purchaseTenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getRelationId, purchaseMarginHead -> purchaseMarginHead, (o1, o2) -> o1));
        LambdaQueryWrapper marginItemQw = new LambdaQueryWrapper();
        marginItemQw.in(BaseEntity::getId, itemIds);
        List<SaleTenderProjectMarginItem> tenderProjectMarginItems = this.tenderProjectMarginItemService.selectByIds(itemIds);
        Assert.isTrue((tenderProjectMarginItems.size() == itemIds.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_WFIHWVXVsKW_1040d961", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        for (SaleTenderProjectMarginItem tenderProjectMarginItem : tenderProjectMarginItems) {
            tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        }
        Set headIds = tenderProjectMarginItems.stream().map(SaleTenderProjectMarginItem::getHeadId).collect(Collectors.toSet());
        List tenderProjectMarginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        Assert.isTrue((headIds.size() == tenderProjectMarginHeads.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKSXWFWVXVsK_54dec862", (String)"\u5b58\u5728\u65e0\u6548\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5"));
        boolean marginItemCount = this.tenderProjectMarginItemService.updateBatchById(tenderProjectMarginItems);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPcWFIKXWVVVXVSDJHrW_1921253c", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        for (SaleTenderProjectMarginHead tenderProjectMarginHead : tenderProjectMarginHeads) {
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = purchaseMarginHeadMap.get(tenderProjectMarginHead.getId());
            tenderProjectMarginHead.setPaidAmount(purchaseTenderProjectMarginHead.getPaidAmount());
            tenderProjectMarginHead.setGuaranteePaidAmount(purchaseTenderProjectMarginHead.getGuaranteePaidAmount());
            tenderProjectMarginHead.setStatus(purchaseTenderProjectMarginHead.getStatus());
        }
        boolean marginHeadCount = this.updateBatchById(tenderProjectMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPcWFIKXWVVVXVSDJHrW_1921253c", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void refund(List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads, List<SaleTenderProjectRefund> saleTenderProjectRefunds) {
        Set headIds = purchaseTenderProjectMarginHeads.stream().map(PurchaseTenderProjectMarginHead::getRelationId).collect(Collectors.toSet());
        List marginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        List updMarginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        Map<String, SaleTenderProjectMarginHead> saleSupplierMap = marginHeads.stream().collect(Collectors.toMap(SaleTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        Map<String, PurchaseTenderProjectMarginHead> purchaseSupplierMap = purchaseTenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        for (SaleTenderProjectRefund saleTenderProjectRefund : saleTenderProjectRefunds) {
            SaleTenderProjectMarginHead saleTenderProjectMarginHead = saleSupplierMap.get(saleTenderProjectRefund.getSupplierAccount());
            saleTenderProjectRefund.setHeadId(saleTenderProjectMarginHead.getId());
            saleTenderProjectRefund.setId(IdWorker.getIdStr());
            saleTenderProjectRefund.setElsAccount(saleTenderProjectMarginHead.getElsAccount());
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = purchaseSupplierMap.get(saleTenderProjectRefund.getSupplierAccount());
            saleTenderProjectMarginHead.setPaidAmount(purchaseTenderProjectMarginHead.getPaidAmount());
            saleTenderProjectMarginHead.setStatus(purchaseTenderProjectMarginHead.getStatus());
            updMarginHeads.add(saleTenderProjectMarginHead);
        }
        boolean marginHeadCount = this.updateBatchById(updMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_YVKmWVVVXVSDJHrW_84245fd3", (String)"\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.tenderProjectRefundService.saveBatch(saleTenderProjectRefunds);
    }

    @Override
    public void reject(String id) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)TenderProjectMarginItemStatusEnum.SUBMIT.getValue().equals(tenderProjectMarginItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APWFzExiTYM_2195ec3f", (String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u56de"));
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.REFUSED.getValue());
        boolean marginItemCount = this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_FKKmWAPcWFIKXWVVVXVSDJHrW_9d78a047", (String)"\u62d2\u7edd\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void checkMarginItemParam(SaleTenderProjectMarginItem tenderProjectMarginItem) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_field_dIxOLVW_2db2c59c", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierName()), (String)I18nUtil.translate((String)"i18n_field_eBtLRLxOLVW_b6922b04", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getMarginCollectionType()), (String)I18nUtil.translate((String)"i18n_field_siHlMCKxOLVW_d85cd1ce", (String)"\u4fdd\u8bc1\u91d1\u6536\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)tenderProjectMarginItem.getAmount()), (String)I18nUtil.translate((String)"i18n_field_siHHfxOLVW_62315538", (String)"\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
        if (TenderProjectMarginItemMarginCollectionTypeEnum.LETTER_GUARANTEE.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getGuarantor()), (String)I18nUtil.translate((String)"i18n_field_tsLxOLVW_b99c6f4f", (String)"\u62c5\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else if (TenderProjectMarginItemMarginCollectionTypeEnum.OTHER.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayAccount()), (String)I18nUtil.translate((String)"i18n_field_MVeyxOLVW_bc58ed69", (String)"\u6c47\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayName()), (String)I18nUtil.translate((String)"i18n_field_MVeDRxOLVW_2553840c", (String)"\u6c47\u6b3e\u8d26\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getBankName()), (String)I18nUtil.translate((String)"i18n_field_vDcxOLVW_2c48a33c", (String)"\u5f00\u6237\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tenderProjectMarginItem.getPayType()), (String)I18nUtil.translate((String)"i18n_field_JpCKCKxOLVW_40b60f06", (String)"\u7f34\u7eb3\u65b9\u5f0f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_field_PxRuWTxJeyeRWCKRBW_2dc93e83", (String)"\u6682\u4e0d\u652f\u6301\u3010\u865a\u62df\u5b50\u8d26\u53f7\u6258\u7ba1\u3011\u65b9\u5f0f\u652f\u4ed8!"));
        }
    }

    private void saveAttachment(String mainId, List<SaleAttachmentDTO> attachmentDTOList) {
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(mainId);
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> {
                attachment.setId(IdWorker.getIdStr());
                attachment.setHeadId(mainId);
            });
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }
}

