/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEnquiryItemServiceImpl
extends ServiceImpl<PurchaseEnquiryItemMapper, PurchaseEnquiryItem>
implements PurchaseEnquiryItemService {
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Override
    public List<PurchaseEnquiryItem> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItem webItem) {
        List<PurchaseEnquiryItem> itemList = this.selectByMainId(webItem.getHeadId()).stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        itemList.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        this.updateBatchById(itemList);
        this.saleEnquiryItemService.replenishMaterialNumber(itemList);
        PurchaseEnquiryItem item2 = itemList.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item2.getSourceType()) && StringUtils.isNotBlank((CharSequence)item2.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item2.getSourceItemId(), item2.getMaterialNumber(), item2.getMaterialDesc(), item2.getMaterialGroup(), item2.getMaterialSpec());
        }
    }

    @Override
    public void exportCompare(String headId, HttpServletResponse response) {
        List<PurchaseEnquiryItem> itemList = ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(headId);
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(headId);
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        for (Object item2 : distinctList) {
            writer.merge(firstRow, firstRow + 3, 0, 0, (Object)((PurchaseEnquiryItem)((Object)item2)).getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 3, 1, 1, (Object)((PurchaseEnquiryItem)((Object)item2)).getItemNumber(), false);
            writer.merge(firstRow, firstRow + 3, 2, 2, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 3, 3, 3, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 3, 4, 4, (Object)((PurchaseEnquiryItem)((Object)item2)).getPriceUnit(), false);
            writer.merge(firstRow, firstRow + 3, 5, 5, (Object)((PurchaseEnquiryItem)((Object)item2)).getRequireQuantity(), false);
            writer.writeCellValue(6, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(6, firstRow + 1, (Object)"\u4e0d\u542b\u7a0e\u4ef7");
            writer.writeCellValue(6, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(6, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            firstRow += 4;
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                writer.writeCellValue(x, y, (Object)item3.getPrice());
                writer.writeCellValue(x, y + 1, (Object)item3.getNetPrice());
                writer.writeCellValue(x, y + 2, (Object)item3.getTaxRate());
                writer.writeCellValue(x, y + 3, item3.getDeliveryDate() == null ? null : DateUtil.format((Date)item3.getDeliveryDate(), (String)"yyyy-MM-dd"));
                y += 4;
            }
            ++x;
        }
        this.ladderCompare(writer, itemList, distinctList, supplierList);
        this.costCompare(writer, itemList, distinctList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            this.log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    private void ladderCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u9636\u68af\u7ea7"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            if (!EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) continue;
            JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
            writer.merge(firstRow, firstRow + array.size() - 1, 0, 0, (Object)item2.getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + array.size() - 1, 1, 1, (Object)item2.getItemNumber(), false);
            writer.merge(firstRow, firstRow + array.size() - 1, 2, 2, (Object)item2.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + array.size() - 1, 3, 3, (Object)item2.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + array.size() - 1, 4, 4, (Object)item2.getPriceUnit(), false);
            writer.merge(firstRow, firstRow + array.size() - 1, 5, 5, (Object)item2.getRequireQuantity(), false);
            for (int index = 0; index < array.size(); ++index) {
                JSONObject ladder = array.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)ladder.getString("ladder"));
            }
            firstRow += array.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONArray array = JSONArray.parseArray((String)item3.getLadderPriceJson());
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)ladder.getBigDecimal("price"));
                }
                y += array.size();
            }
            ++x;
        }
    }

    private void costCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u6210\u672c\u9879"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            JSONObject jsonObject;
            JSONArray groups;
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getCostFormJson()) || (groups = (jsonObject = JSONObject.parseObject((String)item2.getCostFormJson())).getJSONArray("groups")) == null) continue;
            writer.merge(firstRow, firstRow + groups.size() - 1, 0, 0, (Object)item2.getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + groups.size() - 1, 1, 1, (Object)item2.getItemNumber(), false);
            writer.merge(firstRow, firstRow + groups.size() - 1, 2, 2, (Object)item2.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + groups.size() - 1, 3, 3, (Object)item2.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + groups.size() - 1, 4, 4, (Object)item2.getPriceUnit(), false);
            writer.merge(firstRow, firstRow + groups.size() - 1, 5, 5, (Object)item2.getRequireQuantity(), false);
            for (int index = 0; index < groups.size(); ++index) {
                JSONObject group = groups.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)group.getString("groupName"));
            }
            firstRow += groups.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONObject jsonObject = JSONObject.parseObject((String)item3.getCostFormJson());
                JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                for (int index = 0; index < groups.size(); ++index) {
                    JSONObject group = groups.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)group.getBigDecimal("totalValue"));
                }
                y += groups.size();
            }
            ++x;
        }
    }

    private List<String> getHeaderList(List<EnquirySupplierList> supplierList, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierList supplier : supplierList) {
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }
}

