/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialSourceLocalRpcService;
import com.els.modules.demand.rpc.PurchaseOrganizationInfoLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadExtendDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.api.enumerate.MaterialDeliveryArrangeEnum;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.order.api.dto.DeliveryOrderAddressDTO;
import com.els.modules.order.api.dto.PurchaseOrderGenarateConfigDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.dto.PurchaseOrderPermissionConfigDTO;
import com.els.modules.order.api.enumerate.OrderItemSendStatusEnum;
import com.els.modules.order.api.enumerate.OrderItemStatusEnum;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.dto.SupplierOrgInfoDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestHeadServiceImpl
extends BaseServiceImpl<PurchaseRequestHeadMapper, PurchaseRequestHead>
implements PurchaseRequestHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadServiceImpl.class);
    public static final String HAD_SOURCE = "HADSOURCE";
    public static final String NO_HAD_SOURCE = "NOHAHSOURCE";
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService;
    @Resource
    private PurchaseOrganizationInfoLocalRpcService purchaseOrganizationInfoService;
    @Resource
    private PurchaseMaterialSourceLocalRpcService purchaseMaterialSourceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        List<PurchaseOrganizationInfoDTO> list;
        if (StringUtils.isBlank((CharSequence)purchaseRequestHead.getRequestNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmPurchaseRequestNumber", (Object)purchaseRequestHead);
            purchaseRequestHead.setRequestNumber(nextCode);
        }
        if (purchaseRequestHead.getApplyDate() == null) {
            purchaseRequestHead.setApplyDate(new Date());
        }
        purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
        purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseRequestHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length >= 1 && StrUtil.isEmpty((CharSequence)purchaseRequestHead.getApplyDept()) && !CollectionUtils.isEmpty(list = this.purchaseOrganizationInfoService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
            purchaseRequestHead.setApplyDept(list.get(0).getOrgCode());
        }
        String idStr = IdWorker.getIdStr();
        purchaseRequestHead.setDocumentId(idStr);
        this.purchaseRequestHeadMapper.insert((Object)purchaseRequestHead);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setRequestHeadId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.saveIntegratedDocument(integratedDocument);
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int count;
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseRequestHead.setTotalAmount(total);
        }
        if (PURCHASE_UNIT_TYPE.equals(purchaseRequestHead.getAudit())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if (REPERTORY_UNIT_TYPE.equals(purchaseRequestHead.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseRequestHead.getAuditStatus())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if (purchaseRequestHead.getExtendFields() == "") {
            purchaseRequestHead.setExtendFields(null);
        }
        if ((count = this.purchaseRequestHeadMapper.updateById((Object)purchaseRequestHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.purchaseRequestItemMapper.deleteByMainId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseRequestHead.getId());
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    private BigDecimal computeQuantity(PurchaseRequestItem entity) {
        log.info("purchaseMaterialHead id is:" + entity.getMaterialNumber());
        BigDecimal repertoryQuantity = entity.getRepertoryQuantity();
        if (repertoryQuantity == null || repertoryQuantity.compareTo(new BigDecimal(0)) == 0) {
            return repertoryQuantity;
        }
        String purchaseUnit = entity.getPurchaseUnit();
        String repertoryUnit = entity.getRepertoryUnit();
        if (purchaseUnit != null && purchaseUnit.equals(repertoryUnit) || purchaseUnit == null || repertoryUnit == null) {
            return repertoryQuantity;
        }
        List<PurchaseMaterialUnitDTO> units = this.purchaseMaterialHeadLocalRpcService.selectByMaterialNumber(entity.getMaterialNumber());
        ArrayList<PurchaseMaterialUnitDTO> purchaseUnits = new ArrayList<PurchaseMaterialUnitDTO>();
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            String basicUnit = unitDTO.getBasicUnit();
            if (!PURCHASE_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(purchaseUnit)) continue;
            if (basicUnit.equals(repertoryUnit)) {
                BigDecimal basicAmount = unitDTO.getBasicAmount();
                BigDecimal objectAmount = unitDTO.getObjectAmount();
                return repertoryQuantity.divide(basicAmount).multiply(objectAmount);
            }
            purchaseUnits.add(unitDTO);
            break;
        }
        PurchaseMaterialUnitDTO repertoryUnitDto = this.getRePertoryUnit(units, repertoryUnit);
        for (PurchaseMaterialUnitDTO unitDTO : purchaseUnits) {
            if (!unitDTO.getBasicUnit().equals(repertoryUnitDto.getBasicUnit())) continue;
            return repertoryQuantity.multiply(repertoryUnitDto.getBasicAmount()).divide(repertoryUnitDto.getObjectAmount(), 6, RoundingMode.HALF_UP).divide(unitDTO.getBasicAmount(), 6, RoundingMode.HALF_UP).multiply(unitDTO.getObjectAmount());
        }
        return repertoryQuantity;
    }

    private PurchaseMaterialUnitDTO getRePertoryUnit(List<PurchaseMaterialUnitDTO> units, String repertoryUnit) {
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            if (!REPERTORY_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(repertoryUnit)) continue;
            return unitDTO;
        }
        return new PurchaseMaterialUnitDTO();
    }

    private void insertData(PurchaseRequestHead purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(purchaseRequestItemList);
            int count = 1;
            for (PurchaseRequestItem entity : purchaseRequestItemList) {
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                if (null == entity.getId()) {
                    entity.setCreateBy(null);
                    entity.setCreateTime(null);
                }
                entity.setQuantity(this.computeQuantity(entity));
                entity.setPurchaseUnit(entity.getPurchaseUnit());
                entity.setAuditStatus(purchaseRequestHead.getAuditStatus());
                entity.setHeadId(purchaseRequestHead.getId());
                entity.setItemNumber(count + "");
                if (PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(entity.getItemStatus())) {
                    entity.setItemStatus(PurchaseRequestStatusItemEnum.APPROVED.getValue());
                    entity.setRole(null);
                    entity.setPurchasePrincipal(null);
                    entity.setResponsibleGroup(null);
                }
                entity.setRequestNumber(purchaseRequestHead.getRequestNumber());
                entity.setRequestType(purchaseRequestHead.getRequestType());
                if (StringUtils.isBlank((CharSequence)entity.getPurchaseType())) {
                    entity.setPurchaseType(purchaseRequestHead.getPurchaseType());
                }
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                entity.setDocumentId(purchaseRequestHead.getDocumentId());
                if (StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getFactory()) && StringUtils.isBlank((CharSequence)entity.getFactory())) {
                    entity.setFactory(purchaseRequestHead.getFactory());
                }
                if (StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getPurchaseGroup()) && StringUtils.isBlank((CharSequence)entity.getPurchaseGroup())) {
                    entity.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                }
                if (orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()).getPurchaseOrg());
                } else if (orderPermissionConfigMap.get("_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get("_" + entity.getFactory()).getPurchaseOrg());
                } else {
                    throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u884c[" + entity.getItemNumber() + "]\u8bf7\u5728\u91c7\u8d2d\u6743\u9650\u914d\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7");
                }
                if (StringUtils.isNotEmpty((CharSequence)entity.getFactory())) {
                    PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO = this.inquiryInvokeMainDataRpcService.selectByElsAccountAndCode(purchaseRequestHead.getElsAccount(), "factory", entity.getFactory());
                    if (purchaseOrganizationInfoDTO != null) {
                        if (StringUtils.isEmpty((CharSequence)purchaseOrganizationInfoDTO.getSuperBusinessId())) {
                            throw new ELSBootException("\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7684\u7ec4\u7ec7\u7f16\u7801\u4e3a[" + entity.getFactory() + "]\u6ca1\u6709\u7ef4\u62a4\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7,\u8bf7\u7ef4\u62a4");
                        }
                        PurchaseOrganizationInfoDTO companyOrgInfo = this.inquiryInvokeMainDataRpcService.getById(purchaseOrganizationInfoDTO.getSuperBusinessId());
                        entity.setCompany(companyOrgInfo.getOrgCode());
                    } else {
                        throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u5de5\u5382\u4ee3\u7801\u4e3a[" + entity.getFactory() + "]\u7684\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f");
                    }
                }
                entity.setApplyDate(purchaseRequestHead.getApplyDate());
                entity.setApplicant(purchaseRequestHead.getApplicant());
                entity.setSourceNumber(purchaseRequestHead.getRequestNumber());
                entity.setSourceItemNumber(count + "");
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                entity.setRemark(purchaseRequestHead.getRemark());
                entity.setSourceType(purchaseRequestHead.getSourceType());
                ++count;
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseRequestItemList.isEmpty()) {
                this.purchaseRequestItemService.saveBatch(purchaseRequestItemList, 2000);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setCreateTime(null);
                entity.setId(null);
                entity.setCreateBy(null);
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                entity.setHeadId(purchaseRequestHead.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    private Map<String, PurchaseOrderPermissionConfigDTO> getOrderPermissionConfigMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<String> cateCodeAndFactoryKeys = new ArrayList<String>();
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            if (cateCodeAndFactoryKeys.contains(requestItem.getCateCode() + "_" + requestItem.getFactory())) continue;
            cateCodeAndFactoryKeys.add(requestItem.getCateCode() + "_" + requestItem.getFactory());
            cateCodeAndFactoryKeys.add("_" + requestItem.getFactory());
        }
        List<PurchaseOrderPermissionConfigDTO> purchaseOrderPermissionConfigDTOList = this.inquiryInvokeOrderRpcService.getPurchaseOrderPermissionConfigList(cateCodeAndFactoryKeys);
        HashMap<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigByCodeCategoryMap = new HashMap<String, PurchaseOrderPermissionConfigDTO>();
        for (PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO : purchaseOrderPermissionConfigDTOList) {
            orderPermissionConfigByCodeCategoryMap.put(purchaseOrderPermissionConfigDTO.getCateCode() + "_" + purchaseOrderPermissionConfigDTO.getPurchaseFactory(), purchaseOrderPermissionConfigDTO);
        }
        return orderPermissionConfigByCodeCategoryMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseRequestItemMapper.deleteByMainId(id);
        this.purchaseRequestHeadMapper.deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRequestItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRequestHeadMapper.deleteById(serializable);
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseRequestHead head) {
        int count;
        PurchaseRequestHead updateBuyHead = new PurchaseRequestHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setRequestStatus(head.getRequestStatus());
        if (PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue().equals(head.getRequestStatus())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.CANCEL.getValue())).eq(PurchaseRequestItem::getHeadId, (Object)head.getId())).update((Object)new PurchaseRequestItem());
        }
        if ((count = this.purchaseRequestHeadMapper.updateById((Object)updateBuyHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void matchPrice(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        Map<String, List> collect = purchaseRequestItemList.parallelStream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getPurchaseOrg(), p -> {
            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
            getNameList.add((PurchaseRequestItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        ArrayList<String> list1 = new ArrayList<String>(collect.keySet());
        List<String> stringList = this.purchaseInformationRecordsService.checkPriceForSome(list1);
        if (!CollectionUtils.isEmpty(stringList)) {
            ArrayList purchaseRequestItems = new ArrayList();
            for (String s : stringList) {
                if (!collect.containsKey(s)) continue;
                purchaseRequestItems.addAll(collect.get(s));
            }
            if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
                List collect1 = purchaseRequestItems.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue())).in(BaseEntity::getId, collect1)).update((Object)new PurchaseRequestItem());
            }
        }
    }

    @Override
    public List<RequestMatchInfomationVO> matchInformationRecords(List<PurchaseRequestItem> purchaseRequestItemList) {
        try {
            List<RequestMatchInfomationVO> requestMatchInfomationVOS1;
            List<RequestMatchInfomationVO> requestMatchInfomationVOS;
            List<PurchaseRequestItem> requestItemListByNumber = purchaseRequestItemList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
            List<PurchaseRequestItem> requestItemListByEmptyNumber = purchaseRequestItemList.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getMaterialNumber())).collect(Collectors.toList());
            ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
            if (CollectionUtil.isNotEmpty(requestItemListByNumber) && CollectionUtil.isNotEmpty(requestMatchInfomationVOS = this.doRequestToRequestInfomation(requestItemListByNumber))) {
                requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
            }
            if (CollectionUtil.isNotEmpty(requestItemListByEmptyNumber) && CollectionUtil.isNotEmpty(requestMatchInfomationVOS1 = this.doRequestToRequestInfomationByNoNumber(requestItemListByEmptyNumber))) {
                requestMatchInfomationVOList.addAll(requestMatchInfomationVOS1);
            }
            return requestMatchInfomationVOList;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private List<RequestMatchInfomationVO> doRequestToRequestInfomationByNoNumber(List<PurchaseRequestItem> requestItemList) {
        List<String> materialDescs = requestItemList.stream().map(PurchaseRequestItem::getMaterialDesc).collect(Collectors.toList());
        List<PurchaseEnquiryItem> purchaseEnquiryItems = this.purchaseEnquiryItemService.queryEnquiryByDesc(materialDescs);
        List<PurchaseEbiddingItem> purchaseEbiddingItems = this.purchaseEbiddingItemService.queryEbiddingByDesc(materialDescs);
        List<PurchaseBiddingItem> purchaseBiddingItems = this.purchaseBiddingItemService.queryBiddingByDesc(materialDescs);
        Map<String, List<PurchaseEnquiryItem>> enquiryMapByDesc = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(PurchaseEnquiryItem::getMaterialDesc));
        Map<String, List<PurchaseEbiddingItem>> ebiddingMapByDesc = purchaseEbiddingItems.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getMaterialDesc));
        Map<String, List<PurchaseBiddingItem>> biddingMapByDesc = purchaseBiddingItems.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getMaterialDesc));
        List requestHeadIds = requestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List purchaseRequestHeadList = this.listByIds(requestHeadIds);
        ArrayList<String> toElsAccounts = new ArrayList<String>();
        ArrayList<String> orgAndToElsAccount = new ArrayList<String>();
        List enquiryToElsAccounts = purchaseEnquiryItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List ebiddingToElsAccounts = purchaseEbiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseEbiddingItem::getToElsAccount).collect(Collectors.toList());
        List biddingToElsAccounts = purchaseBiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount())).map(PurchaseBiddingItem::getToElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(enquiryToElsAccounts)) {
            toElsAccounts.addAll(enquiryToElsAccounts);
        }
        if (CollectionUtil.isNotEmpty(ebiddingToElsAccounts)) {
            toElsAccounts.addAll(ebiddingToElsAccounts);
        }
        if (CollectionUtil.isNotEmpty(biddingToElsAccounts)) {
            toElsAccounts.addAll(biddingToElsAccounts);
        }
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(requestItemList);
        Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap = this.queryOrderGenrateConfigByMap(purchaseRequestHeadList, requestItemList);
        List<PurchaseRequestItem> requestItemListByEmptyNumber = this.combinRequestItem(orderGenarateConfigMap);
        for (PurchaseRequestItem requestItem : requestItemListByEmptyNumber) {
            List biggindDescToElsAccounts;
            List ebiddingDescToElsAccounts;
            List enquiryDescToElsAccounts;
            if (CollectionUtil.isNotEmpty(purchaseEnquiryItems) && CollectionUtil.isNotEmpty(enquiryDescToElsAccounts = purchaseEnquiryItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList()))) {
                for (String toElsAccount : enquiryDescToElsAccounts) {
                    orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
                }
            }
            if (CollectionUtil.isNotEmpty(purchaseEbiddingItems) && CollectionUtil.isNotEmpty(ebiddingDescToElsAccounts = purchaseEbiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseEbiddingItem::getToElsAccount).collect(Collectors.toList()))) {
                for (String toElsAccount : ebiddingDescToElsAccounts) {
                    orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
                }
            }
            if (!CollectionUtil.isNotEmpty(purchaseBiddingItems) || !CollectionUtil.isNotEmpty(biggindDescToElsAccounts = purchaseBiddingItems.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getToElsAccount()) && item.getMaterialDesc().equals(requestItem.getMaterialDesc())).map(PurchaseBiddingItem::getToElsAccount).collect(Collectors.toList()))) continue;
            for (String toElsAccount : biggindDescToElsAccounts) {
                orgAndToElsAccount.add(requestItem.getElsAccount() + "&&" + toElsAccount + "&&" + requestItem.getPurchaseOrg());
            }
        }
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(toElsAccounts, TenantContext.getTenant());
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgInfoDTOS(orgAndToElsAccount);
        Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = this.getSupplierMasterDataMapByToElsAccount(supplierMasterDataDTOList);
        Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = this.getSupplierOrgDataInfoMapByKey(supplierOrgInfoDTOList);
        if (CollectionUtil.isEmpty(requestItemListByEmptyNumber)) {
            throw new ELSBootException("\u5408\u5e76\u9700\u6c42\u540e,\u8f6c\u5355\u9700\u6c42\u4e3a\u7a7a");
        }
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        for (PurchaseRequestItem requestItem : requestItemListByEmptyNumber) {
            RequestMatchInfomationVO requestMatchInfomationVO;
            RequestMatchInfomationVO paramRequestInfo;
            List<PurchaseEnquiryItem> enquiryItemList = enquiryMapByDesc.get(requestItem.getMaterialDesc());
            List<PurchaseEbiddingItem> ebiddingItemList = ebiddingMapByDesc.get(requestItem.getMaterialDesc());
            List<PurchaseBiddingItem> biddingItemList = biddingMapByDesc.get(requestItem.getMaterialDesc());
            PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getHeadId()));
            Map<PurchaseOrderGenarateConfigDTO, List> purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get(requestItem.getMaterialGroup() + "_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_");
            }
            if (purchaseOrderGenarateConfigMap == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u9879!");
            }
            PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig = purchaseOrderGenarateConfigMap.keySet().iterator().next();
            PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get(requestItem.getCateCode() + "_" + requestItem.getFactory());
            if (purchaseOrderPermissionConfigDTO == null) {
                purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get("_" + requestItem.getFactory());
            }
            if (CollectionUtil.isEmpty(enquiryItemList) && CollectionUtil.isEmpty(ebiddingItemList) && CollectionUtil.isEmpty(biddingItemList) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u53d7\u4ef7\u683c\u63a7\u5236,\u4f46\u7cfb\u7edf\u6ca1\u6709\u5728\u8be2\u4ef7\u3001\u7ade\u4ef7\u3001\u62db\u6807\u4e2d\u5339\u914d\u5230\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e");
            }
            if (purchaseOrderPermissionConfigDTO == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u6743\u9650\u914d\u7f6e,\u8bf7\u5148\u7ef4\u62a4\u8ba2\u5355\u6743\u9650\u6570\u636e");
            }
            if (CollectionUtil.isNotEmpty(enquiryItemList)) {
                for (PurchaseEnquiryItem purchaseEnquiryItem : enquiryItemList) {
                    paramRequestInfo = new RequestMatchInfomationVO();
                    paramRequestInfo.setPrice(purchaseEnquiryItem.getPrice());
                    paramRequestInfo.setNetPirce(purchaseEnquiryItem.getNetPrice());
                    paramRequestInfo.setTaxCode(purchaseEnquiryItem.getTaxCode());
                    paramRequestInfo.setTaxRate(purchaseEnquiryItem.getTaxRate());
                    paramRequestInfo.setToElsAccount(purchaseEnquiryItem.getToElsAccount());
                    paramRequestInfo.setElsAccount(purchaseEnquiryItem.getElsAccount());
                    paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                    requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                    requestMatchInfomationVOList.add(requestMatchInfomationVO);
                }
            }
            if (CollectionUtil.isNotEmpty(ebiddingItemList)) {
                for (PurchaseEbiddingItem ebiddingItem : ebiddingItemList) {
                    paramRequestInfo = new RequestMatchInfomationVO();
                    paramRequestInfo.setPrice(ebiddingItem.getPrice());
                    paramRequestInfo.setNetPirce(ebiddingItem.getNetPrice());
                    paramRequestInfo.setTaxCode(ebiddingItem.getTaxCode());
                    paramRequestInfo.setTaxRate(ebiddingItem.getTaxRate());
                    paramRequestInfo.setToElsAccount(ebiddingItem.getToElsAccount());
                    paramRequestInfo.setElsAccount(ebiddingItem.getElsAccount());
                    paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                    requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                    requestMatchInfomationVOList.add(requestMatchInfomationVO);
                }
            }
            if (!CollectionUtil.isNotEmpty(biddingItemList)) continue;
            for (PurchaseBiddingItem biddingItem : biddingItemList) {
                paramRequestInfo = new RequestMatchInfomationVO();
                paramRequestInfo.setPrice(biddingItem.getPrice());
                paramRequestInfo.setNetPirce(biddingItem.getNetPrice());
                paramRequestInfo.setTaxCode(biddingItem.getTaxCode());
                paramRequestInfo.setTaxRate(biddingItem.getTaxRate());
                paramRequestInfo.setToElsAccount(biddingItem.getToElsAccount());
                paramRequestInfo.setElsAccount(biddingItem.getElsAccount());
                paramRequestInfo.setPurchaseOrg(requestItem.getPurchaseOrg());
                requestMatchInfomationVO = this.getRequestMatchInfomationVOByInquiry(supplierOrgInfoDTOMap, supplierMasterDataDTOMap, paramRequestInfo, requestHead, requestItem, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO);
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        }
        return requestMatchInfomationVOList;
    }

    private RequestMatchInfomationVO getRequestMatchInfomationVOByInquiry(Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, RequestMatchInfomationVO paramRequestMatchInfo, PurchaseRequestHead requestHead, PurchaseRequestItem requestItem, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO) {
        RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
        requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
        requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
        requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
        requestMatchInfomationVO.setMaterialName(requestItem.getMaterialName());
        requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
        requestMatchInfomationVO.setToOrderQuantity(BigDecimal.ZERO);
        requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
        requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
        requestMatchInfomationVO.setCompany(requestItem.getCompany());
        requestMatchInfomationVO.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
        requestMatchInfomationVO.setFactory(requestItem.getFactory());
        requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
        requestMatchInfomationVO.setRequestItemId(requestItem.getId());
        requestMatchInfomationVO.setRequestType(requestHead.getRequestType());
        requestMatchInfomationVO.setRequestTypeName(requestHead.getRequestTypeName());
        requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseUnit(requestItem.getPurchaseUnit());
        requestMatchInfomationVO.setItemRequestTypeName(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
        if (StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
            requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
        }
        requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
        requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
        requestMatchInfomationVO.setCateName(requestItem.getCateName());
        requestMatchInfomationVO.setPreferredSupplier(PURCHASE_UNIT_TYPE);
        requestMatchInfomationVO.setFreePrice(purchaseOrderGenarateConfig.getPriceInfo());
        requestMatchInfomationVO.setTemplateNumber(purchaseOrderGenarateConfig.getTemplateNumber());
        requestMatchInfomationVO.setTemplateName(purchaseOrderGenarateConfig.getTemplateName());
        requestMatchInfomationVO.setTemplateAccount(purchaseOrderGenarateConfig.getTemplateAccount());
        requestMatchInfomationVO.setTemplateVersion(Integer.parseInt(purchaseOrderGenarateConfig.getTemplateVersion()));
        requestMatchInfomationVO.setOrderType(purchaseOrderGenarateConfig.getOrderType());
        requestMatchInfomationVO.setPurchaseType(purchaseOrderGenarateConfig.getItemPurchaseType());
        if (paramRequestMatchInfo != null) {
            SupplierMasterDataDTO supplierMasterDataDTO = supplierMasterDataDTOMap.get(paramRequestMatchInfo.getToElsAccount());
            SupplierOrgInfoDTO supplierOrgInfoDTO = supplierOrgInfoDTOMap.get(paramRequestMatchInfo.getElsAccount() + "&&" + paramRequestMatchInfo.getToElsAccount() + "&&" + paramRequestMatchInfo.getPurchaseOrg());
            if (supplierMasterDataDTO != null) {
                requestMatchInfomationVO.setNeedCoordination(supplierMasterDataDTO.getNeedCoordination());
                requestMatchInfomationVO.setSupplierName(supplierMasterDataDTO.getSupplierName());
            }
            if (supplierOrgInfoDTO != null) {
                requestMatchInfomationVO.setPayWay(supplierOrgInfoDTO.getPaymentMethod());
                requestMatchInfomationVO.setPaymentClause(supplierOrgInfoDTO.getPayConditionCode());
            }
            requestMatchInfomationVO.setToElsAccount(paramRequestMatchInfo.getToElsAccount());
            requestMatchInfomationVO.setTaxRate(paramRequestMatchInfo.getTaxRate());
            requestMatchInfomationVO.setTaxCode(paramRequestMatchInfo.getTaxCode());
            BigDecimal taxRate = new BigDecimal(paramRequestMatchInfo.getTaxRate() == null ? PURCHASE_UNIT_TYPE : paramRequestMatchInfo.getTaxRate());
            BigDecimal price = paramRequestMatchInfo.getPrice() == null ? BigDecimal.ONE : paramRequestMatchInfo.getPrice();
            BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            requestMatchInfomationVO.setPrice(price);
            requestMatchInfomationVO.setNetPirce(netPrice);
            requestMatchInfomationVO.setCurrency(paramRequestMatchInfo.getCurrency());
            requestMatchInfomationVO.setEstimate(paramRequestMatchInfo.getEstimate());
            requestMatchInfomationVO.setPriceUnit(paramRequestMatchInfo.getPriceUnit());
            if (REPERTORY_UNIT_TYPE.equals(purchaseOrderPermissionConfigDTO.getCentralizedDelivery())) {
                requestMatchInfomationVO.setDeliveryAddress(purchaseOrderPermissionConfigDTO.getDeliveryAddress());
            }
            if (StringUtils.isEmpty((CharSequence)paramRequestMatchInfo.getPriceUnit())) {
                requestMatchInfomationVO.setPriceUnit(REPERTORY_UNIT_TYPE);
            }
        }
        return requestMatchInfomationVO;
    }

    private Map<String, List<PurchaseRequestItem>> classicByMaterialSource(List<PurchaseRequestItem> requestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        HashMap<String, List<PurchaseRequestItem>> goodsMaterialNumberMap = new HashMap<String, List<PurchaseRequestItem>>();
        if (purchaseMaterialHeadExtendMap != null) {
            goodsMaterialNumberMap.put(HAD_SOURCE, new ArrayList());
            goodsMaterialNumberMap.put(NO_HAD_SOURCE, new ArrayList());
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
                if (REPERTORY_UNIT_TYPE.equals(purchaseMaterialHeadExtend.getSource())) {
                    ((List)goodsMaterialNumberMap.get(HAD_SOURCE)).add(requestItem);
                    continue;
                }
                ((List)goodsMaterialNumberMap.get(NO_HAD_SOURCE)).add(requestItem);
            }
        }
        return goodsMaterialNumberMap;
    }

    private List<RequestMatchInfomationVO> doRequestToRequestInfomation(List<PurchaseRequestItem> purchaseRequestItemList) {
        List<RequestMatchInfomationVO> requestMatchInfomationList;
        DeliveryOrderAddressDTO deliveryOrderAddressDTO;
        PurchaseRequestHead requestHead;
        PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend;
        PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO;
        PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig;
        Map<PurchaseOrderGenarateConfigDTO, List> purchaseOrderGenarateConfigMap;
        List informationRecordsDTOList;
        List requestHeadIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List purchaseRequestHeadList = this.listByIds(requestHeadIds);
        Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap = this.queryOrderGenrateConfigByMap(purchaseRequestHeadList, purchaseRequestItemList);
        List<PurchaseRequestItem> requestItemList = this.combinRequestItem(orderGenarateConfigMap);
        if (CollectionUtil.isEmpty(requestItemList)) {
            throw new ELSBootException("\u5408\u5e76\u9700\u6c42\u540e,\u8f6c\u5355\u9700\u6c42\u4e3a\u7a7a");
        }
        Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(requestItemList);
        Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = this.getPurchaseMaterialHeadMap(requestItemList);
        Map<String, List<PurchaseRequestItem>> goodsMaterialNumberMap = this.classicByMaterialSource(requestItemList, purchaseMaterialHeadExtendMap);
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        HashMap<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap = new HashMap<String, List<PurchaseInformationRecordsDTO>>();
        List<PurchaseRequestItem> hadGoodsRequestItemList = goodsMaterialNumberMap.get(HAD_SOURCE);
        List<PurchaseRequestItem> noHadRequestItemList = goodsMaterialNumberMap.get(NO_HAD_SOURCE);
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
        this.addNoMaterialRequestInfoToMap(informationRecordsMap, noHadRequestItemList);
        this.addHadMaterialRequestInfoToMap(informationRecordsMap, hadGoodsRequestItemList);
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(informationRecordsMap);
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgDataInfoList(informationRecordsMap);
        Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = this.getSupplierMasterDataMapByToElsAccount(supplierMasterDataDTOList);
        Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = this.getSupplierOrgDataInfoMapByKey(supplierOrgInfoDTOList);
        Map<String, DeliveryOrderAddressDTO> deliveryOrderAddressDTOMap = this.getDeliveryOrderAddressMap(requestItemList);
        for (PurchaseRequestItem requestItem : noHadRequestItemList) {
            informationRecordsDTOList = (List)informationRecordsMap.get(requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory());
            purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get(requestItem.getMaterialGroup() + "_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_");
            }
            if (purchaseOrderGenarateConfigMap == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u9879!");
            }
            purchaseOrderGenarateConfig = purchaseOrderGenarateConfigMap.keySet().iterator().next();
            purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get(requestItem.getCateCode() + "_" + requestItem.getFactory());
            if (purchaseOrderPermissionConfigDTO == null) {
                purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get("_" + requestItem.getFactory());
            }
            if (CollectionUtil.isEmpty((Collection)informationRecordsDTOList) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u53d7\u4ef7\u683c\u63a7\u5236,\u4f46\u7cfb\u7edf\u6ca1\u6709\u5339\u914d\u5230\u6709\u6548\u7684\u4ef7\u683c");
            }
            if (purchaseOrderPermissionConfigDTO == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u6743\u9650\u914d\u7f6e,\u8bf7\u5148\u7ef4\u62a4\u8ba2\u5355\u6743\u9650\u6570\u636e");
            }
            purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
            requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
            deliveryOrderAddressDTO = deliveryOrderAddressDTOMap.get(requestItem.getFactory());
            requestMatchInfomationList = this.getRequestMatchInfomationVO(requestItem, informationRecordsDTOList, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
            requestMatchInfomationVOList.addAll(requestMatchInfomationList);
        }
        for (PurchaseRequestItem requestItem : hadGoodsRequestItemList) {
            informationRecordsDTOList = (List)informationRecordsMap.get(requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory());
            purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get(requestItem.getMaterialGroup() + "_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            if (purchaseOrderGenarateConfigMap == null) {
                purchaseOrderGenarateConfigMap = orderGenarateConfigMap.get("_" + requestItem.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            if (purchaseOrderGenarateConfigMap == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u9879!");
            }
            purchaseOrderGenarateConfig = purchaseOrderGenarateConfigMap.keySet().iterator().next();
            purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get(requestItem.getCateCode() + "_" + requestItem.getFactory());
            if (purchaseOrderPermissionConfigDTO == null) {
                purchaseOrderPermissionConfigDTO = orderPermissionConfigMap.get("_" + requestItem.getFactory());
            }
            if (CollectionUtil.isEmpty((Collection)informationRecordsDTOList) && REPERTORY_UNIT_TYPE.equals(purchaseOrderGenarateConfig.getPriceInfo())) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u5728\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e2d\u53d7\u4ef7\u683c\u63a7\u5236,\u4f46\u7cfb\u7edf\u6ca1\u6709\u5339\u914d\u5230\u6709\u6548\u7684\u4ef7\u683c");
            }
            if (purchaseOrderPermissionConfigDTO == null) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u53f7:" + requestItem.getRequestNumber() + "\u884c\u53f7:" + requestItem.getItemNumber() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u6743\u9650\u914d\u7f6e,\u8bf7\u5148\u7ef4\u62a4\u8ba2\u5355\u6743\u9650\u6570\u636e");
            }
            purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
            requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
            deliveryOrderAddressDTO = deliveryOrderAddressDTOMap.get(requestItem.getFactory());
            requestMatchInfomationList = this.getRequestMatchInfomationVO(requestItem, informationRecordsDTOList, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
            requestMatchInfomationVOList.addAll(requestMatchInfomationList);
        }
        return requestMatchInfomationVOList;
    }

    private Map<String, DeliveryOrderAddressDTO> getDeliveryOrderAddressMap(List<PurchaseRequestItem> requestItemList) {
        List<String> factoryList;
        if (CollectionUtil.isNotEmpty(requestItemList) && CollectionUtil.isNotEmpty(factoryList = requestItemList.stream().map(PurchaseRequestItem::getFactory).distinct().collect(Collectors.toList()))) {
            List deliveryOrderAddressDTOList = this.inquiryInvokeOrderRpcService.getDeliveryOrderAddressList(factoryList);
            deliveryOrderAddressDTOList = deliveryOrderAddressDTOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeliveryOrderAddressDTO>(Comparator.comparing(o -> o.getOrganizationNo()))), ArrayList::new));
            Map<String, DeliveryOrderAddressDTO> deliveryOrderAndAddressMap = deliveryOrderAddressDTOList.stream().collect(Collectors.toMap(DeliveryOrderAddressDTO::getOrganizationNo, Function.identity()));
            return deliveryOrderAndAddressMap;
        }
        return null;
    }

    private List<PurchaseRequestItem> combinRequestItem(Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenarateConfigMap) {
        ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
        Set<String> keys = orderGenarateConfigMap.keySet();
        for (String key : keys) {
            ArrayList requestItems;
            HashMap<String, PurchaseRequestItem> purchaseRequestItemMap;
            Map<PurchaseOrderGenarateConfigDTO, List> requestItemMap = orderGenarateConfigMap.get(key);
            if (requestItemMap.size() == 0) {
                throw new ELSBootException("\u8bf7\u7ef4\u62a4\u8ba2\u5355\u751f\u6210\u914d\u7f6e!");
            }
            Set<PurchaseOrderGenarateConfigDTO> purchaseOrderGenarateConfigDTOS = requestItemMap.keySet();
            PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO = purchaseOrderGenarateConfigDTOS.iterator().next();
            List subRequestItemList = requestItemMap.get(purchaseOrderGenarateConfigDTO);
            if (StringUtils.isBlank((CharSequence)purchaseOrderGenarateConfigDTO.getQuantityCondition())) {
                requestItemList.addAll(subRequestItemList);
                continue;
            }
            String quantityCondition = purchaseOrderGenarateConfigDTO.getQuantityCondition();
            String[] quantityConditionArray = quantityCondition.split(",");
            if (quantityConditionArray.length == 2) {
                purchaseRequestItemMap = new HashMap<String, PurchaseRequestItem>();
                for (PurchaseRequestItem requestItem : subRequestItemList) {
                    if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"))) {
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getQuantity().add(requestItem.getQuantity());
                        continue;
                    }
                    purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"), requestItem);
                }
                requestItems = new ArrayList(purchaseRequestItemMap.values());
                requestItemList.addAll(requestItems);
                continue;
            }
            if (quantityConditionArray.length != 1) continue;
            purchaseRequestItemMap = new HashMap();
            for (PurchaseRequestItem requestItem : subRequestItemList) {
                BigDecimal quantity;
                if ("factory".equals(quantityConditionArray[0])) {
                    if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory())) {
                        quantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).getQuantity().add(requestItem.getQuantity());
                        ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory()))).setQuantity(quantity);
                        continue;
                    }
                    purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + requestItem.getFactory(), requestItem);
                    continue;
                }
                if (!"requiryDate".equals(quantityConditionArray[0])) continue;
                if (purchaseRequestItemMap.containsKey(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"))) {
                    quantity = ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).getQuantity().add(requestItem.getQuantity());
                    ((PurchaseRequestItem)((Object)purchaseRequestItemMap.get(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd")))).setQuantity(quantity);
                    continue;
                }
                purchaseRequestItemMap.put(requestItem.getMaterialNumber() + "&&" + DateUtil.format((Date)requestItem.getDeliveryDate(), (String)"yyyy-MM-dd"), requestItem);
            }
            requestItems = new ArrayList(purchaseRequestItemMap.values());
            requestItemList.addAll(requestItems);
        }
        return requestItemList;
    }

    private Map<String, Map<PurchaseOrderGenarateConfigDTO, List>> queryOrderGenrateConfigByMap(List<PurchaseRequestHead> purchaseRequestHeadList, List<PurchaseRequestItem> requestItemList) {
        HashMap resultMap = new HashMap();
        HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>> orderGenerateMap = new HashMap<String, Map<PurchaseOrderGenarateConfigDTO, List>>();
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(requestItemList)) {
            Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                if (keys.contains(requestHead.getRequestType())) continue;
                keys.add(requestHead.getRequestType());
            }
            List<PurchaseOrderGenarateConfigDTO> orderGenarateConfigDTOList = this.inquiryInvokeOrderRpcService.queryOrderGenrateConfigByRequestType(keys);
            if (CollectionUtil.isNotEmpty(orderGenarateConfigDTOList)) {
                for (PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO : orderGenarateConfigDTOList) {
                    String orderGenarateKey = purchaseOrderGenarateConfigDTO.getConfigTypeValue() + "_" + purchaseOrderGenarateConfigDTO.getPurchaseRequestType() + "_" + purchaseOrderGenarateConfigDTO.getItemPurchaseType();
                    HashMap orderGenarateConfigDTOListMap = new HashMap();
                    orderGenarateConfigDTOListMap.put(purchaseOrderGenarateConfigDTO, new ArrayList());
                    orderGenerateMap.put(orderGenarateKey, orderGenarateConfigDTOListMap);
                }
                for (PurchaseRequestItem purchaseRequestItem : requestItemList) {
                    List list;
                    Set purchaseOrderGenarateConfigDTOS;
                    Map orderGenarateConfigDTOListMap;
                    if (orderGenerateMap.containsKey(purchaseRequestItem.getMaterialGroup() + "_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get(purchaseRequestItem.getMaterialGroup() + "_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    if (orderGenerateMap.containsKey("_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType())) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get("_" + purchaseRequestItem.getRequestType() + "_" + purchaseRequestItem.getPurchaseType());
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    if (orderGenerateMap.containsKey("_" + purchaseRequestItem.getRequestType() + "_")) {
                        orderGenarateConfigDTOListMap = (Map)orderGenerateMap.get("_" + purchaseRequestItem.getRequestType() + "_");
                        purchaseOrderGenarateConfigDTOS = orderGenarateConfigDTOListMap.keySet();
                        list = (List)orderGenarateConfigDTOListMap.get(purchaseOrderGenarateConfigDTOS.iterator().next());
                        list.add(purchaseRequestItem);
                        continue;
                    }
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + purchaseRequestItem.getMaterialNumber() + "\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e");
                }
            } else {
                throw new ELSBootException("\u52fe\u9009\u5230\u7684\u9700\u6c42\u5339\u914d\u5230\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u5bf9\u5e94\u7684\u8ba2\u5355\u751f\u6210\u914d\u7f6e");
            }
        }
        return orderGenerateMap;
    }

    private Map<String, SupplierOrgInfoDTO> getSupplierOrgDataInfoMapByKey(List<SupplierOrgInfoDTO> supplierOrgInfoDTOList) {
        HashMap<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap = new HashMap<String, SupplierOrgInfoDTO>();
        for (SupplierOrgInfoDTO supplierOrgInfoDTO : supplierOrgInfoDTOList) {
            String key = supplierOrgInfoDTO.getToElsAccount() + "&&" + supplierOrgInfoDTO.getElsAccount() + "&&" + supplierOrgInfoDTO.getOrgCode();
            supplierOrgInfoDTOMap.put(key, supplierOrgInfoDTO);
        }
        return supplierOrgInfoDTOMap;
    }

    private Map<String, SupplierMasterDataDTO> getSupplierMasterDataMapByToElsAccount(List<SupplierMasterDataDTO> supplierMasterDataDTOList) {
        HashMap<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = new HashMap<String, SupplierMasterDataDTO>();
        if (CollectionUtil.isNotEmpty(supplierMasterDataDTOList)) {
            for (SupplierMasterDataDTO supplierMasterDataDTO : supplierMasterDataDTOList) {
                supplierMasterDataDTOMap.put(supplierMasterDataDTO.getToElsAccount(), supplierMasterDataDTO);
            }
        }
        return supplierMasterDataDTOMap;
    }

    private List<SupplierOrgInfoDTO> getSupplierOrgDataInfoList(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap) {
        Set<String> keys = informationRecordsMap.keySet();
        ArrayList<String> orgDataKeyList = new ArrayList<String>();
        for (String key : keys) {
            List<PurchaseInformationRecordsDTO> informayionRecordList = informationRecordsMap.get(key);
            for (PurchaseInformationRecordsDTO informationRecordsDTO : informayionRecordList) {
                orgDataKeyList.add(informationRecordsDTO.getElsAccount() + "&&" + informationRecordsDTO.getToElsAccount() + "&&" + informationRecordsDTO.getPurchaseOrg());
            }
        }
        List<SupplierOrgInfoDTO> supplierOrgInfoDTOList = this.getSupplierOrgInfoDTOS(orgDataKeyList);
        return supplierOrgInfoDTOList;
    }

    private List<SupplierOrgInfoDTO> getSupplierOrgInfoDTOS(List<String> orgDataKeyList) {
        return this.inquiryInvokeSupplierRpcService.selectSupplierOrgInfoList(orgDataKeyList);
    }

    private List<SupplierMasterDataDTO> getSupplierMasterDataDTOList(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap) {
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = null;
        if (informationRecordsMap.size() > 0) {
            Set<String> keys = informationRecordsMap.keySet();
            ArrayList<String> toElsAccounts = new ArrayList<String>();
            for (String key : keys) {
                List<PurchaseInformationRecordsDTO> informayionRecordList = informationRecordsMap.get(key);
                List toElsAccountList = informayionRecordList.stream().map(PurchaseInformationRecordsDTO::getToElsAccount).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(toElsAccountList)) continue;
                toElsAccounts.addAll(toElsAccountList);
            }
            String elsAccount = TenantContext.getTenant();
            if (CollectionUtil.isNotEmpty(toElsAccounts)) {
                supplierMasterDataDTOList = this.getSupplierMasterDataDTOList(toElsAccounts, elsAccount);
            } else {
                throw new ELSBootException("\u52fe\u9009\u7684\u9700\u6c42\u67e5\u627e\u4e0d\u5230\u6709\u6548\u7684\u4ef7\u683c");
            }
        }
        return supplierMasterDataDTOList;
    }

    private List<SupplierMasterDataDTO> getSupplierMasterDataDTOList(List<String> toElsAccounts, String elsAccount) {
        return this.inquiryInvokeSupplierRpcService.selectSupplerList(elsAccount, toElsAccounts);
    }

    private void addHadMaterialRequestInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, List<PurchaseRequestItem> hadGoodsRequestItemList) {
        if (CollectionUtil.isNotEmpty(hadGoodsRequestItemList)) {
            List<String> materialNumbers = hadGoodsRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List<PurchaseMaterialSourceDTO> purchaseMaterialSourceList = this.purchaseMaterialSourceLocalRpcService.selectList(materialNumbers, MaterialSourceStatusEnum.NORMAL.getValue(), new Date(), new Date());
            Map<String, List<PurchaseMaterialSourceDTO>> materialNumberMapToSource = purchaseMaterialSourceList.parallelStream().collect(Collectors.groupingBy(PurchaseMaterialSourceDTO::getMaterialNumber));
            HashSet<String> keys = new HashSet<String>();
            for (PurchaseRequestItem requestItem : hadGoodsRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            if (CollectionUtil.isNotEmpty(keys)) {
                for (String key : keys) {
                    List<PurchaseInformationRecordsDTO> informationRecordsList;
                    String materialNumber = key.split("_,")[0];
                    String purchaseOrg = key.split("_,")[1];
                    List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                    informationRecordsMap.put(key, purchaseInformationRecordsList);
                    List<PurchaseMaterialSourceDTO> materialSources = materialNumberMapToSource.get(materialNumber);
                    if (CollectionUtil.isEmpty(materialSources)) {
                        throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u5728\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u914d\u7f6e\u662f\u5426\u6b63\u786e")));
                    }
                    List<String> preferenceToElsAccountList = materialSources.stream().filter(item -> REPERTORY_UNIT_TYPE.equals(item.getPreferredSupplier())).map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
                    List<String> allToElsAccountList = materialSources.stream().map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(preferenceToElsAccountList)) {
                        informationRecordsList = this.purchaseInformationRecordsService.selectList(preferenceToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                        if (CollectionUtil.isEmpty(informationRecordsList)) {
                            throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u67e5\u627e\u4e0d\u5230\u9996\u9009\u4f9b\u5e94\u5546[" + preferenceToElsAccountList.toString() + "]\u7684\u6709\u6548\u4ef7\u683c\u8bb0\u5f55,\u8bf7\u5148\u53bb\u5bfb\u6e90\u6216\u8005\u521b\u5efa\u4ef7\u683c");
                        }
                    } else {
                        informationRecordsList = this.purchaseInformationRecordsService.selectList(allToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                        if (CollectionUtil.isEmpty(informationRecordsList)) {
                            throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u67e5\u627e\u4e0d\u5230\u6709\u6548\u4ef7\u683c");
                        }
                    }
                    if (!CollectionUtil.isNotEmpty(purchaseInformationRecordsList)) continue;
                    informationRecordsMap.put(key, purchaseInformationRecordsList);
                }
            }
        }
    }

    private void addNoMaterialRequestInfoToMap(Map<String, List<PurchaseInformationRecordsDTO>> informationRecordsMap, List<PurchaseRequestItem> noHadRequestItemList) {
        if (CollectionUtil.isNotEmpty(noHadRequestItemList)) {
            HashSet<String> keys = new HashSet<String>();
            for (PurchaseRequestItem requestItem : noHadRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_," + requestItem.getPurchaseOrg() + "_," + requestItem.getFactory();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
            if (CollectionUtil.isNotEmpty(keys)) {
                for (String key : keys) {
                    String materialNumber = key.split("_,")[0];
                    String purchaseOrg = key.split("_,")[1];
                    List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                    if (!CollectionUtil.isNotEmpty(purchaseInformationRecordsList)) continue;
                    informationRecordsMap.put(key, purchaseInformationRecordsList);
                }
            }
        }
    }

    private List<RequestMatchInfomationVO> getRequestMatchInfomationVO(PurchaseRequestItem requestItem, List<PurchaseInformationRecordsDTO> qualifiedPriceRecord, PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend, PurchaseRequestHead requestHead, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO, DeliveryOrderAddressDTO deliveryOrderAddressDTO) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        if (CollectionUtil.isNotEmpty(qualifiedPriceRecord)) {
            for (PurchaseInformationRecordsDTO informationRecordsDTO : qualifiedPriceRecord) {
                RequestMatchInfomationVO requestMatchInfomationVO = this.getRequestMatchInfomationVO2(requestItem, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, informationRecordsDTO, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        } else {
            RequestMatchInfomationVO requestMatchInfomationVO = this.getRequestMatchInfomationVO2(requestItem, purchaseMaterialHeadExtend, requestHead, supplierMasterDataDTOMap, supplierOrgInfoDTOMap, purchaseOrderGenarateConfig, null, purchaseOrderPermissionConfigDTO, deliveryOrderAddressDTO);
            requestMatchInfomationVOList.add(requestMatchInfomationVO);
        }
        return requestMatchInfomationVOList;
    }

    private RequestMatchInfomationVO getRequestMatchInfomationVO2(PurchaseRequestItem requestItem, PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend, PurchaseRequestHead requestHead, Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap, Map<String, SupplierOrgInfoDTO> supplierOrgInfoDTOMap, PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfig, PurchaseInformationRecordsDTO informationRecordsDTO, PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO, DeliveryOrderAddressDTO deliveryOrderAddressDTO) {
        RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
        requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
        requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
        requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
        requestMatchInfomationVO.setMaterialName(requestItem.getMaterialName());
        requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
        BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
        requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
        requestMatchInfomationVO.setToOrderQuantity(BigDecimal.ZERO);
        requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
        requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
        requestMatchInfomationVO.setCompany(requestItem.getCompany());
        if (StringUtils.isBlank((CharSequence)purchaseMaterialHeadExtend.getDeliveryArrange())) {
            requestMatchInfomationVO.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
        } else {
            requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getDeliveryArrange());
        }
        requestMatchInfomationVO.setFactory(requestItem.getFactory());
        requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
        requestMatchInfomationVO.setRequestItemId(requestItem.getId());
        requestMatchInfomationVO.setRequestType(requestHead.getRequestType());
        requestMatchInfomationVO.setRequestTypeName(requestHead.getRequestTypeName());
        requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
        requestMatchInfomationVO.setPurchaseUnit(requestItem.getPurchaseUnit());
        requestMatchInfomationVO.setItemRequestTypeName(requestItem.getPurchaseType());
        requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
        if (StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
            requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
        }
        requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
        requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
        requestMatchInfomationVO.setCateName(requestItem.getCateName());
        requestMatchInfomationVO.setPreferredSupplier(PURCHASE_UNIT_TYPE);
        List materialUnitDTOList = purchaseMaterialHeadExtend.getMaterialUnitDTOList();
        if (CollectionUtil.isEmpty((Collection)materialUnitDTOList)) {
            throw new ELSBootException("\u7269\u6599\u7f16\u7801\uff1a" + purchaseMaterialHeadExtend.getMaterialNumber() + "\u6ca1\u6709\u7ef4\u62a4\u8ba1\u91cf\u5355\u4f4d\u7684\u8f6c\u6362\u5173\u7cfb!");
        }
        List<Object> requestItemMaterialUnitDTOList = new ArrayList();
        PurchaseMaterialUnitDTO requestItemMaterialUnitDTO = new PurchaseMaterialUnitDTO();
        if (CollectionUtil.isNotEmpty((Collection)materialUnitDTOList)) {
            requestItemMaterialUnitDTOList = materialUnitDTOList.stream().filter(item -> PURCHASE_UNIT_TYPE.equals(item.getType()) && requestItem.getPurchaseUnit().equals(item.getObjectUnit())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(requestItemMaterialUnitDTOList)) {
                throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u7269\u6599\u7f16\u53f7\uff1a" + requestItem.getMaterialNumber() + "\u91c7\u8d2d\u5355\u4f4d\uff1a" + requestItem.getPurchaseUnit() + "\u5728\u7269\u6599\u4e3b\u6570\u636e-\u8ba1\u91cf\u5355\u4f4d\u4e2d\u627e\u4e0d\u5230\u8f6c\u6362\u5173\u7cfb");
            }
            requestItemMaterialUnitDTO = (PurchaseMaterialUnitDTO)requestItemMaterialUnitDTOList.get(0);
        }
        if (StringUtils.isBlank((CharSequence)purchaseMaterialHeadExtend.getSource())) {
            requestMatchInfomationVO.setSource(PURCHASE_UNIT_TYPE);
        } else {
            requestMatchInfomationVO.setSource(purchaseMaterialHeadExtend.getSource());
        }
        requestMatchInfomationVO.setFreePrice(purchaseOrderGenarateConfig.getPriceInfo());
        requestMatchInfomationVO.setTemplateNumber(purchaseOrderGenarateConfig.getTemplateNumber());
        requestMatchInfomationVO.setTemplateName(purchaseOrderGenarateConfig.getTemplateName());
        requestMatchInfomationVO.setTemplateAccount(purchaseOrderGenarateConfig.getTemplateAccount());
        requestMatchInfomationVO.setTemplateVersion(Integer.parseInt(purchaseOrderGenarateConfig.getTemplateVersion()));
        requestMatchInfomationVO.setOrderType(purchaseOrderGenarateConfig.getOrderType());
        requestMatchInfomationVO.setPurchaseType(purchaseOrderGenarateConfig.getItemPurchaseType());
        if (informationRecordsDTO != null) {
            SupplierMasterDataDTO supplierMasterDataDTO = supplierMasterDataDTOMap.get(informationRecordsDTO.getToElsAccount());
            SupplierOrgInfoDTO supplierOrgInfoDTO = supplierOrgInfoDTOMap.get(informationRecordsDTO.getElsAccount() + "&&" + informationRecordsDTO.getToElsAccount() + "&&" + informationRecordsDTO.getPurchaseOrg());
            requestMatchInfomationVO.setNeedCoordination(supplierMasterDataDTO.getNeedCoordination());
            if (supplierOrgInfoDTO != null) {
                requestMatchInfomationVO.setPayWay(supplierOrgInfoDTO.getPaymentMethod());
                requestMatchInfomationVO.setPaymentClause(supplierOrgInfoDTO.getPayConditionCode());
            }
            requestMatchInfomationVO.setToElsAccount(informationRecordsDTO.getToElsAccount());
            requestMatchInfomationVO.setSupplierName(informationRecordsDTO.getSupplierName());
            requestMatchInfomationVO.setTaxRate(informationRecordsDTO.getTaxRate());
            requestMatchInfomationVO.setTaxCode(informationRecordsDTO.getTaxCode());
            BigDecimal price = informationRecordsDTO.getPrice();
            if (StringUtils.isEmpty((CharSequence)informationRecordsDTO.getPurchaseUnit())) {
                throw new ELSBootException("\u7269\u6599\u7f16\u53f7:" + informationRecordsDTO.getMaterialNumber() + "\u5339\u914d\u7684\u4ef7\u683c,\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55\u53f7" + informationRecordsDTO.getInfoRecordNumber() + "\u7684\u91c7\u8d2d\u5355\u4f4d\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u8865\u5145!");
            }
            List infomationMaterialUnitDTOList = materialUnitDTOList.stream().filter(item -> PURCHASE_UNIT_TYPE.equals(item.getType()) && requestItem.getPurchaseUnit().equals(item.getObjectUnit())).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(infomationMaterialUnitDTOList)) {
                throw new ELSBootException("\u4ef7\u683c\u8bb0\u5f55\u53f7\uff1a" + informationRecordsDTO.getInfoRecordNumber() + "\u91c7\u8d2d\u5355\u4f4d\uff1a" + informationRecordsDTO.getPurchaseUnit() + "\u5728\u7269\u6599\u4e3b\u6570\u636e-\u8ba1\u91cf\u5355\u4f4d\u4e2d\u627e\u4e0d\u5230\u8f6c\u6362\u5173\u7cfb");
            }
            PurchaseMaterialUnitDTO informationMaterialUnit = (PurchaseMaterialUnitDTO)infomationMaterialUnitDTOList.get(0);
            price = price.divide(informationMaterialUnit.getBasicAmount()).setScale(6, RoundingMode.HALF_UP).multiply(informationMaterialUnit.getObjectAmount());
            price = price.divide(requestItemMaterialUnitDTO.getObjectAmount()).setScale(6, RoundingMode.HALF_UP).multiply(requestItemMaterialUnitDTO.getBasicAmount());
            BigDecimal taxRate = new BigDecimal(informationRecordsDTO.getTaxRate());
            BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 4);
            requestMatchInfomationVO.setPrice(price);
            requestMatchInfomationVO.setNetPirce(netPrice);
            requestMatchInfomationVO.setEffectiveDate(informationRecordsDTO.getEffectiveDate());
            requestMatchInfomationVO.setExpiryDate(informationRecordsDTO.getExpiryDate());
            requestMatchInfomationVO.setLadderPriceJson(informationRecordsDTO.getLadderPriceJson());
            requestMatchInfomationVO.setCurrency(informationRecordsDTO.getCurrencyCode());
            requestMatchInfomationVO.setEstimate(informationRecordsDTO.getTemporaryPrice());
            requestMatchInfomationVO.setPriceUnit(informationRecordsDTO.getPriceUnit());
            if (REPERTORY_UNIT_TYPE.equals(purchaseOrderPermissionConfigDTO.getCentralizedDelivery())) {
                requestMatchInfomationVO.setDeliveryAddress(purchaseOrderPermissionConfigDTO.getDeliveryAddress());
            } else if (deliveryOrderAddressDTO != null) {
                requestMatchInfomationVO.setDeliveryAddress(deliveryOrderAddressDTO.getAddress());
            }
            if (StringUtils.isEmpty((CharSequence)informationRecordsDTO.getPriceUnit())) {
                requestMatchInfomationVO.setPriceUnit(REPERTORY_UNIT_TYPE);
            }
        }
        return requestMatchInfomationVO;
    }

    private Map<String, PurchaseMaterialHeadExtendDTO> getPurchaseMaterialHeadMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            HashMap<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = new HashMap<String, PurchaseMaterialHeadExtendDTO>();
            List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadList = this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumbers);
            List<String> materialIds = purchaseMaterialHeadList.stream().map(BaseDTO::getId).collect(Collectors.toList());
            List<PurchaseMaterialUnitDTO> materialUnitDTOList = this.purchaseMaterialHeadLocalRpcService.listUnitByMaterialIds(materialIds);
            Map<String, List<PurchaseMaterialUnitDTO>> materialUnitClassicByHeadId = materialUnitDTOList.stream().collect(Collectors.groupingBy(PurchaseMaterialUnitDTO::getHeadId));
            Map materialByNumberMap = purchaseMaterialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                if (purchaseMaterialHeadExtendMap.containsKey(key)) continue;
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = new PurchaseMaterialHeadExtendDTO();
                PurchaseMaterialHeadDTO purchaseMaterialHead = (PurchaseMaterialHeadDTO)materialByNumberMap.get(requestItem.getMaterialNumber());
                com.els.common.util.Assert.isNotNull((Object)purchaseMaterialHead, (String)("\u7269\u6599\u7f16\u7801:" + requestItem.getMaterialNumber() + "\u5728\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u6ca1\u6709\u8be5\u6761\u7269\u6599,\u8bf7\u68c0\u67e5"));
                BeanUtils.copyProperties((Object)purchaseMaterialHead, (Object)purchaseMaterialHeadExtend);
                if (StringUtils.isNotBlank((CharSequence)requestItem.getFactory())) {
                    List<PurchaseMaterialItemDTO> purchaseMaterialItemList = this.purchaseMaterialHeadLocalRpcService.selectByMainIdAndFactory(purchaseMaterialHead.getId(), requestItem.getFactory());
                    PurchaseMaterialItemDTO purchaseMaterialItem = null;
                    if (CollectionUtil.isNotEmpty(purchaseMaterialItemList) && (purchaseMaterialItem = purchaseMaterialItemList.get(0)) != null) {
                        purchaseMaterialHeadExtend.setSource(purchaseMaterialItem.getSource());
                        purchaseMaterialHeadExtend.setItemJit(purchaseMaterialItem.getJit());
                        purchaseMaterialHeadExtend.setItemFactory(purchaseMaterialItem.getFactory());
                        purchaseMaterialHeadExtend.setDeliveryArrange(purchaseMaterialItem.getDeliveryArrange());
                    }
                }
                List<PurchaseMaterialUnitDTO> materialUnitDTOS = materialUnitClassicByHeadId.get(purchaseMaterialHead.getId());
                purchaseMaterialHeadExtend.setMaterialUnitDTOList(materialUnitDTOS);
                purchaseMaterialHeadExtendMap.put(key, purchaseMaterialHeadExtend);
            }
            return purchaseMaterialHeadExtendMap;
        }
        return null;
    }

    @Override
    public void syncRequestToOrderQuantity(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                BigDecimal toOrderQuantitySum;
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                String elsAccount = requestItem.getElsAccount();
                if (elsAccount == null) {
                    elsAccount = TenantContext.getTenant();
                }
                if ((toOrderQuantitySum = this.inquiryInvokeOrderRpcService.selectToOrderQuantitySum(requestItem.getRequestNumber(), requestItem.getItemNumber(), elsAccount)) == null) {
                    toOrderQuantitySum = BigDecimal.ZERO;
                }
                purchaseRequestItem.setId(requestItem.getId());
                purchaseRequestItem.setToOrderQuantity(toOrderQuantitySum);
                requestItemList.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(requestItemList);
        }
    }

    @Override
    public void syncRequestatus(List<PurchaseRequestItem> requestItemList) {
        List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseRequestItems = this.purchaseRequestItemMapper.selectBatchIds(ids);
        if (CollectionUtil.isNotEmpty((Collection)purchaseRequestItems)) {
            ArrayList<PurchaseRequestItem> purchaseRequestItems1 = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItems) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                purchaseRequestItem.setId(requestItem.getId());
                if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) == 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                } else if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) < 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_BUILT.getValue());
                }
                purchaseRequestItems1.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(purchaseRequestItems1);
        }
    }

    @Override
    public void toDemandPool(String id) {
        List<PurchaseRequestItem> collect;
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadVO);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List ids = items.stream().filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(BaseEntity::getId, ids);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        if (!CollectionUtils.isEmpty(collect = purchaseRequestItemList.parallelStream().filter(item -> !StringUtils.isBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList()))) {
            this.matchPrice(collect);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadVO.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update((Object)new PurchaseRequestHead());
        List<PurchaseRequestItem> purchaseRequestItemsNew = this.purchaseRequestItemMapper.selectByMainId(id);
        List collect1 = purchaseRequestItemsNew.parallelStream().filter(item -> "sumit".equals(item.getTacticsEntity()) || "person".equals(item.getTacticsEntity())).map(PurchaseRequestItem::getTacticsObject).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            for (String s : collect1) {
                if (!s.contains("_")) continue;
                String[] s1 = s.split("_");
                super.sendMsg(purchaseRequestHead.getElsAccount(), s1[1], (Object)purchaseRequestHead, "", "purchaseRequest", "publish");
            }
        }
    }

    @Override
    public List<PurchaseRequestItemDTO> selectPurchaseRequestItemByItemIds(List<String> itemIds) {
        List list = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, itemIds)).list();
        return SysUtil.copyProperties((List)list, PurchaseRequestItemDTO.class);
    }

    @Override
    public String requestToCreateOrder(List<RequestMatchInfomationVO> requestMatchInfomationList) {
        HashMap<String, List<RequestMatchInfomationVO>> requestMatchInfumationMapByCondition = new HashMap<String, List<RequestMatchInfomationVO>>();
        for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationList) {
            List<RequestMatchInfomationVO> requestMatchInfomationVOS;
            String key = requestMatchInfomationVO.getToElsAccount() + "&&" + requestMatchInfomationVO.getPurchaseOrg() + "&&" + requestMatchInfomationVO.getPurchaseGroup() + "&&" + requestMatchInfomationVO.getCompany() + "&&" + requestMatchInfomationVO.getFreePrice() + "&&" + requestMatchInfomationVO.getOrderType() + "&&" + requestMatchInfomationVO.getTemplateNumber() + requestMatchInfomationVO.getTemplateAccount() + "&&" + requestMatchInfomationVO.getCurrency();
            if (requestMatchInfumationMapByCondition.containsKey(key)) {
                requestMatchInfomationVOS = (List)requestMatchInfumationMapByCondition.get(key);
                requestMatchInfomationVOS.add(requestMatchInfomationVO);
                requestMatchInfumationMapByCondition.put(key, requestMatchInfomationVOS);
                continue;
            }
            requestMatchInfomationVOS = new ArrayList();
            requestMatchInfomationVOS.add(requestMatchInfomationVO);
            requestMatchInfumationMapByCondition.put(key, requestMatchInfomationVOS);
        }
        List<PurchaseOrderHeadDTO> orderHeadDTOList = this.packageRequestToOrder(requestMatchInfumationMapByCondition);
        String result = this.inquiryInvokeOrderRpcService.requestToCreateOrder(orderHeadDTOList);
        ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationList) {
            PurchaseRequestItem requestItem = new PurchaseRequestItem();
            requestItem.setRequestNumber(requestMatchInfomationVO.getRequestNumber());
            requestItem.setItemNumber(requestMatchInfomationVO.getRequestItemNumber());
            requestItem.setId(requestMatchInfomationVO.getRequestItemId());
            requestItem.setElsAccount(requestMatchInfomationVO.getElsAccount());
            purchaseRequestItemList.add(requestItem);
        }
        this.syncRequestToOrderQuantity(purchaseRequestItemList);
        this.syncRequestatus(purchaseRequestItemList);
        return result;
    }

    public List<PurchaseOrderHeadDTO> packageRequestToOrder(Map<String, List<RequestMatchInfomationVO>> requestMatchInfumationMapByCondition) {
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadVOList = new ArrayList<PurchaseOrderHeadDTO>();
        Set<String> keys = requestMatchInfumationMapByCondition.keySet();
        HashMap stringPurchaseRequestItemHashMap = new HashMap();
        LoginUser loginUser = SysUtil.getLoginUser();
        for (String key : keys) {
            Object collect;
            List<RequestMatchInfomationVO> requestMatchInfomationVOList = requestMatchInfumationMapByCondition.get(key);
            String documentId = null;
            String documenParenttId = null;
            List requestItemVoList = new ArrayList();
            if (!CollectionUtils.isEmpty(requestMatchInfomationVOList)) {
                List requestItemList = requestMatchInfomationVOList.stream().map(item -> item.getRequestItemId()).collect(Collectors.toList());
                requestItemVoList = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, requestItemList)).list();
                collect = requestItemVoList.stream().map(i -> i.getDocumentId()).collect(Collectors.toList());
                List collectHeadId = requestItemVoList.stream().map(i -> i.getHeadId()).collect(Collectors.toList());
                documentId = StringUtils.join((Iterable)collect, (char)',');
                documenParenttId = StringUtils.join(collectHeadId, (char)',');
            }
            PurchaseOrderHeadDTO purchaseOrderHead = new PurchaseOrderHeadDTO();
            collect = requestItemVoList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (v1, v2) -> v2));
            purchaseOrderHead.setDocumentParentId(documenParenttId);
            purchaseOrderHead.setDocumentId(documentId);
            ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
            ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
            int i2 = 1;
            for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationVOList) {
                PurchaseOrderItemDTO purchaseOrderItem = new PurchaseOrderItemDTO();
                if (StringUtils.isNotBlank((CharSequence)requestMatchInfomationVO.getLadderPriceJson()) && REPERTORY_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
                    this.parseLadderJsonPriceToPirceRecord(requestMatchInfomationVO, requestMatchInfomationVO.getToOrderQuantity());
                }
                purchaseOrderItem.setItemNumber("" + i2++);
                purchaseOrderItem.setMaterialNumber(requestMatchInfomationVO.getMaterialNumber());
                purchaseOrderItem.setMaterialDesc(requestMatchInfomationVO.getMaterialDesc());
                purchaseOrderItem.setMaterialGroup(requestMatchInfomationVO.getMaterialGroup());
                purchaseOrderItem.setCateCode(requestMatchInfomationVO.getCateCode());
                purchaseOrderItem.setCateName(requestMatchInfomationVO.getCateName());
                purchaseOrderItem.setQuantity(requestMatchInfomationVO.getToOrderQuantity());
                purchaseOrderItem.setPurchaseUnit(requestMatchInfomationVO.getPurchaseUnit());
                purchaseOrderItem.setPrice(requestMatchInfomationVO.getPrice());
                purchaseOrderItem.setNetPrice(requestMatchInfomationVO.getNetPirce());
                purchaseOrderItem.setTaxRate(requestMatchInfomationVO.getTaxRate());
                purchaseOrderItem.setTaxCode(requestMatchInfomationVO.getTaxCode());
                BigDecimal taxAmount = BigDecimal.ZERO;
                BigDecimal netAmount = BigDecimal.ZERO;
                taxAmount = requestMatchInfomationVO.getPrice().multiply(requestMatchInfomationVO.getToOrderQuantity());
                netAmount = requestMatchInfomationVO.getNetPirce().multiply(requestMatchInfomationVO.getToOrderQuantity());
                if (REPERTORY_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
                    if (BigDecimal.ZERO.compareTo(taxAmount) != 0) {
                        taxAmount = taxAmount.divide(new BigDecimal(requestMatchInfomationVO.getPriceUnit())).setScale(6, 4);
                    }
                    if (BigDecimal.ZERO.compareTo(netAmount) != 0) {
                        netAmount = taxAmount.divide(new BigDecimal(requestMatchInfomationVO.getPriceUnit())).setScale(6, 4);
                    }
                }
                purchaseOrderItem.setTaxAmount(taxAmount);
                purchaseOrderItem.setNetAmount(netAmount);
                purchaseOrderItem.setRequireDate(requestMatchInfomationVO.getRequireDate());
                purchaseOrderItem.setDeliveryAddress(requestMatchInfomationVO.getDeliveryAddress());
                purchaseOrderItem.setMaterialName(requestMatchInfomationVO.getMaterialName());
                purchaseOrderItem.setCurrency(requestMatchInfomationVO.getCurrency());
                purchaseOrderItem.setReceiveQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setOnWayQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setDeliveryQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setClose(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                purchaseOrderItem.setFreeze(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                purchaseOrderItem.setItemStatus(OrderItemStatusEnum.UN_CONFIRM.getValue());
                purchaseOrderItem.setSendStatus(OrderItemSendStatusEnum.NO_PUBLISH.getValue());
                if (StringUtils.isBlank((CharSequence)requestMatchInfomationVO.getJit())) {
                    purchaseOrderItem.setJit(MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue());
                } else {
                    purchaseOrderItem.setJit(requestMatchInfomationVO.getJit());
                }
                purchaseOrderItem.setDeleteOrder(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                purchaseOrderItem.setFactory(requestMatchInfomationVO.getFactory());
                purchaseOrderItem.setReturned(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                if (StringUtils.isNotEmpty((CharSequence)requestMatchInfomationVO.getEstimate())) {
                    purchaseOrderItem.setEstimate(Integer.valueOf(Integer.parseInt(requestMatchInfomationVO.getEstimate())));
                } else {
                    purchaseOrderItem.setEstimate(Integer.valueOf(Integer.parseInt(PURCHASE_UNIT_TYPE)));
                }
                purchaseOrderItem.setCheckQuality(requestMatchInfomationVO.getCheckQuality());
                purchaseOrderItem.setStorageLocation(requestMatchInfomationVO.getStorageLocation());
                if (PURCHASE_UNIT_TYPE.equals(requestMatchInfomationVO.getFreePrice())) {
                    purchaseOrderItem.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
                } else {
                    purchaseOrderItem.setSourceType(OrderSourceTypeEnum.PURCHASE_REQUEST.getValue());
                }
                purchaseOrderItem.setSourceNumber(requestMatchInfomationVO.getRequestNumber());
                purchaseOrderItem.setSourceItemNumber(requestMatchInfomationVO.getRequestItemNumber());
                purchaseOrderItem.setSourceId(requestMatchInfomationVO.getRequestItemId());
                if (collect.containsKey(requestMatchInfomationVO.getRequestItemId())) {
                    PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)collect.get(requestMatchInfomationVO.getRequestItemId()));
                    purchaseOrderItem.setDocumentId(purchaseRequestItem.getDocumentId());
                    purchaseOrderItem.setDocumentParentId(purchaseRequestItem.getId());
                    purchaseOrderItem.setId(IdWorker.getIdStr());
                }
                purchaseOrderItem.setPurchaseType(requestMatchInfomationVO.getItemRequestType());
                purchaseOrderItemList.add(purchaseOrderItem);
            }
            if (CollectionUtil.isNotEmpty(purchaseOrderItemList)) {
                int deliveryItemCount = 1;
                for (PurchaseOrderItemDTO orderItem : purchaseOrderItemList) {
                    if (!MaterialDeliveryArrangeEnum.DELIVERY_PLAN.getValue().equals(orderItem.getJit())) continue;
                    PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                    orderDeliveryPlan.setItemNumber(deliveryItemCount + "");
                    orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
                    orderDeliveryPlan.setDocumentId(orderItem.getDocumentId());
                    orderDeliveryPlan.setDocumentParentId(orderItem.getId());
                    orderDeliveryPlan.setQuantity(orderItem.getQuantity());
                    orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
                    orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
                    orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
                    orderDeliveryPlan.setPurchaseUnit(orderItem.getPurchaseUnit());
                    ++deliveryItemCount;
                    purchaseOrderDeliveryPlanList.add(orderDeliveryPlan);
                }
            }
            purchaseOrderHead.setSupplierName(requestMatchInfomationVOList.get(0).getSupplierName());
            purchaseOrderHead.setToElsAccount(requestMatchInfomationVOList.get(0).getToElsAccount());
            purchaseOrderHead.setPurchaseGroup(requestMatchInfomationVOList.get(0).getPurchaseGroup());
            purchaseOrderHead.setPurchaseOrg(requestMatchInfomationVOList.get(0).getPurchaseOrg());
            purchaseOrderHead.setCompany(requestMatchInfomationVOList.get(0).getCompany());
            purchaseOrderHead.setCurrency(requestMatchInfomationVOList.get(0).getCurrency());
            purchaseOrderHead.setTemplateName(requestMatchInfomationVOList.get(0).getTemplateName());
            purchaseOrderHead.setTemplateNumber(requestMatchInfomationVOList.get(0).getTemplateNumber());
            purchaseOrderHead.setTemplateVersion(requestMatchInfomationVOList.get(0).getTemplateVersion() + "");
            purchaseOrderHead.setTemplateAccount(requestMatchInfomationVOList.get(0).getTemplateAccount());
            purchaseOrderHead.setOrderType(requestMatchInfomationVOList.get(0).getOrderType());
            if (PURCHASE_UNIT_TYPE.equals(requestMatchInfomationVOList.get(0).getFreePrice())) {
                purchaseOrderHead.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
            } else {
                purchaseOrderHead.setSourceType(OrderSourceTypeEnum.PURCHASE_REQUEST.getValue());
            }
            purchaseOrderHead.setBusAccount(TenantContext.getTenant());
            purchaseOrderHead.setPurchasePrincipal(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            purchaseOrderHead.setPurchaseOrderItemList(purchaseOrderItemList);
            purchaseOrderHead.setPurchaseOrderDeliveryPlanList(purchaseOrderDeliveryPlanList);
            purchaseOrderHead.setPaymentWay(requestMatchInfomationVOList.get(0).getPayWay());
            purchaseOrderHead.setPaymentClause(requestMatchInfomationVOList.get(0).getPaymentClause());
            purchaseOrderHead.setIsTeamwork(requestMatchInfomationVOList.get(0).getNeedCoordination());
            purchaseOrderHeadVOList.add(purchaseOrderHead);
        }
        return purchaseOrderHeadVOList;
    }

    private void parseLadderJsonPriceToPirceRecord(RequestMatchInfomationVO requestMatchInfomationVO, BigDecimal quantity) {
        JSONArray ladderPriceArray = JSONArray.parseArray((String)requestMatchInfomationVO.getLadderPriceJson());
        BigDecimal price = requestMatchInfomationVO.getPrice();
        BigDecimal netPrice = requestMatchInfomationVO.getNetPirce();
        BigDecimal baseQuantity = BigDecimal.ZERO;
        for (Object obj : ladderPriceArray) {
            JSONObject ladderPriceJson = (JSONObject)obj;
            BigDecimal ladderPrice = ladderPriceJson.getBigDecimal("price");
            BigDecimal ladderNetPrice = ladderPriceJson.getBigDecimal("netPrice");
            BigDecimal ladderQuantity = ladderPriceJson.getBigDecimal("ladderQuantity");
            Assert.notNull((Object)ladderQuantity, (String)I18nUtil.translate((String)"", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u7a7a"));
            ladderPriceJson.put("price", (Object)ladderPrice.setScale(6, 4));
            ladderPriceJson.put("netPrice", (Object)ladderNetPrice.setScale(6, 4));
            if (quantity.compareTo(ladderQuantity) < 0 || ladderQuantity.compareTo(baseQuantity) < 0) continue;
            price = ladderPrice;
            netPrice = ladderNetPrice;
            baseQuantity = ladderQuantity;
        }
        requestMatchInfomationVO.setPrice(price);
        requestMatchInfomationVO.setNetPirce(netPrice);
    }

    @Override
    public void getPurchaseRequestByERP() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseRequestData", (Object)new JSONObject());
    }

    @Override
    public void pushPurchaseRequestData(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseRequestHeadList = this.listByIds(idList).stream().filter(head -> !REPERTORY_UNIT_TYPE.equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseRequestHead head2 : purchaseRequestHeadList) {
            this.pushPurchaseRequest(head2);
        }
    }

    private void pushPurchaseRequest(PurchaseRequestHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseRequestData", (Object)head);
    }
}

