/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.qualification.enumerate;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.service.PublicInquiryService;
import org.springframework.util.Assert;

public enum SourceTypeEnum {
    EBIDDING("ebidding", "\u7ade\u4ef7", "purchaseEbiddingHeadServiceImpl", "publicEbiddingServiceImpl"),
    BIDDING("bidding", "\u62db\u6295\u6807", "purchaseBiddingHeadServiceImpl", "publicBiddingServiceImpl"),
    ENQUIRY("enquiry", "\u8be2\u4ef7", "purchaseEnquiryHeadServiceImpl", "publicEnquiryServiceImpl"),
    SURVEY("survey", "\u95ee\u5377", "purchaseEnquiryHeadServiceImpl", "PurchaseSurveyItemServiceImpl");

    private final String value;
    private final String desc;
    private final String executeImpl;
    private final String publicImpl;

    private SourceTypeEnum(String value, String desc, String executeImpl, String publicImpl) {
        this.value = value;
        this.desc = desc;
        this.executeImpl = executeImpl;
        this.publicImpl = publicImpl;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getExecuteImpl() {
        return this.executeImpl;
    }

    public String getPublicImpl() {
        return this.publicImpl;
    }

    public static PurchaseExecuteReviewService getExecuteService(String value) {
        Assert.hasText((String)value, (String)I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"value"}));
        for (SourceTypeEnum enums : SourceTypeEnum.values()) {
            if (!enums.getValue().equals(value)) continue;
            Object impl = SpringContextUtils.getBean((String)enums.getExecuteImpl());
            if (impl instanceof PurchaseExecuteReviewService) {
                return (PurchaseExecuteReviewService)impl;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_source_type_enum_no_purchase_impl", (String)"${0} \u5fc5\u987b\u662f\u5b9e\u73b0${1}\u63a5\u53e3", (String[])new String[]{"SourceTypeEnum.impl", "PurchaseExecuteReviewService"}));
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_source_type_enum_no_find_impl", (String)"${0}\u6ca1\u6709\u627e\u5230${1}\u5bf9\u5e94\u7684impl", (String[])new String[]{"SourceTypeEnum", value}));
    }

    public static PublicInquiryService getPublicService(String value) {
        Assert.hasText((String)value, (String)I18nUtil.translate((String)"i18n_alert_empty_value_not_empty", (String)"${0}\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{"value"}));
        for (SourceTypeEnum enums : SourceTypeEnum.values()) {
            if (!enums.getValue().equals(value)) continue;
            Object impl = SpringContextUtils.getBean((String)enums.getPublicImpl());
            if (impl instanceof PublicInquiryService) {
                return (PublicInquiryService)impl;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_source_type_enum_no_public_impl", (String)"SourceTypeEnum.impl \u5fc5\u987b\u662f\u5b9e\u73b0PublicInquiryService\u63a5\u53e3"));
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_source_type_enum_no_find_impl", (String)"${0}\u6ca1\u6709\u627e\u5230${1}\u5bf9\u5e94\u7684impl", (String[])new String[]{"SourceTypeEnum", value}));
    }
}

