/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.BiddingMemberVO;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.ConfirmBidVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingHead"})
@Api(tags={"\u91c7\u8d2d\u62db\u6807\u5355"})
public class PurchaseBiddingHeadController
extends BaseController<PurchaseBiddingHead, PurchaseBiddingHeadService> {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SearSourMaterValidService validService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="bidding")
    public Result<?> queryPageList(PurchaseBiddingHead purchaseBiddingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)purchaseBiddingHead.getId())) {
            ids = purchaseBiddingHead.getId().replace(" ", "").split(",");
            purchaseBiddingHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="bidding")
    public Result<?> queryTabsCount(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)purchaseBiddingHead.getId())) {
            ids = purchaseBiddingHead.getId().replace(" ", "").split(",");
            purchaseBiddingHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select(new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = ((PurchaseBiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/contractQueryBidding"})
    @PermissionDataView(businessType="bidding")
    public Result<?> contractQueryBidding(PurchaseBiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((QueryWrapper)queryWrapper.inSql((Object)"bidding_number", "select bidding_number from purchase_bidding_head where bidding_status=5 ")).orderByDesc(true, (Object[])new String[]{"create_time"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba2\u5355\u5206\u9875\u5217\u8868\u67e5\u8be2\u62db\u6807\u884c", notes="\u8ba2\u5355\u5206\u9875\u5217\u8868\u67e5\u8be2\u62db\u6807\u884c")
    @GetMapping(value={"/orderQueryBiddingByDesc"})
    @PermissionDataView(businessType="bidding")
    public Result<?> orderQueryBiddingByDesc(PurchaseBiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.inSql((Object)"bidding_number", "select bidding_number from purchase_bidding_head where bidding_status=5 ");
        queryWrapper.eq((Object)"item_status", (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        queryWrapper.eq((Object)"material_desc", (Object)item.getMaterialDesc());
        queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.isNull((Object)"material_number")).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"material_number", (Object)"");
            });
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseBiddingHead:add"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> add(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.saveMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseBiddingHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchaseBiddingHead:edit"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> edit(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead dbPurchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)purchaseBiddingHeadPage.getId())));
        Assert.isTrue((boolean)BiddingStatusEnum.NEW.getValue().equals(dbPurchaseBiddingHead.getBiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91"));
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.updateMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"purchaseBiddingHead:publish"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> publish(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        this.validService.publishBidding(purchaseBiddingHeadPage.getPurchaseOrg(), purchaseBiddingHeadPage.getPurchaseBiddingItemList());
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getBiddingNumber())) {
            purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        }
        this.purchaseBiddingHeadService.publish(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807", notes="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @PostMapping(value={"/requestToBidding"})
    public Result<?> requestToBidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseBiddingHead head = new PurchaseBiddingHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        ArrayList<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("2", requestItemList.get(0).getPurchaseOrg(), requestItemList);
        for (PurchaseRequestItem requestItem : requestItemList) {
            PurchaseBiddingItem item2 = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item2));
            item2.setId(null);
            item2.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item2.setSourceNumber(requestItem.getRequestNumber());
            item2.setSourceItemNumber(requestItem.getItemNumber());
            item2.setSourceItemId(requestItem.getId());
            item2.setPriceUnit(requestItem.getUnitPrice());
            item2.setPurchaseUnit(requestItem.getPurchaseUnit());
            item2.setRequireQuantity(requestItem.getQuantity());
            item2.setRequireDate(requestItem.getApplyDate());
            itemList.add(item2);
        }
        head.setDocumentId(requestItemList.get(0).getDocumentId());
        if (StringUtils.isNotBlank((CharSequence)requestItemList.get(0).getDocumentId())) {
            head.setDocumentParentId(requestItemList.get(0).getHeadId());
        }
        head.setCompany(requestItemList.get(0).getCompany());
        head.setPurchaseGroup(requestItemList.get(0).getPurchaseGroup());
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)head));
        this.purchaseBiddingHeadService.saveMain(head, itemList, new ArrayList<BiddingSupplier>(), new ArrayList<PurchaseBiddingSpecialist>(), new ArrayList<PurchaseAttachmentDemandDTO>(), new ArrayList<PurchaseAttachmentDTO>());
        return Result.ok((String)("\u8f6c\u62db\u6807\u6210\u529f,\u62db\u6807\u5355\u53f7\u4e3a:" + head.getBiddingNumber()));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u5f00\u901a\u6743\u9650")
    @ApiOperation(value="\u5f00\u901a\u6743\u9650", notes="\u5f00\u901a\u6743\u9650")
    @PostMapping(value={"/openPermission"})
    @RequiresPermissions(value={"purchaseBiddingHead:openPermission"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> openPermission(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.openPermission(purchaseBiddingHead, purchaseBiddingHeadPage.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseBiddingHead:delete"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        ArrayList<PurchaseBiddingItem> distinctList = new ArrayList<PurchaseBiddingItem>();
        Map<String, List<PurchaseBiddingItem>> groupList = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getItemNumber));
        for (Map.Entry<String, List<PurchaseBiddingItem>> entry : groupList.entrySet()) {
            Optional<PurchaseBiddingItem> optional = entry.getValue().stream().filter(item -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())).findFirst();
            if (!optional.isPresent()) {
                optional = entry.getValue().stream().max(Comparator.nullsLast(Comparator.comparing(PurchaseBiddingItem::getItemStatus, Comparator.nullsFirst(Comparator.naturalOrder()))));
            }
            if (!optional.isPresent()) continue;
            if (BiddingStatusEnum.BIDDING.getValue().equals(purchaseBiddingHead.getBiddingStatus())) {
                optional.get().setPrice(null);
                optional.get().setNetPrice(null);
                optional.get().setTaxAmount(null);
                optional.get().setNetAmount(null);
            }
            distinctList.add(optional.get());
        }
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(distinctList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5")
    @GetMapping(value={"/queryQuoteById"})
    public Result<?> queryQuoteById(@RequestParam(name="id") String id) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458", notes="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458")
    @GetMapping(value={"/queryMemberById"})
    public Result<?> queryMemberById(@RequestParam(name="id") String id) {
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        return Result.ok(purchaseBiddingSpecialistList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @ApiOperation(value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458", notes="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @PostMapping(value={"/saveMember"})
    @RequiresPermissions(value={"purchaseBiddingHead:saveMember"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveMember(@RequestBody BiddingMemberVO memberVO) {
        this.purchaseBiddingSpecialistService.saveMember(memberVO.getId(), memberVO.getPurchaseBiddingSpecialistList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5f00\u6807")
    @ApiOperation(value="\u901a\u8fc7id\u5f00\u6807", notes="\u901a\u8fc7id\u5f00\u6807")
    @GetMapping(value={"/openBiddingById"})
    @RequiresPermissions(value={"purchaseBiddingHead:openBiddingById"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> openBiddingById(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.openBidding(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryConfirmBidById"})
    public Result<?> queryConfirmBidById(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, true);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)")
    @GetMapping(value={"/queryConfirmBidByIdIgnore"})
    public Result<?> queryConfirmBidByIdIgnore(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, false);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveConfirmBid"})
    @RequiresPermissions(value={"purchaseBiddingHead:saveConfirmBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveConfirmBid(@RequestBody ConfirmBidVO bidVO) {
        this.biddingSupplierService.confirmBid(bidVO.getId(), bidVO.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @ApiOperation(value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55", notes="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @GetMapping(value={"/manualCreatePrce"})
    @RequiresPermissions(value={"purchaseBiddingHead:manualCreatePrce"})
    public Result<?> manualCreatePrce(@RequestParam(name="id") String id) {
        this.biddingSupplierService.manualCreatePrce(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @GetMapping(value={"/queryByAccount"})
    public Result<?> queryByAccount(@RequestParam(name="toElsAccount") String toElsAccount) {
        List biddingSupplierList = this.biddingSupplierService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_els_account", (Object)toElsAccount)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        List biddingWinList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("participationCount", biddingSupplierList.size());
        resultMap.put("biddingWinCount", biddingWinList.size());
        return Result.ok(resultMap);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f-\u5217\u8868\u8df3\u8f6c", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f-\u5217\u8868\u8df3\u8f6c")
    @GetMapping(value={"/supplierPortraiTotList"})
    public Result<?> supplierPortraiTotList(@RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="type") String type) {
        String str;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if ("1".equals(type)) {
            queryWrapper.eq((Object)"bidding_status", (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        }
        List biddingSupplierList = this.biddingSupplierService.list((Wrapper)queryWrapper);
        List ids = biddingSupplierList.stream().map(BiddingSupplier::getHeadId).distinct().collect(Collectors.toList());
        String id = "-1";
        if (!ids.isEmpty()) {
            id = ids.toString();
            id = id.substring(1, id.length() - 1);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("id", id);
        returnMap.put("isMenu", false);
        LoginUser user = SysUtil.getLoginUser();
        JSONArray menuJsonArray = this.invokeAccountRpcService.getMenuJsonArray(user.getElsAccount(), user.getSubAccount(), Integer.valueOf(0));
        if (!menuJsonArray.isEmpty() && menuJsonArray.size() > 0 && (str = menuJsonArray.toString()).contains("/srm/bidding/purchase/PurchaseBiddingHeadList")) {
            returnMap.put("isMenu", true);
        }
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u8865\u5145\u7269\u6599")
    @ApiOperation(value="\u8865\u5145\u7269\u6599", notes="\u8865\u5145\u7269\u6599")
    @PostMapping(value={"/replenishMaterialNumber"})
    @RequiresPermissions(value={"purchaseBiddingHead:replenishMaterialNumber"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> replenishMaterialNumber(@RequestBody PurchaseBiddingItem webItem) {
        Assert.notNull((Object)((Object)webItem), (String)I18nUtil.translate((String)"", (String)"\u8865\u5145\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.biddingSupplierService.replenishMaterialNumber(webItem);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b", notes="\u4f9b\u5e94\u5546\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/queryRisk"})
    public Result<?> queryRisk(@RequestParam(name="id") String id) {
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        Map<String, BiddingSupplier> biddingSupplierMap = biddingSupplierList.stream().collect(Collectors.toMap(BiddingSupplier::getToElsAccount, Function.identity()));
        List<SupplierRelationFindResultVO> relationFindResultVOS = this.biddingSupplierService.queryRiskRelationFind(biddingSupplierMap);
        return Result.ok(relationFindResultVOS);
    }

    @GetMapping(value={"/querySupplierList"})
    public Result<?> querySupplierList(@RequestParam(name="id") String id) {
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        return Result.ok(biddingSupplierList);
    }
}

