/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplierCapacity.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.supplierCapacity.entity.PurchaseSupplierCapacityHead;
import com.els.modules.supplierCapacity.entity.PurchaseSupplierCapacityItem;
import com.els.modules.supplierCapacity.entity.SaleSupplierCapacityHead;
import com.els.modules.supplierCapacity.entity.SaleSupplierCapacityItem;
import com.els.modules.supplierCapacity.enumerate.SupplierCapacityStatusEnum;
import com.els.modules.supplierCapacity.mapper.PurchaseSupplierCapacityHeadMapper;
import com.els.modules.supplierCapacity.mapper.PurchaseSupplierCapacityItemMapper;
import com.els.modules.supplierCapacity.mapper.SaleSupplierCapacityHeadMapper;
import com.els.modules.supplierCapacity.mapper.SaleSupplierCapacityItemMapper;
import com.els.modules.supplierCapacity.service.PurchaseSupplierCapacityHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSupplierCapacityHeadServiceImpl
extends BaseServiceImpl<PurchaseSupplierCapacityHeadMapper, PurchaseSupplierCapacityHead>
implements PurchaseSupplierCapacityHeadService {
    @Autowired
    private PurchaseSupplierCapacityHeadMapper purchaseSupplierCapacityHeadMapper;
    @Autowired
    private PurchaseSupplierCapacityItemMapper purchaseSupplierCapacityItemMapper;
    @Autowired
    private SaleSupplierCapacityHeadMapper saleSupplierCapacityHeadMapper;
    @Autowired
    private SaleSupplierCapacityItemMapper saleSupplierCapacityItemMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSupplierCapacityHead purchaseSupplierCapacityHead, List<PurchaseSupplierCapacityItem> purchaseSupplierCapacityItemList) {
        BigDecimal supplierCapacity = this.computeSupplierCapacity(purchaseSupplierCapacityItemList);
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseSupplierCapacityHead.setElsAccount(loginUser.getElsAccount());
        purchaseSupplierCapacityHead.setTotalCapacityAmount(supplierCapacity);
        if (purchaseSupplierCapacityHead.getPersonTotalCapacityAmount() == null) {
            purchaseSupplierCapacityHead.setPersonTotalCapacityAmount(supplierCapacity);
        }
        purchaseSupplierCapacityHead.setRelationId(IdWorker.getIdStr());
        purchaseSupplierCapacityHead.setBusAccount(loginUser.getElsAccount());
        purchaseSupplierCapacityHead.setDocumentNumber(this.baseRpcService.getNextCode("purchaseSupplierCapacity", (Object)purchaseSupplierCapacityHead));
        this.purchaseSupplierCapacityHeadMapper.insert((Object)purchaseSupplierCapacityHead);
        super.setHeadDefaultValue((BaseEntity)purchaseSupplierCapacityHead);
        this.insertData(purchaseSupplierCapacityHead, purchaseSupplierCapacityItemList);
    }

    private BigDecimal computeSupplierCapacity(List<PurchaseSupplierCapacityItem> purchaseSupplierCapacityItemList) {
        BigDecimal result = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(purchaseSupplierCapacityItemList)) {
            for (PurchaseSupplierCapacityItem purchaseSupplierCapacityItem : purchaseSupplierCapacityItemList) {
                if (purchaseSupplierCapacityItem.getCapacity() == null) continue;
                result = result.add(purchaseSupplierCapacityItem.getCapacity());
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSupplierCapacityHead purchaseSupplierCapacityHead, List<PurchaseSupplierCapacityItem> purchaseSupplierCapacityItemList) {
        BigDecimal supplierCapacity = this.computeSupplierCapacity(purchaseSupplierCapacityItemList);
        purchaseSupplierCapacityHead.setTotalCapacityAmount(supplierCapacity);
        if (purchaseSupplierCapacityHead.getPersonTotalCapacityAmount() == null) {
            purchaseSupplierCapacityHead.setPersonTotalCapacityAmount(supplierCapacity);
        }
        this.purchaseSupplierCapacityHeadMapper.updateById((Object)purchaseSupplierCapacityHead);
        this.purchaseSupplierCapacityItemMapper.deleteByMainId(purchaseSupplierCapacityHead.getId());
        this.insertData(purchaseSupplierCapacityHead, purchaseSupplierCapacityItemList);
    }

    private void insertData(PurchaseSupplierCapacityHead purchaseSupplierCapacityHead, List<PurchaseSupplierCapacityItem> purchaseSupplierCapacityItemList) {
        if (!CollectionUtils.isEmpty(purchaseSupplierCapacityItemList)) {
            for (PurchaseSupplierCapacityItem entity : purchaseSupplierCapacityItemList) {
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSupplierCapacityHead);
                entity.setHeadId(purchaseSupplierCapacityHead.getId());
                entity.setRelationId(IdWorker.getIdStr());
                entity.setId(IdWorker.getIdStr());
                entity.setDocumentNumber(purchaseSupplierCapacityHead.getDocumentNumber());
                entity.setElsAccount(purchaseSupplierCapacityHead.getElsAccount());
                entity.setToElsAccount(purchaseSupplierCapacityHead.getToElsAccount());
            }
            if (!purchaseSupplierCapacityItemList.isEmpty()) {
                this.purchaseSupplierCapacityItemMapper.insertBatchSomeColumn(purchaseSupplierCapacityItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSupplierCapacityItemMapper.deleteByMainId(id);
        this.purchaseSupplierCapacityHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSupplierCapacityItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSupplierCapacityHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void publish(PurchaseSupplierCapacityHead purchaseSupplierCapacityHead, List<PurchaseSupplierCapacityItem> purchaseSupplierCapacityItemList) {
        PurchaseSupplierCapacityHead dbSupplierCapacity = (PurchaseSupplierCapacityHead)((Object)this.getById((Serializable)((Object)purchaseSupplierCapacityHead.getId())));
        if (dbSupplierCapacity == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8be5\u5355\u636e,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        SaleSupplierCapacityHead dbSaleSupplierCapacityHead = (SaleSupplierCapacityHead)((Object)this.saleSupplierCapacityHeadMapper.selectById((Serializable)((Object)purchaseSupplierCapacityHead.getRelationId())));
        purchaseSupplierCapacityHead.setDocumentStatus(SupplierCapacityStatusEnum.PUBLISH.getValue());
        SaleSupplierCapacityHead saleSupplierCapacityHead = new SaleSupplierCapacityHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierCapacityHead), (Object)((Object)saleSupplierCapacityHead));
        saleSupplierCapacityHead.setElsAccount(purchaseSupplierCapacityHead.getToElsAccount());
        saleSupplierCapacityHead.setToElsAccount(purchaseSupplierCapacityHead.getElsAccount());
        saleSupplierCapacityHead.setId(purchaseSupplierCapacityHead.getRelationId());
        saleSupplierCapacityHead.setRelationId(purchaseSupplierCapacityHead.getId());
        if (dbSaleSupplierCapacityHead == null) {
            this.saleSupplierCapacityHeadMapper.insert((Object)saleSupplierCapacityHead);
        } else {
            this.saleSupplierCapacityHeadMapper.updateById((Object)saleSupplierCapacityHead);
            this.saleSupplierCapacityItemMapper.deleteByMainId(purchaseSupplierCapacityHead.getRelationId());
        }
        this.purchaseSupplierCapacityHeadMapper.updateById((Object)purchaseSupplierCapacityHead);
        if (CollectionUtil.isNotEmpty(purchaseSupplierCapacityItemList)) {
            ArrayList<SaleSupplierCapacityItem> saleSupplierCapacityItemList = new ArrayList<SaleSupplierCapacityItem>();
            for (PurchaseSupplierCapacityItem purchaseSupplierCapacityItem : purchaseSupplierCapacityItemList) {
                SaleSupplierCapacityItem saleSupplierCapacityItem = new SaleSupplierCapacityItem();
                BeanUtils.copyProperties((Object)((Object)purchaseSupplierCapacityItem), (Object)((Object)saleSupplierCapacityItem));
                saleSupplierCapacityItem.setId(purchaseSupplierCapacityItem.getRelationId());
                saleSupplierCapacityItem.setRelationId(purchaseSupplierCapacityItem.getId());
                saleSupplierCapacityItem.setElsAccount(purchaseSupplierCapacityItem.getToElsAccount());
                saleSupplierCapacityItem.setToElsAccount(purchaseSupplierCapacityItem.getElsAccount());
                saleSupplierCapacityItem.setDocumentNumber(saleSupplierCapacityHead.getDocumentNumber());
                saleSupplierCapacityItemList.add(saleSupplierCapacityItem);
            }
            this.saleSupplierCapacityItemMapper.insertBatchSomeColumn(saleSupplierCapacityItemList);
        }
    }

    @Override
    public void cancel(PurchaseSupplierCapacityHead purchaseSupplierCapacityHead) {
        PurchaseSupplierCapacityHead dbPurchaseSupplierCapacity = (PurchaseSupplierCapacityHead)((Object)this.getById((Serializable)((Object)purchaseSupplierCapacityHead.getId())));
        if (dbPurchaseSupplierCapacity == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u65e0\u6b64\u5355\u636e,\u8bf7\u5237\u65b0\u7cfb\u7edf");
        }
        dbPurchaseSupplierCapacity.setDocumentStatus(SupplierCapacityStatusEnum.CANCEL.getValue());
        this.updateById((Object)dbPurchaseSupplierCapacity);
        SaleSupplierCapacityHead saleSupplierCapacityHead = (SaleSupplierCapacityHead)((Object)this.saleSupplierCapacityHeadMapper.selectById((Serializable)((Object)purchaseSupplierCapacityHead.getRelationId())));
        if (saleSupplierCapacityHead != null) {
            saleSupplierCapacityHead.setDocumentStatus(SupplierCapacityStatusEnum.CANCEL.getValue());
            this.saleSupplierCapacityHeadMapper.updateById((Object)saleSupplierCapacityHead);
        }
    }
}

