/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.enums.WorkFlowType;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PublishEbiddingAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PublishEbiddingAdapter.class);
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseEbiddingHeadVO headVO = (PurchaseEbiddingHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseEbiddingHeadVO.class));
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        head.setPublishTime(null);
        head.setPublishUser(null);
        head.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchaseEbiddingHeadService.updateMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        this.updateAuditStatus(inputParamVO, outputParamVO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            String id = inputParamVO.getBusinessId();
            PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setPurchaseEbiddingItemList(this.purchaseEbiddingItemService.selectByMainId(id));
            headVO.setPurchaseEbiddingSupplierList(this.purchaseEbiddingSupplierService.selectByMainId(id));
            headVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
            headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
            this.purchaseEbiddingHeadService.publish(headVO);
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(inputParamVO.getBusinessId());
        updateHead.setFlowId(outputParamVO.getProcessRootId());
        updateHead.setAuditStatus(outputParamVO.getAuditStatus());
        updateHead.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || "auditReject".equals(optType)) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"ebidding", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"ebidding", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)headId)));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(headId);
        headVO.setPurchaseEbiddingItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

