/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.BiddingEvaluationRegulationSelection;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateItem;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationRegulationSelectionMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateItemMapper;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingEvaResultMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingRegulationVO;
import com.els.modules.bidding.vo.SupplierEvaScoreVO;
import com.els.modules.specialist.service.SpecialistInfoService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingEvaResultServiceImpl
extends ServiceImpl<PurchaseBiddingEvaResultMapper, PurchaseBiddingEvaResult>
implements PurchaseBiddingEvaResultService {
    @Autowired
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Autowired
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Autowired
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Autowired
    private BiddingSupplierMapper biddingSupplierMapper;
    @Autowired
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Autowired
    private BiddingEvaluationTemplateItemMapper biddingEvaluationTemplateItemMapper;
    @Autowired
    private BiddingEvaluationRegulationSelectionMapper biddingEvaluationRegulationSelectionMapper;
    @Autowired
    private SpecialistInfoService specialistInfoService;

    private List<BiddingRegulationVO> getResult(List<PurchaseBiddingEvaResult> list) {
        if (CollUtil.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList<BiddingRegulationVO> resultList = new ArrayList<BiddingRegulationVO>();
        Map<String, List<PurchaseBiddingEvaResult>> map = list.stream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getRegulationId));
        List<String> regulationIds = list.parallelStream().map(PurchaseBiddingEvaResult::getRegulationId).collect(Collectors.toList());
        Map<String, List<BiddingEvaluationRegulationSelection>> biddingEvaluationRegulationSelectionMap = this.biddingEvaluationRegulationSelectionMapper.selectWithoutElsAccountByRegulationIds(regulationIds).parallelStream().collect(Collectors.groupingBy(BiddingEvaluationRegulationSelection::getHeadId));
        for (String id : map.keySet()) {
            List<PurchaseBiddingEvaResult> itemList = map.get(id);
            BiddingRegulationVO vo = new BiddingRegulationVO();
            BeanUtil.copyProperties((Object)((Object)itemList.get(0)), (Object)((Object)vo), (String[])new String[0]);
            vo.setRegulationSelections(biddingEvaluationRegulationSelectionMap.get(itemList.get(0).getRegulationId()));
            ArrayList<SupplierEvaScoreVO> scoreList = new ArrayList<SupplierEvaScoreVO>();
            for (PurchaseBiddingEvaResult result : itemList) {
                SupplierEvaScoreVO scoreVO = new SupplierEvaScoreVO();
                scoreVO.setToElsAccount(result.getToElsAccount());
                scoreVO.setSupplierName(result.getSupplierName());
                scoreVO.setSupplierCode(result.getSupplierCode());
                scoreVO.setScore(result.getScore());
                scoreList.add(scoreVO);
            }
            vo.setSupplierEvaScoreList(scoreList);
            resultList.add(vo);
        }
        return resultList;
    }

    private void check(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    @Override
    public List<BiddingRegulationVO> findEvaResult(String headId) {
        LoginUser user = SysUtil.getLoginUser();
        List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(headId).stream().filter(o -> MemberTypeEnum.EVA_BID.getValue().equals(o.getMemberType())).collect(Collectors.toList());
        List specialistList = purchaseBiddingSpecialistList.stream().filter(o -> o.getSubAccount().equals(user.getSubAccount())).collect(Collectors.toList());
        if (specialistList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_view_bidding_doc_bidding", (String)"\u53ea\u6709\u5f53\u524d\u62db\u6807\u5355\u7684\u8bc4\u6807\u4e13\u5bb6\u53ef\u4ee5\u67e5\u770b\uff01"));
        }
        List resultList = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId)).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (!resultList.isEmpty()) {
            return this.getResult(resultList);
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)head.getElsAccount())).eq((Object)"evaluation_number", (Object)head.getBidEvaluationNumber())));
        if (evaluationTemplateHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_evaluation_of_bids_template_no_found_template", (String)"\u8bc4\u6807\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        List<BiddingEvaluationTemplateItem> templateItemList = this.biddingEvaluationTemplateItemMapper.selectByMainId(evaluationTemplateHead.getId());
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        PurchaseBiddingSpecialist specialist = (PurchaseBiddingSpecialist)((Object)specialistList.get(0));
        for (BiddingSupplier supplier : biddingSupplierList) {
            for (BiddingEvaluationTemplateItem item : templateItemList) {
                if (!specialist.getSpecialistClasses().contains(item.getRegulationType())) continue;
                PurchaseBiddingEvaResult result = new PurchaseBiddingEvaResult();
                result.setToElsAccount(supplier.getToElsAccount());
                result.setSupplierCode(supplier.getSupplierCode());
                result.setSupplierName(supplier.getSupplierName());
                result.setFullMark(item.getFullMark());
                result.setRegulationDetail(item.getRegulationDetail());
                result.setRegulationId(item.getRegulationId());
                result.setRegulationName(item.getRegulationName());
                result.setRegulationType(item.getRegulationType());
                result.setInputType(item.getInputType());
                result.setInputValue(item.getInputValue());
                resultList.add(result);
            }
        }
        return this.getResult(resultList);
    }

    @Override
    public void saveEvaResult(String headId, List<BiddingRegulationVO> resultList) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_evaluation_of_bids_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8bc4\u6807\uff01"));
        }
        LoginUser user = SysUtil.getLoginUser();
        List list = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId)).eq(PurchaseBiddingEvaResult::getSubAccount, (Object)user.getSubAccount()));
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_doc_score_repeat", (String)"\u5df2\u7ecf\u8bc4\u5206\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u8bc4\u5206\uff01"));
        }
        ArrayList<PurchaseBiddingEvaResult> insertList = new ArrayList<PurchaseBiddingEvaResult>();
        for (BiddingRegulationVO regulationVO : resultList) {
            List<SupplierEvaScoreVO> scoreList = regulationVO.getSupplierEvaScoreList();
            for (SupplierEvaScoreVO scoreVO : scoreList) {
                PurchaseBiddingEvaResult result = new PurchaseBiddingEvaResult();
                BeanUtil.copyProperties((Object)((Object)regulationVO), (Object)((Object)result), (String[])new String[0]);
                if (scoreVO.getScore() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_score_not_empty", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (regulationVO.getFullMark() != null && scoreVO.getScore().compareTo(regulationVO.getFullMark()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_score_no_gt_full marks", (String)"\u8bc4\u5206\u4e0d\u80fd\u5927\u4e8e\u6ee1\u5206\uff01"));
                }
                result.setFullMark(regulationVO.getFullMark());
                result.setToElsAccount(scoreVO.getToElsAccount());
                result.setSupplierName(scoreVO.getSupplierName());
                result.setSupplierCode(scoreVO.getSupplierCode());
                result.setScore(scoreVO.getScore());
                result.setHeadId(headId);
                result.setElsAccount(user.getElsAccount());
                result.setDeleted(CommonConstant.DEL_FLAG_0);
                result.setSubAccount(user.getSubAccount());
                result.setCreateBy(user.getSubAccount());
                result.setCreateTime(new Date());
                result.setScoreTime(new Date());
                result.setEvaBidIp(IPUtils.getIpAddr());
                insertList.add(result);
            }
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
            this.specialistInfoService.addByEvaResult(head);
        }
    }

    private long getEchoCount(String toElsAccount, Map<String, List<PurchaseBiddingItem>> itemMap) {
        List<PurchaseBiddingItem> itemList = itemMap.get(toElsAccount);
        if (itemList == null) {
            return 0L;
        }
        long echoCount = itemList.stream().filter(o -> o.getPrice() != null).count();
        return echoCount;
    }

    private BigDecimal getTotalAmount(String toElsAccount, Map<String, List<PurchaseBiddingItem>> itemMap) {
        List<PurchaseBiddingItem> itemList = itemMap.get(toElsAccount);
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (itemList == null) {
            return totalAmount;
        }
        for (PurchaseBiddingItem item : itemList) {
            if (item.getPrice() == null) continue;
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal amount = price.multiply(quantity);
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }

    private BigDecimal getScore(String toElsAccount, String type, Map<String, List<PurchaseBiddingEvaResult>> resultMap, BigDecimal weight) {
        List<PurchaseBiddingEvaResult> itemList = resultMap.get(toElsAccount);
        BigDecimal totalScore = BigDecimal.ZERO;
        if (itemList == null) {
            return totalScore;
        }
        itemList = itemList.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        int count = 0;
        for (PurchaseBiddingEvaResult result2 : itemList) {
            totalScore = totalScore.add(result2.getScore());
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        if (weight == null) {
            return totalScore.divide(new BigDecimal(count), 2, 4);
        }
        Map<String, List<PurchaseBiddingEvaResult>> listMap = itemList.parallelStream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getSubAccount));
        return totalScore.divide(new BigDecimal(listMap.size()), 2, 4);
    }

    private void rankByTotalAmount(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTotalAmount)).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setQuoteRank(rank + "");
            ++rank;
        }
    }

    private void rankByBusScore(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getBusScore).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setBusRank(rank + "");
            ++rank;
        }
    }

    private void rankByTecScore(List<BiddingEvaResultVO> resultList) {
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTecScore).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setTecRank(rank + "");
            ++rank;
        }
    }

    private List<BiddingEvaResultVO> rankByTotalScore(List<BiddingEvaResultVO> resultList) {
        List<BiddingEvaResultVO> list = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTotalScore).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : list) {
            resultVO.setSynthesisRank(rank + "");
            ++rank;
        }
        return list;
    }

    @Override
    public List<BiddingEvaResultVO> findEvaBidList(String headId) {
        this.check(headId);
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (BiddingStatusEnum.BIDDING.getValue().equals(head.getBiddingStatus()) || BiddingStatusEnum.NEW.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_status_can_not_view", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u67e5\u770b\uff01"));
        }
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        List itemNumberList = purchaseBiddingItemList.stream().map(PurchaseBiddingItem::getItemNumber).distinct().collect(Collectors.toList());
        int totalRows = itemNumberList.size();
        Map<String, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        BigDecimal busWeight = new BigDecimal(100);
        BigDecimal tecWeight = new BigDecimal(100);
        if (!StringUtils.isEmpty((CharSequence)head.getBidEvaluationNumber())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getEvaluationNumber, (Object)head.getBidEvaluationNumber());
            lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            lambdaQueryWrapper.eq(BiddingEvaluationTemplateHead::getTemplateStatus, (Object)"1");
            BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectOne((Wrapper)lambdaQueryWrapper));
            busWeight = biddingEvaluationTemplateHead.getBusWeight();
            tecWeight = biddingEvaluationTemplateHead.getTecWeight();
        }
        List biddingEvaResultList = ((PurchaseBiddingEvaResultMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)headId));
        Map<String, List<PurchaseBiddingEvaResult>> resultMap = biddingEvaResultList.stream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getToElsAccount));
        ArrayList<BiddingEvaResultVO> resultList = new ArrayList<BiddingEvaResultVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingEvaResultVO resultVO = new BiddingEvaResultVO();
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)resultVO, (String[])new String[0]);
            resultVO.setQuoteEcho(this.getEchoCount(supplier.getToElsAccount(), itemMap) + "/" + totalRows);
            resultVO.setTotalAmount(this.getTotalAmount(supplier.getToElsAccount(), itemMap));
            resultVO.setBusScore(this.getScore(supplier.getToElsAccount(), "1", resultMap, busWeight));
            resultVO.setTecScore(this.getScore(supplier.getToElsAccount(), "2", resultMap, tecWeight));
            resultVO.setBusScoreByWeights(this.getScoreByWeights(supplier.getToElsAccount(), "1", resultMap, busWeight));
            resultVO.setTecScoreByWeights(this.getScoreByWeights(supplier.getToElsAccount(), "2", resultMap, tecWeight));
            resultVO.setBusWeights(busWeight);
            resultVO.setTecWeights(tecWeight);
            BigDecimal totalScore = resultVO.getBusScoreByWeights().add(resultVO.getTecScoreByWeights());
            resultVO.setTotalScore(totalScore);
            resultList.add(resultVO);
        }
        this.rankByTotalAmount(resultList);
        this.rankByBusScoreByWeights(resultList, busWeight);
        this.rankByTecScoreByWeights(resultList, tecWeight);
        return this.rankByTotalScore(resultList);
    }

    private BigDecimal getScoreByWeights(String toElsAccount, String type, Map<String, List<PurchaseBiddingEvaResult>> resultMap, BigDecimal weights) {
        List<PurchaseBiddingEvaResult> itemList = resultMap.get(toElsAccount);
        BigDecimal totalScore = BigDecimal.ZERO;
        if (itemList == null) {
            return totalScore;
        }
        if (weights == null) {
            return this.getScore(toElsAccount, type, resultMap, weights);
        }
        int count = 0;
        itemList = itemList.parallelStream().filter(result -> type.equals(result.getRegulationType())).collect(Collectors.toList());
        Map<String, List<PurchaseBiddingEvaResult>> listMap = itemList.parallelStream().collect(Collectors.groupingBy(PurchaseBiddingEvaResult::getSubAccount));
        for (PurchaseBiddingEvaResult result2 : itemList) {
            BigDecimal score = result2.getScore();
            totalScore = totalScore.add(score.multiply(weights).multiply(new BigDecimal(0.01)));
            ++count;
        }
        if (count == 0) {
            return totalScore;
        }
        return totalScore.divide(new BigDecimal(listMap.size()), 2, 4);
    }

    private void rankByBusScoreByWeights(List<BiddingEvaResultVO> resultList, BigDecimal weights) {
        if (weights == null) {
            this.rankByBusScore(resultList);
            return;
        }
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getBusScoreByWeights).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setBusRank(rank + "");
            ++rank;
        }
    }

    private void rankByTecScoreByWeights(List<BiddingEvaResultVO> resultList, BigDecimal weights) {
        if (weights == null) {
            this.rankByTecScore(resultList);
            return;
        }
        resultList = resultList.parallelStream().sorted(Comparator.comparing(BiddingEvaResultVO::getTecScoreByWeights).reversed()).collect(Collectors.toList());
        int rank = 1;
        for (BiddingEvaResultVO resultVO : resultList) {
            resultVO.setTecRank(rank + "");
            ++rank;
        }
    }
}

