/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.alert;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryNotQuoteAlertServiceImpl
implements AlertRpcService {
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.QUOTING.getValue());
        wrapper.gt(SaleEnquiryItem::getQuoteEndTime, (Object)LocalDateTime.now());
        List noQuoteList = this.saleEnquiryItemService.list((Wrapper)wrapper);
        List headIdList = noQuoteList.stream().map(SaleEnquiryItem::getHeadId).distinct().collect(Collectors.toList());
        return CollectionUtil.isEmpty(headIdList) ? new ArrayList() : this.saleEnquiryHeadService.listByIds(headIdList);
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        SaleEnquiryHead head = (SaleEnquiryHead)((Object)obj);
        EnquirySupplierList dbSupplier = (EnquirySupplierList)((Object)this.enquirySupplierListService.getById((Serializable)((Object)head.getSupplierListId())));
        String supplierPrincipal = dbSupplier == null ? "" : dbSupplier.getSupplierPrincipal();
        String subAccount = StringUtils.isBlank((CharSequence)supplierPrincipal) ? "1001" : supplierPrincipal.split("_")[0];
        ElsSubAccountDTO account = this.invokeAccountRpcService.getAccount(head.getElsAccount(), subAccount);
        ArrayList<ElsSubAccountDTO> result = new ArrayList<ElsSubAccountDTO>();
        result.add(account);
        return result;
    }

    public String buildUrlParam(Object obj) {
        SaleEnquiryHead head = (SaleEnquiryHead)((Object)obj);
        JSONObject object = new JSONObject();
        object.put("id", (Object)head.getId());
        object.put("templateNumber", (Object)head.getTemplateNumber());
        object.put("templateVersion", (Object)head.getTemplateVersion());
        object.put("busAccount", (Object)head.getBusAccount());
        object.put("supplierTaxRate", (Object)head.getSupplierTaxRate());
        return SysUtil.getUrlParamByJson((JSONObject)object);
    }
}

