/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemHisMapper;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEnquiryItemHisServiceImpl
extends ServiceImpl<PurchaseEnquiryItemHisMapper, PurchaseEnquiryItemHis>
implements PurchaseEnquiryItemHisService {
    private String priceType = "price";
    private BigDecimal ladderQuantity = BigDecimal.ONE;
    private String costGroup;
    private Map<String, Function<List<PurchaseEnquiryItemHis>, CurrentQuoteTrendVO>> functionMap = new HashMap<String, Function<List<PurchaseEnquiryItemHis>, CurrentQuoteTrendVO>>();

    @PostConstruct
    public void init() {
        this.functionMap.put(EnquiryQuoteWayEnum.NORMAL.getValue(), this::getNormalQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.LADDER.getValue(), this::getLadderQuoteHis);
        this.functionMap.put(EnquiryQuoteWayEnum.COST.getValue(), this::getCostQuoteHis);
    }

    @Override
    public void saveQuoteItemHis(SaleEnquiryHead saleHead, List<SaleEnquiryItem> needRecordList) {
        ArrayList<PurchaseEnquiryItemHis> purchaseItemHisList = new ArrayList<PurchaseEnquiryItemHis>();
        for (SaleEnquiryItem saleItem : needRecordList) {
            PurchaseEnquiryItemHis purchaseHis = new PurchaseEnquiryItemHis();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)purchaseHis));
            purchaseHis.setId(null);
            purchaseHis.setElsAccount(saleItem.getToElsAccount());
            purchaseHis.setRelationId(null);
            purchaseHis.setHeadId(saleHead.getRelationId());
            purchaseHis.setItemId(saleItem.getRelationId());
            purchaseHis.setToElsAccount(saleItem.getElsAccount());
            purchaseItemHisList.add(purchaseHis);
        }
        this.saveBatch(purchaseItemHisList, 20000);
    }

    @Override
    public CurrentQuoteTrendVO findQuoteHis(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        this.priceType = request.getParameter("priceType");
        this.ladderQuantity = StrUtil.isBlank((CharSequence)request.getParameter("ladderQuantity")) ? null : new BigDecimal(request.getParameter("ladderQuantity"));
        this.costGroup = request.getParameter("costGroup");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemHis::getHeadId, (Object)headId);
        if (StrUtil.isNotBlank((CharSequence)itemNumber)) {
            queryWrapper.eq(PurchaseEnquiryItemHis::getItemNumber, (Object)itemNumber);
        }
        queryWrapper.orderByAsc(PurchaseEnquiryItemHis::getQuoteCount);
        List list = ((PurchaseEnquiryItemHisMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.hidePrice(list);
        return this.functionMap.get(((PurchaseEnquiryItemHis)((Object)list.get(0))).getQuotePriceWay()).apply(list);
    }

    private void hidePrice(List<PurchaseEnquiryItemHis> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            boolean showPrice;
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)SpringContextUtils.getBean(PurchaseEnquiryHeadService.class)).getById((Serializable)((Object)list.get(0).getHeadId())));
            boolean bl = showPrice = !"0".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || dbHead.getQuoteEndTime().before(new Date());
            if (!showPrice) {
                for (PurchaseEnquiryItemHis item : list) {
                    Object object2;
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                    if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                        JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                        for (Object object2 : ladderPriceJson) {
                            JSONObject ladderItem = (JSONObject)object2;
                            ladderItem.put("netPrice", null);
                            ladderItem.put("price", null);
                            ladderItem.put("taxAmount", null);
                            ladderItem.put("netAmount", null);
                        }
                        item.setLadderPriceJson(ladderPriceJson.toJSONString());
                    }
                    if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                    JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                    JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                    object2 = data.keySet().iterator();
                    while (object2.hasNext()) {
                        String key = (String)object2.next();
                        data.put(key, (Object)new JSONArray());
                    }
                    JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                    for (Object object3 : groups) {
                        JSONObject group = (JSONObject)object3;
                        group.put("totalValue", null);
                    }
                    item.setCostFormJson(costFormJson.toJSONString());
                }
            }
        }
    }

    private CurrentQuoteTrendVO getTrend(List<PurchaseEnquiryItemHis> dataList) {
        CurrentQuoteTrendVO trendVO = new CurrentQuoteTrendVO();
        List<String> legendData = dataList.stream().map(PurchaseEnquiryItemHis::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        List<Integer> xAxisData = dataList.stream().map(PurchaseEnquiryItemHis::getQuoteCount).distinct().collect(Collectors.toList());
        trendVO.setXAxisData(xAxisData);
        return trendVO;
    }

    private CurrentQuoteTrendVO getNormalQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            List priceList = "netPrice".equals(this.priceType) ? itemList.stream().map(PurchaseEnquiryItemHis::getNetPrice).collect(Collectors.toList()) : itemList.stream().map(PurchaseEnquiryItemHis::getPrice).collect(Collectors.toList());
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getLadderQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        Assert.notNull((Object)this.ladderQuantity, (String)I18nUtil.translate((String)"", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHis item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())) {
                    JSONArray ladderArray = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (Object ladderObject : ladderArray) {
                        JSONObject ladder = (JSONObject)ladderObject;
                        BigDecimal ladderQuantity = ladder.getBigDecimal("ladderQuantity");
                        if (this.ladderQuantity.compareTo(ladderQuantity) < 0) continue;
                        price = "netPrice".equals(this.priceType) ? ladder.getBigDecimal("netPrice") : ladder.getBigDecimal("price");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private CurrentQuoteTrendVO getCostQuoteHis(List<PurchaseEnquiryItemHis> dataList) {
        Assert.hasText((String)this.costGroup, (String)I18nUtil.translate((String)"", (String)"\u6210\u672c\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
        CurrentQuoteTrendVO trendVO = this.getTrend(dataList);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            ArrayList<BigDecimal> priceList = new ArrayList<BigDecimal>();
            for (PurchaseEnquiryItemHis item : itemList) {
                BigDecimal price = null;
                if (StrUtil.isNotBlank((CharSequence)item.getCostFormJson())) {
                    JSONObject costObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = costObject.getJSONArray("groups") == null ? new JSONArray() : costObject.getJSONArray("groups");
                    for (Object groupObject : groups) {
                        JSONObject group = (JSONObject)groupObject;
                        if (!this.costGroup.equals(group.getString("groupCode"))) continue;
                        price = group.getBigDecimal("totalValue");
                    }
                }
                priceList.add(price);
            }
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }
}

