/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingItemServiceImpl
extends ServiceImpl<PurchaseBiddingItemMapper, PurchaseBiddingItem>
implements PurchaseBiddingItemService {
    @Autowired
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;

    @Override
    public List<PurchaseBiddingItem> selectByMainId(String mainId) {
        return this.purchaseBiddingItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchaseBiddingItem> queryBiddingByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.inSql(PurchaseBiddingItem::getBiddingNumber, "select bidding_number from purchase_bidding_head where bidding_status=5 ");
        lambdaQueryWrapper.eq(PurchaseBiddingItem::getItemStatus, (Object)BiddingItemStatusEnum.BIDDING_WIN.getValue());
        lambdaQueryWrapper.in(PurchaseBiddingItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseBiddingItem::getMaterialNumber)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseBiddingItem::getMaterialNumber, (Object)"");
            });
        });
        List purchaseBiddingItems = this.purchaseBiddingItemMapper.selectList((Wrapper)lambdaQueryWrapper);
        return purchaseBiddingItems;
    }
}

