/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.SpringContextUtils;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.mapper.SaleEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.service.impl.EnquirySubstituteHeadServiceImpl;
import com.els.modules.enquiry.service.impl.PurchaseEnquiryItemServiceImpl;
import com.els.modules.enquiry.service.impl.SaleEnquiryHeadServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SaleEnquiryItemServiceImpl
extends ServiceImpl<SaleEnquiryItemMapper, SaleEnquiryItem>
implements SaleEnquiryItemService {
    @Override
    public List<SaleEnquiryItem> selectByMainId(String mainId) {
        return ((SaleEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void revoke(List<PurchaseEnquiryItem> revokeList) {
        this.updateBatchById(this.getOptionList(revokeList));
    }

    @Override
    public void reject(List<PurchaseEnquiryItem> rejectList) {
        this.updateBatchById(this.getOptionList(rejectList));
    }

    @Override
    public void accept(List<PurchaseEnquiryItem> acceptList) {
        this.updateBatchById(this.getOptionList(acceptList));
    }

    @Override
    public void oneAward(List<PurchaseEnquiryItem> awardList) {
        this.updateBatchById(this.getOptionList(awardList));
    }

    @Override
    @SrmTransaction
    public void quoteConfirm(SaleEnquiryHead dbHead) {
        dbHead.setQuoteConfirmFlag("1");
        SaleEnquiryHead newdbHead = new SaleEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)newdbHead));
        ((SaleEnquiryHeadServiceImpl)SpringContextUtils.getBean(SaleEnquiryHeadServiceImpl.class)).updateById((Object)dbHead);
        List<SaleEnquiryItem> dbItemList = ((SaleEnquiryItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbItemList.forEach(item -> item.setQuoteFlag("1"));
        this.updateBatchById(dbItemList);
        ArrayList<PurchaseEnquiryItem> updateList = new ArrayList<PurchaseEnquiryItem>();
        for (SaleEnquiryItem item2 : dbItemList) {
            PurchaseEnquiryItem purchase = new PurchaseEnquiryItem();
            purchase.setId(item2.getRelationId());
            purchase.setQuoteFlag("1");
            updateList.add(purchase);
        }
        PurchaseEnquiryItemService purchaseEnquiryItemService = (PurchaseEnquiryItemService)SpringContextUtils.getBean(PurchaseEnquiryItemServiceImpl.class);
        purchaseEnquiryItemService.updateBatchById(updateList);
        EnquirySubstituteHeadService enquirySubstituteHeadService = (EnquirySubstituteHeadService)SpringContextUtils.getBean(EnquirySubstituteHeadServiceImpl.class);
        enquirySubstituteHeadService.quoteConfirm(newdbHead, dbItemList);
    }

    private List<SaleEnquiryItem> getOptionList(List<PurchaseEnquiryItem> optionList) {
        ArrayList<SaleEnquiryItem> resultList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : optionList) {
            SaleEnquiryItem option = new SaleEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)option));
            option.setId(item.getRelationId());
            option.setHeadId(null);
            option.setRelationId(item.getId());
            option.setElsAccount(item.getToElsAccount());
            option.setToElsAccount(item.getElsAccount());
            resultList.add(option);
        }
        return resultList;
    }

    @Override
    public void replenishMaterialNumber(List<PurchaseEnquiryItem> itemList) {
        ArrayList<SaleEnquiryItem> updateList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : itemList) {
            SaleEnquiryItem updateItem = new SaleEnquiryItem();
            updateItem.setId(item.getRelationId());
            updateItem.setMaterialNumber(item.getMaterialNumber());
            updateItem.setMaterialDesc(item.getMaterialDesc());
            updateItem.setMaterialGroup(item.getMaterialGroup());
            updateItem.setMaterialSpec(item.getMaterialSpec());
            updateItem.setMaterialGroupName(item.getMaterialGroupName());
            updateList.add(updateItem);
        }
        this.updateBatchById(updateList);
    }
}

