/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryItemHis;
import com.els.modules.enquiry.mapper.SaleEnquiryItemHisMapper;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.service.SaleEnquiryItemHisService;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEnquiryItemHisServiceImpl
extends ServiceImpl<SaleEnquiryItemHisMapper, SaleEnquiryItemHis>
implements SaleEnquiryItemHisService {
    @Autowired
    private PurchaseEnquiryItemHisService purchaseEnquiryItemHisService;

    @Override
    public void saveQuoteItemHis(SaleEnquiryHead saleHead, List<SaleEnquiryItem> needRecordList) {
        if (CollectionUtil.isNotEmpty(needRecordList)) {
            Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
            executor.execute(() -> {
                ArrayList<SaleEnquiryItemHis> saleItemHisList = new ArrayList<SaleEnquiryItemHis>();
                for (SaleEnquiryItem saleItem : needRecordList) {
                    SaleEnquiryItemHis saleHis = new SaleEnquiryItemHis();
                    BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)saleHis));
                    saleHis.setId(null);
                    saleHis.setRelationId(null);
                    saleHis.setHeadId(saleHead.getId());
                    saleHis.setItemId(saleItem.getId());
                    saleItemHisList.add(saleHis);
                }
                this.saveBatch(saleItemHisList, 2000);
                this.purchaseEnquiryItemHisService.saveQuoteItemHis(saleHead, needRecordList);
            });
        }
    }

    @Override
    public CurrentQuoteTrendVO queryQuoteHisTrend(String headId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SaleEnquiryItemHis::getHeadId, (Object)headId);
        queryWrapper.orderByAsc(SaleEnquiryItemHis::getQuoteCount);
        List list = ((SaleEnquiryItemHisMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        CurrentQuoteTrendVO trendVO = new CurrentQuoteTrendVO();
        List<String> legendData = list.parallelStream().map(SaleEnquiryItemHis::getMaterialNumber).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        List<Integer> xAxisData = list.parallelStream().map(SaleEnquiryItemHis::getQuoteCount).distinct().collect(Collectors.toList());
        trendVO.setXAxisData(xAxisData);
        Map<String, List<SaleEnquiryItemHis>> itemMap = list.parallelStream().collect(Collectors.groupingBy(SaleEnquiryItemHis::getMaterialNumber));
        JSONArray array = new JSONArray();
        for (String materialNumber : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)materialNumber);
            object.put("type", (Object)"bar");
            List<SaleEnquiryItemHis> itemList = itemMap.get(materialNumber);
            List priceList = itemList.parallelStream().map(SaleEnquiryItemHis::getPrice).collect(Collectors.toList());
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }
}

