/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.impl.PurchaseBiddingProjectHeadServiceImpl;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PurchaseBiddingProjectAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseBiddingProjectHeadVO headVO = (PurchaseBiddingProjectHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseBiddingProjectHeadVO.class));
        List<PurchaseBiddingHead> purchaseBiddingHeadList = headVO.getPurchaseBiddingHeadList();
        if (!CollectionUtils.isEmpty(purchaseBiddingHeadList)) {
            PurchaseBiddingProjectHeadServiceImpl.checkAndSetProjectParam(headVO);
        }
        PurchaseBiddingProjectHead head = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setBiddingStatus(BiddingStatusEnum.NEW.getValue());
        head.setPublishTime(null);
        head.setPublishUser(null);
        head.setWorkFlowType(outputParamVO.getBpmnType());
        this.updateAuditStatus(inputParamVO, outputParamVO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            String id = inputParamVO.getBusinessId();
            PurchaseBiddingProjectHead dbHead = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)id)));
            List itemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
            List<BiddingSupplier> supplierList = this.biddingSupplierService.selectByMainId(id);
            List<PurchaseBiddingSpecialist> specialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
            List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBiddingProjectHead updateHead = new PurchaseBiddingProjectHead();
        updateHead.setId(inputParamVO.getBusinessId());
        updateHead.setFlowId(outputParamVO.getProcessRootId());
        updateHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseBiddingProjectHeadService.updateById((Object)updateHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"biddingProject", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"biddingProject", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseBiddingProjectHead head = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)headId)));
        PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemService.selectByMainId(headId);
        headVO.setPurchaseBiddingItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

