/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseEnquiryItemServiceImpl
extends ServiceImpl<PurchaseEnquiryItemMapper, PurchaseEnquiryItem>
implements PurchaseEnquiryItemService {
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;

    @Override
    public List<PurchaseEnquiryItem> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void hideQuotePrice(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> itemList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItem item : itemList) {
                Object object2;
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    item.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                item.setCostFormJson(costFormJson.toJSONString());
            }
        }
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItem webItem) {
        List<PurchaseEnquiryItem> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEnquiryItem> items = this.handlePurchaseEnquiyItemList(webItem, itemList);
        this.updateBatchById(items);
        this.saleEnquiryItemService.replenishMaterialNumber(items);
        this.enquirySubstituteItemService.replenishMaterialNumber(items);
        PurchaseEnquiryItem item = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType()) && StringUtils.isNotBlank((CharSequence)item.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item.getSourceItemId(), item.getMaterialNumber(), item.getMaterialDesc(), item.getMaterialGroup(), item.getMaterialSpec());
        }
    }

    private List<PurchaseEnquiryItem> handlePurchaseEnquiyItemList(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List<PurchaseEnquiryItem> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        return items;
    }

    private void checkMaterialNumber(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItem::getMaterialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public void exportCompare(PurchaseEnquiryHead dbHead, HttpServletResponse response) {
        List<PurchaseEnquiryItem> itemList = ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        this.hideQuotePrice(dbHead, itemList);
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        for (Object item2 : distinctList) {
            writer.merge(firstRow, firstRow + 3, 0, 0, (Object)((PurchaseEnquiryItem)((Object)item2)).getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 3, 1, 1, (Object)((PurchaseEnquiryItem)((Object)item2)).getItemNumber(), false);
            writer.merge(firstRow, firstRow + 3, 2, 2, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 3, 3, 3, (Object)((PurchaseEnquiryItem)((Object)item2)).getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 3, 4, 4, (Object)((PurchaseEnquiryItem)((Object)item2)).getPriceUnit(), false);
            writer.merge(firstRow, firstRow + 3, 5, 5, (Object)((PurchaseEnquiryItem)((Object)item2)).getRequireQuantity(), false);
            writer.writeCellValue(6, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(6, firstRow + 1, (Object)"\u4e0d\u542b\u7a0e\u4ef7");
            writer.writeCellValue(6, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(6, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            firstRow += 4;
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                writer.writeCellValue(x, y, (Object)item3.getPrice());
                writer.writeCellValue(x, y + 1, (Object)item3.getNetPrice());
                writer.writeCellValue(x, y + 2, (Object)item3.getTaxRate());
                writer.writeCellValue(x, y + 3, item3.getDeliveryDate() == null ? null : DateUtil.format((Date)item3.getDeliveryDate(), (String)"yyyy-MM-dd"));
                y += 4;
            }
            ++x;
        }
        this.ladderCompare(writer, itemList, distinctList, supplierList);
        this.costCompare(writer, itemList, distinctList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            this.log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<PurchaseEnquiryItem> queryEnquiryByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItem::getMaterialNumber)).or(qw1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw1.eq(PurchaseEnquiryItem::getMaterialNumber, (Object)"");
            });
        });
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    private void ladderCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u9636\u68af\u7ea7"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            if (!EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) continue;
            JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
            this.mergeCell(writer, firstRow, array, item2);
            for (int index = 0; index < array.size(); ++index) {
                JSONObject ladder = array.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)ladder.getString("ladder"));
            }
            firstRow += array.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONArray array = JSONArray.parseArray((String)item3.getLadderPriceJson());
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)ladder.getBigDecimal("price"));
                }
                y += array.size();
            }
            ++x;
        }
    }

    private void costCompare(ExcelWriter writer, List<PurchaseEnquiryItem> itemList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u63cf\u8ff0", "\u5355\u4f4d", "\u9700\u6c42\u6570\u91cf", "\u6210\u672c\u9879"));
        int firstRow = 1;
        for (PurchaseEnquiryItem item2 : distinctList) {
            JSONObject jsonObject;
            JSONArray groups;
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)item2.getCostFormJson()) || (groups = (jsonObject = JSONObject.parseObject((String)item2.getCostFormJson())).getJSONArray("groups")) == null) continue;
            this.mergeCell(writer, firstRow, groups, item2);
            for (int index = 0; index < groups.size(); ++index) {
                JSONObject group = groups.getJSONObject(index);
                writer.writeCellValue(6, firstRow + index, (Object)group.getString("groupName"));
            }
            firstRow += groups.size();
        }
        int x = 7;
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            int y = 1;
            for (PurchaseEnquiryItem item3 : dataList) {
                JSONObject jsonObject = JSONObject.parseObject((String)item3.getCostFormJson());
                JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                for (int index = 0; index < groups.size(); ++index) {
                    JSONObject group = groups.getJSONObject(index);
                    writer.writeCellValue(x, y + index, (Object)group.getBigDecimal("totalValue"));
                }
                y += groups.size();
            }
            ++x;
        }
    }

    private void mergeCell(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups, PurchaseEnquiryItem item) {
        if (ladderOrGroups.size() > 1) {
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 0, 0, (Object)item.getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 1, 1, (Object)item.getItemNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 2, 2, (Object)item.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 3, 3, (Object)item.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 4, 4, (Object)item.getPriceUnit(), false);
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 5, 5, (Object)item.getRequireQuantity(), false);
        } else {
            writer.writeCellValue(0, firstRow, (Object)item.getEnquiryNumber());
            writer.writeCellValue(1, firstRow, (Object)item.getItemNumber());
            writer.writeCellValue(2, firstRow, (Object)item.getMaterialNumber());
            writer.writeCellValue(3, firstRow, (Object)item.getMaterialDesc());
            writer.writeCellValue(4, firstRow, (Object)item.getPriceUnit());
            writer.writeCellValue(5, firstRow, (Object)item.getRequireQuantity());
        }
    }

    private List<String> getHeaderList(List<EnquirySupplierList> supplierList, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierList supplier : supplierList) {
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }
}

