/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.enumerate.PurchaseTenderShortlistedRulesEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaGroupSummaryResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaBidAttachmentInfo;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidWinningCandidateStatusEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidEvaHeadMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaGroupSummaryResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaBidAttachmentInfoService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.strategy.shortlisted.ShortlistedRulesStrategy;
import com.els.modules.tender.evaluation.vo.EvaResultVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaHeadVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaRankingVO;
import com.els.modules.tender.evaluation.vo.SupplierVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidEvaHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidEvaHeadMapper, PurchaseTenderProjectBidEvaHead>
implements PurchaseTenderProjectBidEvaHeadService {
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService evaExpertTaskService;
    @Autowired
    private PurchaseTenderEvaluationGroupService evaluationGroupService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService evaRegulationResultService;
    @Autowired
    private PurchaseTenderProjectBidWinningCandidateService bidWinningCandidateService;
    @Autowired
    private PurchaseTenderProjectEvaBidAttachmentInfoService evaBidAttachmentInfoService;
    @Autowired
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService principlesService;
    @Autowired
    private PurchaseTenderProjectBidEvaGroupSummaryResultService evaGroupSummaryResultService;

    @Override
    public PurchaseTenderProjectBidEvaHeadVO queryById(String id) {
        PurchaseTenderProjectBidEvaHead bidEvaHead = (PurchaseTenderProjectBidEvaHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = (PurchaseTenderProjectBidEvaHeadVO)((Object)SysUtil.copyProperties((Object)((Object)bidEvaHead), PurchaseTenderProjectBidEvaHeadVO.class));
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectBySubpackageId(bidEvaHead.getSubpackageId());
        Map<String, List<PurchaseTenderProjectEvaExpertTask>> resultList = bidEvaGroupResultList.stream().collect(Collectors.groupingBy(x -> x.getJudgesName() + "_" + x.getJudgesElsAccount() + "_" + x.getJudgesElsSubAccount(), Collectors.toList()));
        bidEvaHeadVO.setExpertTaskList(resultList);
        return bidEvaHeadVO;
    }

    @Override
    public PurchaseTenderProjectBidEvaHeadVO queryBySubpackageId(String subpackageId) {
        String tenderCurrentStep;
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep());
        if (bidEvaHeadList.isEmpty()) {
            return new PurchaseTenderProjectBidEvaHeadVO();
        }
        PurchaseTenderProjectBidEvaHead bidEvaHead = bidEvaHeadList.get(0);
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = (PurchaseTenderProjectBidEvaHeadVO)((Object)SysUtil.copyProperties((Object)((Object)bidEvaHead), PurchaseTenderProjectBidEvaHeadVO.class));
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectBySubpackageId(bidEvaHead.getSubpackageId());
        Map<String, List<PurchaseTenderProjectEvaExpertTask>> resultList = bidEvaGroupResultList.stream().collect(Collectors.groupingBy(x -> x.getJudgesName() + "_" + x.getJudgesElsAccount() + "_" + x.getJudgesElsSubAccount(), Collectors.toList()));
        bidEvaHeadVO.setExpertTaskList(resultList);
        return bidEvaHeadVO;
    }

    @Override
    public SupplierEvaGroupResultVO querySupplierResultByGroupId(String evaGroupId, String judgesTaskItemId) {
        ArrayList resultList;
        SupplierEvaGroupResultVO resultVO = new SupplierEvaGroupResultVO();
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(evaGroupId);
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        resultVO.setEvaluationGroupType(evaluationGroupVO.getGroupType());
        resultVO.setEvaluationGroupVO(evaluationGroupVO);
        Map bidEvaGroupSummaryResultListMap = this.evaGroupSummaryResultService.selectEvaGroupSummaryResultByMainId(evaluationGroupVO.getSubpackageId(), evaGroupId).stream().collect(Collectors.toMap(SupplierEvaRankingVO::getSupplierAccount, Function.identity()));
        List<TenderProjectSupplier> tenderProjectSupplier = this.tenderProjectSupplierService.getDecryptSupplier(evaluationGroupVO.getSubpackageId());
        ArrayList<SupplierVO> supplierList = new ArrayList<SupplierVO>();
        for (TenderProjectSupplier supplier : tenderProjectSupplier) {
            SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult;
            SupplierVO supplierVO = new SupplierVO();
            supplierVO.setSupplierAccount(supplier.getSupplierAccount());
            supplierVO.setSupplierName(supplier.getSupplierName());
            supplierVO.setInvalid(supplier.getInvalid());
            SupplierEvaRankingVO evaRankingVO = (SupplierEvaRankingVO)bidEvaGroupSummaryResultListMap.get(supplier.getSupplierAccount());
            if (evaRankingVO != null && (evaGroupSummaryResult = evaRankingVO.getResult().get(evaGroupId)) != null) {
                supplierVO.setEvaGroupResult(evaGroupSummaryResult.getEvaGroupResult());
                supplierVO.setTotalScore(evaGroupSummaryResult.getTotalScore());
            }
            supplierList.add(supplierVO);
        }
        resultVO.setSupplierList(supplierList);
        List<PurchaseTenderProjectBidEvaRegulationResult> regulationResultList = this.evaRegulationResultService.selectByMainId(judgesTaskItemId, evaGroupId);
        if (regulationResultList.isEmpty()) {
            resultList = new ArrayList();
            Map<String, SaleTenderPriceOpenings> priceOpeningsMap = null;
            if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue())) {
                PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
                String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
                List<SaleTenderPriceOpenings> tenderPriceOpeningsList = this.saleTenderPriceOpeningsService.getSalePriceOpeningsByBidLetterId(tenderBidLetterId);
                priceOpeningsMap = tenderPriceOpeningsList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
            }
            for (SupplierVO supplier : supplierList) {
                if ("1".equals(supplier.getInvalid())) continue;
                if (evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue())) {
                    this.buildPriceOpenings(evaluationGroupVO, resultList, priceOpeningsMap, supplier, summaryScorePrecision);
                    continue;
                }
                this.buildRegulation(evaluationGroupVO, resultList, supplier);
            }
            Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> listMap = resultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
            resultVO.setEvaResultListMap(listMap);
            return resultVO;
        }
        resultList = SysUtil.copyProperties(regulationResultList, PurchaseTenderProjectBidEvaRegulationResultVO.class);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResultVO>> listMap = resultList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        resultVO.setEvaResultListMap(listMap);
        for (SupplierVO supplier : supplierList) {
            BigDecimal total = BigDecimal.ZERO;
            List resultVOList = listMap.get(supplier.getSupplierAccount());
            resultVOList = Optional.ofNullable(resultVOList).orElse(new ArrayList());
            for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : resultVOList) {
                total = total.add(regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore());
                if (!evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue())) continue;
                BigDecimal score = regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore();
                BigDecimal weightScore = regulationResultVO.getWeightScore() == null ? BigDecimal.ZERO : regulationResultVO.getWeightScore();
                regulationResultVO.setScore(score.setScale(summaryScorePrecision, 4));
                regulationResultVO.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
            }
            if (!evaluationGroupVO.getGroupType().equals(TenderEvaGroupTypeEnum.SCORE.getValue())) continue;
            supplier.setTotalScore(total);
        }
        return resultVO;
    }

    private void buildRegulation(PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<PurchaseTenderProjectBidEvaRegulationResultVO> resultList, SupplierVO supplier) {
        List<PurchaseTenderEvaluationRegulationInfo> regulationInfoList = evaluationGroupVO.getTenderEvaluationTemplateRegulationInfoList();
        for (PurchaseTenderEvaluationRegulationInfo regulationInfo : regulationInfoList) {
            PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = new PurchaseTenderProjectBidEvaRegulationResultVO();
            regulationResultVO.setSupplierAccount(supplier.getSupplierAccount());
            regulationResultVO.setSupplierName(supplier.getSupplierName());
            regulationResultVO.setTenderProjectId(regulationInfo.getTenderProjectId());
            regulationResultVO.setSubpackageId(regulationInfo.getSubpackageId());
            regulationResultVO.setEvaGroupId(evaluationGroupVO.getId());
            regulationResultVO.setEvaGroupType(evaluationGroupVO.getGroupType());
            regulationResultVO.setRegulationId(regulationInfo.getId());
            regulationResultVO.setRegulationName(regulationInfo.getRegulationName());
            regulationResultVO.setWeight(evaluationGroupVO.getWeights());
            resultList.add(regulationResultVO);
        }
    }

    private void buildPriceOpenings(PurchaseTenderEvaluationGroupVO evaluationGroupVO, List<PurchaseTenderProjectBidEvaRegulationResultVO> resultList, Map<String, SaleTenderPriceOpenings> priceOpeningsMap, SupplierVO supplier, int summaryScorePrecision) {
        PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO = new PurchaseTenderProjectBidEvaRegulationResultVO();
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        String quoteColumnName = priceRegulationInfo.getQuoteColumnName();
        SaleTenderPriceOpenings saleTenderPriceOpenings = priceOpeningsMap.get(supplier.getSupplierAccount());
        String customizeFieldData = saleTenderPriceOpenings.getCustomizeFieldData();
        JSONObject jsonObject = JSON.parseArray((String)customizeFieldData).getJSONObject(0);
        String quoteValue = jsonObject.getString(quoteColumnName);
        if (StringUtils.isNotBlank((CharSequence)quoteValue)) {
            regulationResultVO.setQuote(BigDecimal.valueOf(Long.valueOf(quoteValue)));
            BigDecimal priceCorrection = regulationResultVO.getPriceCorrection() == null ? BigDecimal.ZERO : regulationResultVO.getPriceCorrection();
            regulationResultVO.setEvaPrice(regulationResultVO.getQuote().subtract(priceCorrection));
        }
        BigDecimal score = regulationResultVO.getScore() == null ? BigDecimal.ZERO : regulationResultVO.getScore();
        BigDecimal weightScore = regulationResultVO.getWeightScore() == null ? BigDecimal.ZERO : regulationResultVO.getWeightScore();
        regulationResultVO.setScore(score.setScale(summaryScorePrecision, 4));
        regulationResultVO.setWeightScore(weightScore.setScale(summaryScorePrecision, 4));
        regulationResultVO.setSupplierAccount(supplier.getSupplierAccount());
        regulationResultVO.setSupplierName(supplier.getSupplierName());
        regulationResultVO.setTenderProjectId(evaluationGroupVO.getTenderProjectId());
        regulationResultVO.setSubpackageId(evaluationGroupVO.getSubpackageId());
        regulationResultVO.setEvaGroupId(evaluationGroupVO.getId());
        regulationResultVO.setEvaGroupType(evaluationGroupVO.getGroupType());
        regulationResultVO.setRegulationId(priceRegulationInfo.getId());
        regulationResultVO.setWeight(evaluationGroupVO.getWeights());
        resultList.add(regulationResultVO);
    }

    @Override
    @SrmTransaction
    public void saveSupplierEvaGroupResult(String evaluationGroupType, List<SupplierVO> supplierList) {
        String evaTaskId = supplierList.get(0).getJudgesTaskItemId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)evaTaskId)));
        this.saveOrUpdateResult(supplierList, evaExpertTask);
    }

    @Override
    @SrmTransaction
    public void publishSupplierEvaGroupResult(String evaluationGroupType, List<SupplierVO> supplierList) {
        String evaTaskId = supplierList.get(0).getJudgesTaskItemId();
        PurchaseTenderProjectEvaExpertTask evaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)this.evaExpertTaskService.getById((Serializable)((Object)evaTaskId)));
        Assert.isTrue((boolean)"0".equals(evaExpertTask.getEvaGroupStatus()), (String)I18nUtil.translate((String)"", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u8bc4\u6807\uff01"));
        evaExpertTask.setEvaGroupStatus("1");
        this.evaExpertTaskService.updateById((Object)evaExpertTask);
        this.saveOrUpdateResult(supplierList, evaExpertTask);
        List<PurchaseTenderProjectEvaExpertTask> evaExpertTaskList = this.evaExpertTaskService.selectByEvaGroupIdAndStatus(evaExpertTask.getEvaGroupId(), "0", evaExpertTask.getSubpackageId());
        if (evaExpertTaskList.isEmpty()) {
            List<SupplierEvaRankingVO> summaryEvaSupplierResultList = this.evaRegulationResultService.summaryEvaResult(evaExpertTask.getSubpackageId(), evaExpertTask.getEvaGroupId());
            ArrayList<PurchaseTenderProjectBidEvaGroupSummaryResult> bidEvaGroupSummaryResultList = new ArrayList<PurchaseTenderProjectBidEvaGroupSummaryResult>();
            ArrayList<String> invalidSupplierAccountList = new ArrayList<String>();
            for (SupplierEvaRankingVO supplierEvaRankingVO : summaryEvaSupplierResultList) {
                PurchaseTenderProjectBidEvaGroupSummaryResult summaryResult = new PurchaseTenderProjectBidEvaGroupSummaryResult();
                SupplierEvaRankingVO.EvaGroupSummaryResult evaGroupSummaryResult = supplierEvaRankingVO.getResult().get(evaExpertTask.getEvaGroupId());
                summaryResult.setSupplierAccount(supplierEvaRankingVO.getSupplierAccount());
                summaryResult.setSupplierName(supplierEvaRankingVO.getSupplierName());
                summaryResult.setInvalid(supplierEvaRankingVO.getInvalid());
                summaryResult.setSubpackageId(evaExpertTask.getSubpackageId());
                summaryResult.setEvaGroupId(evaExpertTask.getEvaGroupId());
                summaryResult.setJudgesTaskHeadId(evaExpertTask.getHeadId());
                summaryResult.setTenderProjectId(evaExpertTask.getTenderProjectId());
                summaryResult.setEvaGroupType(evaGroupSummaryResult.getEvaGroupType());
                summaryResult.setScore(evaGroupSummaryResult.getTotalScore());
                summaryResult.setResult(evaGroupSummaryResult.getEvaGroupResult());
                summaryResult.setWeight(evaGroupSummaryResult.getWeight());
                summaryResult.setOrderBy(evaGroupSummaryResult.getOrderBy());
                summaryResult.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
                summaryResult.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
                summaryResult.setCurrentStep(TenderFlagInjectionContext.getTenderCurrentStep());
                if ("1".equals(supplierEvaRankingVO.getInvalid())) {
                    invalidSupplierAccountList.add(supplierEvaRankingVO.getSupplierAccount());
                }
                bidEvaGroupSummaryResultList.add(summaryResult);
            }
            this.tenderProjectSupplierService.updateInvalidStatusByMainId(evaExpertTask.getSubpackageId(), invalidSupplierAccountList);
            this.evaGroupSummaryResultService.deleteByMainId(evaExpertTask.getSubpackageId(), evaExpertTask.getEvaGroupId());
            this.evaGroupSummaryResultService.saveBatch(bidEvaGroupSummaryResultList);
        }
    }

    private void saveOrUpdateResult(List<SupplierVO> supplierList, PurchaseTenderProjectEvaExpertTask evaExpertTask) {
        ArrayList<PurchaseTenderProjectBidEvaRegulationResult> allRegulationResultList = new ArrayList<PurchaseTenderProjectBidEvaRegulationResult>();
        LoginUser loginUser = SysUtil.getLoginUser();
        for (SupplierVO supplierResultVO : supplierList) {
            List<PurchaseTenderProjectBidEvaRegulationResult> resultList = supplierResultVO.getBidEvaRegulationResultList();
            for (PurchaseTenderProjectBidEvaRegulationResult regulationResult : resultList) {
                regulationResult.setId(IdWorker.getIdStr());
                regulationResult.setJudgesName(loginUser.getRealname());
                regulationResult.setJudgesElsSubAccount(loginUser.getSubAccount());
                regulationResult.setJudgesElsAccount(loginUser.getElsAccount());
                regulationResult.setInvalid("0");
            }
            allRegulationResultList.addAll(resultList);
        }
        this.evaRegulationResultService.deleteByMainId(evaExpertTask.getEvaGroupId(), evaExpertTask.getId());
        this.evaRegulationResultService.saveBatch(allRegulationResultList, 1000);
    }

    @Override
    public boolean isEvaFinish(String subpackageId) {
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectBySubpackageId(subpackageId);
        long count = bidEvaGroupResultList.parallelStream().filter(result -> "0".equals(result.getEvaGroupStatus())).count();
        return count == 0L;
    }

    @Override
    public EvaResultVO getSupplierEvaRanking(String subpackageId) {
        List<PurchaseTenderProjectEvaExpertTask> bidEvaGroupResultList = this.evaExpertTaskService.selectBySubpackageId(subpackageId);
        long count = bidEvaGroupResultList.parallelStream().filter(result -> "0".equals(result.getEvaGroupStatus())).count();
        Assert.isTrue((!bidEvaGroupResultList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8bc4\u5ba1\u4efb\u52a1\u4e0d\u5b58\u5728!"));
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8bc4\u5ba1\u4efb\u52a1!"));
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(bidEvaGroupResultList.get(0).getEvaGroupId());
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        EvaResultVO evaResultVO = new EvaResultVO();
        List<SupplierEvaRankingVO> supplierEvaRankingList = this.evaGroupSummaryResultService.getSupplierEvaRanking(subpackageId);
        for (SupplierEvaRankingVO supplierEvaRankingVO : supplierEvaRankingList) {
            supplierEvaRankingVO.setTotalScore(supplierEvaRankingVO.getTotalScore().setScale(summaryScorePrecision, 4));
            Map<String, SupplierEvaRankingVO.EvaGroupSummaryResult> result2 = supplierEvaRankingVO.getResult();
            for (SupplierEvaRankingVO.EvaGroupSummaryResult value : result2.values()) {
                if (value.getTotalScore() == null) continue;
                value.setTotalScore(value.getTotalScore().setScale(summaryScorePrecision, 4));
            }
        }
        List<PurchaseTenderProjectBidWinningCandidate> winningCandidates = this.bidWinningCandidateService.selectBySubpackageId(subpackageId, null);
        if (winningCandidates.isEmpty()) {
            String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
            String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
            String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType) || SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType) && SubpackageInfoCurrentStepEnum.FIRST_STEP.getValue().equals(currentStep)) {
                LoginUser loginUser = SysUtil.getLoginUser();
                List expertTasks = bidEvaGroupResultList.stream().filter(evaExpertTask -> {
                    String judgesAccount = evaExpertTask.getJudgesElsAccount() + "_" + evaExpertTask.getJudgesElsSubAccount();
                    String currentUser = loginUser.getElsAccount() + "_" + loginUser.getSubAccount();
                    return currentUser.equals(judgesAccount);
                }).collect(Collectors.toList());
                PurchaseTenderProjectEvaExpertTask purchaseTenderProjectEvaExpertTask = (PurchaseTenderProjectEvaExpertTask)((Object)expertTasks.get(0));
                if ("1".equals(purchaseTenderProjectEvaExpertTask.getJudgesGroupLeader())) {
                    PurchaseTenderShortlistedRulesEnum shortlistedRulesEnum;
                    ShortlistedRulesStrategy rulesStrategy;
                    if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getShortlistedRules()) && (rulesStrategy = (ShortlistedRulesStrategy)SpringContextUtils.getBean((String)(shortlistedRulesEnum = PurchaseTenderShortlistedRulesEnum.getPurchaseTenderShortlistedRulesEnum(evaluationPrinciples.getShortlistedRules())).getBeanName(), ShortlistedRulesStrategy.class)) != null) {
                        rulesStrategy.execute(evaluationPrinciples, supplierEvaRankingList);
                    }
                } else {
                    supplierEvaRankingList.parallelStream().forEach(supplierEvaRanking -> supplierEvaRanking.setCandidate("0"));
                }
            }
        } else {
            Map winningCandidateMap = winningCandidates.parallelStream().collect(Collectors.toMap(PurchaseTenderProjectBidWinningCandidate::getSupplierAccount, Function.identity()));
            supplierEvaRankingList.parallelStream().forEach(supplierEvaRanking -> supplierEvaRanking.setCandidate(winningCandidateMap.containsKey(supplierEvaRanking.getSupplierAccount()) ? "1" : "0"));
        }
        evaResultVO.setSupplierEvaRanking(supplierEvaRankingList);
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList = this.evaBidAttachmentInfoService.selectBySubpackageId(subpackageId);
        evaResultVO.setEvaBidAttachmentInfoList(evaBidAttachmentInfoList);
        return evaResultVO;
    }

    @Override
    @SrmTransaction
    public void saveEvaResult(EvaResultVO evaResultVO) {
        List<PurchaseTenderProjectEvaBidAttachmentInfo> evaBidAttachmentInfoList = evaResultVO.getEvaBidAttachmentInfoList();
        List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidateList = evaResultVO.getBidWinningCandidateList();
        Assert.isTrue((!bidWinningCandidateList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n__YIRdXxOLVW_9d450bac", (String)"\u63a8\u8350\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        String subpackageId = bidWinningCandidateList.get(0).getSubpackageId();
        this.bidWinningCandidateService.deleteByMainId(subpackageId);
        this.evaBidAttachmentInfoService.deleteByMainId(subpackageId);
        bidWinningCandidateList = bidWinningCandidateList.stream().filter(bidWinningCandidate -> !"1".equals(bidWinningCandidate.getInvalid())).collect(Collectors.toList());
        bidWinningCandidateList.forEach(bidWinningCandidate -> {
            bidWinningCandidate.setCheckType(tenderCheckType);
            bidWinningCandidate.setProcessType(tenderProcessType);
            bidWinningCandidate.setCurrentStep(tenderCurrentStep);
            bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.NEW.getValue());
        });
        evaBidAttachmentInfoList.forEach(bidAttachmentInfo -> {
            bidAttachmentInfo.setCheckType(tenderCheckType);
            bidAttachmentInfo.setProcessType(tenderProcessType);
            bidAttachmentInfo.setCurrentStep(tenderCurrentStep);
        });
        this.bidWinningCandidateService.deleteByMainId(subpackageId);
        this.evaBidAttachmentInfoService.deleteByMainId(subpackageId);
        this.bidWinningCandidateService.saveBatch(bidWinningCandidateList, 1000);
        this.evaBidAttachmentInfoService.saveBatch(evaBidAttachmentInfoList, 1000);
        List<String> shortlistedSupplierAccountList = bidWinningCandidateList.stream().map(PurchaseTenderProjectBidWinningCandidate::getSupplierAccount).collect(Collectors.toList());
        this.tenderProjectSupplierService.updateShortlistedStatus(subpackageId, shortlistedSupplierAccountList);
        List<PurchaseTenderProjectBidEvaHead> bidEvaHeadList = ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep);
        for (PurchaseTenderProjectBidEvaHead bidEvaHead : bidEvaHeadList) {
            bidEvaHead.setEvaStatus("1");
        }
        this.updateBatchById(bidEvaHeadList);
        Integer subpackageStatus = TenderOperationFieldUtils.getEndEvaBidSubpackageStatus();
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)evaBidAttachmentInfoList.get(0)).subpackageId(subpackageId).subpackageStatus(subpackageStatus + "").build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction
    public void deleteBySubpackageId(String subpackageId) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ((PurchaseTenderProjectBidEvaHeadMapper)this.baseMapper).deleteBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep);
    }

    @Override
    public List<PurchaseTenderProjectBidEvaRegulationResultVO> priceScoreCalculation(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList) {
        PurchaseTenderProjectBidEvaRegulationResultVO resultVO = regulationCalList.get(0);
        PurchaseTenderEvaluationGroupVO evaluationGroupVO = this.evaluationGroupService.queryRegulationInfoByEvaGroupId(resultVO.getEvaGroupId());
        PurchaseTenderEvaluationPrinciples evaluationPrinciples = this.principlesService.queryPurchaseTenderEvaluationPrinciples(evaluationGroupVO.getHeadId());
        PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        regulationCalList.parallelStream().forEach(evaSupplierResultVO -> {
            BigDecimal priceCorrection = evaSupplierResultVO.getPriceCorrection() == null ? BigDecimal.valueOf(0L) : evaSupplierResultVO.getPriceCorrection();
            evaSupplierResultVO.setEvaPrice(evaSupplierResultVO.getQuote().add(priceCorrection));
        });
        this.calBasePrice(regulationCalList, priceRegulationInfo);
        TemplatePriceStrategy priceStrategy = (TemplatePriceStrategy)SpringContextUtils.getBean((String)priceRegulationInfo.getPricePointsCalFormula(), TemplatePriceStrategy.class);
        priceStrategy.priceScoreCalculate(regulationCalList, evaluationGroupVO, evaluationPrinciples);
        return regulationCalList;
    }

    private void calBasePrice(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo) {
        BigDecimal basePrice = BigDecimal.ZERO;
        String baseCalRules = priceRegulationInfo.getBaseCalRules();
        if ("0".equals(baseCalRules)) {
            int minQuote = Integer.MAX_VALUE;
            for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
                if (minQuote <= regulationResultVO.getEvaPrice().intValue()) continue;
                minQuote = regulationResultVO.getEvaPrice().intValue();
            }
            basePrice = new BigDecimal(minQuote);
        } else {
            for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
                basePrice = basePrice.add(regulationResultVO.getEvaPrice());
            }
            basePrice = basePrice.divide(new BigDecimal(regulationCalList.size()), 2, 4);
        }
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            regulationResultVO.setBasePrice(basePrice);
        }
    }
}

