/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.strategy.price.handler;

import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.evaluation.strategy.price.TemplatePriceStrategy;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="operationMinPricePositiveDeviationStrategy")
public class OperationMinPricePositiveDeviationStrategy
implements TemplatePriceStrategy {
    @Override
    public void priceScoreCalculate(List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList, PurchaseTenderEvaluationGroupVO evaluationGroupVO, PurchaseTenderEvaluationPrinciples evaluationPrinciples) {
        PurchaseTenderEvaluationPriceRegulationInfo regulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
        int summaryScorePrecision = 0;
        if (StringUtils.isNotBlank((CharSequence)evaluationPrinciples.getSummaryScorePrecision())) {
            summaryScorePrecision = Integer.parseInt(evaluationPrinciples.getSummaryScorePrecision());
        }
        int aboveScore = regulationInfo.getAboveScore() == null ? 0 : regulationInfo.getAboveScore();
        int lowestScore = regulationInfo.getLowestScore() == null ? 0 : regulationInfo.getLowestScore();
        for (PurchaseTenderProjectBidEvaRegulationResultVO regulationResultVO : regulationCalList) {
            BigDecimal lowestScoreBigDecimal;
            BigDecimal offset = regulationResultVO.getEvaPrice().subtract(regulationResultVO.getBasePrice()).multiply(new BigDecimal(100)).multiply(new BigDecimal(aboveScore)).divide(regulationResultVO.getBasePrice(), summaryScorePrecision, 4);
            BigDecimal result = BigDecimal.valueOf(evaluationGroupVO.getScore().intValue()).subtract(offset);
            if (result.compareTo(lowestScoreBigDecimal = BigDecimal.valueOf(lowestScore)) > 0) {
                regulationResultVO.setScore(result);
            } else {
                regulationResultVO.setScore(lowestScoreBigDecimal);
            }
            BigDecimal evaGroupWeightScope = regulationResultVO.getScore().multiply(regulationResultVO.getWeight()).divide(new BigDecimal(100), summaryScorePrecision, 4);
            regulationResultVO.setWeightScore(evaGroupWeightScope);
        }
    }
}

