/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.notice.service.impl;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.inquiry.service.PublicInquiryService;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.enumerate.PurchaseTenderNoticeTypeEnum;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeHeadService;
import com.els.modules.tender.notice.service.PurchaseTenderNoticeItemService;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeInfoVO;
import com.els.modules.tender.notice.vo.PurchaseTenderNoticeVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.mapper.PurchaseTenderProjectHeadMapper;
import com.els.modules.tender.project.service.impl.PurchaseTenderProjectSubpackageInfoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderNoticeServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectHeadMapper, PurchaseTenderProjectHead>
implements PublicInquiryService {
    @Autowired
    private PurchaseTenderNoticeHeadService purchaseTenderNoticeHeadService;
    @Autowired
    private PurchaseTenderNoticeItemService purchaseTenderNoticeItemService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoServiceImpl purchaseTenderProjectSubpackageInfoService;

    @Override
    public Result<?> getPublicResult(String headId) {
        PurchaseTenderNoticeVO purchaseTenderNoticeVO = new PurchaseTenderNoticeVO();
        PurchaseTenderNoticeHead purchaseTenderNoticeHead = (PurchaseTenderNoticeHead)((Object)this.purchaseTenderNoticeHeadService.getById((Serializable)((Object)headId)));
        if (purchaseTenderNoticeHead == null) {
            return Result.ok((Object)((Object)purchaseTenderNoticeVO));
        }
        BeanUtils.copyProperties((Object)((Object)purchaseTenderNoticeHead), (Object)((Object)purchaseTenderNoticeVO));
        List<PurchaseTenderNoticeItem> purchaseTenderNoticeItems = this.purchaseTenderNoticeItemService.selectByMainId(headId);
        List<String> subpackageIds = purchaseTenderNoticeItems.stream().map(PurchaseTenderNoticeItem::getSubpackageId).distinct().collect(Collectors.toList());
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.purchaseTenderProjectSubpackageInfoService.selectBatchIds(subpackageIds);
        Map<String, PurchaseTenderProjectSubpackageInfo> subpackageInfoMap = purchaseTenderProjectSubpackageInfos.stream().collect(Collectors.toMap(BaseEntity::getId, noticeItem -> noticeItem, (o1, o2) -> o1));
        ArrayList<PurchaseTenderNoticeInfoVO> purchaseTenderNoticeInfoVOS = new ArrayList<PurchaseTenderNoticeInfoVO>();
        purchaseTenderNoticeItems.forEach(item -> {
            PurchaseTenderNoticeInfoVO purchaseTenderNoticeInfoVO = new PurchaseTenderNoticeInfoVO();
            purchaseTenderNoticeInfoVO.setTenderProjectId(item.getTenderProjectId());
            purchaseTenderNoticeInfoVO.setSubpackageId(item.getSubpackageId());
            purchaseTenderNoticeInfoVO.setSubpackageName(item.getSubpackageName());
            purchaseTenderNoticeInfoVO.setSignUpEndTime(purchaseTenderNoticeHead.getSignUpEndTime());
            purchaseTenderNoticeInfoVO.setBiddingEndTime(purchaseTenderNoticeHead.getBiddingEndTime());
            purchaseTenderNoticeInfoVO.setFileSubmitEndTime(purchaseTenderNoticeHead.getFileSubmitEndTime());
            purchaseTenderNoticeInfoVO.setFileClarificationEndTime(purchaseTenderNoticeHead.getFileClarificationEndTime());
            PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)((Object)subpackageInfoMap.get(item.getSubpackageId())));
            purchaseTenderNoticeInfoVO.setTenderProjectName(purchaseTenderProjectSubpackageInfo.getTenderProjectName());
            String signUp = purchaseTenderProjectSubpackageInfo.getSignUp();
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(purchaseTenderProjectSubpackageInfo.getCheckType()) && (PurchaseTenderNoticeTypeEnum.INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType()) || PurchaseTenderNoticeTypeEnum.CHANGE_INVITATION_BID.getValue().equals(purchaseTenderNoticeHead.getNoticeType()))) {
                signUp = "0";
            }
            purchaseTenderNoticeInfoVO.setSignUp(signUp);
            purchaseTenderNoticeInfoVO.setBidding(purchaseTenderProjectSubpackageInfo.getBidding());
            purchaseTenderNoticeInfoVO.setSubpackageNumber(purchaseTenderProjectSubpackageInfo.getSubpackageNumber());
            purchaseTenderNoticeInfoVO.setTenderType(purchaseTenderProjectSubpackageInfo.getTenderType());
            purchaseTenderNoticeInfoVO.setCheckType(purchaseTenderProjectSubpackageInfo.getCheckType());
            purchaseTenderNoticeInfoVO.setProcessType(purchaseTenderProjectSubpackageInfo.getProcessType());
            purchaseTenderNoticeInfoVO.setBidOpenType(purchaseTenderProjectSubpackageInfo.getBidOpenType());
            purchaseTenderNoticeInfoVO.setEvaluationType(purchaseTenderProjectSubpackageInfo.getEvaluationType());
            purchaseTenderNoticeInfoVO.setConsortiumBidding(purchaseTenderProjectSubpackageInfo.getConsortiumBidding());
            purchaseTenderNoticeInfoVO.setSignUpType(purchaseTenderProjectSubpackageInfo.getSignUpType());
            purchaseTenderNoticeInfoVO.setSignUpBeginTime(purchaseTenderProjectSubpackageInfo.getSignUpBeginTime());
            purchaseTenderNoticeInfoVO.setPreFileClarificationEndTime(purchaseTenderProjectSubpackageInfo.getPreFileClarificationEndTime());
            purchaseTenderNoticeInfoVO.setPreOpenBiddingTime(purchaseTenderProjectSubpackageInfo.getPreOpenBiddingTime());
            purchaseTenderNoticeInfoVO.setBiddingBeginTime(purchaseTenderProjectSubpackageInfo.getBiddingBeginTime());
            purchaseTenderNoticeInfoVOS.add(purchaseTenderNoticeInfoVO);
        });
        purchaseTenderNoticeVO.setPurchaseTenderNoticeInfoVOS(purchaseTenderNoticeInfoVOS);
        return Result.ok((Object)((Object)purchaseTenderNoticeVO));
    }

    @Override
    @SrmTransaction
    public void apply(PublicInquiryVO inquiryVO) {
    }
}

