/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.process.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.tender.process.entity.TenderProcessNode;
import com.els.modules.tender.process.enumerate.TenderNodeStateEnum;
import com.els.modules.tender.process.enumerate.TenderProcessNodeCheckStateEnum;
import com.els.modules.tender.process.mapper.TenderProcessNodeMapper;
import com.els.modules.tender.process.service.TenderProcessNodeService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TenderProcessNodeServiceImpl
extends BaseServiceImpl<TenderProcessNodeMapper, TenderProcessNode>
implements TenderProcessNodeService {
    private static final Logger log = LoggerFactory.getLogger(TenderProcessNodeServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BaseRpcService baseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProcessNode tenderProcessNode) {
        this.checkAndSetParam(tenderProcessNode);
        this.NodeI18n(tenderProcessNode);
        ((TenderProcessNodeMapper)this.baseMapper).insert((Object)tenderProcessNode);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProcessNode tenderProcessNode) {
        this.checkAndSetParam(tenderProcessNode);
        this.NodeI18n(tenderProcessNode);
        int count = ((TenderProcessNodeMapper)this.baseMapper).updateById((Object)tenderProcessNode);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatch(List<String> idList) {
        this.removeByIds(idList);
    }

    private void checkAndSetParam(TenderProcessNode tenderProcessNode) {
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProcessNode.getPeriodType()), (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)tenderProcessNode.getSortOrder()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u8f93\u5165\u6392\u5e8f\u53f7\uff01"));
        tenderProcessNode.setNodeCode(this.invokeBaseRpcService.getNextCode("tenderProcessNodeNumber", (Object)tenderProcessNode));
        tenderProcessNode.setStatus(TenderNodeStateEnum.ENABLE.getValue() + "");
        tenderProcessNode.setDeleted(CommonConstant.DEL_FLAG_0);
        if (!StringUtils.hasText((String)tenderProcessNode.getDefaultCheckState())) {
            tenderProcessNode.setDefaultCheckState(TenderProcessNodeCheckStateEnum.CHECK.getValue());
        }
    }

    @Override
    public List<TenderProcessNode> selectBatchIds(List<String> nodeIds) {
        return ((TenderProcessNodeMapper)this.baseMapper).selectBatchIds(nodeIds);
    }

    public void NodeI18n(TenderProcessNode node) {
        String i18nKey = this.baseRpcService.checkAndAdd(node.getNodeName());
        node.setI18nKey(i18nKey);
        this.baseRpcService.translate();
    }
}

