/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingNotice;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingNoticeService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingProjectHead"})
@Api(tags={"\u62db\u6807\u9879\u76ee\u5934"})
public class PurchaseBiddingProjectHeadController
extends BaseController<PurchaseBiddingProjectHead, PurchaseBiddingProjectHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBiddingProjectHeadController.class);
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseBiddingNoticeService purchaseBiddingNoticeService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryPageList(PurchaseBiddingProjectHead purchaseBiddingProjectHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingProjectHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="biddingProject")
    public Result<?> queryTabsCount(PurchaseBiddingProjectHead purchaseBiddingProjectHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)purchaseBiddingProjectHead.getId())) {
            ids = purchaseBiddingProjectHead.getId().replace(" ", "").split(",");
            purchaseBiddingProjectHead.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingProjectHead), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select(new String[]{"project_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"project_status");
        List list = ((PurchaseBiddingProjectHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingProjectHead::getProjectStatus, PurchaseBiddingProjectHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "project_status", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:add"})
    public Result<?> add(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.saveMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        return Result.ok((Object)((Object)purchaseBiddingProjectHead));
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:edit"})
    public Result<?> edit(@RequestBody PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadPage) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHeadPage), (Object)((Object)purchaseBiddingProjectHead));
        this.purchaseBiddingProjectHeadService.updateMain(purchaseBiddingProjectHead, purchaseBiddingProjectHeadPage.getPurchaseBiddingHeadList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingItemList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingNoticeList(), purchaseBiddingProjectHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingProjectHeadPage.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingProjectHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u62db\u6807\u9879\u76ee\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBiddingProjectHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(id);
        return Result.ok((Object)((Object)purchaseBiddingProjectHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingHeadByMainId"})
    public Result<?> queryPurchaseBiddingHeadListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingHeadList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u5206\u5305\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBiddingItemByMainId"})
    public Result<?> queryPurchaseBiddingItemListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u516c\u544a")
    @GetMapping(value={"/queryPurchaseBiddingNoticeByMainId"})
    public Result<?> queryPurchaseBiddingNoticeListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingNoticeList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4e13\u5bb6")
    @GetMapping(value={"/queryPurchaseBiddingSpecialistByMainId"})
    public Result<?> queryPurchaseBiddingSpecialistListByMainId(@RequestParam(name="id") String id) {
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        return Result.ok((Object)purchaseBiddingSpecialistList);
    }

    @ApiOperation(value="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546", notes="\u901a\u8fc7\u62db\u6807\u9879\u76ee\u5934id\u67e5\u8be2\u62db\u6807\u4f9b\u5e94\u5546")
    @GetMapping(value={"/querybiddingSupplierByMainId"})
    public Result<?> querybiddingSupplierListByMainId(@RequestParam(name="id") String id) {
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        return Result.ok((Object)biddingSupplierList);
    }

    @ApiOperation(value="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236", notes="\u62db\u6807\u9879\u76ee\u5934-\u590d\u5236")
    @PostMapping(value={"/copyData"})
    @RequiresPermissions(value={"bidding#purchaseBiddingProjectHead:copyData"})
    public Result<?> copyData(@RequestBody PurchaseBiddingProjectHead purchaseBiddingProjectHead) {
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = this.queryDataById(purchaseBiddingProjectHead.getId());
        this.purchaseBiddingProjectHeadService.copyData(purchaseBiddingProjectHeadVO);
        return this.commonSuccessResult(3);
    }

    private PurchaseBiddingProjectHeadVO queryDataById(String id) {
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO = new PurchaseBiddingProjectHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHead), (Object)((Object)purchaseBiddingProjectHeadVO));
        List purchaseBiddingHeadList = ((LambdaQueryChainWrapper)this.purchaseBiddingHeadService.lambdaQuery().eq(PurchaseBiddingHead::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingHeadList(purchaseBiddingHeadList);
        List purchaseBiddingItemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List purchaseBiddingNoticeList = ((LambdaQueryChainWrapper)this.purchaseBiddingNoticeService.lambdaQuery().eq(PurchaseBiddingNotice::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingNoticeList(purchaseBiddingNoticeList);
        List purchaseBiddingSpecialistList = ((LambdaQueryChainWrapper)this.purchaseBiddingSpecialistService.lambdaQuery().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List biddingSupplierList = ((LambdaQueryChainWrapper)this.biddingSupplierService.lambdaQuery().eq(BiddingSupplier::getProjectId, (Object)id)).list();
        purchaseBiddingProjectHeadVO.setBiddingSupplierList(biddingSupplierList);
        return purchaseBiddingProjectHeadVO;
    }
}

