/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.entity.PurchaseMentoringItem;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.PurchaseMentoringItemService;
import com.els.modules.bidding.vo.PurchaseMentoringHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseMentoringHead"})
@Api(tags={"\u91c7\u8d2d\u65b9\u7b54\u7591\u4fe1\u606f\u5934"})
public class PurchaseMentoringHeadController
extends BaseController<PurchaseMentoringHead, PurchaseMentoringHeadService> {
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private PurchaseMentoringItemService purchaseMentoringItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseMentoringHead")
    public Result<?> queryPageList(PurchaseMentoringHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMentoringHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u65b9\u7b54\u7591\u4fe1\u606f\u5934-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#purchaseMentoringHead:edit"})
    public Result<?> edit(@RequestBody PurchaseMentoringHeadVO purchaseMentoringHeadPage) {
        PurchaseMentoringHead purchaseMentoringHead = new PurchaseMentoringHead();
        BeanUtils.copyProperties((Object)((Object)purchaseMentoringHeadPage), (Object)((Object)purchaseMentoringHead));
        this.purchaseMentoringHeadService.updateMain(purchaseMentoringHead, purchaseMentoringHeadPage.getPurchaseMentoringItemList(), purchaseMentoringHeadPage.getAttachments());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMentoringHead dbHead = (PurchaseMentoringHead)((Object)this.purchaseMentoringHeadService.getById((Serializable)((Object)id)));
        PurchaseMentoringHeadVO headVO = new PurchaseMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseMentoringItem> dbItemList = this.purchaseMentoringItemService.selectByMainId(id);
        dbItemList.forEach(row -> {
            if (StrUtil.isNotBlank((CharSequence)row.getFileAddress())) {
                row.setFileAddress(this.replaceFileNameDashed(row.getFileAddress()));
            }
        });
        headVO.setPurchaseMentoringItemList(dbItemList);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        List<PurchaseAttachmentDTO> attachmentList = attachments.stream().filter(attachment -> !"purchase_mentoring_file_upload".equals(attachment.getBusinessType())).collect(Collectors.toList());
        headVO.setAttachments(attachmentList);
        return Result.ok((Object)((Object)headVO));
    }

    private String replaceFileNameDashed(String val) {
        String[] strArr = val.split("-");
        if (strArr.length < 3) {
            return val;
        }
        String id = strArr[0];
        return id + "-" + val.replaceAll(id + "-", "").replaceAll("-", "_");
    }

    @AutoLog(value="\u91c7\u8d2d\u65b9\u7b54\u7591-\u53d1\u5e03", operateType=3)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseMentoringHeadVO headVO) {
        PurchaseMentoringHead head = new PurchaseMentoringHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        this.purchaseMentoringHeadService.publish(head, headVO.getPurchaseMentoringItemList(), headVO.getAttachments(), headVO.getPurchaseMentoringItem());
        return this.commonSuccessResult(3);
    }
}

